/*
 * Decompiled with CFR 0.152.
 */
package latte.view;

import java.util.ArrayList;
import latte.action.AllAction;
import latte.model.LMAssociation;
import latte.model.LMDependency;
import latte.model.LMGeneralization;
import latte.model.LMImplementation;
import latte.model.LMRelation;
import latte.view.LVClassDiag;
import latte.view.LVConst;
import latte.view.LVDiamondDecoration;
import latte.view.LVFigure;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Point;

public class LVRelation
extends PolylineConnection
implements MouseListener,
MouseMotionListener {
    private LVClassDiag parent_ = null;
    private LMRelation lmRel_ = null;
    private int clickPos_ = 0;
    public static final int WIDTH_NORMAL = 1;
    public static final int WIDTH_SELECTED = 2;
    public static final int CLICKPOS_SOURCE = 1;
    public static final int CLICKPOS_TARGET = 2;

    public LVRelation(LVClassDiag parent, LMRelation rel, LVFigure fromFig, LVFigure toFig) {
        this.parent_ = parent;
        this.lmRel_ = rel;
        this.setSourceAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)fromFig));
        this.setTargetAnchor((ConnectionAnchor)new ChopboxAnchor((IFigure)toFig));
        this.setForegroundColor(LVConst.foreColor_);
        if (this.lmRel_ instanceof LMAssociation || this.lmRel_ instanceof LMGeneralization) {
            this.setLineStyle(1);
        } else {
            this.setLineStyle(3);
        }
        this.setConnectionRouter((ConnectionRouter)new BendpointConnectionRouter());
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.updateFigure();
    }

    public void mousePressed(MouseEvent me) {
        System.out.println("LatteConnection.mousePressed()");
        Point sPoint = this.getStart();
        Point ePoint = this.getEnd();
        int lenStart = Math.abs(sPoint.x - me.x) + Math.abs(sPoint.y - me.y);
        int lenEnd = Math.abs(ePoint.x - me.x) + Math.abs(ePoint.y - me.y);
        this.clickPos_ = lenStart < lenEnd ? 1 : 2;
        this.parent_.setSelectedLVRel(this);
        if (this.lmRel_ instanceof LMAssociation) {
            this.parent_.setPopupMenu(3);
        } else {
            this.parent_.setPopupMenu(2);
        }
        this.getParent().handleMousePressed(me);
        AllAction.SELECT_DEF.execute(this.lmRel_);
    }

    public void mouseReleased(MouseEvent me) {
        this.parent_.setPopupMenu(1);
        this.getParent().handleMouseReleased(me);
    }

    public void mouseDoubleClicked(MouseEvent me) {
        AllAction.ROUTECONS_DELETE.execute(null);
    }

    public void mouseDragged(MouseEvent me) {
        this.getParent().handleMouseDragged(me);
    }

    public void mouseMoved(MouseEvent me) {
        this.getParent().handleMouseMoved(me);
    }

    public void mouseEntered(MouseEvent me) {
        this.getParent().handleMouseEntered(me);
    }

    public void mouseExited(MouseEvent me) {
        this.getParent().handleMouseExited(me);
    }

    public void mouseHover(MouseEvent me) {
        this.getParent().handleMouseHover(me);
    }

    public LMRelation getLmRel() {
        return this.lmRel_;
    }

    public void updateFigure() {
        PolygonDecoration targetDeco;
        if (this.getLmRel().isSelected()) {
            this.setLineWidth(2);
        } else {
            this.setLineWidth(1);
        }
        Point p = this.getLmRel().getRoutingCons();
        System.out.println("getRoutingCons()=" + p);
        if (p != null) {
            ArrayList<LatteBendpoint> cons = new ArrayList<LatteBendpoint>(1);
            cons.add(new LatteBendpoint(p));
            this.setRoutingConstraint(cons);
        } else {
            this.setRoutingConstraint(null);
        }
        if (this.lmRel_ instanceof LMAssociation) {
            LMAssociation lmAss = (LMAssociation)this.lmRel_;
            Object sourceDeco = null;
            Object targetDeco2 = null;
            if (lmAss.getNavigatable() != 3) {
                switch (lmAss.getNavigatable()) {
                    case 1: {
                        targetDeco2 = new NavigatableDecoration();
                        break;
                    }
                    case 2: {
                        sourceDeco = new NavigatableDecoration();
                    }
                }
            }
            if (lmAss.getContainer() != 1) {
                switch (lmAss.getContainer()) {
                    case 4: {
                        sourceDeco = new AggregationDecoration();
                        break;
                    }
                    case 5: {
                        sourceDeco = new CompositionDecoration();
                        break;
                    }
                    case 2: {
                        targetDeco2 = new AggregationDecoration();
                        break;
                    }
                    case 3: {
                        targetDeco2 = new CompositionDecoration();
                    }
                }
            }
            this.setSourceDecoration((RotatableDecoration)sourceDeco);
            this.setTargetDecoration((RotatableDecoration)targetDeco2);
        } else if (this.getTargetDecoration() == null && this.lmRel_ instanceof LMGeneralization) {
            targetDeco = new PolygonDecoration();
            targetDeco.setBackgroundColor(ColorConstants.white);
            targetDeco.setScale(8.0, 5.0);
            this.setTargetDecoration((RotatableDecoration)targetDeco);
        } else if (this.getTargetDecoration() == null && this.lmRel_ instanceof LMDependency) {
            targetDeco = new PolylineDecoration();
            targetDeco.setScale(8.0, 5.0);
            this.setTargetDecoration((RotatableDecoration)targetDeco);
        } else if (this.getTargetDecoration() == null && this.lmRel_ instanceof LMImplementation) {
            targetDeco = new PolygonDecoration();
            targetDeco.setBackgroundColor(ColorConstants.white);
            targetDeco.setScale(8.0, 5.0);
            this.setTargetDecoration((RotatableDecoration)targetDeco);
        }
    }

    public int getClickPos() {
        return this.clickPos_;
    }

    class LatteBendpoint
    extends Point
    implements Bendpoint {
        LatteBendpoint(Point p) {
            super(p);
        }

        public Point getLocation() {
            int x = this.x + ((LVRelation)LVRelation.this).parent_.getDraw2dView().getLocation().x;
            int y = this.y + ((LVRelation)LVRelation.this).parent_.getDraw2dView().getLocation().y;
            return new Point(x, y);
        }
    }

    class NavigatableDecoration
    extends PolylineDecoration {
        NavigatableDecoration() {
            this.setScale(8.0, 5.0);
        }
    }

    class AggregationDecoration
    extends LVDiamondDecoration {
        AggregationDecoration() {
            this.setBackgroundColor(ColorConstants.white);
            this.setScale(6.0, 4.0);
        }
    }

    class CompositionDecoration
    extends LVDiamondDecoration {
        CompositionDecoration() {
            this.setScale(6.0, 4.0);
        }
    }
}

