/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.PrintGraphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.image.ImageObserver;
import java.text.AttributedCharacterIterator;
import sun.awt.Graphics2Delegate;
import sun.awt.windows.WPrintGraphics;
import sun.awt.windows.WPrintJob;

public class WPrintGraphicsWrapper
extends Graphics
implements PrintGraphics,
Graphics2Delegate {
    private WPrintGraphics target;
    private double ratio = 1.0;
    private double sx = 1.0;
    private double sy = 1.0;
    WPrintJob pjob;

    public PrintJob getPrintJob() {
        return this.pjob;
    }

    public WPrintGraphicsWrapper(WPrintGraphics wPrintGraphics, WPrintJob wPrintJob) {
        this.target = wPrintGraphics;
        this.target.wrapper = this;
        this.pjob = wPrintJob;
        if (wPrintJob != null) {
            this.ratio = (double)wPrintJob.truePageResolution / (double)wPrintJob.pageResolution;
        }
    }

    public Graphics create() {
        return new WPrintGraphicsWrapper((WPrintGraphics)this.target.create(), this.pjob);
    }

    Graphics create(int n) {
        return new WPrintGraphicsWrapper((WPrintGraphics)this.target.create(n), this.pjob);
    }

    public Graphics getTarget() {
        return this.target;
    }

    public double getRatio() {
        return this.ratio;
    }

    public double getScaleFactorX() {
        return this.sx;
    }

    public double getScaleFactorY() {
        return this.sy;
    }

    public void translate(int n, int n2) {
        this.target.translate(n, n2);
    }

    public Color getColor() {
        return this.target.getColor();
    }

    public void setColor(Color color) {
        this.target.setColor(color);
    }

    public void setBackground(Color color) {
        this.target.setBackground(color);
    }

    public void setPaintMode() {
        this.target.setPaintMode();
    }

    public void setXORMode(Color color) {
        this.target.setXORMode(color);
    }

    public Font getFont() {
        return this.target.getFont();
    }

    public void setFont(Font font) {
        this.target.setFont(font);
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.target.getFontMetrics(font);
    }

    public Rectangle getClipBounds() {
        return this.target.getClipBounds();
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.target.clipRect(n, n2, n3, n4);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.target.setClip(n, n2, n3, n4);
    }

    public Shape getClip() {
        return this.target.getClip();
    }

    public void setClip(Shape shape) {
        this.target.setClip(shape);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.copyArea(n, n2, n3, n4, n5, n6);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.target.drawLine(n, n2, n3, n4);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.target.fillRect(n, n2, n3, n4);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.target.drawRect(n, n2, n3, n4);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.target.clearRect(n, n2, n3, n4);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.target.draw3DRect(n, n2, n3, n4, bl);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.target.fill3DRect(n, n2, n3, n4, bl);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.target.drawOval(n, n2, n3, n4);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.target.fillOval(n, n2, n3, n4);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.target.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.target.drawPolyline(nArray, nArray2, n);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.target.drawPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.target.fillPolygon(nArray, nArray2, n);
    }

    public void drawString(String string, int n, int n2) {
        AffineTransform affineTransform = this.target.getTransform();
        this.target.scale(this.ratio, this.ratio);
        try {
            this.target.drawingText = true;
            this.target.drawString(string, n, n2);
            Object var6_5 = null;
            this.target.drawingText = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.target.drawingText = false;
            throw throwable;
        }
        this.target.setTransform(affineTransform);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        AffineTransform affineTransform = this.target.getTransform();
        this.target.scale(this.ratio, this.ratio);
        try {
            this.target.drawingText = true;
            this.target.drawString(attributedCharacterIterator, n, n2);
            Object var6_5 = null;
            this.target.drawingText = false;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            this.target.drawingText = false;
            throw throwable;
        }
        this.target.setTransform(affineTransform);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        AffineTransform affineTransform = this.target.getTransform();
        this.target.scale(this.ratio, this.ratio);
        try {
            this.target.drawingText = true;
            this.target.drawChars(cArray, n, n2, n3, n4);
            Object var8_7 = null;
            this.target.drawingText = false;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.target.drawingText = false;
            throw throwable;
        }
        this.target.setTransform(affineTransform);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        AffineTransform affineTransform = this.target.getTransform();
        this.target.scale(this.ratio, this.ratio);
        try {
            this.target.drawingText = true;
            this.target.drawBytes(byArray, n, n2, n3, n4);
            Object var8_7 = null;
            this.target.drawingText = false;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            this.target.drawingText = false;
            throw throwable;
        }
        this.target.setTransform(affineTransform);
    }

    private boolean drawScaledImageHelper(Image image, int n, int n2, int n3, int n4, int n5, int n6, BooleanFunction booleanFunction) {
        boolean bl = true;
        if (n3 > 0 && n4 > 0) {
            this.sx = Math.min((double)n5 / (double)n3, this.ratio);
            this.sy = Math.min((double)n6 / (double)n4, this.ratio);
        }
        if (this.sx <= 1.0 && this.sy <= 1.0) {
            this.sy = 1.0;
            this.sx = 1.0;
            return booleanFunction.invoke();
        }
        AffineTransform affineTransform = this.target.getTransform();
        this.target.preScale(this.sx, this.sy);
        Rectangle rectangle = this.getBoundsForPrinting(n, n2, n3, n4);
        Dimension dimension = this.getCellDimension();
        try {
            this.target.drawingScaledImage = true;
            int n7 = rectangle.x;
            while (n7 < rectangle.x + rectangle.width) {
                int n8 = rectangle.y;
                while (n8 < rectangle.y + rectangle.height) {
                    this.target.setDevClip(n7, n8, dimension.width, dimension.height);
                    bl = bl && booleanFunction.invoke();
                    n8 += dimension.height;
                }
                n7 += dimension.width;
            }
            Object var16_15 = null;
            this.target.drawingScaledImage = false;
            Dimension dimension2 = this.pjob.getPageDimension();
            this.target.setDevClip(0, 0, dimension2.width, dimension2.height);
            this.target.setTransform(affineTransform);
            this.sy = 1.0;
            this.sx = 1.0;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            this.target.drawingScaledImage = false;
            Dimension dimension3 = this.pjob.getPageDimension();
            this.target.setDevClip(0, 0, dimension3.width, dimension3.height);
            this.target.setTransform(affineTransform);
            this.sy = 1.0;
            this.sx = 1.0;
            throw throwable;
        }
        return bl;
    }

    private Rectangle getBoundsForPrinting(int n, int n2, int n3, int n4) {
        double[] dArray = new double[]{n, n2, n + n3, n2, n + n3, n2 + n4, n, n2 + n4};
        this.target.getTransform().transform(dArray, 0, dArray, 0, 4);
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = dArray[0];
        double d4 = dArray[1];
        int n5 = 2;
        while (n5 < 8) {
            if (dArray[n5] > d) {
                d = dArray[n5];
            } else if (dArray[n5] < d3) {
                d3 = dArray[n5];
            }
            if (dArray[n5 + 1] > d2) {
                d2 = dArray[n5 + 1];
            } else if (dArray[n5 + 1] < d4) {
                d4 = dArray[n5 + 1];
            }
            n5 += 2;
        }
        Rectangle rectangle = new Rectangle(0, 0, 0, 0);
        Dimension dimension = this.pjob.getPageDimension();
        d3 = Math.max(d3, 0.0);
        d4 = Math.max(d4, 0.0);
        d = Math.min(d, (double)dimension.width * this.sx);
        d2 = Math.min(d2, (double)dimension.height * this.sy);
        if (d >= d3 && d2 >= d4) {
            rectangle = new Rectangle((int)Math.floor(d3), (int)Math.floor(d4), (int)Math.ceil(d - d3), (int)Math.ceil(d2 - d4));
        }
        return rectangle;
    }

    private Dimension getCellDimension() {
        Dimension dimension = this.pjob.getPageDimension();
        int n = this.pjob.getPageResolution();
        return new Dimension((int)Math.floor((double)(dimension.width * 72) / (double)n), (int)Math.floor((double)(dimension.height * 72) / (double)n));
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.target.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(final Image image, final int n, final int n2, final int n3, final int n4, final ImageObserver imageObserver) {
        return this.drawScaledImageHelper(image, n, n2, n3, n4, image.getWidth(imageObserver), image.getHeight(imageObserver), new BooleanFunction(){

            public boolean invoke() {
                return WPrintGraphicsWrapper.this.target.drawImage(image, n, n2, n3, n4, imageObserver);
            }
        });
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.target.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(final Image image, final int n, final int n2, final int n3, final int n4, final Color color, final ImageObserver imageObserver) {
        return this.drawScaledImageHelper(image, n, n2, n3, n4, image.getWidth(imageObserver), image.getHeight(imageObserver), new BooleanFunction(){

            public boolean invoke() {
                return WPrintGraphicsWrapper.this.target.drawImage(image, n, n2, n3, n4, color, imageObserver);
            }
        });
    }

    public boolean drawImage(final Image image, final int n, final int n2, final int n3, final int n4, final int n5, final int n6, final int n7, final int n8, final ImageObserver imageObserver) {
        return this.drawScaledImageHelper(image, n, n2, n3 - n, n4 - n2, n7 - n5, n8 - n6, new BooleanFunction(){

            public boolean invoke() {
                return WPrintGraphicsWrapper.this.target.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
            }
        });
    }

    public boolean drawImage(final Image image, final int n, final int n2, final int n3, final int n4, final int n5, final int n6, final int n7, final int n8, final Color color, final ImageObserver imageObserver) {
        return this.drawScaledImageHelper(image, n, n2, n3 - n, n4 - n2, n7 - n5, n8 - n6, new BooleanFunction(){

            public boolean invoke() {
                return WPrintGraphicsWrapper.this.target.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
            }
        });
    }

    public void dispose() {
        this.target.dispose();
    }

    public void finalize() {
    }

    public String toString() {
        return this.getClass().getName() + "[target=" + this.target.toString() + "]";
    }

    public Rectangle getClipRect() {
        return this.target.getClipBounds();
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        return this.target.hitClip(n, n2, n3, n4);
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        return this.target.getClipBounds(rectangle);
    }

    static interface BooleanFunction {
        public boolean invoke();
    }
}

