/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Frame;
import java.awt.JobAttributes;
import java.awt.PageAttributes;
import java.awt.PrintJob;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;
import sun.awt.print.PrintControl;
import sun.awt.print.PrinterCapabilities;
import sun.awt.print.PrinterListUpdatable;
import sun.awt.windows.WFramePeer;
import sun.awt.windows.WPrintDialog;
import sun.awt.windows.WPrintJob;

class WPrintControl
extends PrintControl {
    private static final PageAttributes.MediaType[] dmPaperToPrintControl;
    private WFramePeer dialogOwnerPeer = null;
    private static final double TENTHS_MM_TO_POINTS = 3.527777778;
    private static final HashMap mediaCache;
    private static final HashMap capabilitiesCache;

    public WPrintControl(Frame frame, String string, JobAttributes jobAttributes, PageAttributes pageAttributes) {
        super(frame, string, jobAttributes, pageAttributes);
        if (frame != null) {
            this.dialogOwnerPeer = (WFramePeer)frame.getPeer();
        }
    }

    private native char _getWin32MediaAttrib(int var1, String var2);

    public char getWin32MediaAttrib() {
        return this._getWin32MediaAttrib(this.getMediaAttrib(), this.getPrinterAttrib());
    }

    private int findWin32Media(int n, int n2, int n3, boolean bl) {
        if (n >= 1 && n <= 41) {
            if (bl && (n == 32 || n == 39 || n == 40)) {
                return -1;
            }
            return dmPaperToPrintControl[n - 1].hashCode();
        }
        Integer n4 = (Integer)mediaCache.get(new CacheKey(n, n2, n3));
        if (n4 != null) {
            int n5 = n4;
            if (bl) {
                int n6 = (int)((double)n2 / 3.527777778 + 0.5);
                int n7 = (int)((double)n3 / 3.527777778 + 0.5);
                if (n6 == PrintControl.WIDTHS[n5] && n7 == PrintControl.LENGTHS[n5] || n6 == PrintControl.LENGTHS[n5] && n7 == PrintControl.WIDTHS[n5]) {
                    return n5;
                }
                return -1;
            }
            return n5;
        }
        int n8 = (int)((double)n2 / 3.527777778 + 0.5);
        int n9 = (int)((double)n3 / 3.527777778 + 0.5);
        int n10 = Integer.MAX_VALUE;
        int n11 = -1;
        int n12 = 0;
        while (n12 < PrintControl.SIZES.length) {
            int n13;
            int n14 = Math.abs(n8 - PrintControl.WIDTHS[n12]) + Math.abs(n9 - PrintControl.LENGTHS[n12]);
            int n15 = n14 = n14 < (n13 = Math.abs(n8 - PrintControl.LENGTHS[n12]) + Math.abs(n9 - PrintControl.WIDTHS[n12])) ? n14 : n13;
            if (n14 < n10) {
                n10 = n14;
                n11 = n12;
                if (n10 == 0) break;
            }
            ++n12;
        }
        mediaCache.put(new CacheKey(n, n2, n3), new Integer(n11));
        if (!bl || n10 == 0) {
            return n11;
        }
        return -1;
    }

    public void setWin32MediaAttrib(int n, int n2, int n3) {
        this.setMediaAttrib(this.findWin32Media(n, n2, n3, false));
    }

    public native String getDefaultPrinterName();

    private native boolean _getCapabilities(PrinterCapabilities var1);

    public boolean getCapabilities(PrinterCapabilities printerCapabilities) {
        PrinterCapabilities printerCapabilities2 = (PrinterCapabilities)capabilitiesCache.get(printerCapabilities.getPrinterName());
        if (printerCapabilities2 != null) {
            printerCapabilities.set(printerCapabilities2);
            return true;
        }
        if (!this._getCapabilities(printerCapabilities)) {
            return false;
        }
        int[] nArray = printerCapabilities.getSizes();
        if (nArray != null) {
            TreeSet treeSet = new TreeSet();
            int n = 0;
            while (n < nArray.length) {
                if (nArray[n] != -1) {
                    treeSet.add(new Integer(nArray[n]));
                }
                ++n;
            }
            int[] nArray2 = new int[treeSet.size()];
            Iterator iterator = treeSet.iterator();
            int n2 = 0;
            while (iterator.hasNext()) {
                nArray2[n2] = (Integer)iterator.next();
                ++n2;
            }
            printerCapabilities.setSizes(nArray2);
        }
        capabilitiesCache.put(printerCapabilities.getPrinterName(), printerCapabilities);
        return true;
    }

    private native String[] _getPrinterList();

    public void getPrinterList(final PrinterListUpdatable printerListUpdatable) {
        new Thread(new Runnable(){

            public void run() {
                String[] stringArray = WPrintControl.this._getPrinterList();
                if (stringArray != null) {
                    TreeSet treeSet = new TreeSet();
                    int n = 0;
                    while (n < stringArray.length) {
                        treeSet.add(stringArray[n]);
                        ++n;
                    }
                    Iterator iterator = treeSet.iterator();
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        stringArray[n2] = (String)iterator.next();
                        ++n2;
                    }
                }
                printerListUpdatable.updatePrinterList(stringArray);
            }
        }).start();
    }

    protected PrintJob initJobWithNativeDialog() {
        WPrintDialog wPrintDialog = new WPrintDialog(this.dialogOwner, this);
        PrintJob printJob = wPrintDialog.initJob();
        wPrintDialog.dispose();
        return printJob;
    }

    protected PrintJob createPrintJob() {
        return WPrintJob.createPrintJob(this);
    }

    private static native void initIDs();

    static {
        WPrintControl.initIDs();
        dmPaperToPrintControl = new PageAttributes.MediaType[]{PageAttributes.MediaType.NA_LETTER, PageAttributes.MediaType.NA_LETTER, PageAttributes.MediaType.LEDGER, PageAttributes.MediaType.LEDGER, PageAttributes.MediaType.NA_LEGAL, PageAttributes.MediaType.INVOICE, PageAttributes.MediaType.EXECUTIVE, PageAttributes.MediaType.ISO_A3, PageAttributes.MediaType.ISO_A4, PageAttributes.MediaType.ISO_A4, PageAttributes.MediaType.ISO_A5, PageAttributes.MediaType.ISO_B4, PageAttributes.MediaType.JIS_B5, PageAttributes.MediaType.FOLIO, PageAttributes.MediaType.QUARTO, PageAttributes.MediaType.NA_10X14_ENVELOPE, PageAttributes.MediaType.B, PageAttributes.MediaType.NA_LETTER, PageAttributes.MediaType.NA_NUMBER_9_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_10_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_11_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_12_ENVELOPE, PageAttributes.MediaType.NA_NUMBER_14_ENVELOPE, PageAttributes.MediaType.C, PageAttributes.MediaType.D, PageAttributes.MediaType.E, PageAttributes.MediaType.ISO_DESIGNATED_LONG, PageAttributes.MediaType.ISO_C5, PageAttributes.MediaType.ISO_C3, PageAttributes.MediaType.ISO_C4, PageAttributes.MediaType.ISO_C6, PageAttributes.MediaType.ITALY_ENVELOPE, PageAttributes.MediaType.ISO_B4, PageAttributes.MediaType.ISO_B5, PageAttributes.MediaType.ISO_B6, PageAttributes.MediaType.ITALY_ENVELOPE, PageAttributes.MediaType.MONARCH_ENVELOPE, PageAttributes.MediaType.PERSONAL_ENVELOPE, PageAttributes.MediaType.NA_10X15_ENVELOPE, PageAttributes.MediaType.NA_9X12_ENVELOPE, PageAttributes.MediaType.FOLIO};
        mediaCache = new HashMap();
        capabilitiesCache = new HashMap();
    }

    private class CacheKey {
        int dmIndex;
        int width;
        int length;

        CacheKey(int n, int n2, int n3) {
            this.dmIndex = n;
            this.width = n2;
            this.length = n3;
        }

        public int hashCode() {
            return this.dmIndex;
        }

        public boolean equals(Object object) {
            CacheKey cacheKey = (CacheKey)object;
            return this.dmIndex == cacheKey.dmIndex && (this.width == cacheKey.width && this.length == cacheKey.length || this.width == cacheKey.length && this.length == cacheKey.width);
        }
    }
}

