/*
 * Decompiled with CFR 0.152.
 */
package sun.awt.windows;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.peer.CanvasPeer;
import java.lang.ref.WeakReference;
import java.security.AccessController;
import sun.awt.DrawingSurface;
import sun.awt.DrawingSurfaceInfo;
import sun.awt.Graphics2Delegate;
import sun.awt.Win32GraphicsDevice;
import sun.awt.windows.WComponentPeer;
import sun.awt.windows.WDrawingSurfaceInfo;
import sun.security.action.GetPropertyAction;

class WCanvasPeer
extends WComponentPeer
implements CanvasPeer,
DrawingSurface {
    private static boolean eraseBackgroundDisabled;

    WCanvasPeer(Component component) {
        super(component);
    }

    protected void initNonDefaultGC() {
        GraphicsConfiguration graphicsConfiguration = this.getTargetGC();
        if (graphicsConfiguration != null) {
            ((Win32GraphicsDevice)graphicsConfiguration.getDevice()).addNonDefaultGC(new WeakReference(this.target));
        }
    }

    native void create(WComponentPeer var1);

    void initialize() {
        super.initialize();
        Color color = ((Component)this.target).getBackground();
        if (color != null) {
            this.setBackground(color);
        }
    }

    public void paint(Graphics graphics) {
        Dimension dimension = ((Component)this.target).getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(((Component)this.target).getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(((Component)this.target).getForeground());
        }
        super.paint(graphics);
    }

    public void print(Graphics graphics) {
        Dimension dimension = ((Component)this.target).getSize();
        if (graphics instanceof Graphics2D || graphics instanceof Graphics2Delegate) {
            graphics.clearRect(0, 0, dimension.width, dimension.height);
        } else {
            graphics.setColor(((Component)this.target).getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
            graphics.setColor(((Component)this.target).getForeground());
        }
        super.print(graphics);
    }

    public DrawingSurfaceInfo getDrawingSurfaceInfo() {
        return new WDrawingSurfaceInfo(this);
    }

    public boolean shouldClearRectBeforePaint() {
        return !eraseBackgroundDisabled;
    }

    static {
        String string = (String)AccessController.doPrivileged(new GetPropertyAction("sun.awt.noerasebackground"));
        eraseBackgroundDisabled = string != null && string.length() > 0 && string.charAt(0) == 't';
    }
}

