/*
 * Decompiled with CFR 0.152.
 */
package sun.awt;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import sun.awt.Win32GraphicsDevice;

public class Win32GraphicsConfig
extends GraphicsConfiguration {
    Win32GraphicsDevice screen;
    int visual;
    ColorModel colorModel;

    private static native void initIDs();

    public static Win32GraphicsConfig getConfig(Win32GraphicsDevice win32GraphicsDevice, int n) {
        return new Win32GraphicsConfig(win32GraphicsDevice, n);
    }

    public Win32GraphicsConfig(GraphicsDevice graphicsDevice, int n) {
        this.screen = (Win32GraphicsDevice)graphicsDevice;
        this.visual = n;
    }

    public GraphicsDevice getDevice() {
        return this.screen;
    }

    public int getVisual() {
        return this.visual;
    }

    public BufferedImage createCompatibleImage(int n, int n2) {
        ColorModel colorModel = this.getColorModel();
        WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
        return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
    }

    public BufferedImage createCompatibleImage(int n, int n2, int n3) {
        switch (n3) {
            case 1: {
                return this.createCompatibleImage(n, n2);
            }
            case 2: 
            case 3: {
                ColorModel colorModel = this.getColorModel(n3);
                WritableRaster writableRaster = colorModel.createCompatibleWritableRaster(n, n2);
                return new BufferedImage(colorModel, writableRaster, colorModel.isAlphaPremultiplied(), null);
            }
        }
        throw new IllegalArgumentException("Unknown transparency type " + n3);
    }

    public synchronized ColorModel getColorModel() {
        if (this.colorModel == null) {
            this.colorModel = this.makeColorModel(this.screen.getScreen());
        }
        return this.colorModel;
    }

    private native ColorModel makeColorModel(int var1);

    public ColorModel getColorModel(int n) {
        if (n == 1) {
            return this.getColorModel();
        }
        if (n == 2) {
            return new DirectColorModel(25, 0xFF0000, 65280, 255, 0x1000000);
        }
        if (n == 3) {
            return ColorModel.getRGBdefault();
        }
        return null;
    }

    public AffineTransform getDefaultTransform() {
        return new AffineTransform();
    }

    public AffineTransform getNormalizingTransform() {
        double d = this.getXResolution() / 72.0;
        double d2 = this.getYResolution() / 72.0;
        return new AffineTransform(d, 0.0, 0.0, d2, 0.0, 0.0);
    }

    private double getXResolution() {
        return 72.0;
    }

    private double getYResolution() {
        return 72.0;
    }

    public String toString() {
        return "Win32GraphicsConfig[dev=" + this.screen + ",pixfmt=" + this.visual + "]";
    }

    private native Rectangle getBounds(int var1);

    public Rectangle getBounds() {
        return this.getBounds(this.screen.getScreen());
    }

    static {
        Win32GraphicsConfig.initIDs();
    }
}

