/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text.html;

import java.awt.Color;
import java.awt.Font;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.ImageIcon;
import javax.swing.SizeRequirements;
import javax.swing.text.AttributeSet;
import javax.swing.text.Element;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.View;
import javax.swing.text.html.HTML;

public class CSS
implements Serializable {
    private static final Hashtable attributeMap = new Hashtable();
    private static final Hashtable valueMap = new Hashtable();
    static int[] sizeMap = new int[]{8, 10, 12, 14, 18, 24, 36};
    private static final Hashtable htmlAttrToCssAttrMap = new Hashtable(20);
    private static final Hashtable styleConstantToCssMap = new Hashtable(17);
    private static final Hashtable htmlValueToCssValueMap = new Hashtable(8);
    private static final Hashtable cssValueToInternalValueMap = new Hashtable(13);
    private static Hashtable fontMapping;
    private static final Object fontMappingLock;
    private transient Hashtable valueConvertor = new Hashtable();
    private int baseFontSize = 3;

    public CSS() {
        this.valueConvertor.put(Attribute.FONT_SIZE, new FontSize());
        this.valueConvertor.put(Attribute.FONT_FAMILY, new FontFamily());
        this.valueConvertor.put(Attribute.FONT_WEIGHT, new FontWeight());
        this.valueConvertor.put(Attribute.BORDER_STYLE, new BorderStyle());
        ColorValue colorValue = new ColorValue();
        this.valueConvertor.put(Attribute.COLOR, colorValue);
        this.valueConvertor.put(Attribute.BACKGROUND_COLOR, colorValue);
        this.valueConvertor.put(Attribute.BORDER_COLOR, colorValue);
        LengthValue lengthValue = new LengthValue();
        this.valueConvertor.put(Attribute.MARGIN_TOP, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_BOTTOM, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_LEFT, lengthValue);
        this.valueConvertor.put(Attribute.MARGIN_RIGHT, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_TOP, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_BOTTOM, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_LEFT, lengthValue);
        this.valueConvertor.put(Attribute.PADDING_RIGHT, lengthValue);
        BorderWidthValue borderWidthValue = new BorderWidthValue(null, 0);
        this.valueConvertor.put(Attribute.BORDER_WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_TOP_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.BORDER_BOTTOM_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.BORDER_LEFT_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.BORDER_RIGHT_WIDTH, borderWidthValue);
        this.valueConvertor.put(Attribute.TEXT_INDENT, lengthValue);
        this.valueConvertor.put(Attribute.WIDTH, lengthValue);
        this.valueConvertor.put(Attribute.HEIGHT, lengthValue);
        this.valueConvertor.put(Attribute.BORDER_SPACING, lengthValue);
        StringValue stringValue = new StringValue();
        this.valueConvertor.put(Attribute.FONT_STYLE, stringValue);
        this.valueConvertor.put(Attribute.TEXT_DECORATION, stringValue);
        this.valueConvertor.put(Attribute.TEXT_ALIGN, stringValue);
        this.valueConvertor.put(Attribute.VERTICAL_ALIGN, stringValue);
        CssValueMapper cssValueMapper = new CssValueMapper();
        this.valueConvertor.put(Attribute.LIST_STYLE_TYPE, cssValueMapper);
        this.valueConvertor.put(Attribute.BACKGROUND_IMAGE, new BackgroundImage());
        this.valueConvertor.put(Attribute.BACKGROUND_POSITION, new BackgroundPosition());
        this.valueConvertor.put(Attribute.BACKGROUND_REPEAT, cssValueMapper);
        this.valueConvertor.put(Attribute.BACKGROUND_ATTACHMENT, cssValueMapper);
        CssValue cssValue = new CssValue();
        int n = Attribute.allAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            Attribute attribute = Attribute.allAttributes[n2];
            if (this.valueConvertor.get(attribute) == null) {
                this.valueConvertor.put(attribute, cssValue);
            }
            ++n2;
        }
    }

    void setBaseFontSize(int n) {
        this.baseFontSize = n < 1 ? 0 : (n > 7 ? 7 : n);
    }

    void setBaseFontSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n = Integer.valueOf(string.substring(1));
                this.setBaseFontSize(this.baseFontSize + n);
            } else if (string.startsWith("-")) {
                int n = -Integer.valueOf(string.substring(1)).intValue();
                this.setBaseFontSize(this.baseFontSize + n);
            } else {
                this.setBaseFontSize(Integer.valueOf(string));
            }
        }
    }

    int getBaseFontSize() {
        return this.baseFontSize;
    }

    void addInternalCSSValue(MutableAttributeSet mutableAttributeSet, Attribute attribute, String string) {
        if (attribute == Attribute.FONT) {
            ShorthandFontParser.parseShorthandFont(this, string, mutableAttributeSet);
        } else if (attribute == Attribute.BACKGROUND) {
            ShorthandBackgroundParser.parseShorthandBackground(this, string, mutableAttributeSet);
        } else if (attribute == Attribute.MARGIN) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_MARGINS);
        } else if (attribute == Attribute.PADDING) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_PADDING);
        } else if (attribute == Attribute.BORDER_WIDTH) {
            ShorthandMarginParser.parseShorthandMargin(this, string, mutableAttributeSet, Attribute.ALL_BORDER_WIDTHS);
        } else {
            Object object = this.getInternalCSSValue(attribute, string);
            if (object != null) {
                mutableAttributeSet.addAttribute(attribute, object);
            }
        }
    }

    Object getInternalCSSValue(Attribute attribute, String string) {
        CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
        return cssValue.parseCssValue(string);
    }

    Attribute styleConstantsKeyToCSSKey(StyleConstants styleConstants) {
        return (Attribute)styleConstantToCssMap.get(styleConstants);
    }

    Object styleConstantsValueToCSSValue(StyleConstants styleConstants, Object object) {
        Attribute attribute = this.styleConstantsKeyToCSSKey(styleConstants);
        if (attribute != null) {
            CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
            return cssValue.fromStyleConstants(styleConstants, object);
        }
        return null;
    }

    Object cssValueToStyleConstantsValue(StyleConstants styleConstants, Object object) {
        if (object instanceof CssValue) {
            return ((CssValue)object).toStyleConstants(styleConstants, null);
        }
        return null;
    }

    Font getFont(StyleContext styleContext, AttributeSet attributeSet, int n) {
        Object object;
        Object object2;
        int n2 = CSS.getFontSize(attributeSet, n);
        StringValue stringValue = (StringValue)attributeSet.getAttribute(Attribute.VERTICAL_ALIGN);
        if (stringValue != null && (((String)(object2 = stringValue.toString())).indexOf("sup") >= 0 || ((String)object2).indexOf("sub") >= 0)) {
            n2 -= 2;
        }
        String string = (object2 = (FontFamily)attributeSet.getAttribute(Attribute.FONT_FAMILY)) != null ? ((FontFamily)object2).getValue() : "SansSerif";
        int n3 = 0;
        FontWeight fontWeight = (FontWeight)attributeSet.getAttribute(Attribute.FONT_WEIGHT);
        if (fontWeight != null && fontWeight.getValue() > 400) {
            n3 |= 1;
        }
        if ((object = attributeSet.getAttribute(Attribute.FONT_STYLE)) != null && object.toString().indexOf("italic") >= 0) {
            n3 |= 2;
        }
        Font font = styleContext.getFont(string, n3, n2);
        return font;
    }

    static int getFontSize(AttributeSet attributeSet, int n) {
        FontSize fontSize = (FontSize)attributeSet.getAttribute(Attribute.FONT_SIZE);
        return fontSize != null ? (int)fontSize.getValue(attributeSet) : n;
    }

    Color getColor(AttributeSet attributeSet, Attribute attribute) {
        ColorValue colorValue = (ColorValue)attributeSet.getAttribute(attribute);
        if (colorValue != null) {
            return colorValue.getValue();
        }
        return null;
    }

    float getPointSize(String string) {
        if (string != null) {
            if (string.startsWith("+")) {
                int n = Integer.valueOf(string.substring(1));
                return this.getPointSize(this.baseFontSize + n);
            }
            if (string.startsWith("-")) {
                int n = -Integer.valueOf(string.substring(1)).intValue();
                return this.getPointSize(this.baseFontSize + n);
            }
            int n = Integer.valueOf(string);
            return this.getPointSize(n);
        }
        return 0.0f;
    }

    float getLength(AttributeSet attributeSet, Attribute attribute) {
        LengthValue lengthValue = (LengthValue)attributeSet.getAttribute(attribute);
        float f = lengthValue != null ? lengthValue.getValue() : 0.0f;
        return f;
    }

    AttributeSet translateHTMLToCSS(AttributeSet attributeSet) {
        Object object;
        SimpleAttributeSet simpleAttributeSet = new SimpleAttributeSet();
        Element element = (Element)((Object)attributeSet);
        HTML.Tag tag = this.getHTMLTag(attributeSet);
        if (tag == HTML.Tag.TD || tag == HTML.Tag.TH) {
            object = element.getParentElement().getParentElement().getAttributes();
            this.translateAttribute(HTML.Attribute.BORDER, (AttributeSet)object, simpleAttributeSet);
            String string = (String)object.getAttribute(HTML.Attribute.CELLPADDING);
            if (string != null) {
                Object object2 = this.getInternalCSSValue(Attribute.PADDING_TOP, string);
                simpleAttributeSet.addAttribute(Attribute.PADDING_TOP, object2);
                simpleAttributeSet.addAttribute(Attribute.PADDING_BOTTOM, object2);
                simpleAttributeSet.addAttribute(Attribute.PADDING_LEFT, object2);
                simpleAttributeSet.addAttribute(Attribute.PADDING_RIGHT, object2);
            }
        }
        if (element.isLeaf()) {
            this.translateEmbeddedAttributes(attributeSet, simpleAttributeSet);
        } else {
            this.translateAttributes(tag, attributeSet, simpleAttributeSet);
        }
        if (tag == HTML.Tag.CAPTION) {
            object = attributeSet.getAttribute(HTML.Attribute.ALIGN);
            if (object != null && (object.equals("top") || object.equals("bottom"))) {
                simpleAttributeSet.addAttribute(Attribute.CAPTION_SIDE, object);
                simpleAttributeSet.removeAttribute(Attribute.TEXT_ALIGN);
            } else {
                object = attributeSet.getAttribute(HTML.Attribute.VALIGN);
                if (object != null) {
                    simpleAttributeSet.addAttribute(Attribute.CAPTION_SIDE, object);
                }
            }
        }
        return simpleAttributeSet;
    }

    static Hashtable getValidFontNameMapping() {
        if (fontMapping == null) {
            Object object = fontMappingLock;
            synchronized (object) {
                if (fontMapping == null) {
                    String[] stringArray = null;
                    try {
                        Object object2;
                        Method method;
                        Class clazz = Class.forName("java.awt.GraphicsEnvironment");
                        if (clazz != null && (method = clazz.getDeclaredMethod("getLocalGraphicsEnvironment", null)) != null && (object2 = method.invoke(clazz, null)) != null && (method = clazz.getMethod("getAvailableFontFamilyNames", null)) != null) {
                            stringArray = (String[])method.invoke(object2, null);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (stringArray == null) {
                        stringArray = Toolkit.getDefaultToolkit().getFontList();
                    }
                    if (stringArray != null) {
                        fontMapping = new Hashtable(stringArray.length * 2);
                        int n = stringArray.length - 1;
                        while (n >= 0) {
                            fontMapping.put(stringArray[n].toLowerCase(), stringArray[n]);
                            fontMapping.put(stringArray[n], stringArray[n]);
                            --n;
                        }
                    } else {
                        fontMapping = new Hashtable(1);
                    }
                }
            }
        }
        return fontMapping;
    }

    public static Attribute[] getAllAttributeKeys() {
        Attribute[] attributeArray = new Attribute[Attribute.allAttributes.length];
        System.arraycopy(Attribute.allAttributes, 0, attributeArray, 0, Attribute.allAttributes.length);
        return attributeArray;
    }

    public static final Attribute getAttribute(String string) {
        return (Attribute)attributeMap.get(string);
    }

    static final Value getValue(String string) {
        return (Value)valueMap.get(string);
    }

    static URL getURL(URL uRL, String string) {
        URL uRL2;
        if (string == null) {
            return null;
        }
        if (string.startsWith("url(") && string.endsWith(")")) {
            string = string.substring(4, string.length() - 1);
        }
        try {
            uRL2 = new URL(string);
            if (uRL2 != null) {
                return uRL2;
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (uRL != null) {
            try {
                uRL2 = new URL(uRL, string);
                return uRL2;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    static String colorToHex(Color color) {
        String string = new String("#");
        String string2 = Integer.toHexString(color.getRed());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getGreen());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        string2 = Integer.toHexString(color.getBlue());
        if (string2.length() > 2) {
            string2 = string2.substring(0, 2);
        } else {
            string = string2.length() < 2 ? string + "0" + string2 : string + string2;
        }
        return string;
    }

    static final Color hexToColor(String string) {
        Color color;
        int n = string.length();
        String string2 = string.startsWith("#") ? string.substring(1, Math.min(string.length(), 7)) : string;
        String string3 = "0x" + string2;
        try {
            color = Color.decode(string3);
        }
        catch (NumberFormatException numberFormatException) {
            color = null;
        }
        return color;
    }

    static Color stringToColor(String string) {
        Color color = null;
        color = string.charAt(0) == '#' ? CSS.hexToColor(string) : (string.equalsIgnoreCase("Black") ? CSS.hexToColor("#000000") : (string.equalsIgnoreCase("Silver") ? CSS.hexToColor("#C0C0C0") : (string.equalsIgnoreCase("Gray") ? CSS.hexToColor("#808080") : (string.equalsIgnoreCase("White") ? CSS.hexToColor("#FFFFFF") : (string.equalsIgnoreCase("Maroon") ? CSS.hexToColor("#800000") : (string.equalsIgnoreCase("Red") ? CSS.hexToColor("#FF0000") : (string.equalsIgnoreCase("Purple") ? CSS.hexToColor("#800080") : (string.equalsIgnoreCase("Fuchsia") ? CSS.hexToColor("#FF00FF") : (string.equalsIgnoreCase("Green") ? CSS.hexToColor("#008000") : (string.equalsIgnoreCase("Lime") ? CSS.hexToColor("#00FF00") : (string.equalsIgnoreCase("Olive") ? CSS.hexToColor("#808000") : (string.equalsIgnoreCase("Yellow") ? CSS.hexToColor("#FFFF00") : (string.equalsIgnoreCase("Navy") ? CSS.hexToColor("#000080") : (string.equalsIgnoreCase("Blue") ? CSS.hexToColor("#0000FF") : (string.equalsIgnoreCase("Teal") ? CSS.hexToColor("#008080") : (string.equalsIgnoreCase("Aqua") ? CSS.hexToColor("#00FFFF") : CSS.hexToColor(string)))))))))))))))));
        return color;
    }

    static int getIndexOfSize(float f) {
        int n = 0;
        while (n < sizeMap.length) {
            if (f <= (float)sizeMap[n]) {
                return n;
            }
            ++n;
        }
        return sizeMap.length - 1;
    }

    /*
     * Unable to fully structure code
     */
    static String[] parseStrings(String var0) {
        var3_1 = var0 == null ? 0 : var0.length();
        var4_2 = new Vector(4);
        var1_3 = 0;
        ** GOTO lbl15
        {
            ++var1_3;
            do {
                if (var1_3 < var3_1 && Character.isWhitespace(var0.charAt(var1_3))) continue block0;
                var2_4 = var1_3;
                while (var1_3 < var3_1 && !Character.isWhitespace(var0.charAt(var1_3))) {
                    ++var1_3;
                }
                if (var2_4 != var1_3) {
                    var4_2.addElement(var0.substring(var2_4, var1_3));
                }
                ++var1_3;
lbl15:
                // 2 sources

            } while (var1_3 < var3_1);
        }
        var5_5 = new String[var4_2.size()];
        var4_2.copyInto(var5_5);
        return var5_5;
    }

    float getPointSize(int n) {
        if (n < 0) {
            return sizeMap[0];
        }
        if (n > sizeMap.length - 1) {
            return sizeMap[sizeMap.length - 1];
        }
        return sizeMap[n];
    }

    private void translateEmbeddedAttributes(AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        if (attributeSet.getAttribute(StyleConstants.NameAttribute) == HTML.Tag.HR) {
            this.translateAttributes(HTML.Tag.HR, attributeSet, mutableAttributeSet);
        }
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof HTML.Tag) {
                HTML.Tag tag = (HTML.Tag)object;
                Object object2 = attributeSet.getAttribute(tag);
                if (object2 == null || !(object2 instanceof AttributeSet)) continue;
                this.translateAttributes(tag, (AttributeSet)object2, mutableAttributeSet);
                continue;
            }
            if (!(object instanceof Attribute)) continue;
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
    }

    private void translateAttributes(HTML.Tag tag, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Enumeration enumeration = attributeSet.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            Object object = enumeration.nextElement();
            if (object instanceof HTML.Attribute) {
                HTML.Attribute attribute = (HTML.Attribute)object;
                if (attribute == HTML.Attribute.ALIGN) {
                    Object object2;
                    Attribute attribute2;
                    String string = (String)attributeSet.getAttribute(HTML.Attribute.ALIGN);
                    if (string == null || (attribute2 = this.getCssAlignAttribute(tag, attributeSet)) == null || (object2 = this.getCssValue(attribute2, string)) == null) continue;
                    mutableAttributeSet.addAttribute(attribute2, object2);
                    continue;
                }
                if (attribute == HTML.Attribute.SIZE && !this.isHTMLFontTag(tag)) continue;
                this.translateAttribute(attribute, attributeSet, mutableAttributeSet);
                continue;
            }
            if (!(object instanceof Attribute)) continue;
            mutableAttributeSet.addAttribute(object, attributeSet.getAttribute(object));
        }
    }

    private void translateAttribute(HTML.Attribute attribute, AttributeSet attributeSet, MutableAttributeSet mutableAttributeSet) {
        Attribute[] attributeArray = this.getCssAttribute(attribute);
        String string = (String)attributeSet.getAttribute(attribute);
        if (attributeArray == null || string == null) {
            return;
        }
        int n = 0;
        while (n < attributeArray.length) {
            Object object = this.getCssValue(attributeArray[n], string);
            if (object != null) {
                mutableAttributeSet.addAttribute(attributeArray[n], object);
            }
            ++n;
        }
    }

    Object getCssValue(Attribute attribute, String string) {
        CssValue cssValue = (CssValue)this.valueConvertor.get(attribute);
        Object object = cssValue.parseHtmlValue(string);
        return object;
    }

    private Attribute[] getCssAttribute(HTML.Attribute attribute) {
        return (Attribute[])htmlAttrToCssAttrMap.get(attribute);
    }

    private Attribute getCssAlignAttribute(HTML.Tag tag, AttributeSet attributeSet) {
        return Attribute.TEXT_ALIGN;
    }

    private HTML.Tag getHTMLTag(AttributeSet attributeSet) {
        Object object = attributeSet.getAttribute(StyleConstants.NameAttribute);
        if (object instanceof HTML.Tag) {
            HTML.Tag tag = (HTML.Tag)object;
            return tag;
        }
        return null;
    }

    private boolean isHTMLFontTag(HTML.Tag tag) {
        return tag != null && (tag == HTML.Tag.FONT || tag == HTML.Tag.BASEFONT);
    }

    private boolean isFloater(String string) {
        return string.equals("left") || string.equals("right");
    }

    private boolean validTextAlignValue(String string) {
        return this.isFloater(string) || string.equals("center");
    }

    static SizeRequirements calculateTiledRequirements(LayoutIterator layoutIterator, SizeRequirements sizeRequirements) {
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n = 0;
        int n2 = 0;
        int n3 = layoutIterator.getCount();
        int n4 = 0;
        while (n4 < n3) {
            layoutIterator.setIndex(n4);
            int n5 = n;
            int n6 = (int)layoutIterator.getLeadingCollapseSpan();
            int n7 = Math.max(n5, n6);
            if (n7 != 0) {
                n2 += n7 - n5;
            }
            l3 += (long)((int)layoutIterator.getPreferredSpan(0.0f));
            l = (long)((float)l + layoutIterator.getMinimumSpan(0.0f));
            l2 = (long)((float)l2 + layoutIterator.getMaximumSpan(0.0f));
            n = (int)layoutIterator.getTrailingCollapseSpan();
            ++n4;
        }
        l -= (long)n2;
        l3 -= (long)n2;
        l2 -= (long)n2;
        if (sizeRequirements == null) {
            sizeRequirements = new SizeRequirements();
        }
        sizeRequirements.minimum = l > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l;
        sizeRequirements.preferred = l3 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l3;
        sizeRequirements.maximum = l2 > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)l2;
        return sizeRequirements;
    }

    static void calculateTiledLayout(LayoutIterator layoutIterator, int n) {
        int n2;
        long l = 0L;
        long l2 = 0L;
        long l3 = 0L;
        int n3 = 0;
        int n4 = 0;
        int n5 = layoutIterator.getCount();
        int n6 = 0;
        while (n6 < n5) {
            layoutIterator.setIndex(n6);
            n2 = n3;
            int n7 = (int)layoutIterator.getLeadingCollapseSpan();
            layoutIterator.setOffset(Math.max(n2, n7));
            if (layoutIterator.getOffset() != 0) {
                layoutIterator.setOffset(layoutIterator.getOffset() - n2);
                n4 += layoutIterator.getOffset();
            }
            layoutIterator.setSpan((int)layoutIterator.getPreferredSpan(n));
            l3 += (long)layoutIterator.getSpan();
            l = (long)((float)l + layoutIterator.getMinimumSpan(n));
            l2 = (long)((float)l2 + layoutIterator.getMaximumSpan(n));
            n3 = (int)layoutIterator.getTrailingCollapseSpan();
            ++n6;
        }
        n2 = n - n4;
        long l4 = (long)n2 - l3;
        float f = 0.0f;
        if (l4 != 0L) {
            float f2 = l4 > 0L ? (float)(l2 - l3) : (float)(l3 - l);
            f = (float)l4 / f2;
            f = Math.min(f, 1.0f);
            f = Math.max(f, -1.0f);
        }
        int n8 = 0;
        int n9 = 0;
        while (n9 < n5) {
            layoutIterator.setIndex(n9);
            layoutIterator.setOffset(layoutIterator.getOffset() + n8);
            int n10 = f > 0.0f ? (int)layoutIterator.getMaximumSpan(n) - layoutIterator.getSpan() : layoutIterator.getSpan() - (int)layoutIterator.getMinimumSpan(n);
            int n11 = (int)(f * (float)n10 + 0.5f);
            layoutIterator.setSpan(layoutIterator.getSpan() + n11);
            n8 = (int)Math.min((long)n8 + (long)layoutIterator.getSpan(), Integer.MAX_VALUE);
            ++n9;
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.defaultWriteObject();
        Enumeration enumeration = this.valueConvertor.keys();
        objectOutputStream.writeInt(this.valueConvertor.size());
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                Object object = enumeration.nextElement();
                Object object2 = this.valueConvertor.get(object);
                if (!(object instanceof Serializable) && (object = StyleContext.getStaticAttributeKey(object)) == null) {
                    object = null;
                    object2 = null;
                } else if (!(object2 instanceof Serializable) && (object2 = StyleContext.getStaticAttributeKey(object2)) == null) {
                    object = null;
                    object2 = null;
                }
                objectOutputStream.writeObject(object);
                objectOutputStream.writeObject(object2);
            }
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
        objectInputStream.defaultReadObject();
        int n = objectInputStream.readInt();
        this.valueConvertor = new Hashtable(Math.max(1, n));
        while (n-- > 0) {
            Object object;
            Object object2 = objectInputStream.readObject();
            Object object3 = objectInputStream.readObject();
            Object object4 = StyleContext.getStaticAttribute(object2);
            if (object4 != null) {
                object2 = object4;
            }
            if ((object = StyleContext.getStaticAttribute(object3)) != null) {
                object3 = object;
            }
            if (object2 == null || object3 == null) continue;
            this.valueConvertor.put(object2, object3);
        }
    }

    static {
        fontMappingLock = new Object();
        int n = 0;
        while (n < Attribute.allAttributes.length) {
            attributeMap.put(Attribute.allAttributes[n].toString(), Attribute.allAttributes[n]);
            ++n;
        }
        int n2 = 0;
        while (n2 < Value.allValues.length) {
            valueMap.put(Value.allValues[n2].toString(), Value.allValues[n2]);
            ++n2;
        }
        htmlAttrToCssAttrMap.put(HTML.Attribute.COLOR, new Attribute[]{Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.TEXT, new Attribute[]{Attribute.COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CLEAR, new Attribute[]{Attribute.CLEAR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BACKGROUND, new Attribute[]{Attribute.BACKGROUND_IMAGE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BGCOLOR, new Attribute[]{Attribute.BACKGROUND_COLOR});
        htmlAttrToCssAttrMap.put(HTML.Attribute.WIDTH, new Attribute[]{Attribute.WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HEIGHT, new Attribute[]{Attribute.HEIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.BORDER, new Attribute[]{Attribute.BORDER_TOP_WIDTH, Attribute.BORDER_RIGHT_WIDTH, Attribute.BORDER_BOTTOM_WIDTH, Attribute.BORDER_LEFT_WIDTH});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLPADDING, new Attribute[]{Attribute.PADDING});
        htmlAttrToCssAttrMap.put(HTML.Attribute.CELLSPACING, new Attribute[]{Attribute.BORDER_SPACING});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINWIDTH, new Attribute[]{Attribute.MARGIN_LEFT, Attribute.MARGIN_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.MARGINHEIGHT, new Attribute[]{Attribute.MARGIN_TOP, Attribute.MARGIN_BOTTOM});
        htmlAttrToCssAttrMap.put(HTML.Attribute.HSPACE, new Attribute[]{Attribute.PADDING_LEFT, Attribute.PADDING_RIGHT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VSPACE, new Attribute[]{Attribute.PADDING_BOTTOM, Attribute.PADDING_TOP});
        htmlAttrToCssAttrMap.put(HTML.Attribute.FACE, new Attribute[]{Attribute.FONT_FAMILY});
        htmlAttrToCssAttrMap.put(HTML.Attribute.SIZE, new Attribute[]{Attribute.FONT_SIZE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.VALIGN, new Attribute[]{Attribute.VERTICAL_ALIGN});
        htmlAttrToCssAttrMap.put(HTML.Attribute.ALIGN, new Attribute[]{Attribute.VERTICAL_ALIGN, Attribute.TEXT_ALIGN, Attribute.FLOAT});
        htmlAttrToCssAttrMap.put(HTML.Attribute.TYPE, new Attribute[]{Attribute.LIST_STYLE_TYPE});
        htmlAttrToCssAttrMap.put(HTML.Attribute.NOWRAP, new Attribute[]{Attribute.WHITE_SPACE});
        styleConstantToCssMap.put(StyleConstants.FontFamily, Attribute.FONT_FAMILY);
        styleConstantToCssMap.put(StyleConstants.FontSize, Attribute.FONT_SIZE);
        styleConstantToCssMap.put(StyleConstants.Bold, Attribute.FONT_WEIGHT);
        styleConstantToCssMap.put(StyleConstants.Italic, Attribute.FONT_STYLE);
        styleConstantToCssMap.put(StyleConstants.Underline, Attribute.TEXT_DECORATION);
        styleConstantToCssMap.put(StyleConstants.StrikeThrough, Attribute.TEXT_DECORATION);
        styleConstantToCssMap.put(StyleConstants.Superscript, Attribute.VERTICAL_ALIGN);
        styleConstantToCssMap.put(StyleConstants.Subscript, Attribute.VERTICAL_ALIGN);
        styleConstantToCssMap.put(StyleConstants.Foreground, Attribute.COLOR);
        styleConstantToCssMap.put(StyleConstants.Background, Attribute.BACKGROUND_COLOR);
        styleConstantToCssMap.put(StyleConstants.FirstLineIndent, Attribute.TEXT_INDENT);
        styleConstantToCssMap.put(StyleConstants.LeftIndent, Attribute.MARGIN_LEFT);
        styleConstantToCssMap.put(StyleConstants.RightIndent, Attribute.MARGIN_RIGHT);
        styleConstantToCssMap.put(StyleConstants.SpaceAbove, Attribute.MARGIN_TOP);
        styleConstantToCssMap.put(StyleConstants.SpaceBelow, Attribute.MARGIN_BOTTOM);
        styleConstantToCssMap.put(StyleConstants.Alignment, Attribute.TEXT_ALIGN);
        htmlValueToCssValueMap.put("disc", Value.DISC);
        htmlValueToCssValueMap.put("square", Value.SQUARE);
        htmlValueToCssValueMap.put("circle", Value.CIRCLE);
        htmlValueToCssValueMap.put("1", Value.DECIMAL);
        htmlValueToCssValueMap.put("a", Value.LOWER_ALPHA);
        htmlValueToCssValueMap.put("A", Value.UPPER_ALPHA);
        htmlValueToCssValueMap.put("i", Value.LOWER_ROMAN);
        htmlValueToCssValueMap.put("I", Value.UPPER_ROMAN);
        cssValueToInternalValueMap.put("disc", Value.DISC);
        cssValueToInternalValueMap.put("square", Value.SQUARE);
        cssValueToInternalValueMap.put("circle", Value.CIRCLE);
        cssValueToInternalValueMap.put("decimal", Value.DECIMAL);
        cssValueToInternalValueMap.put("lower-roman", Value.LOWER_ROMAN);
        cssValueToInternalValueMap.put("upper-roman", Value.UPPER_ROMAN);
        cssValueToInternalValueMap.put("lower-alpha", Value.LOWER_ALPHA);
        cssValueToInternalValueMap.put("upper-alpha", Value.UPPER_ALPHA);
        cssValueToInternalValueMap.put("repeat", Value.BACKGROUND_REPEAT);
        cssValueToInternalValueMap.put("no-repeat", Value.BACKGROUND_NO_REPEAT);
        cssValueToInternalValueMap.put("repeat-x", Value.BACKGROUND_REPEAT_X);
        cssValueToInternalValueMap.put("repeat-y", Value.BACKGROUND_REPEAT_Y);
        cssValueToInternalValueMap.put("scroll", Value.BACKGROUND_SCROLL);
        cssValueToInternalValueMap.put("fixed", Value.BACKGROUND_FIXED);
        Object[] objectArray = Attribute.allAttributes;
        try {
            int n3 = 0;
            while (n3 < objectArray.length) {
                StyleContext.registerStaticAttributeKey(objectArray[n3]);
                ++n3;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        objectArray = Value.allValues;
        try {
            int n4 = 0;
            while (n4 < objectArray.length) {
                StyleContext.registerStaticAttributeKey(objectArray[n4]);
                ++n4;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static interface LayoutIterator {
        public void setOffset(int var1);

        public int getOffset();

        public void setSpan(int var1);

        public int getSpan();

        public int getCount();

        public void setIndex(int var1);

        public float getMinimumSpan(float var1);

        public float getPreferredSpan(float var1);

        public float getMaximumSpan(float var1);

        public float getLeadingCollapseSpan();

        public float getTrailingCollapseSpan();
    }

    static class ShorthandMarginParser {
        ShorthandMarginParser() {
        }

        static void parseShorthandMargin(CSS cSS, String string, MutableAttributeSet mutableAttributeSet, Attribute[] attributeArray) {
            String[] stringArray = CSS.parseStrings(string);
            int n = stringArray.length;
            boolean bl = false;
            switch (n) {
                case 0: {
                    return;
                }
                case 1: {
                    int n2 = 0;
                    while (n2 < 4) {
                        cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[n2], stringArray[0]);
                        ++n2;
                    }
                    break;
                }
                case 2: {
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[0], stringArray[0]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[2], stringArray[0]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[1], stringArray[1]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[3], stringArray[1]);
                    break;
                }
                case 3: {
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[0], stringArray[0]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[1], stringArray[1]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[2], stringArray[2]);
                    cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[3], stringArray[1]);
                    break;
                }
                default: {
                    int n3 = 0;
                    while (n3 < 4) {
                        cSS.addInternalCSSValue(mutableAttributeSet, attributeArray[n3], stringArray[n3]);
                        ++n3;
                    }
                    break block0;
                }
            }
        }
    }

    static class ShorthandBackgroundParser {
        ShorthandBackgroundParser() {
        }

        static void parseShorthandBackground(CSS cSS, String string, MutableAttributeSet mutableAttributeSet) {
            String[] stringArray = CSS.parseStrings(string);
            int n = stringArray.length;
            int n2 = 0;
            int n3 = 0;
            while (n2 < n) {
                String string2 = stringArray[n2++];
                if ((n3 & 1) == 0 && ShorthandBackgroundParser.isImage(string2)) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_IMAGE, string2);
                    n3 = (short)(n3 | 1);
                    continue;
                }
                if ((n3 & 2) == 0 && ShorthandBackgroundParser.isRepeat(string2)) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_REPEAT, string2);
                    n3 = (short)(n3 | 2);
                    continue;
                }
                if ((n3 & 4) == 0 && ShorthandBackgroundParser.isAttachment(string2)) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_ATTACHMENT, string2);
                    n3 = (short)(n3 | 4);
                    continue;
                }
                if ((n3 & 8) == 0 && ShorthandBackgroundParser.isPosition(string2)) {
                    if (n2 < n && ShorthandBackgroundParser.isPosition(stringArray[n2])) {
                        cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_POSITION, string2 + " " + stringArray[n2++]);
                    } else {
                        cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_POSITION, string2);
                    }
                    n3 = (short)(n3 | 8);
                    continue;
                }
                if ((n3 & 0x10) != 0 || !ShorthandBackgroundParser.isColor(string2)) continue;
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_COLOR, string2);
                n3 = (short)(n3 | 0x10);
            }
            if (!(n3 & true)) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_IMAGE, null);
            }
            if ((n3 & 2) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_REPEAT, "repeat");
            }
            if ((n3 & 4) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_ATTACHMENT, "scroll");
            }
            if ((n3 & 8) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.BACKGROUND_POSITION, null);
            }
        }

        static boolean isImage(String string) {
            return string.startsWith("url(") && string.endsWith(")");
        }

        static boolean isRepeat(String string) {
            return string.equals("repeat-x") || string.equals("repeat-y") || string.equals("repeat") || string.equals("no-repeat");
        }

        static boolean isAttachment(String string) {
            return string.equals("fixed") || string.equals("scroll");
        }

        static boolean isPosition(String string) {
            return string.equals("top") || string.equals("bottom") || string.equals("left") || string.equals("right") || string.equals("center") || string.length() > 0 && Character.isDigit(string.charAt(0));
        }

        static boolean isColor(String string) {
            return CSS.stringToColor(string) != null;
        }
    }

    static class ShorthandFontParser {
        ShorthandFontParser() {
        }

        static void parseShorthandFont(CSS cSS, String string, MutableAttributeSet mutableAttributeSet) {
            String string2;
            String[] stringArray = CSS.parseStrings(string);
            int n = stringArray.length;
            int n2 = 0;
            int n3 = 0;
            int n4 = Math.min(3, n);
            while (n2 < n4) {
                if (!(n3 & true) && ShorthandFontParser.isFontStyle(stringArray[n2])) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_STYLE, stringArray[n2++]);
                    n3 = (short)(n3 | 1);
                    continue;
                }
                if ((n3 & 2) == 0 && ShorthandFontParser.isFontVariant(stringArray[n2])) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_VARIANT, stringArray[n2++]);
                    n3 = (short)(n3 | 2);
                    continue;
                }
                if ((n3 & 4) == 0 && ShorthandFontParser.isFontWeight(stringArray[n2])) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_WEIGHT, stringArray[n2++]);
                    n3 = (short)(n3 | 4);
                    continue;
                }
                if (!stringArray[n2].equals("normal")) break;
                ++n2;
            }
            if (!(n3 & true)) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_STYLE, "normal");
            }
            if ((n3 & 2) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_VARIANT, "normal");
            }
            if ((n3 & 4) == 0) {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_WEIGHT, "normal");
            }
            if (n2 < n) {
                string2 = stringArray[n2];
                int n5 = string2.indexOf(47);
                if (n5 != -1) {
                    string2 = string2.substring(0, n5);
                    stringArray[n2] = stringArray[n2].substring(n5);
                } else {
                    ++n2;
                }
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_SIZE, string2);
            } else {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_SIZE, "medium");
            }
            if (n2 < n && stringArray[n2].startsWith("/")) {
                string2 = null;
                if (stringArray[n2].equals("/")) {
                    if (++n2 < n) {
                        string2 = stringArray[n2++];
                    }
                } else {
                    string2 = stringArray[n2++].substring(1);
                }
                if (string2 != null) {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.LINE_HEIGHT, string2);
                } else {
                    cSS.addInternalCSSValue(mutableAttributeSet, Attribute.LINE_HEIGHT, "normal");
                }
            } else {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.LINE_HEIGHT, "normal");
            }
            if (n2 < n) {
                string2 = stringArray[n2++];
                while (n2 < n) {
                    string2 = string2 + " " + stringArray[n2++];
                }
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_FAMILY, string2);
            } else {
                cSS.addInternalCSSValue(mutableAttributeSet, Attribute.FONT_FAMILY, "SansSerif");
            }
        }

        private static boolean isFontStyle(String string) {
            return string.equals("italic") || string.equals("oblique");
        }

        private static boolean isFontVariant(String string) {
            return string.equals("small-caps");
        }

        private static boolean isFontWeight(String string) {
            if (string.equals("bold") || string.equals("bolder") || string.equals("italic") || string.equals("lighter")) {
                return true;
            }
            return string.length() == 3 && string.charAt(0) >= '1' && string.charAt(0) <= '9' && string.charAt(1) == '0' && string.charAt(2) == '0';
        }
    }

    static class LengthUnit
    implements Serializable {
        static Hashtable lengthMapping = new Hashtable(6);
        short type;
        float value;
        static final short UNINITALIZED_LENGTH = 10;

        LengthUnit(String string, short s, float f) {
            this.parse(string, s, f);
        }

        void parse(String string, short s, float f) {
            this.type = s;
            this.value = f;
            int n = string.length();
            if (n > 0 && string.charAt(n - 1) == '%') {
                try {
                    this.value = Float.valueOf(string.substring(0, n - 1)).floatValue() / 100.0f;
                    this.type = 1;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (n >= 2) {
                String string2 = string.substring(n - 2, n);
                Float f2 = (Float)lengthMapping.get(string2);
                if (f2 != null) {
                    try {
                        this.value = Float.valueOf(string.substring(0, n - 2)).floatValue() * f2.floatValue();
                        this.type = 0;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string2.equals("em") || string2.equals("ex")) {
                    try {
                        this.value = Float.valueOf(string.substring(0, n - 2)).floatValue();
                        this.type = (short)3;
                    }
                    catch (NumberFormatException numberFormatException) {}
                } else if (string.equals("larger")) {
                    this.value = 2.0f;
                    this.type = (short)2;
                } else if (string.equals("smaller")) {
                    this.value = -2.0f;
                    this.type = (short)2;
                } else {
                    try {
                        this.value = Float.valueOf(string).floatValue();
                        this.type = 0;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
            }
        }

        public String toString() {
            return this.type + " " + this.value;
        }

        static {
            lengthMapping.put("pt", new Float(1.0f));
            lengthMapping.put("px", new Float(1.3f));
            lengthMapping.put("mm", new Float(2.83464f));
            lengthMapping.put("cm", new Float(28.3464f));
            lengthMapping.put("pc", new Float(12.0f));
            lengthMapping.put("in", new Float(72.0f));
        }
    }

    static class BackgroundImage
    extends CssValue {
        private boolean loadedImage;
        private ImageIcon image;

        BackgroundImage() {
        }

        Object parseCssValue(String string) {
            BackgroundImage backgroundImage = new BackgroundImage();
            backgroundImage.svalue = string;
            return backgroundImage;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        ImageIcon getImage(URL uRL) {
            if (!this.loadedImage) {
                BackgroundImage backgroundImage = this;
                synchronized (backgroundImage) {
                    if (!this.loadedImage) {
                        URL uRL2 = CSS.getURL(uRL, this.svalue);
                        this.loadedImage = true;
                        if (uRL2 != null) {
                            this.image = new ImageIcon(uRL2);
                        }
                    }
                }
            }
            return this.image;
        }
    }

    static class BackgroundPosition
    extends CssValue {
        float horizontalPosition;
        float verticalPosition;
        short relative;

        BackgroundPosition() {
        }

        Object parseCssValue(String string) {
            String[] stringArray = CSS.parseStrings(string);
            int n = stringArray.length;
            BackgroundPosition backgroundPosition = new BackgroundPosition();
            backgroundPosition.relative = (short)5;
            backgroundPosition.svalue = string;
            if (n > 0) {
                Object object;
                int n2 = 0;
                int n3 = 0;
                while (n3 < n) {
                    if (((String)(object = stringArray[n3++])).equals("center")) {
                        n2 = (short)(n2 | 4);
                        continue;
                    }
                    if ((n2 & 1) == 0) {
                        if (((String)object).equals("top")) {
                            n2 = (short)(n2 | 1);
                        } else if (((String)object).equals("bottom")) {
                            n2 = (short)(n2 | 1);
                            backgroundPosition.verticalPosition = 1.0f;
                            continue;
                        }
                    }
                    if ((n2 & 2) != 0) continue;
                    if (((String)object).equals("left")) {
                        n2 = (short)(n2 | 2);
                        backgroundPosition.horizontalPosition = 0.0f;
                        continue;
                    }
                    if (!((String)object).equals("right")) continue;
                    n2 = (short)(n2 | 2);
                    backgroundPosition.horizontalPosition = 1.0f;
                }
                if (n2 != 0) {
                    if (n2 & true) {
                        if ((n2 & 2) == 0) {
                            backgroundPosition.horizontalPosition = 0.5f;
                        }
                    } else if ((n2 & 2) == 2) {
                        backgroundPosition.verticalPosition = 0.5f;
                    } else {
                        backgroundPosition.verticalPosition = 0.5f;
                        backgroundPosition.horizontalPosition = 0.5f;
                    }
                } else {
                    object = new LengthUnit(stringArray[0], 0, 0.0f);
                    if (((LengthUnit)object).type == 0) {
                        backgroundPosition.horizontalPosition = ((LengthUnit)object).value;
                        backgroundPosition.relative = (short)(1 ^ backgroundPosition.relative);
                    } else if (((LengthUnit)object).type == 1) {
                        backgroundPosition.horizontalPosition = ((LengthUnit)object).value;
                    } else if (((LengthUnit)object).type == 3) {
                        backgroundPosition.horizontalPosition = ((LengthUnit)object).value;
                        backgroundPosition.relative = (short)(1 ^ backgroundPosition.relative | 2);
                    }
                    if (n > 1) {
                        object = new LengthUnit(stringArray[1], 0, 0.0f);
                        if (((LengthUnit)object).type == 0) {
                            backgroundPosition.verticalPosition = ((LengthUnit)object).value;
                            backgroundPosition.relative = (short)(4 ^ backgroundPosition.relative);
                        } else if (((LengthUnit)object).type == 1) {
                            backgroundPosition.verticalPosition = ((LengthUnit)object).value;
                        } else if (((LengthUnit)object).type == 3) {
                            backgroundPosition.verticalPosition = ((LengthUnit)object).value;
                            backgroundPosition.relative = (short)(4 ^ backgroundPosition.relative | 8);
                        }
                    } else {
                        backgroundPosition.verticalPosition = 0.5f;
                    }
                }
            }
            return backgroundPosition;
        }

        boolean isHorizontalPositionRelativeToSize() {
            return (this.relative & 1) == 1;
        }

        boolean isHorizontalPositionRelativeToFontSize() {
            return (this.relative & 2) == 2;
        }

        float getHorizontalPosition() {
            return this.horizontalPosition;
        }

        boolean isVerticalPositionRelativeToSize() {
            return (this.relative & 4) == 4;
        }

        boolean isVerticalPositionRelativeToFontSize() {
            return (this.relative & 8) == 8;
        }

        float getVerticalPosition() {
            return this.verticalPosition;
        }
    }

    static class CssValueMapper
    extends CssValue {
        CssValueMapper() {
        }

        Object parseCssValue(String string) {
            Object object = cssValueToInternalValueMap.get(string);
            if (object == null) {
                object = cssValueToInternalValueMap.get(string.toLowerCase());
            }
            return object;
        }

        Object parseHtmlValue(String string) {
            Object object = htmlValueToCssValueMap.get(string);
            if (object == null) {
                object = htmlValueToCssValueMap.get(string.toLowerCase());
            }
            return object;
        }
    }

    static class BorderWidthValue
    extends LengthValue {
        private int index;
        private static final float[] values = new float[]{1.0f, 2.0f, 4.0f};

        BorderWidthValue(String string, int n) {
            this.svalue = string;
            this.index = n;
        }

        float getValue() {
            return values[this.index];
        }

        float getValue(float f) {
            return values[this.index];
        }

        Object parseCssValue(String string) {
            if (string != null) {
                if (string.equals("thick")) {
                    return new BorderWidthValue(string, 2);
                }
                if (string.equals("medium")) {
                    return new BorderWidthValue(string, 1);
                }
                if (string.equals("thin")) {
                    return new BorderWidthValue(string, 0);
                }
            }
            return super.parseCssValue(string);
        }

        Object parseHtmlValue(String string) {
            if (string == "#DEFAULT") {
                return this.parseCssValue("medium");
            }
            return this.parseCssValue(string);
        }
    }

    static class LengthValue
    extends CssValue {
        boolean percentage;
        float span;

        LengthValue() {
        }

        float getValue() {
            return this.getValue(0.0f);
        }

        float getValue(float f) {
            if (this.percentage) {
                return this.span * f;
            }
            return this.span;
        }

        boolean isPercentage() {
            return this.percentage;
        }

        Object parseCssValue(String string) {
            LengthValue lengthValue;
            try {
                float f = Float.valueOf(string).floatValue();
                lengthValue = new LengthValue();
                lengthValue.span = f;
            }
            catch (NumberFormatException numberFormatException) {
                LengthUnit lengthUnit = new LengthUnit(string, 10, 0.0f);
                switch (lengthUnit.type) {
                    case 0: {
                        lengthValue = new LengthValue();
                        lengthValue.span = Math.max(0.0f, lengthUnit.value);
                        break;
                    }
                    case 1: {
                        lengthValue = new LengthValue();
                        lengthValue.span = Math.max(0.0f, Math.min(1.0f, lengthUnit.value));
                        lengthValue.percentage = true;
                        break;
                    }
                    default: {
                        return null;
                    }
                }
            }
            lengthValue.svalue = string;
            return lengthValue;
        }

        Object parseHtmlValue(String string) {
            if (string.equals("#DEFAULT")) {
                string = "1";
            }
            return this.parseCssValue(string);
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            LengthValue lengthValue = new LengthValue();
            lengthValue.svalue = object.toString();
            lengthValue.span = ((Float)object).floatValue();
            return lengthValue;
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return new Float(this.getValue());
        }
    }

    static class BorderStyle
    extends CssValue {
        private transient Value style;

        BorderStyle() {
        }

        Value getValue() {
            return this.style;
        }

        Object parseCssValue(String string) {
            Value value = CSS.getValue(string);
            if (value != null && (value == Value.INSET || value == Value.OUTSET || value == Value.NONE || value == Value.DOTTED || value == Value.DASHED || value == Value.SOLID || value == Value.DOUBLE || value == Value.GROOVE || value == Value.RIDGE)) {
                BorderStyle borderStyle = new BorderStyle();
                borderStyle.svalue = string;
                borderStyle.style = value;
                return borderStyle;
            }
            return null;
        }

        private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
            objectOutputStream.defaultWriteObject();
            if (this.style == null) {
                objectOutputStream.writeObject(null);
            } else {
                objectOutputStream.writeObject(this.style.toString());
            }
        }

        private void readObject(ObjectInputStream objectInputStream) throws ClassNotFoundException, IOException {
            objectInputStream.defaultReadObject();
            Object object = objectInputStream.readObject();
            if (object != null) {
                this.style = CSS.getValue((String)object);
            }
        }
    }

    static class ColorValue
    extends CssValue {
        Color c;

        ColorValue() {
        }

        Color getValue() {
            return this.c;
        }

        Object parseCssValue(String string) {
            Color color = CSS.stringToColor(string);
            if (color != null) {
                ColorValue colorValue = new ColorValue();
                colorValue.svalue = string;
                colorValue.c = color;
                return colorValue;
            }
            return null;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            ColorValue colorValue = new ColorValue();
            colorValue.c = (Color)object;
            colorValue.svalue = CSS.colorToHex(colorValue.c);
            return colorValue;
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return this.c;
        }
    }

    static class FontWeight
    extends CssValue {
        int weight;

        FontWeight() {
        }

        int getValue() {
            return this.weight;
        }

        Object parseCssValue(String string) {
            FontWeight fontWeight = new FontWeight();
            fontWeight.svalue = string;
            if (string.equals("bold")) {
                fontWeight.weight = 700;
            } else if (string.equals("normal")) {
                fontWeight.weight = 400;
            } else {
                try {
                    fontWeight.weight = Integer.parseInt(string);
                }
                catch (NumberFormatException numberFormatException) {
                    fontWeight = null;
                }
            }
            return fontWeight;
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (object.equals(Boolean.TRUE)) {
                return this.parseCssValue("bold");
            }
            return this.parseCssValue("normal");
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return this.weight > 500 ? Boolean.TRUE : Boolean.FALSE;
        }

        boolean isBold() {
            return this.weight > 500;
        }
    }

    static class FontFamily
    extends CssValue {
        String family;

        FontFamily() {
        }

        String getValue() {
            return this.family;
        }

        /*
         * Unable to fully structure code
         */
        Object parseCssValue(String var1_1) {
            block8: {
                block7: {
                    var2_2 = var1_1.indexOf(44);
                    var3_3 = CSS.getValidFontNameMapping();
                    var4_4 = new FontFamily();
                    var4_4.svalue = var1_1;
                    var4_4.family = null;
                    if (var2_2 != -1) break block7;
                    this.setFontName(var3_3, var4_4, var1_1);
                    break block8;
                }
                var5_5 = false;
                var7_6 = var1_1.length();
                var2_2 = 0;
                ** GOTO lbl30
                {
                    ++var2_2;
                    do {
                        if (var2_2 < var7_6 && Character.isWhitespace(var1_1.charAt(var2_2))) continue block0;
                        var6_7 = var2_2;
                        if ((var2_2 = var1_1.indexOf(44, var2_2)) == -1) {
                            var2_2 = var7_6;
                        }
                        if (var6_7 < var7_6) {
                            if (var6_7 != var2_2) {
                                var8_8 = var2_2;
                                if (var2_2 > 0 && var1_1.charAt(var2_2 - 1) == ' ') {
                                    --var8_8;
                                }
                                this.setFontName(var3_3, var4_4, var1_1.substring(var6_7, var8_8));
                                var5_5 = var4_4.family != null;
                            }
                            ++var2_2;
                            continue;
                        }
                        var5_5 = true;
lbl30:
                        // 3 sources

                    } while (!var5_5);
                }
            }
            if (var4_4.family == null) {
                var4_4.family = "SansSerif";
            }
            return var4_4;
        }

        private void setFontName(Hashtable hashtable, FontFamily fontFamily, String string) {
            fontFamily.family = (String)hashtable.get(this.mapFontName(string));
            if (fontFamily.family == null) {
                fontFamily.family = (String)hashtable.get(string.toLowerCase());
            }
        }

        private String mapFontName(String string) {
            if (string.equals("monospace")) {
                return "monospaced";
            }
            return string;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return this.parseCssValue(object.toString());
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return this.family;
        }
    }

    class FontSize
    extends CssValue {
        float value;
        boolean index;
        LengthUnit lu;

        FontSize() {
        }

        float getValue(AttributeSet attributeSet) {
            AttributeSet attributeSet2;
            if (this.index) {
                return CSS.this.getPointSize((int)this.value);
            }
            if (this.lu == null) {
                return this.value;
            }
            if (this.lu.type == 0) {
                return this.lu.value;
            }
            if (attributeSet != null && (attributeSet2 = attributeSet.getResolveParent()) != null) {
                int n = StyleConstants.getFontSize(attributeSet2);
                float f = this.lu.type == 1 || this.lu.type == 3 ? this.lu.value * (float)n : this.lu.value + (float)n;
                return f;
            }
            return 12.0f;
        }

        Object parseCssValue(String string) {
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                if (string.equals("xx-small")) {
                    fontSize.value = 0.0f;
                    fontSize.index = true;
                } else if (string.equals("x-small")) {
                    fontSize.value = 1.0f;
                    fontSize.index = true;
                } else if (string.equals("small")) {
                    fontSize.value = 2.0f;
                    fontSize.index = true;
                } else if (string.equals("medium")) {
                    fontSize.value = 3.0f;
                    fontSize.index = true;
                } else if (string.equals("large")) {
                    fontSize.value = 4.0f;
                    fontSize.index = true;
                } else if (string.equals("x-large")) {
                    fontSize.value = 5.0f;
                    fontSize.index = true;
                } else if (string.equals("xx-large")) {
                    fontSize.value = 6.0f;
                    fontSize.index = true;
                } else {
                    fontSize.lu = new LengthUnit(string, 1, 1.0f);
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }

        Object parseHtmlValue(String string) {
            FontSize fontSize = new FontSize();
            fontSize.svalue = string;
            try {
                int n = CSS.this.getBaseFontSize();
                if (string != null && string.charAt(0) == '+') {
                    int n2 = Integer.valueOf(string.substring(1));
                    fontSize.value = n + n2;
                    fontSize.index = true;
                } else if (string != null && string.charAt(0) == '-') {
                    int n3 = -Integer.valueOf(string.substring(1)).intValue();
                    fontSize.value = n + n3;
                    fontSize.index = true;
                } else {
                    fontSize.value = Integer.parseInt(string);
                    if (fontSize.value > 6.0f) {
                        fontSize.value = 6.0f;
                    } else if (fontSize.value < 0.0f) {
                        fontSize.value = 0.0f;
                    }
                    fontSize.index = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                fontSize = null;
            }
            return fontSize;
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return this.parseCssValue(object.toString());
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            if (view != null) {
                return new Integer((int)this.getValue(view.getAttributes()));
            }
            return new Integer((int)this.getValue(null));
        }
    }

    static class StringValue
    extends CssValue {
        StringValue() {
        }

        Object parseCssValue(String string) {
            StringValue stringValue = new StringValue();
            stringValue.svalue = string;
            return stringValue;
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            if (styleConstants == StyleConstants.Italic) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("italic");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Underline) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("underline");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Alignment) {
                String string;
                int n = (Integer)object;
                switch (n) {
                    case 0: {
                        string = "left";
                        break;
                    }
                    case 2: {
                        string = "right";
                        break;
                    }
                    case 1: {
                        string = "center";
                        break;
                    }
                    case 3: {
                        string = "justify";
                        break;
                    }
                    default: {
                        string = "left";
                    }
                }
                return this.parseCssValue(string);
            }
            if (styleConstants == StyleConstants.StrikeThrough) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("line-through");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Superscript) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("super");
                }
                return this.parseCssValue("");
            }
            if (styleConstants == StyleConstants.Subscript) {
                if (object.equals(Boolean.TRUE)) {
                    return this.parseCssValue("sub");
                }
                return this.parseCssValue("");
            }
            return null;
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            if (styleConstants == StyleConstants.Italic) {
                if (this.svalue.indexOf("italic") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Underline) {
                if (this.svalue.indexOf("underline") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Alignment) {
                if (this.svalue.equals("right")) {
                    return new Integer(2);
                }
                if (this.svalue.equals("center")) {
                    return new Integer(1);
                }
                if (this.svalue.equals("justify")) {
                    return new Integer(3);
                }
                return new Integer(0);
            }
            if (styleConstants == StyleConstants.StrikeThrough) {
                if (this.svalue.indexOf("line-through") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Superscript) {
                if (this.svalue.indexOf("super") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if (styleConstants == StyleConstants.Subscript) {
                if (this.svalue.indexOf("sub") >= 0) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            return null;
        }

        boolean isItalic() {
            return this.svalue.indexOf("italic") != -1;
        }

        boolean isStrike() {
            return this.svalue.indexOf("line-through") != -1;
        }

        boolean isUnderline() {
            return this.svalue.indexOf("underline") != -1;
        }

        boolean isSub() {
            return this.svalue.indexOf("sub") != -1;
        }

        boolean isSup() {
            return this.svalue.indexOf("sup") != -1;
        }
    }

    static class CssValue
    implements Serializable {
        String svalue;

        CssValue() {
        }

        Object parseCssValue(String string) {
            return string;
        }

        Object parseHtmlValue(String string) {
            return this.parseCssValue(string);
        }

        Object fromStyleConstants(StyleConstants styleConstants, Object object) {
            return null;
        }

        Object toStyleConstants(StyleConstants styleConstants, View view) {
            return null;
        }

        public String toString() {
            return this.svalue;
        }
    }

    static final class Value {
        static final Value INHERITED = new Value("inherited");
        static final Value NONE = new Value("none");
        static final Value DOTTED = new Value("dotted");
        static final Value DASHED = new Value("dashed");
        static final Value SOLID = new Value("solid");
        static final Value DOUBLE = new Value("double");
        static final Value GROOVE = new Value("groove");
        static final Value RIDGE = new Value("ridge");
        static final Value INSET = new Value("inset");
        static final Value OUTSET = new Value("outset");
        static final Value BLANK_LIST_ITEM = new Value("none");
        static final Value DISC = new Value("disc");
        static final Value CIRCLE = new Value("circle");
        static final Value SQUARE = new Value("square");
        static final Value DECIMAL = new Value("decimal");
        static final Value LOWER_ROMAN = new Value("lower-roman");
        static final Value UPPER_ROMAN = new Value("upper-roman");
        static final Value LOWER_ALPHA = new Value("lower-alpha");
        static final Value UPPER_ALPHA = new Value("upper-alpha");
        static final Value BACKGROUND_NO_REPEAT = new Value("no-repeat");
        static final Value BACKGROUND_REPEAT = new Value("repeat");
        static final Value BACKGROUND_REPEAT_X = new Value("repeat-x");
        static final Value BACKGROUND_REPEAT_Y = new Value("repeat-y");
        static final Value BACKGROUND_SCROLL = new Value("scroll");
        static final Value BACKGROUND_FIXED = new Value("fixed");
        private String name;
        static final Value[] allValues = new Value[]{INHERITED, NONE, DOTTED, DASHED, SOLID, DOUBLE, GROOVE, RIDGE, INSET, OUTSET, DISC, CIRCLE, SQUARE, DECIMAL, LOWER_ROMAN, UPPER_ROMAN, LOWER_ALPHA, UPPER_ALPHA, BLANK_LIST_ITEM, BACKGROUND_NO_REPEAT, BACKGROUND_REPEAT, BACKGROUND_REPEAT_X, BACKGROUND_REPEAT_Y, BACKGROUND_FIXED, BACKGROUND_FIXED};

        private Value(String string) {
            this.name = string;
        }

        public String toString() {
            return this.name;
        }
    }

    public static final class Attribute {
        private String name;
        private String defaultValue;
        private boolean inherited;
        public static final Attribute BACKGROUND = new Attribute("background", null, false);
        public static final Attribute BACKGROUND_ATTACHMENT = new Attribute("background-attachment", "scroll", false);
        public static final Attribute BACKGROUND_COLOR = new Attribute("background-color", "transparent", false);
        public static final Attribute BACKGROUND_IMAGE = new Attribute("background-image", "none", false);
        public static final Attribute BACKGROUND_POSITION = new Attribute("background-position", null, false);
        public static final Attribute BACKGROUND_REPEAT = new Attribute("background-repeat", "repeat", false);
        public static final Attribute BORDER = new Attribute("border", null, false);
        public static final Attribute BORDER_BOTTOM = new Attribute("border-bottom", null, false);
        public static final Attribute BORDER_BOTTOM_WIDTH = new Attribute("border-bottom-width", "medium", false);
        public static final Attribute BORDER_COLOR = new Attribute("border-color", null, false);
        public static final Attribute BORDER_LEFT = new Attribute("border-left", null, false);
        public static final Attribute BORDER_LEFT_WIDTH = new Attribute("border-left-width", "medium", false);
        public static final Attribute BORDER_RIGHT = new Attribute("border-right", null, false);
        public static final Attribute BORDER_RIGHT_WIDTH = new Attribute("border-right-width", "medium", false);
        public static final Attribute BORDER_STYLE = new Attribute("border-style", "none", false);
        public static final Attribute BORDER_TOP = new Attribute("border-top", null, false);
        public static final Attribute BORDER_TOP_WIDTH = new Attribute("border-top-width", "medium", false);
        public static final Attribute BORDER_WIDTH = new Attribute("border-width", "medium", false);
        public static final Attribute CLEAR = new Attribute("clear", "none", false);
        public static final Attribute COLOR = new Attribute("color", null, true);
        public static final Attribute DISPLAY = new Attribute("display", "block", false);
        public static final Attribute FLOAT = new Attribute("float", "none", false);
        public static final Attribute FONT = new Attribute("font", null, true);
        public static final Attribute FONT_FAMILY = new Attribute("font-family", null, true);
        public static final Attribute FONT_SIZE = new Attribute("font-size", "medium", true);
        public static final Attribute FONT_STYLE = new Attribute("font-style", "normal", true);
        public static final Attribute FONT_VARIANT = new Attribute("font-variant", "normal", true);
        public static final Attribute FONT_WEIGHT = new Attribute("font-weight", "normal", true);
        public static final Attribute HEIGHT = new Attribute("height", "auto", false);
        public static final Attribute LETTER_SPACING = new Attribute("letter-spacing", "normal", true);
        public static final Attribute LINE_HEIGHT = new Attribute("line-height", "normal", true);
        public static final Attribute LIST_STYLE = new Attribute("list-style", null, true);
        public static final Attribute LIST_STYLE_IMAGE = new Attribute("list-style-image", "none", true);
        public static final Attribute LIST_STYLE_POSITION = new Attribute("list-style-position", "outside", true);
        public static final Attribute LIST_STYLE_TYPE = new Attribute("list-style-type", "disc", true);
        public static final Attribute MARGIN = new Attribute("margin", null, false);
        public static final Attribute MARGIN_BOTTOM = new Attribute("margin-bottom", "0", false);
        public static final Attribute MARGIN_LEFT = new Attribute("margin-left", "0", false);
        public static final Attribute MARGIN_RIGHT = new Attribute("margin-right", "0", false);
        public static final Attribute MARGIN_TOP = new Attribute("margin-top", "0", false);
        public static final Attribute PADDING = new Attribute("padding", null, false);
        public static final Attribute PADDING_BOTTOM = new Attribute("padding-bottom", "0", false);
        public static final Attribute PADDING_LEFT = new Attribute("padding-left", "0", false);
        public static final Attribute PADDING_RIGHT = new Attribute("padding-right", "0", false);
        public static final Attribute PADDING_TOP = new Attribute("padding-top", "0", false);
        public static final Attribute TEXT_ALIGN = new Attribute("text-align", null, true);
        public static final Attribute TEXT_DECORATION = new Attribute("text-decoration", "none", true);
        public static final Attribute TEXT_INDENT = new Attribute("text-indent", "0", true);
        public static final Attribute TEXT_TRANSFORM = new Attribute("text-transform", "none", true);
        public static final Attribute VERTICAL_ALIGN = new Attribute("vertical-align", "baseline", false);
        public static final Attribute WORD_SPACING = new Attribute("word-spacing", "normal", true);
        public static final Attribute WHITE_SPACE = new Attribute("white-space", "normal", true);
        public static final Attribute WIDTH = new Attribute("width", "auto", false);
        static final Attribute BORDER_SPACING = new Attribute("border-spacing", "0", true);
        static final Attribute CAPTION_SIDE = new Attribute("caption-side", "left", true);
        static final Attribute[] allAttributes = new Attribute[]{BACKGROUND, BACKGROUND_ATTACHMENT, BACKGROUND_COLOR, BACKGROUND_IMAGE, BACKGROUND_POSITION, BACKGROUND_REPEAT, BORDER, BORDER_BOTTOM, BORDER_BOTTOM_WIDTH, BORDER_COLOR, BORDER_LEFT, BORDER_LEFT_WIDTH, BORDER_RIGHT, BORDER_RIGHT_WIDTH, BORDER_STYLE, BORDER_TOP, BORDER_TOP_WIDTH, BORDER_WIDTH, CLEAR, COLOR, DISPLAY, FLOAT, FONT, FONT_FAMILY, FONT_SIZE, FONT_STYLE, FONT_VARIANT, FONT_WEIGHT, HEIGHT, LETTER_SPACING, LINE_HEIGHT, LIST_STYLE, LIST_STYLE_IMAGE, LIST_STYLE_POSITION, LIST_STYLE_TYPE, MARGIN, MARGIN_BOTTOM, MARGIN_LEFT, MARGIN_RIGHT, MARGIN_TOP, PADDING, PADDING_BOTTOM, PADDING_LEFT, PADDING_RIGHT, PADDING_TOP, TEXT_ALIGN, TEXT_DECORATION, TEXT_INDENT, TEXT_TRANSFORM, VERTICAL_ALIGN, WORD_SPACING, WHITE_SPACE, WIDTH, BORDER_SPACING, CAPTION_SIDE};
        private static final Attribute[] ALL_MARGINS = new Attribute[]{MARGIN_TOP, MARGIN_RIGHT, MARGIN_BOTTOM, MARGIN_LEFT};
        private static final Attribute[] ALL_PADDING = new Attribute[]{PADDING_TOP, PADDING_RIGHT, PADDING_BOTTOM, PADDING_LEFT};
        private static final Attribute[] ALL_BORDER_WIDTHS = new Attribute[]{BORDER_TOP_WIDTH, BORDER_RIGHT_WIDTH, BORDER_BOTTOM_WIDTH, BORDER_LEFT_WIDTH};

        private Attribute(String string, String string2, boolean bl) {
            this.name = string;
            this.defaultValue = string2;
            this.inherited = bl;
        }

        public String toString() {
            return this.name;
        }

        public String getDefaultValue() {
            return this.defaultValue;
        }

        public boolean isInherited() {
            return this.inherited;
        }
    }
}

