/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.text;

import java.awt.Graphics;
import java.awt.Shape;
import java.util.Vector;
import javax.swing.event.DocumentEvent;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.BoxView;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Position;
import javax.swing.text.StateInvariantError;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;

public class ZoneView
extends BoxView {
    int maxZoneSize = 8192;
    int maxZonesLoaded = 3;

    public ZoneView(Element element, int n) {
        super(element, n);
    }

    public int getMaximumZoneSize() {
        return this.maxZoneSize;
    }

    public void setMaximumZoneSize(int n) {
        this.maxZoneSize = n;
    }

    public int getMaxZonesLoaded() {
        return this.maxZonesLoaded;
    }

    public void setMaxZonesLoaded(int n) {
        this.maxZonesLoaded = n;
    }

    protected void zoneWasLoaded(View view) {
    }

    protected void unloadZone(View view) {
        view.removeAll();
    }

    protected boolean isZoneLoaded(View view) {
        return view.getViewCount() > 0;
    }

    protected View createZone(int n, int n2) {
        Document document = this.getDocument();
        Zone zone = null;
        try {
            zone = new Zone(this.getElement(), document.createPosition(n), document.createPosition(n2));
        }
        catch (BadLocationException badLocationException) {
            throw new StateInvariantError(badLocationException.getMessage());
        }
        return zone;
    }

    protected void loadChildren(ViewFactory viewFactory) {
        Document document = this.getDocument();
        int n = this.getStartOffset();
        int n2 = this.getEndOffset();
        this.append(this.createZone(n, n2));
        this.handleInsert(n, n2 - n);
    }

    protected int getViewIndexAtPosition(int n) {
        int n2 = this.getViewCount();
        if (n == this.getEndOffset()) {
            return n2 - 1;
        }
        int n3 = 0;
        while (n3 < n2) {
            View view = this.getView(n3);
            if (n >= view.getStartOffset() && n < view.getEndOffset()) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    void handleInsert(int n, int n2) {
        int n3 = this.getViewIndexAtPosition(n);
        View view = this.getView(n3);
        int n4 = view.getStartOffset();
        int n5 = view.getEndOffset();
        if (n5 - n4 > this.maxZoneSize) {
            this.splitZone(n3, n4, n5);
        }
    }

    void handleRemove(int n, int n2) {
    }

    void splitZone(int n, int n2, int n3) {
        Element element = this.getElement();
        Document document = element.getDocument();
        Vector vector = new Vector();
        int n4 = n2;
        do {
            n2 = n4;
            n4 = Math.min(this.getDesiredZoneEnd(n2), n3);
            vector.addElement(this.createZone(n2, n4));
        } while (n4 < n3);
        View view = this.getView(n);
        Object[] objectArray = new View[vector.size()];
        vector.copyInto(objectArray);
        this.replace(n, 1, (View[])objectArray);
    }

    int getDesiredZoneEnd(int n) {
        Element element = this.getElement();
        int n2 = element.getElementIndex(n + this.maxZoneSize / 2);
        Element element2 = element.getElement(n2);
        int n3 = element2.getStartOffset();
        int n4 = element2.getEndOffset();
        if (n4 - n > this.maxZoneSize && n3 > n) {
            return n3;
        }
        return n4;
    }

    protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
        return false;
    }

    public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.handleInsert(documentEvent.getOffset(), documentEvent.getLength());
        super.insertUpdate(documentEvent, shape, viewFactory);
    }

    public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
        this.handleRemove(documentEvent.getOffset(), documentEvent.getLength());
        super.removeUpdate(documentEvent, shape, viewFactory);
    }

    class Zone
    extends BoxView {
        Position start;
        Position end;
        int minorSpan = 500;
        float volumeCoefficient = 240.0f;

        Zone(Element element, Position position, Position position2) {
            super(element, ZoneView.this.getAxis());
            this.start = position;
            this.end = position2;
        }

        public void load() {
            if (!this.isLoaded()) {
                System.out.println("loading: " + this.getStartOffset() + "," + this.getEndOffset());
                Element element = this.getElement();
                ViewFactory viewFactory = this.getViewFactory();
                int n = element.getElementIndex(this.getStartOffset());
                int n2 = element.getElementIndex(this.getEndOffset());
                View[] viewArray = new View[n2 - n + 1];
                int n3 = n;
                while (n3 <= n2) {
                    viewArray[n3 - n] = viewFactory.create(element.getElement(n3));
                    ++n3;
                }
                this.replace(0, 0, viewArray);
            }
        }

        public void unload() {
            this.removeAll();
        }

        public boolean isLoaded() {
            return this.getViewCount() != 0;
        }

        protected void loadChildren(ViewFactory viewFactory) {
        }

        protected int getViewIndexAtPosition(int n) {
            Element element = this.getElement();
            int n2 = element.getElementIndex(n);
            int n3 = element.getElementIndex(this.getStartOffset());
            return n2 - n3;
        }

        protected void layout(int n, int n2) {
            if (this.isLoaded()) {
                super.layout(n, n2);
            } else {
                int n3;
                int n4 = this.getAxis();
                int n5 = n3 = n4 == 1 ? n : n2;
                if (n3 != this.minorSpan) {
                    this.minorSpan = n3;
                    this.preferenceChanged(null, n4 == 0, n4 == 1);
                }
            }
        }

        protected boolean updateChildren(DocumentEvent.ElementChange elementChange, DocumentEvent documentEvent, ViewFactory viewFactory) {
            Element[] elementArray = elementChange.getChildrenRemoved();
            Element[] elementArray2 = elementChange.getChildrenAdded();
            Element element = this.getElement();
            int n = element.getElementIndex(this.getStartOffset());
            int n2 = element.getElementIndex(this.getEndOffset() - 1);
            int n3 = elementChange.getIndex();
            if (n3 >= n && n3 <= n2) {
                int n4 = n3 - n;
                int n5 = Math.min(n2 - n + 1, elementArray2.length);
                int n6 = Math.min(n2 - n + 1, elementArray.length);
                View[] viewArray = new View[n5];
                int n7 = 0;
                while (n7 < n5) {
                    viewArray[n7] = viewFactory.create(elementArray2[n7]);
                    ++n7;
                }
                this.replace(n4, n6, viewArray);
            }
            return true;
        }

        public AttributeSet getAttributes() {
            return ZoneView.this.getAttributes();
        }

        public float getPreferredSpan(int n) {
            if (this.isLoaded()) {
                return super.getPreferredSpan(n);
            }
            if (this.getAxis() == n) {
                int n2 = this.getEndOffset() - this.getStartOffset();
                float f = (float)n2 * this.volumeCoefficient;
                float f2 = f / (float)this.minorSpan;
                return f2;
            }
            return this.minorSpan;
        }

        public float getMinimumSpan(int n) {
            if (this.isLoaded()) {
                return super.getMinimumSpan(n);
            }
            if (n == this.getAxis()) {
                return this.getPreferredSpan(n);
            }
            if (n == 0) {
                return this.getLeftInset() + this.getRightInset() + 1;
            }
            return this.getTopInset() + this.getBottomInset() + 1;
        }

        public float getMaximumSpan(int n) {
            if (this.isLoaded()) {
                return super.getMaximumSpan(n);
            }
            if (n == this.getAxis()) {
                return this.getPreferredSpan(n);
            }
            return 2147483.0f;
        }

        public float getAlignment(int n) {
            if (this.isLoaded()) {
                return super.getAlignment(n);
            }
            return 0.5f;
        }

        public void paint(Graphics graphics, Shape shape) {
            this.load();
            super.paint(graphics, shape);
        }

        public int viewToModel(float f, float f2, Shape shape, Position.Bias[] biasArray) {
            this.load();
            return super.viewToModel(f, f2, shape, biasArray);
        }

        public Shape modelToView(int n, Shape shape, Position.Bias bias) throws BadLocationException {
            this.load();
            return super.modelToView(n, shape, bias);
        }

        public int getStartOffset() {
            return this.start.getOffset();
        }

        public int getEndOffset() {
            return this.end.getOffset();
        }

        public void insertUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.isLoaded()) {
                super.insertUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void removeUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.isLoaded()) {
                super.removeUpdate(documentEvent, shape, viewFactory);
            }
        }

        public void changedUpdate(DocumentEvent documentEvent, Shape shape, ViewFactory viewFactory) {
            if (this.isLoaded()) {
                super.changedUpdate(documentEvent, shape, viewFactory);
            }
        }
    }
}

