/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.colorchooser;

import java.awt.image.ColorModel;
import java.awt.image.ImageConsumer;
import java.awt.image.ImageProducer;
import javax.swing.colorchooser.SyntheticImageGenerator;

abstract class SyntheticImage
implements ImageProducer {
    private SyntheticImageGenerator root;
    protected int width = 10;
    protected int height = 100;
    static final ColorModel cm = ColorModel.getRGBdefault();
    public static final int pixMask = 255;
    private Thread runner;

    protected SyntheticImage() {
    }

    protected SyntheticImage(int n, int n2) {
        this.width = n;
        this.height = n2;
    }

    protected void computeRow(int n, int[] nArray) {
        int n2 = 255 - 255 * n / (this.height - 1);
        n2 = 0xFF000000 | n2 << 16 | n2 << 8 | n2;
        int n3 = nArray.length;
        while (--n3 >= 0) {
            nArray[n3] = n2;
        }
    }

    public synchronized void addConsumer(ImageConsumer imageConsumer) {
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.ic == imageConsumer) {
                return;
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
        this.root = new SyntheticImageGenerator(imageConsumer, this.root, this);
    }

    public synchronized boolean isConsumer(ImageConsumer imageConsumer) {
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.ic == imageConsumer) {
                return true;
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
        return false;
    }

    public synchronized void removeConsumer(ImageConsumer imageConsumer) {
        Object var2_2 = null;
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.ic == imageConsumer) {
                syntheticImageGenerator.useful = false;
                if (var2_2 != null) {
                    var2_2.next = syntheticImageGenerator.next;
                } else {
                    this.root = syntheticImageGenerator.next;
                }
                return;
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
    }

    public synchronized void startProduction(ImageConsumer imageConsumer) {
        this.addConsumer(imageConsumer);
        SyntheticImageGenerator syntheticImageGenerator = this.root;
        while (syntheticImageGenerator != null) {
            if (syntheticImageGenerator.useful && !syntheticImageGenerator.isAlive()) {
                syntheticImageGenerator.start();
            }
            syntheticImageGenerator = syntheticImageGenerator.next;
        }
    }

    protected boolean isStatic() {
        return true;
    }

    public void nextFrame(int n) {
    }

    public void requestTopDownLeftRightResend(ImageConsumer imageConsumer) {
    }
}

