/*
 * Decompiled with CFR 0.152.
 */
package java.rmi.server;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.rmi.server.UID;
import java.security.AccessController;
import java.security.SecureRandom;
import java.util.Random;
import sun.security.action.GetBooleanAction;

public final class ObjID
implements Serializable {
    public static final int REGISTRY_ID = 0;
    public static final int ACTIVATOR_ID = 1;
    public static final int DGC_ID = 2;
    private long objNum;
    private UID space;
    private static final UID mySpace;
    private static final Random generator;
    private static final long serialVersionUID = -6386392263968365220L;

    public ObjID() {
        this.space = mySpace != null ? mySpace : new UID();
        this.objNum = generator.nextLong();
    }

    public ObjID(int n) {
        this.space = new UID(0);
        this.objNum = n;
    }

    private ObjID(long l, UID uID) {
        this.objNum = l;
        this.space = uID;
    }

    public void write(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeLong(this.objNum);
        this.space.write(objectOutput);
    }

    public static ObjID read(ObjectInput objectInput) throws IOException {
        long l = objectInput.readLong();
        UID uID = UID.read(objectInput);
        return new ObjID(l, uID);
    }

    public int hashCode() {
        return (int)this.objNum;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ObjID) {
            ObjID objID = (ObjID)object;
            return this.objNum == objID.objNum && this.space.equals(objID.space);
        }
        return false;
    }

    public String toString() {
        return "[" + (this.space.equals(mySpace) ? "" : this.space + ", ") + this.objNum + "]";
    }

    static {
        Boolean bl = (Boolean)AccessController.doPrivileged(new GetBooleanAction("java.rmi.server.randomIDs"));
        boolean bl2 = bl;
        if (bl2) {
            generator = new SecureRandom();
            mySpace = null;
        } else {
            generator = new InsecureRandom();
            mySpace = new UID();
        }
    }

    private static class InsecureRandom
    extends Random {
        private static final long serialVersionUID = -698228687531590145L;
        private long nextNum;

        private InsecureRandom() {
        }

        public synchronized long nextLong() {
            return this.nextNum++;
        }
    }
}

