/*
 * Decompiled with CFR 0.152.
 */
package java.awt.image;

import java.awt.image.ComponentSampleModel;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.awt.image.RasterFormatException;
import java.awt.image.SampleModel;

public final class BandedSampleModel
extends ComponentSampleModel {
    public BandedSampleModel(int n, int n2, int n3, int n4) {
        super(n, n2, n3, 1, n2, BandedSampleModel.createIndiciesArray(n4), BandedSampleModel.createOffsetArray(n4));
    }

    public BandedSampleModel(int n, int n2, int n3, int n4, int[] nArray, int[] nArray2) {
        super(n, n2, n3, 1, n4, nArray, nArray2);
    }

    public SampleModel createCompatibleSampleModel(int n, int n2) {
        int[] nArray = this.numBanks == 1 ? this.orderBands(this.bandOffsets, n * n2) : new int[this.bandOffsets.length];
        BandedSampleModel bandedSampleModel = new BandedSampleModel(this.dataType, n, n2, n, this.bankIndices, nArray);
        return bandedSampleModel;
    }

    public SampleModel createSubsetSampleModel(int[] nArray) {
        if (nArray.length > this.bankIndices.length) {
            throw new RasterFormatException("There are only " + this.bankIndices.length + " bands");
        }
        int[] nArray2 = new int[nArray.length];
        int[] nArray3 = new int[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            nArray2[n] = this.bankIndices[nArray[n]];
            nArray3[n] = this.bandOffsets[nArray[n]];
            ++n;
        }
        return new BandedSampleModel(this.dataType, this.width, this.height, this.scanlineStride, nArray2, nArray3);
    }

    public DataBuffer createDataBuffer() {
        DataBuffer dataBuffer = null;
        int n = this.scanlineStride * this.height;
        switch (this.dataType) {
            case 0: {
                dataBuffer = new DataBufferByte(n, this.numBands);
                break;
            }
            case 1: {
                dataBuffer = new DataBufferUShort(n, this.numBands);
                break;
            }
            case 2: {
                dataBuffer = new DataBufferShort(n, this.numBands);
                break;
            }
            case 3: {
                dataBuffer = new DataBufferInt(n, this.numBands);
            }
        }
        return dataBuffer;
    }

    public Object getDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n;
        switch (n3) {
            case 0: {
                byte[] byArray = object == null ? new byte[n4] : (byte[])object;
                int n6 = 0;
                while (n6 < n4) {
                    byArray[n6] = (byte)dataBuffer.getElem(this.bankIndices[n6], n5 + this.bandOffsets[n6]);
                    ++n6;
                }
                object = byArray;
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = object == null ? new short[n4] : (short[])object;
                int n7 = 0;
                while (n7 < n4) {
                    sArray[n7] = (short)dataBuffer.getElem(this.bankIndices[n7], n5 + this.bandOffsets[n7]);
                    ++n7;
                }
                object = sArray;
                break;
            }
            case 3: {
                int[] nArray = object == null ? new int[n4] : (int[])object;
                int n8 = 0;
                while (n8 < n4) {
                    nArray[n8] = dataBuffer.getElem(this.bankIndices[n8], n5 + this.bandOffsets[n8]);
                    ++n8;
                }
                object = nArray;
            }
        }
        return object;
    }

    public int[] getPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[this.numBands];
        int n3 = n2 * this.scanlineStride + n;
        int n4 = 0;
        while (n4 < this.numBands) {
            nArray2[n4] = dataBuffer.getElem(this.bankIndices[n4], n3 + this.bandOffsets[n4]);
            ++n4;
        }
        return nArray2;
    }

    public int[] getPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4 * this.numBands];
        int n5 = 0;
        while (n5 < this.numBands) {
            int n6 = n2 * this.scanlineStride + n + this.bandOffsets[n5];
            int n7 = n5;
            int n8 = this.bankIndices[n5];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    nArray2[n7] = dataBuffer.getElem(n8, n10++);
                    n7 += this.numBands;
                    ++n11;
                }
                n6 += this.scanlineStride;
                ++n9;
            }
            ++n5;
        }
        return nArray2;
    }

    public int getSample(int n, int n2, int n3, DataBuffer dataBuffer) {
        int n4 = dataBuffer.getElem(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3]);
        return n4;
    }

    public float getSampleFloat(int n, int n2, int n3, DataBuffer dataBuffer) {
        float f = dataBuffer.getElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3]);
        return f;
    }

    public double getSampleDouble(int n, int n2, int n3, DataBuffer dataBuffer) {
        double d = dataBuffer.getElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3]);
        return d;
    }

    public int[] getSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int[] nArray2 = nArray != null ? nArray : new int[n3 * n4];
        int n6 = n2 * this.scanlineStride + n + this.bandOffsets[n5];
        int n7 = 0;
        int n8 = this.bankIndices[n5];
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n6;
            int n11 = 0;
            while (n11 < n3) {
                nArray2[n7++] = dataBuffer.getElem(n8, n10++);
                ++n11;
            }
            n6 += this.scanlineStride;
            ++n9;
        }
        return nArray2;
    }

    public void setDataElements(int n, int n2, Object object, DataBuffer dataBuffer) {
        int n3 = this.getTransferType();
        int n4 = this.getNumDataElements();
        int n5 = n2 * this.scanlineStride + n;
        switch (n3) {
            case 0: {
                byte[] byArray = (byte[])object;
                int n6 = 0;
                while (n6 < n4) {
                    dataBuffer.setElem(this.bankIndices[n6], n5 + this.bandOffsets[n6], byArray[n6] & 0xFF);
                    ++n6;
                }
                break;
            }
            case 1: 
            case 2: {
                short[] sArray = (short[])object;
                int n7 = 0;
                while (n7 < n4) {
                    dataBuffer.setElem(this.bankIndices[n7], n5 + this.bandOffsets[n7], sArray[n7] & 0xFFFF);
                    ++n7;
                }
                break;
            }
            case 3: {
                int[] nArray = (int[])object;
                int n8 = 0;
                while (n8 < n4) {
                    dataBuffer.setElem(this.bankIndices[n8], n5 + this.bandOffsets[n8], nArray[n8]);
                    ++n8;
                }
                break;
            }
        }
    }

    public void setPixel(int n, int n2, int[] nArray, DataBuffer dataBuffer) {
        int n3 = n2 * this.scanlineStride + n;
        int n4 = 0;
        while (n4 < this.numBands) {
            dataBuffer.setElem(this.bankIndices[n4], n3 + this.bandOffsets[n4], nArray[n4]);
            ++n4;
        }
    }

    public void setPixels(int n, int n2, int n3, int n4, int[] nArray, DataBuffer dataBuffer) {
        int n5 = 0;
        while (n5 < this.numBands) {
            int n6 = n2 * this.scanlineStride + n + this.bandOffsets[n5];
            int n7 = n5;
            int n8 = this.bankIndices[n5];
            int n9 = 0;
            while (n9 < n4) {
                int n10 = n6;
                int n11 = 0;
                while (n11 < n3) {
                    dataBuffer.setElem(n8, n10++, nArray[n7]);
                    n7 += this.numBands;
                    ++n11;
                }
                n6 += this.scanlineStride;
                ++n9;
            }
            ++n5;
        }
    }

    public void setSample(int n, int n2, int n3, int n4, DataBuffer dataBuffer) {
        dataBuffer.setElem(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3], n4);
    }

    public void setSample(int n, int n2, int n3, float f, DataBuffer dataBuffer) {
        dataBuffer.setElemFloat(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3], f);
    }

    public void setSample(int n, int n2, int n3, double d, DataBuffer dataBuffer) {
        dataBuffer.setElemDouble(this.bankIndices[n3], n2 * this.scanlineStride + n + this.bandOffsets[n3], d);
    }

    public void setSamples(int n, int n2, int n3, int n4, int n5, int[] nArray, DataBuffer dataBuffer) {
        int n6 = n2 * this.scanlineStride + n + this.bandOffsets[n5];
        int n7 = 0;
        int n8 = this.bankIndices[n5];
        int n9 = 0;
        while (n9 < n4) {
            int n10 = n6;
            int n11 = 0;
            while (n11 < n3) {
                dataBuffer.setElem(n8, n10++, nArray[n7++]);
                ++n11;
            }
            n6 += this.scanlineStride;
            ++n9;
        }
    }

    private static int[] createOffsetArray(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = 0;
            ++n2;
        }
        return nArray;
    }

    private static int[] createIndiciesArray(int n) {
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        return nArray;
    }
}

