/*
 * Decompiled with CFR 0.152.
 */
package com.sun.corba.se.internal.orbutil;

import com.sun.corba.se.internal.orbutil.ObjectStreamClass_1_3_1;
import java.lang.reflect.Field;

class ObjectStreamField
implements Comparable {
    private String name;
    private char type;
    private Field field;
    private String typeString;
    private Class clazz;
    private String signature;
    private long fieldID = -1L;
    static /* synthetic */ Class class$java$lang$Object;

    ObjectStreamField(String string, Class clazz) {
        this.name = string;
        this.clazz = clazz;
        if (clazz.isPrimitive()) {
            if (clazz == Integer.TYPE) {
                this.type = (char)73;
            } else if (clazz == Byte.TYPE) {
                this.type = (char)66;
            } else if (clazz == Long.TYPE) {
                this.type = (char)74;
            } else if (clazz == Float.TYPE) {
                this.type = (char)70;
            } else if (clazz == Double.TYPE) {
                this.type = (char)68;
            } else if (clazz == Short.TYPE) {
                this.type = (char)83;
            } else if (clazz == Character.TYPE) {
                this.type = (char)67;
            } else if (clazz == Boolean.TYPE) {
                this.type = (char)90;
            }
        } else if (clazz.isArray()) {
            this.type = (char)91;
            this.typeString = ObjectStreamClass_1_3_1.getSignature(clazz);
        } else {
            this.type = (char)76;
            this.typeString = ObjectStreamClass_1_3_1.getSignature(clazz);
        }
        this.signature = this.typeString != null ? this.typeString : String.valueOf(this.type);
    }

    ObjectStreamField(Field field) {
        this(field.getName(), field.getType());
        this.field = field;
    }

    ObjectStreamField(String string, char c, Field field, String string2) {
        this.name = string;
        this.type = c;
        this.field = field;
        this.typeString = string2;
        this.signature = this.typeString != null ? this.typeString : String.valueOf(this.type);
    }

    public String getName() {
        return this.name;
    }

    public Class getType() {
        if (this.clazz != null) {
            return this.clazz;
        }
        switch (this.type) {
            case 'B': {
                this.clazz = Byte.TYPE;
                break;
            }
            case 'C': {
                this.clazz = Character.TYPE;
                break;
            }
            case 'S': {
                this.clazz = Short.TYPE;
                break;
            }
            case 'I': {
                this.clazz = Integer.TYPE;
                break;
            }
            case 'J': {
                this.clazz = Long.TYPE;
                break;
            }
            case 'F': {
                this.clazz = Float.TYPE;
                break;
            }
            case 'D': {
                this.clazz = Double.TYPE;
                break;
            }
            case 'Z': {
                this.clazz = Boolean.TYPE;
                break;
            }
            case 'L': 
            case '[': {
                this.clazz = class$java$lang$Object == null ? (class$java$lang$Object = ObjectStreamField.class$("java.lang.Object")) : class$java$lang$Object;
            }
        }
        return this.clazz;
    }

    public char getTypeCode() {
        return this.type;
    }

    public String getTypeString() {
        return this.typeString;
    }

    Field getField() {
        return this.field;
    }

    void setField(Field field) {
        this.field = field;
        this.fieldID = -1L;
    }

    ObjectStreamField() {
    }

    public boolean isPrimitive() {
        return this.type != '[' && this.type != 'L';
    }

    public int compareTo(Object object) {
        boolean bl;
        ObjectStreamField objectStreamField = (ObjectStreamField)object;
        boolean bl2 = this.typeString == null;
        boolean bl3 = bl = objectStreamField.typeString == null;
        if (bl2 != bl) {
            return bl2 ? -1 : 1;
        }
        return this.name.compareTo(objectStreamField.name);
    }

    public boolean typeEquals(ObjectStreamField objectStreamField) {
        if (objectStreamField == null || this.type != objectStreamField.type) {
            return false;
        }
        if (this.typeString == null && objectStreamField.typeString == null) {
            return true;
        }
        return ObjectStreamClass_1_3_1.compareClassNames(this.typeString, objectStreamField.typeString, '/');
    }

    public String getSignature() {
        return this.signature;
    }

    public String toString() {
        if (this.typeString != null) {
            return this.typeString + " " + this.name;
        }
        return this.type + " " + this.name;
    }

    public Class getClazz() {
        return this.clazz;
    }

    public long getFieldID(Class clazz) {
        if (this.fieldID == -1L) {
            this.fieldID = this.typeString != null ? ObjectStreamField.getFieldIDNative(clazz, this.getName(), this.typeString) : ObjectStreamField.getFieldIDNative(clazz, this.getName(), this.getSignature());
        }
        return this.fieldID;
    }

    private static native long getFieldIDNative(Class var0, String var1, String var2);

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

