/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal;

import org.eclipse.swt.internal.win32.OS;

public final class Converter {
    static final byte[] NULL_BYTE_ARRAY = new byte[1];
    static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    static final char[] EMPTY_CHAR_ARRAY = new char[0];
    static int CodePage = OS.GetACP();

    public static int defaultCodePage() {
        return CodePage;
    }

    public static char[] mbcsToWcs(int codePage, byte[] buffer) {
        if (codePage < 0 || buffer == null) {
            return EMPTY_CHAR_ARRAY;
        }
        int length = buffer.length;
        if (length == 0) {
            return EMPTY_CHAR_ARRAY;
        }
        char[] lpWideCharStr = new char[length];
        int i = 0;
        while (i < length) {
            if ((buffer[i] & 0xFF) > 127) {
                int cp = codePage != 0 ? codePage : CodePage;
                int cchWideChar = OS.MultiByteToWideChar(cp, 1, buffer, length, null, 0);
                if (cchWideChar == 0) {
                    return EMPTY_CHAR_ARRAY;
                }
                lpWideCharStr = new char[cchWideChar];
                OS.MultiByteToWideChar(cp, 1, buffer, length, lpWideCharStr, cchWideChar);
                return lpWideCharStr;
            }
            lpWideCharStr[i] = (char)buffer[i];
            ++i;
        }
        return lpWideCharStr;
    }

    public static byte[] wcsToMbcs(int codePage, char[] buffer) {
        return Converter.wcsToMbcs(0, buffer, false);
    }

    public static byte[] wcsToMbcs(int codePage, char[] buffer, boolean terminate) {
        if (codePage < 0 || buffer == null) {
            return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        int length = buffer.length;
        if (length == 0) {
            return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
        }
        byte[] mbcs = new byte[terminate ? length + 1 : length];
        int i = 0;
        while (i < length) {
            if ((buffer[i] & 0xFFFF) > 127) {
                int cp = codePage != 0 ? codePage : CodePage;
                int cchMultiByte = OS.WideCharToMultiByte(cp, 0, buffer, length, null, 0, null, null);
                if (cchMultiByte == 0) {
                    return terminate ? NULL_BYTE_ARRAY : EMPTY_BYTE_ARRAY;
                }
                byte[] lpMultiByteStr = new byte[terminate ? cchMultiByte + 1 : cchMultiByte];
                OS.WideCharToMultiByte(cp, 0, buffer, length, lpMultiByteStr, cchMultiByte, null, null);
                return lpMultiByteStr;
            }
            mbcs[i] = (byte)buffer[i];
            ++i;
        }
        return mbcs;
    }

    public static byte[] wcsToMbcs(int codePage, String string) {
        return Converter.wcsToMbcs(0, string, false);
    }

    public static byte[] wcsToMbcs(int codePage, String string, boolean terminate) {
        if (terminate) {
            if (string == null) {
                return NULL_BYTE_ARRAY;
            }
            int count = string.length();
            char[] buffer = new char[count + 1];
            string.getChars(0, count, buffer, 0);
            return Converter.wcsToMbcs(codePage, buffer, false);
        }
        if (string == null) {
            return EMPTY_BYTE_ARRAY;
        }
        int count = string.length();
        char[] buffer = new char[count];
        string.getChars(0, count, buffer, 0);
        return Converter.wcsToMbcs(codePage, buffer, false);
    }
}

