/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Region;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.win32.BITMAP;
import org.eclipse.swt.internal.win32.BITMAPINFOHEADER;
import org.eclipse.swt.internal.win32.GRADIENT_RECT;
import org.eclipse.swt.internal.win32.ICONINFO;
import org.eclipse.swt.internal.win32.LOGPEN;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.SIZE;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TEXTMETRIC;
import org.eclipse.swt.internal.win32.TRIVERTEX;

public final class GC {
    public int handle;
    Drawable drawable;
    GCData data;

    GC() {
    }

    public GC(Drawable drawable) {
        if (drawable == null) {
            SWT.error(4);
        }
        GCData data = new GCData();
        int hDC = drawable.internal_new_GC(data);
        Device device = data.device;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        data.device = device;
        this.init(drawable, data, hDC);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void copyArea(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.type != 0 || image.isDisposed()) {
            SWT.error(5);
        }
        Device device = this.data.device;
        int hDC = device.internal_new_GC(null);
        Rectangle rect = image.getBounds();
        int memHdc = OS.CreateCompatibleDC(hDC);
        int hOldBitmap = OS.SelectObject(memHdc, image.handle);
        OS.BitBlt(memHdc, 0, 0, rect.width, rect.height, this.handle, x, y, 0xCC0020);
        OS.SelectObject(memHdc, hOldBitmap);
        OS.DeleteDC(memHdc);
        device.internal_dispose_GC(hDC, null);
    }

    public void copyArea(int srcX, int srcY, int width, int height, int destX, int destY) {
        int hwnd;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((hwnd = this.data.hwnd) == 0) {
            OS.BitBlt(this.handle, destX, destY, width, height, this.handle, srcX, srcY, 0xCC0020);
        } else {
            RECT lprcClip = null;
            int hrgn = OS.CreateRectRgn(0, 0, 0, 0);
            if (OS.GetClipRgn(this.handle, hrgn) == 1) {
                lprcClip = new RECT();
                OS.GetRgnBox(hrgn, lprcClip);
            }
            OS.DeleteObject(hrgn);
            RECT lprcScroll = new RECT();
            OS.SetRect(lprcScroll, srcX, srcY, srcX + width, srcY + height);
            int res = OS.ScrollWindowEx(hwnd, destX - srcX, destY - srcY, lprcScroll, lprcClip, 0, null, 6);
            if (res == 0 && OS.IsWinCE) {
                boolean disjoint;
                OS.BitBlt(this.handle, destX, destY, width, height, this.handle, srcX, srcY, 0xCC0020);
                int deltaX = destX - srcX;
                int deltaY = destY - srcY;
                boolean bl = disjoint = destX + width < srcX || srcX + width < destX || destY + height < srcY || srcY + height < destY;
                if (disjoint) {
                    OS.InvalidateRect(hwnd, lprcScroll, true);
                } else {
                    if (deltaX != 0) {
                        int newX = destX - deltaX;
                        if (deltaX < 0) {
                            newX = destX + width;
                        }
                        OS.SetRect(lprcScroll, newX, srcY, newX + Math.abs(deltaX), srcY + height);
                        OS.InvalidateRect(hwnd, lprcScroll, true);
                    }
                    if (deltaY != 0) {
                        int newY = destY - deltaY;
                        if (deltaY < 0) {
                            newY = destY + height;
                        }
                        OS.SetRect(lprcScroll, srcX, newY, srcX + width, newY + Math.abs(deltaY));
                        OS.InvalidateRect(hwnd, lprcScroll, true);
                    }
                }
            }
        }
    }

    int createDIB(int width, int height) {
        int[] pBits;
        int hDib;
        int depth = 32;
        BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
        bmiHeader.biSize = 40;
        bmiHeader.biWidth = width;
        bmiHeader.biHeight = -height;
        bmiHeader.biPlanes = 1;
        bmiHeader.biBitCount = (short)depth;
        bmiHeader.biCompression = OS.IsWinCE ? 3 : 0;
        byte[] bmi = new byte[40 + (OS.IsWinCE ? 12 : 0)];
        OS.MoveMemory(bmi, bmiHeader, 40);
        if (OS.IsWinCE) {
            int redMask = 65280;
            int greenMask = 0xFF0000;
            int blueMask = -16777216;
            int offset = 40;
            bmi[offset] = (byte)((redMask & 0xFF000000) >> 24);
            bmi[offset + 1] = (byte)((redMask & 0xFF0000) >> 16);
            bmi[offset + 2] = (byte)((redMask & 0xFF00) >> 8);
            bmi[offset + 3] = (byte)((redMask & 0xFF) >> 0);
            bmi[offset + 4] = (byte)((greenMask & 0xFF000000) >> 24);
            bmi[offset + 5] = (byte)((greenMask & 0xFF0000) >> 16);
            bmi[offset + 6] = (byte)((greenMask & 0xFF00) >> 8);
            bmi[offset + 7] = (byte)((greenMask & 0xFF) >> 0);
            bmi[offset + 8] = (byte)((blueMask & 0xFF000000) >> 24);
            bmi[offset + 9] = (byte)((blueMask & 0xFF0000) >> 16);
            bmi[offset + 10] = (byte)((blueMask & 0xFF00) >> 8);
            bmi[offset + 11] = (byte)((blueMask & 0xFF) >> 0);
        }
        if ((hDib = OS.CreateDIBSection(0, bmi, 0, pBits = new int[1], 0, 0)) == 0) {
            SWT.error(2);
        }
        return hDib;
    }

    public void dispose() {
        Image image;
        if (this.handle == 0) {
            return;
        }
        if (this.data.device.isDisposed()) {
            return;
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.DeleteObject(oldPen);
        int nullBrush = OS.GetStockObject(5);
        int oldBrush = OS.SelectObject(this.handle, nullBrush);
        OS.DeleteObject(oldBrush);
        int hNullBitmap = this.data.hNullBitmap;
        if (hNullBitmap != 0) {
            OS.SelectObject(this.handle, hNullBitmap);
            this.data.hNullBitmap = 0;
        }
        if ((image = this.data.image) != null) {
            image.memGC = null;
        }
        Device device = this.data.device;
        this.drawable.internal_dispose_GC(this.handle, this.data);
        this.drawable = null;
        this.handle = 0;
        this.data.image = null;
        this.data.ps = null;
        if (device.tracking) {
            device.dispose_Object(this);
        }
        this.data.device = null;
        this.data = null;
    }

    public void drawArc(int x, int y, int width, int height, int startAngle, int endAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || endAngle == 0) {
            SWT.error(5);
        }
        if (OS.IsWinCE) {
            if (endAngle < 0) {
                startAngle += endAngle;
                endAngle = -endAngle;
            }
            if (endAngle > 360) {
                endAngle = 360;
            }
            int[] points = new int[(endAngle + 1) * 2];
            int cteX = 2 * x + width;
            int cteY = 2 * y + height;
            int index = 0;
            int i = 0;
            while (i <= endAngle) {
                points[index++] = Compatibility.cos(startAngle + i, width) + cteX >> 1;
                points[index++] = cteY - Compatibility.sin(startAngle + i, height) >> 1;
                ++i;
            }
            OS.Polyline(this.handle, points, points.length / 2);
        } else {
            int y1;
            int y2;
            int x1;
            int x2;
            if (endAngle >= 360 || endAngle <= -360) {
                x1 = x2 = x + width;
                y1 = y2 = y + height / 2;
            } else {
                boolean isNegative = endAngle < 0;
                endAngle += startAngle;
                if (isNegative) {
                    int tmp = startAngle;
                    startAngle = endAngle;
                    endAngle = tmp;
                }
                x1 = Compatibility.cos(startAngle, width) + x + width / 2;
                y1 = -1 * Compatibility.sin(startAngle, height) + y + height / 2;
                x2 = Compatibility.cos(endAngle, width) + x + width / 2;
                y2 = -1 * Compatibility.sin(endAngle, height) + y + height / 2;
            }
            int nullBrush = OS.GetStockObject(5);
            int oldBrush = OS.SelectObject(this.handle, nullBrush);
            OS.Arc(this.handle, x, y, x + width + 1, y + height + 1, x1, y1, x2, y2);
            OS.SelectObject(this.handle, oldBrush);
        }
    }

    public void drawFocus(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, x + width, y + height);
        OS.DrawFocusRect(this.handle, rect);
    }

    public void drawImage(Image image, int x, int y) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, 0, 0, -1, -1, x, y, -1, -1, true);
    }

    public void drawImage(Image image, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (srcWidth == 0 || srcHeight == 0 || destWidth == 0 || destHeight == 0) {
            return;
        }
        if (srcX < 0 || srcY < 0 || srcWidth < 0 || srcHeight < 0 || destWidth < 0 || destHeight < 0) {
            SWT.error(5);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.drawImage(image, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, false);
    }

    void drawImage(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        switch (srcImage.type) {
            case 0: {
                this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            case 1: {
                this.drawIcon(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple);
                break;
            }
            default: {
                SWT.error(42);
            }
        }
    }

    void drawIcon(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        boolean failed;
        if (simple) {
            OS.DrawIconEx(this.handle, destX, destY, srcImage.handle, 0, 0, 0, 0, 3);
            return;
        }
        ICONINFO srcIconInfo = new ICONINFO();
        if (OS.IsWinCE) {
            Image.GetIconInfo(srcImage, srcIconInfo);
        } else {
            OS.GetIconInfo(srcImage.handle, srcIconInfo);
        }
        int hBitmap = srcIconInfo.hbmColor;
        if (hBitmap == 0) {
            hBitmap = srcIconInfo.hbmMask;
        }
        BITMAP bm = new BITMAP();
        OS.GetObject(hBitmap, 24, bm);
        int iconWidth = bm.bmWidth;
        int iconHeight = bm.bmHeight;
        if (hBitmap == srcIconInfo.hbmMask) {
            iconHeight /= 2;
        }
        if (simple) {
            srcWidth = destWidth = iconWidth;
            srcHeight = destHeight = iconHeight;
        }
        boolean bl = failed = srcX + srcWidth > iconWidth || srcY + srcHeight > iconHeight;
        if (!failed) {
            boolean bl2 = simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && srcHeight == destHeight && srcWidth == iconWidth && srcHeight == iconHeight;
            if (simple) {
                OS.DrawIconEx(this.handle, destX, destY, srcImage.handle, 0, 0, 0, 0, 3);
            } else {
                Device device = this.data.device;
                int hDC = device.internal_new_GC(null);
                ICONINFO newIconInfo = new ICONINFO();
                newIconInfo.fIcon = true;
                int srcHdc = OS.CreateCompatibleDC(hDC);
                int dstHdc = OS.CreateCompatibleDC(hDC);
                int srcColorY = srcY;
                int srcColor = srcIconInfo.hbmColor;
                if (srcColor == 0) {
                    srcColor = srcIconInfo.hbmMask;
                    srcColorY += iconHeight;
                }
                int oldSrcBitmap = OS.SelectObject(srcHdc, srcColor);
                newIconInfo.hbmColor = OS.CreateCompatibleBitmap(srcHdc, destWidth, destHeight);
                if (newIconInfo.hbmColor == 0) {
                    SWT.error(2);
                }
                int oldDestBitmap = OS.SelectObject(dstHdc, newIconInfo.hbmColor);
                if (!OS.IsWinCE) {
                    OS.SetStretchBltMode(dstHdc, 3);
                }
                OS.StretchBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcColorY, srcWidth, srcHeight, 0xCC0020);
                OS.SelectObject(srcHdc, srcIconInfo.hbmMask);
                newIconInfo.hbmMask = OS.CreateBitmap(destWidth, destHeight, 1, 1, null);
                if (newIconInfo.hbmMask == 0) {
                    SWT.error(2);
                }
                OS.SelectObject(dstHdc, newIconInfo.hbmMask);
                OS.StretchBlt(dstHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0xCC0020);
                OS.SelectObject(srcHdc, oldSrcBitmap);
                OS.SelectObject(dstHdc, oldDestBitmap);
                int hIcon = OS.CreateIconIndirect(newIconInfo);
                if (hIcon == 0) {
                    SWT.error(2);
                }
                OS.DrawIconEx(this.handle, destX, destY, hIcon, destWidth, destHeight, 0, 0, 3);
                OS.DestroyIcon(hIcon);
                OS.DeleteObject(newIconInfo.hbmMask);
                OS.DeleteObject(newIconInfo.hbmColor);
                OS.DeleteDC(dstHdc);
                OS.DeleteDC(srcHdc);
                device.internal_dispose_GC(hDC, null);
            }
        }
        OS.DeleteObject(srcIconInfo.hbmMask);
        if (srcIconInfo.hbmColor != 0) {
            OS.DeleteObject(srcIconInfo.hbmColor);
        }
        if (failed) {
            SWT.error(5);
        }
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple) {
        BITMAP bm = new BITMAP();
        OS.GetObject(srcImage.handle, 24, bm);
        int imgWidth = bm.bmWidth;
        int imgHeight = bm.bmHeight;
        if (simple) {
            srcWidth = destWidth = imgWidth;
            srcHeight = destHeight = imgHeight;
        } else {
            if (srcX + srcWidth > imgWidth || srcY + srcHeight > imgHeight) {
                SWT.error(5);
            }
            simple = srcX == 0 && srcY == 0 && srcWidth == destWidth && destWidth == imgWidth && srcHeight == destHeight && destHeight == imgHeight;
        }
        boolean mustRestore = false;
        GC memGC = srcImage.memGC;
        if (memGC != null && !memGC.isDisposed()) {
            mustRestore = true;
            GCData data = memGC.data;
            if (data.hNullBitmap != 0) {
                OS.SelectObject(memGC.handle, data.hNullBitmap);
                data.hNullBitmap = 0;
            }
        }
        if (srcImage.alpha != -1 || srcImage.alphaData != null) {
            this.drawBitmapAlpha(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else if (srcImage.transparentPixel != -1) {
            this.drawBitmapTransparent(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        } else {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
        }
        if (mustRestore) {
            int hOldBitmap;
            memGC.data.hNullBitmap = hOldBitmap = OS.SelectObject(memGC.handle, srcImage.handle);
        }
    }

    void drawBitmapAlpha(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        boolean hasAlphaChannel;
        if (srcImage.alpha == 0) {
            return;
        }
        if (srcImage.alpha == 255) {
            this.drawBitmap(srcImage, srcX, srcY, srcWidth, srcHeight, destX, destY, destWidth, destHeight, simple, bm, imgWidth, imgHeight);
            return;
        }
        Rectangle rect = this.getClipping();
        if ((rect = rect.intersection(new Rectangle(destX, destY, destWidth, destHeight))).isEmpty()) {
            return;
        }
        int sx1 = srcX + (rect.x - destX) * srcWidth / destWidth;
        int sx2 = srcX + (rect.x + rect.width - destX) * srcWidth / destWidth;
        int sy1 = srcY + (rect.y - destY) * srcHeight / destHeight;
        int sy2 = srcY + (rect.y + rect.height - destY) * srcHeight / destHeight;
        destX = rect.x;
        destY = rect.y;
        destWidth = rect.width;
        destHeight = rect.height;
        srcX = sx1;
        srcY = sy1;
        srcWidth = Math.max(1, sx2 - sx1);
        srcHeight = Math.max(1, sy2 - sy1);
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, srcImage.handle);
        int memHdc = OS.CreateCompatibleDC(this.handle);
        int memDib = this.createDIB(Math.max(srcWidth, destWidth), Math.max(srcHeight, destHeight));
        int oldMemBitmap = OS.SelectObject(memHdc, memDib);
        BITMAP dibBM = new BITMAP();
        OS.GetObject(memDib, 24, dibBM);
        int sizeInBytes = dibBM.bmWidthBytes * dibBM.bmHeight;
        OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
        byte[] destData = new byte[sizeInBytes];
        OS.MoveMemory(destData, dibBM.bmBits, sizeInBytes);
        OS.BitBlt(memHdc, 0, 0, srcWidth, srcHeight, srcHdc, srcX, srcY, 0xCC0020);
        byte[] srcData = new byte[sizeInBytes];
        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
        int alpha = srcImage.alpha;
        boolean bl = hasAlphaChannel = srcImage.alpha == -1;
        if (hasAlphaChannel) {
            int apinc = imgWidth - srcWidth;
            int spinc = dibBM.bmWidthBytes - srcWidth * 4;
            int ap = srcY * imgWidth + srcX;
            int sp = 3;
            byte[] alphaData = srcImage.alphaData;
            int y = 0;
            while (y < srcHeight) {
                int x = 0;
                while (x < srcWidth) {
                    srcData[sp] = alphaData[ap++];
                    sp += 4;
                    ++x;
                }
                ap += apinc;
                sp += spinc;
                ++y;
            }
        }
        if (!OS.IsWinCE) {
            OS.SetStretchBltMode(memHdc, 3);
        }
        OS.MoveMemory(dibBM.bmBits, srcData, sizeInBytes);
        if (OS.IsWinCE && (destWidth > srcWidth || destHeight > srcHeight) || !OS.IsWinNT && !OS.IsWinCE) {
            int tempHdc = OS.CreateCompatibleDC(this.handle);
            int tempDib = this.createDIB(destWidth, destHeight);
            int oldTempBitmap = OS.SelectObject(tempHdc, tempDib);
            OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, 0xCC0020);
            OS.BitBlt(memHdc, 0, 0, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
            OS.SelectObject(tempHdc, oldTempBitmap);
            OS.DeleteObject(tempDib);
            OS.DeleteDC(tempHdc);
        } else {
            OS.StretchBlt(memHdc, 0, 0, destWidth, destHeight, memHdc, 0, 0, srcWidth, srcHeight, 0xCC0020);
        }
        OS.MoveMemory(srcData, dibBM.bmBits, sizeInBytes);
        int dpinc = dibBM.bmWidthBytes - destWidth * 4;
        int dp = 0;
        int y = 0;
        while (y < destHeight) {
            int x = 0;
            while (x < destWidth) {
                if (hasAlphaChannel) {
                    alpha = srcData[dp + 3] & 0xFF;
                }
                int n = dp;
                destData[n] = (byte)(destData[n] + ((srcData[dp] & 0xFF) - (destData[dp] & 0xFF)) * alpha / 255);
                int n2 = dp + 1;
                destData[n2] = (byte)(destData[n2] + ((srcData[dp + 1] & 0xFF) - (destData[dp + 1] & 0xFF)) * alpha / 255);
                int n3 = dp + 2;
                destData[n3] = (byte)(destData[n3] + ((srcData[dp + 2] & 0xFF) - (destData[dp + 2] & 0xFF)) * alpha / 255);
                dp += 4;
                ++x;
            }
            dp += dpinc;
            ++y;
        }
        OS.MoveMemory(dibBM.bmBits, destData, sizeInBytes);
        OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, memHdc, 0, 0, 0xCC0020);
        OS.SelectObject(memHdc, oldMemBitmap);
        OS.DeleteDC(memHdc);
        OS.DeleteObject(memDib);
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
    }

    void drawBitmapTransparent(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        Device device = this.data.device;
        int hDC = device.internal_new_GC(null);
        int transBlue = 0;
        int transGreen = 0;
        int transRed = 0;
        boolean isDib = bm.bmBits != 0;
        int hBitmap = srcImage.handle;
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, hBitmap);
        byte[] originalColors = null;
        if (bm.bmBitsPixel <= 8) {
            if (isDib) {
                if (OS.IsWinCE) {
                    byte[] pBits = new byte[1];
                    OS.MoveMemory(pBits, bm.bmBits, 1);
                    byte oldValue = pBits[0];
                    int mask = 255 << 8 - bm.bmBitsPixel & 0xFF;
                    pBits[0] = (byte)(srcImage.transparentPixel << 8 - bm.bmBitsPixel | pBits[0] & ~mask);
                    OS.MoveMemory(bm.bmBits, pBits, 1);
                    int color = OS.GetPixel(srcHdc, 0, 0);
                    pBits[0] = oldValue;
                    OS.MoveMemory(bm.bmBits, pBits, 1);
                    transBlue = (color & 0xFF0000) >> 16;
                    transGreen = (color & 0xFF00) >> 8;
                    transRed = color & 0xFF;
                } else {
                    int maxColors = 1 << bm.bmBitsPixel;
                    byte[] oldColors = new byte[maxColors * 4];
                    OS.GetDIBColorTable(srcHdc, 0, maxColors, oldColors);
                    int offset = srcImage.transparentPixel * 4;
                    byte[] newColors = new byte[oldColors.length];
                    transBlue = 255;
                    transGreen = 255;
                    transRed = 255;
                    newColors[offset] = (byte)transBlue;
                    newColors[offset + 1] = (byte)transGreen;
                    newColors[offset + 2] = (byte)transRed;
                    OS.SetDIBColorTable(srcHdc, 0, maxColors, newColors);
                    originalColors = oldColors;
                }
            } else {
                int numColors = 1 << bm.bmBitsPixel;
                BITMAPINFOHEADER bmiHeader = new BITMAPINFOHEADER();
                bmiHeader.biSize = 40;
                bmiHeader.biPlanes = bm.bmPlanes;
                bmiHeader.biBitCount = bm.bmBitsPixel;
                byte[] bmi = new byte[40 + numColors * 4];
                OS.MoveMemory(bmi, bmiHeader, 40);
                if (OS.IsWinCE) {
                    SWT.error(20);
                }
                OS.GetDIBits(srcHdc, srcImage.handle, 0, 0, 0, bmi, 0);
                int offset = 40 + 4 * srcImage.transparentPixel;
                transRed = bmi[offset + 2] & 0xFF;
                transGreen = bmi[offset + 1] & 0xFF;
                transBlue = bmi[offset] & 0xFF;
            }
        } else {
            int pixel = srcImage.transparentPixel;
            switch (bm.bmBitsPixel) {
                case 16: {
                    transBlue = (pixel & 0x1F) << 3;
                    transGreen = (pixel & 0x3E0) >> 2;
                    transRed = (pixel & 0x7C00) >> 7;
                    break;
                }
                case 24: {
                    transBlue = (pixel & 0xFF0000) >> 16;
                    transGreen = (pixel & 0xFF00) >> 8;
                    transRed = pixel & 0xFF;
                    break;
                }
                case 32: {
                    transBlue = (pixel & 0xFF000000) >>> 24;
                    transGreen = (pixel & 0xFF0000) >> 16;
                    transRed = (pixel & 0xFF00) >> 8;
                }
            }
        }
        if (OS.IsWinCE) {
            int transparentColor = transBlue << 16 | transGreen << 8 | transRed;
            OS.TransparentImage(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, transparentColor);
        } else {
            int maskHdc = OS.CreateCompatibleDC(hDC);
            int maskBitmap = OS.CreateBitmap(imgWidth, imgHeight, 1, 1, null);
            int oldMaskBitmap = OS.SelectObject(maskHdc, maskBitmap);
            OS.SetBkColor(srcHdc, transBlue << 16 | transGreen << 8 | transRed);
            OS.BitBlt(maskHdc, 0, 0, imgWidth, imgHeight, srcHdc, 0, 0, 0xCC0020);
            if (originalColors != null) {
                OS.SetDIBColorTable(srcHdc, 0, 1 << bm.bmBitsPixel, originalColors);
            }
            int tempHdc = OS.CreateCompatibleDC(hDC);
            int tempBitmap = OS.CreateCompatibleBitmap(hDC, destWidth, destHeight);
            int oldTempBitmap = OS.SelectObject(tempHdc, tempBitmap);
            OS.BitBlt(tempHdc, 0, 0, destWidth, destHeight, this.handle, destX, destY, 0xCC0020);
            if (!OS.IsWinCE) {
                OS.SetStretchBltMode(tempHdc, 3);
            }
            OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0x660046);
            OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, maskHdc, srcX, srcY, srcWidth, srcHeight, 8913094);
            OS.StretchBlt(tempHdc, 0, 0, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, 0x660046);
            OS.BitBlt(this.handle, destX, destY, destWidth, destHeight, tempHdc, 0, 0, 0xCC0020);
            OS.SelectObject(tempHdc, oldTempBitmap);
            OS.DeleteDC(tempHdc);
            OS.DeleteObject(tempBitmap);
            OS.SelectObject(maskHdc, oldMaskBitmap);
            OS.DeleteDC(maskHdc);
            OS.DeleteObject(maskBitmap);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        if (hBitmap != srcImage.handle) {
            OS.DeleteObject(hBitmap);
        }
        OS.DeleteDC(srcHdc);
        device.internal_dispose_GC(hDC, null);
    }

    void drawBitmap(Image srcImage, int srcX, int srcY, int srcWidth, int srcHeight, int destX, int destY, int destWidth, int destHeight, boolean simple, BITMAP bm, int imgWidth, int imgHeight) {
        int srcHdc = OS.CreateCompatibleDC(this.handle);
        int oldSrcBitmap = OS.SelectObject(srcHdc, srcImage.handle);
        int mode = 0;
        int rop2 = 0;
        if (!OS.IsWinCE) {
            rop2 = OS.GetROP2(this.handle);
            mode = OS.SetStretchBltMode(this.handle, 3);
        } else {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        }
        int dwRop = rop2 == 7 ? 0x660046 : 0xCC0020;
        OS.StretchBlt(this.handle, destX, destY, destWidth, destHeight, srcHdc, srcX, srcY, srcWidth, srcHeight, dwRop);
        if (!OS.IsWinCE) {
            OS.SetStretchBltMode(this.handle, mode);
        }
        OS.SelectObject(srcHdc, oldSrcBitmap);
        OS.DeleteDC(srcHdc);
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            int[] points = new int[]{x1, y1, x2, y2};
            OS.Polyline(this.handle, points, points.length / 2);
        } else {
            OS.MoveToEx(this.handle, x1, y1, 0);
            OS.LineTo(this.handle, x2, y2);
        }
        OS.SetPixel(this.handle, x2, y2, OS.GetTextColor(this.handle));
    }

    public void drawOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nullBrush = OS.GetStockObject(5);
        int oldBrush = OS.SelectObject(this.handle, nullBrush);
        OS.Ellipse(this.handle, x, y, x + width + 1, y + height + 1);
        OS.SelectObject(this.handle, oldBrush);
    }

    public void drawPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int nullBrush = OS.GetStockObject(5);
        int oldBrush = OS.SelectObject(this.handle, nullBrush);
        OS.Polygon(this.handle, pointArray, pointArray.length / 2);
        OS.SelectObject(this.handle, oldBrush);
    }

    public void drawPolyline(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        OS.Polyline(this.handle, pointArray, pointArray.length / 2);
    }

    public void drawRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hOld = OS.SelectObject(this.handle, OS.GetStockObject(5));
        OS.Rectangle(this.handle, x, y, x + width + 1, y + height + 1);
        OS.SelectObject(this.handle, hOld);
    }

    public void drawRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.drawRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void drawRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            if (width == 0 || height == 0) {
                return;
            }
            if (arcWidth == 0 || arcHeight == 0) {
                this.drawRectangle(x, y, width, height);
                return;
            }
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            if (arcWidth < 0) {
                arcWidth = -arcWidth;
            }
            if (arcHeight < 0) {
                arcHeight = -arcHeight;
            }
            if (arcWidth > width) {
                arcWidth = width;
            }
            if (arcHeight > height) {
                arcHeight = height;
            }
            if (arcWidth < width) {
                this.drawLine(x + arcWidth / 2, y, x + width - arcWidth / 2, y);
                this.drawLine(x + arcWidth / 2, y + height - 1, x + width - arcWidth / 2, y + height - 1);
            }
            if (arcHeight < height) {
                this.drawLine(x, y + arcHeight / 2, x, y + height - arcHeight / 2);
                this.drawLine(x + width - 1, y + arcHeight / 2, x + width - 1, y + height - arcHeight / 2);
            }
            if (arcWidth != 0 && arcHeight != 0) {
                this.drawArc(x, y, arcWidth, arcHeight, 90, 90);
                this.drawArc(x + width - arcWidth - 1, y, arcWidth, arcHeight, 0, 90);
                this.drawArc(x + width - arcWidth - 1, y + height - arcHeight - 1, arcWidth, arcHeight, 0, -90);
                this.drawArc(x, y + height - arcHeight - 1, arcWidth, arcHeight, 180, 90);
            }
        } else {
            int nullBrush = OS.GetStockObject(5);
            int oldBrush = OS.SelectObject(this.handle, nullBrush);
            OS.RoundRect(this.handle, x, y, x + width, y + height, arcWidth, arcHeight);
            OS.SelectObject(this.handle, oldBrush);
        }
    }

    public void drawString(String string, int x, int y) {
        this.drawString(string, x, y, false);
    }

    public void drawString(String string, int x, int y, boolean isTransparent) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        int length = string.length();
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        int oldBkMode = OS.SetBkMode(this.handle, isTransparent ? 1 : 2);
        OS.ExtTextOutW(this.handle, x, y, 0, null, buffer, length, null);
        OS.SetBkMode(this.handle, oldBkMode);
    }

    public void drawText(String string, int x, int y) {
        this.drawText(string, x, y, 6);
    }

    public void drawText(String string, int x, int y, boolean isTransparent) {
        int flags = 6;
        if (isTransparent) {
            flags |= 1;
        }
        this.drawText(string, x, y, flags);
    }

    public void drawText(String string, int x, int y, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            return;
        }
        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
        int length = buffer.length();
        if (length == 0) {
            return;
        }
        RECT rect = new RECT();
        OS.SetRect(rect, x, y, Short.MAX_VALUE, Short.MAX_VALUE);
        int uFormat = 0;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        int oldBkMode = OS.SetBkMode(this.handle, (flags & 1) != 0 ? 1 : 2);
        OS.DrawText(this.handle, buffer, length, rect, uFormat);
        OS.SetBkMode(this.handle, oldBkMode);
    }

    public boolean equals(Object object) {
        return object == this || object instanceof GC && this.handle == ((GC)object).handle;
    }

    public void fillArc(int x, int y, int width, int height, int startAngle, int endAngle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width < 0) {
            x += width;
            width = -width;
        }
        if (height < 0) {
            y += height;
            height = -height;
        }
        if (width == 0 || height == 0 || endAngle == 0) {
            SWT.error(5);
        }
        if (OS.IsWinCE) {
            if (endAngle < 0) {
                startAngle += endAngle;
                endAngle = -endAngle;
            }
            boolean drawSegments = true;
            if (endAngle >= 360) {
                endAngle = 360;
                drawSegments = false;
            }
            int[] points = new int[(endAngle + 1) * 2 + (drawSegments ? 4 : 0)];
            int cteX = 2 * x + width;
            int cteY = 2 * y + height;
            int index = drawSegments ? 2 : 0;
            int i = 0;
            while (i <= endAngle) {
                points[index++] = Compatibility.cos(startAngle + i, width) + cteX >> 1;
                points[index++] = cteY - Compatibility.sin(startAngle + i, height) >> 1;
                ++i;
            }
            if (drawSegments) {
                int n = cteX >> 1;
                points[points.length - 2] = n;
                points[0] = n;
                int n2 = cteY >> 1;
                points[points.length - 1] = n2;
                points[1] = n2;
            }
            int nullPen = OS.GetStockObject(8);
            int oldPen = OS.SelectObject(this.handle, nullPen);
            OS.Polygon(this.handle, points, points.length / 2);
            OS.SelectObject(this.handle, oldPen);
        } else {
            int y1;
            int y2;
            int x1;
            int x2;
            if (endAngle >= 360 || endAngle <= -360) {
                x1 = x2 = x + width;
                y1 = y2 = y + height / 2;
            } else {
                boolean isNegative = endAngle < 0;
                endAngle += startAngle;
                if (isNegative) {
                    int tmp = startAngle;
                    startAngle = endAngle;
                    endAngle = tmp;
                }
                x1 = Compatibility.cos(startAngle, width) + x + width / 2;
                y1 = -1 * Compatibility.sin(startAngle, height) + y + height / 2;
                x2 = Compatibility.cos(endAngle, width) + x + width / 2;
                y2 = -1 * Compatibility.sin(endAngle, height) + y + height / 2;
            }
            int nullPen = OS.GetStockObject(8);
            int oldPen = OS.SelectObject(this.handle, nullPen);
            OS.Pie(this.handle, x, y, x + width + 1, y + height + 1, x1, y1, x2, y2);
            OS.SelectObject(this.handle, oldPen);
        }
    }

    public void fillGradientRectangle(int x, int y, int width, int height, boolean vertical) {
        int depth;
        int toColor;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (width == 0 || height == 0) {
            return;
        }
        int fromColor = OS.GetTextColor(this.handle);
        if (fromColor == -1) {
            fromColor = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        if ((toColor = OS.GetBkColor(this.handle)) == -1) {
            toColor = OS.GetSysColor(OS.COLOR_WINDOW);
        }
        boolean swapColors = false;
        if (width < 0) {
            x += width;
            width = -width;
            if (!vertical) {
                swapColors = true;
            }
        }
        if (height < 0) {
            y += height;
            height = -height;
            if (vertical) {
                swapColors = true;
            }
        }
        if (swapColors) {
            int t = fromColor;
            fromColor = toColor;
            toColor = t;
        }
        RGB fromRGB = new RGB(fromColor & 0xFF, fromColor >>> 8 & 0xFF, fromColor >>> 16 & 0xFF);
        RGB toRGB = new RGB(toColor & 0xFF, toColor >>> 8 & 0xFF, toColor >>> 16 & 0xFF);
        if (fromRGB.red == toRGB.red && fromRGB.green == toRGB.green && fromRGB.blue == toRGB.blue) {
            OS.PatBlt(this.handle, x, y, width, height, 15728673);
            return;
        }
        if (!OS.IsWinCE) {
            int hHeap = OS.GetProcessHeap();
            int pMesh = OS.HeapAlloc(hHeap, 8, 40);
            int pVertex = pMesh + 8;
            GRADIENT_RECT gradientRect = new GRADIENT_RECT();
            gradientRect.UpperLeft = 0;
            gradientRect.LowerRight = 1;
            OS.MoveMemory(pMesh, gradientRect, 8);
            TRIVERTEX trivertex = new TRIVERTEX();
            trivertex.x = x;
            trivertex.y = y;
            trivertex.Red = (short)(fromRGB.red << 8 | fromRGB.red);
            trivertex.Green = (short)(fromRGB.green << 8 | fromRGB.green);
            trivertex.Blue = (short)(fromRGB.blue << 8 | fromRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory(pVertex, trivertex, 16);
            trivertex.x = x + width;
            trivertex.y = y + height;
            trivertex.Red = (short)(toRGB.red << 8 | toRGB.red);
            trivertex.Green = (short)(toRGB.green << 8 | toRGB.green);
            trivertex.Blue = (short)(toRGB.blue << 8 | toRGB.blue);
            trivertex.Alpha = (short)-1;
            OS.MoveMemory(pVertex + 16, trivertex, 16);
            boolean success = OS.GradientFill(this.handle, pVertex, 2, pMesh, 1, vertical ? 1 : 0);
            OS.HeapFree(hHeap, 0, pMesh);
            if (success) {
                return;
            }
        }
        int bitResolution = (depth = OS.GetDeviceCaps(this.handle, 12)) >= 24 ? 8 : (depth >= 15 ? 5 : 0);
        ImageData.fillGradientRectangle(this, this.data.device, x, y, width, height, vertical, fromRGB, toRGB, bitResolution, bitResolution, bitResolution);
    }

    public void fillOval(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.Ellipse(this.handle, x, y, x + width + 1, y + height + 1);
        OS.SelectObject(this.handle, oldPen);
    }

    public void fillPolygon(int[] pointArray) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.Polygon(this.handle, pointArray, pointArray.length / 2);
        OS.SelectObject(this.handle, oldPen);
    }

    public void fillRectangle(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        int dwRop = rop2 == 7 ? 5898313 : 15728673;
        OS.PatBlt(this.handle, x, y, width, height, dwRop);
    }

    public void fillRectangle(Rectangle rect) {
        if (rect == null) {
            SWT.error(4);
        }
        this.fillRectangle(rect.x, rect.y, rect.width, rect.height);
    }

    public void fillRoundRectangle(int x, int y, int width, int height, int arcWidth, int arcHeight) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int nullPen = OS.GetStockObject(8);
        int oldPen = OS.SelectObject(this.handle, nullPen);
        OS.RoundRect(this.handle, x, y, x + width, y + height, arcWidth, arcHeight);
        OS.SelectObject(this.handle, oldPen);
    }

    public int getAdvanceWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (OS.IsWinCE) {
            SIZE size = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{ch}, 1, size);
            return size.cx;
        }
        int tch = ch;
        if (ch > 127) {
            TCHAR buffer = new TCHAR(this.getCodePage(), (char)ch, false);
            tch = buffer.tcharAt(0);
        }
        int[] width = new int[1];
        OS.GetCharWidth(this.handle, tch, tch, width);
        return width[0];
    }

    public Color getBackground() {
        int color;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((color = OS.GetBkColor(this.handle)) == -1) {
            color = OS.GetSysColor(OS.COLOR_WINDOW);
        }
        return Color.win32_new(this.data.device, color);
    }

    public int getCharWidth(char ch) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (!OS.IsWinCE) {
            int[] width;
            int tch = ch;
            if (ch > 127) {
                TCHAR buffer = new TCHAR(this.getCodePage(), (char)ch, false);
                tch = buffer.tcharAt(0);
            }
            if (OS.GetCharABCWidths(this.handle, tch, tch, width = new int[3])) {
                return width[1];
            }
        }
        TEXTMETRIC tm = new TEXTMETRIC();
        OS.GetTextMetricsW(this.handle, tm);
        SIZE size = new SIZE();
        OS.GetTextExtentPoint32W(this.handle, new char[]{ch}, 1, size);
        return size.cx - tm.tmOverhang;
    }

    public Rectangle getClipping() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        RECT rect = new RECT();
        OS.GetClipBox(this.handle, rect);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public void getClipping(Region region) {
        int result;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (region == null) {
            SWT.error(4);
        }
        if ((result = OS.GetClipRgn(this.handle, region.handle)) == 1) {
            return;
        }
        RECT rect = new RECT();
        OS.GetClipBox(this.handle, rect);
        OS.SetRectRgn(region.handle, rect.left, rect.top, rect.right, rect.bottom);
    }

    int getCodePage() {
        if (OS.IsWinCE) {
            return OS.GetACP();
        }
        int[] lpCs = new int[8];
        int cs = OS.GetTextCharset(this.handle);
        OS.TranslateCharsetInfo(cs, lpCs, 1);
        return lpCs[1];
    }

    public Font getFont() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hFont = OS.GetCurrentObject(this.handle, 6);
        return Font.win32_new(this.data.device, hFont);
    }

    public FontMetrics getFontMetrics() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        TEXTMETRIC lptm = new TEXTMETRIC();
        OS.GetTextMetrics(this.handle, lptm);
        return FontMetrics.win32_new(lptm);
    }

    public Color getForeground() {
        int color;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if ((color = OS.GetTextColor(this.handle)) == -1) {
            color = OS.GetSysColor(OS.COLOR_WINDOWTEXT);
        }
        return Color.win32_new(this.data.device, color);
    }

    public int getLineStyle() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hPen = OS.GetCurrentObject(this.handle, 1);
        LOGPEN logPen = new LOGPEN();
        OS.GetObject(hPen, 16, logPen);
        switch (logPen.lopnStyle) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
        }
        return 1;
    }

    public int getLineWidth() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hPen = OS.GetCurrentObject(this.handle, 1);
        LOGPEN logPen = new LOGPEN();
        OS.GetObject(hPen, 16, logPen);
        return logPen.x;
    }

    public boolean getXORMode() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int rop2 = 0;
        if (OS.IsWinCE) {
            rop2 = OS.SetROP2(this.handle, 13);
            OS.SetROP2(this.handle, rop2);
        } else {
            rop2 = OS.GetROP2(this.handle);
        }
        return rop2 == 7;
    }

    void init(Drawable drawable, GCData data, int hDC) {
        Image image;
        int hPalette;
        int hFont;
        int background;
        int foreground = data.foreground;
        if (foreground != -1 && OS.GetTextColor(hDC) != foreground) {
            OS.SetTextColor(hDC, foreground);
            int hPen = OS.CreatePen(0, 0, foreground);
            OS.SelectObject(hDC, hPen);
        }
        if ((background = data.background) != -1 && OS.GetBkColor(hDC) != background) {
            OS.SetBkColor(hDC, background);
            int hBrush = OS.CreateSolidBrush(background);
            OS.SelectObject(hDC, hBrush);
        }
        if ((hFont = data.hFont) != 0) {
            OS.SelectObject(hDC, hFont);
        }
        if ((hPalette = data.device.hPalette) != 0) {
            OS.SelectPalette(hDC, hPalette, true);
            OS.RealizePalette(hDC);
        }
        if ((image = data.image) != null) {
            data.hNullBitmap = OS.SelectObject(hDC, image.handle);
            image.memGC = this;
        }
        this.drawable = drawable;
        this.data = data;
        this.handle = hDC;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isClipped() {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int region = OS.CreateRectRgn(0, 0, 0, 0);
        int result = OS.GetClipRgn(this.handle, region);
        OS.DeleteObject(region);
        return result > 0;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (OS.GetBkColor(this.handle) == color.handle) {
            return;
        }
        OS.SetBkColor(this.handle, color.handle);
        int newBrush = OS.CreateSolidBrush(color.handle);
        int oldBrush = OS.SelectObject(this.handle, newBrush);
        OS.DeleteObject(oldBrush);
    }

    public void setClipping(int x, int y, int width, int height) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hRgn = OS.CreateRectRgn(x, y, x + width, y + height);
        OS.SelectClipRgn(this.handle, hRgn);
        OS.DeleteObject(hRgn);
    }

    public void setClipping(Rectangle rect) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (rect == null) {
            OS.SelectClipRgn(this.handle, 0);
            return;
        }
        this.setClipping(rect.x, rect.y, rect.width, rect.height);
    }

    public void setClipping(Region region) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hRegion = 0;
        if (region != null) {
            hRegion = region.handle;
        }
        OS.SelectClipRgn(this.handle, hRegion);
    }

    public void setFont(Font font) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (font == null) {
            OS.SelectObject(this.handle, this.data.device.systemFont);
        } else {
            if (font.isDisposed()) {
                SWT.error(5);
            }
            OS.SelectObject(this.handle, font.handle);
        }
    }

    public void setForeground(Color color) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (OS.GetTextColor(this.handle) == color.handle) {
            return;
        }
        int hPen = OS.GetCurrentObject(this.handle, 1);
        LOGPEN logPen = new LOGPEN();
        OS.GetObject(hPen, 16, logPen);
        OS.SetTextColor(this.handle, color.handle);
        int newPen = OS.CreatePen(logPen.lopnStyle, logPen.x, color.handle);
        int oldPen = OS.SelectObject(this.handle, newPen);
        OS.DeleteObject(oldPen);
    }

    public void setLineStyle(int lineStyle) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int style = -1;
        switch (lineStyle) {
            case 1: {
                style = 0;
                break;
            }
            case 2: {
                style = 1;
                break;
            }
            case 3: {
                style = 2;
                break;
            }
            case 4: {
                style = 3;
                break;
            }
            case 5: {
                style = 4;
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        int hPen = OS.GetCurrentObject(this.handle, 1);
        LOGPEN logPen = new LOGPEN();
        OS.GetObject(hPen, 16, logPen);
        if (logPen.lopnStyle == style) {
            return;
        }
        OS.SetBkMode(this.handle, style == 0 ? 2 : 1);
        int newPen = OS.CreatePen(style, logPen.x, logPen.lopnColor);
        int oldPen = OS.SelectObject(this.handle, newPen);
        OS.DeleteObject(oldPen);
    }

    public void setLineWidth(int lineWidth) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        int hPen = OS.GetCurrentObject(this.handle, 1);
        LOGPEN logPen = new LOGPEN();
        OS.GetObject(hPen, 16, logPen);
        if (logPen.x == lineWidth) {
            return;
        }
        int newPen = OS.CreatePen(logPen.lopnStyle, lineWidth, logPen.lopnColor);
        int oldPen = OS.SelectObject(this.handle, newPen);
        OS.DeleteObject(oldPen);
    }

    public void setXORMode(boolean xor) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (xor) {
            OS.SetROP2(this.handle, 7);
        } else {
            OS.SetROP2(this.handle, 13);
        }
    }

    public Point stringExtent(String string) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        SIZE size = new SIZE();
        int length = string.length();
        if (length == 0) {
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, size);
            return new Point(0, size.cy);
        }
        char[] buffer = new char[length];
        string.getChars(0, length, buffer, 0);
        OS.GetTextExtentPoint32W(this.handle, buffer, length, size);
        return new Point(size.cx, size.cy);
    }

    public Point textExtent(String string) {
        return this.textExtent(string, 6);
    }

    public Point textExtent(String string, int flags) {
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (string == null) {
            SWT.error(4);
        }
        if (string.length() == 0) {
            SIZE size = new SIZE();
            OS.GetTextExtentPoint32W(this.handle, new char[]{' '}, 1, size);
            return new Point(0, size.cy);
        }
        RECT rect = new RECT();
        TCHAR buffer = new TCHAR(this.getCodePage(), string, false);
        int uFormat = 1024;
        if ((flags & 2) == 0) {
            uFormat |= 0x20;
        }
        if ((flags & 4) != 0) {
            uFormat |= 0x40;
        }
        if ((flags & 8) == 0) {
            uFormat |= 0x800;
        }
        OS.DrawText(this.handle, buffer, buffer.length(), rect, uFormat);
        return new Point(rect.right, rect.bottom);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "GC {*DISPOSED*}";
        }
        return "GC {" + this.handle + "}";
    }

    public static GC win32_new(Drawable drawable, GCData data) {
        GC gc = new GC();
        int hDC = drawable.internal_new_GC(data);
        gc.init(drawable, data, hDC);
        return gc;
    }
}

