/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.usability;

import java.lang.ref.SoftReference;
import java.security.AccessController;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.StringTokenizer;
import sun.plugin.resources.ResourceHandler;
import sun.plugin.usability.DialogFactory;
import sun.plugin.usability.TraceListener;
import sun.security.action.GetPropertyAction;

public class Trace {
    private static boolean bBasicTraceOn = false;
    private static boolean bExtTraceOn = false;
    private static boolean bSecurityTraceOn = false;
    private static boolean bNetTraceOn = false;
    private static boolean bLiveConnectTraceOn = false;
    private static boolean bAutomationOn = false;
    private static HashMap threadGroups;

    public static void reset() {
        if (Boolean.getBoolean("javaplugin.trace")) {
            String string = AccessController.doPrivileged(new GetPropertyAction("javaplugin.trace.option"));
            if (string == null) {
                bBasicTraceOn = true;
                bNetTraceOn = true;
                bSecurityTraceOn = true;
                bExtTraceOn = true;
                bLiveConnectTraceOn = true;
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(string, "|");
                while (stringTokenizer.hasMoreTokens()) {
                    String string2 = stringTokenizer.nextToken();
                    if (string2 == null || string2.equalsIgnoreCase("all")) {
                        bBasicTraceOn = true;
                        bNetTraceOn = true;
                        bSecurityTraceOn = true;
                        bExtTraceOn = true;
                        bLiveConnectTraceOn = true;
                        break;
                    }
                    if (string2.equalsIgnoreCase("basic")) {
                        bBasicTraceOn = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("net")) {
                        bNetTraceOn = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("security")) {
                        bSecurityTraceOn = true;
                        continue;
                    }
                    if (string2.equalsIgnoreCase("ext")) {
                        bExtTraceOn = true;
                        continue;
                    }
                    if (!string2.equalsIgnoreCase("liveconnect")) continue;
                    bLiveConnectTraceOn = true;
                }
            }
        }
    }

    public static boolean isEnabled() {
        return bBasicTraceOn || bNetTraceOn || bSecurityTraceOn || bExtTraceOn || bLiveConnectTraceOn;
    }

    public static void setBasicTrace(boolean bl) {
        bBasicTraceOn = bl;
    }

    public static void setNetTrace(boolean bl) {
        bNetTraceOn = bl;
    }

    public static void setSecurityTrace(boolean bl) {
        bSecurityTraceOn = bl;
    }

    public static void setExtTrace(boolean bl) {
        bExtTraceOn = bl;
    }

    public static void setLiveConnectTrace(boolean bl) {
        bLiveConnectTraceOn = bl;
    }

    public static boolean isAutomationEnabled() {
        return bAutomationOn;
    }

    public static void println(String string) {
        Trace.println(string, null);
    }

    public static void println(String string, int n) {
        Trace.println(string, null, n);
    }

    public static void println(String string, TraceListener traceListener) {
        Trace.println(string, traceListener, 2);
    }

    public static void println(String string, TraceListener traceListener, int n) {
        if (bBasicTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, traceListener, n);
    }

    public static void printException(Throwable throwable) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.general_error"), throwable};
            DialogFactory.showExceptionDialog(objectArray, null);
        }
    }

    public static void printException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{string, throwable};
            DialogFactory.showExceptionDialog(objectArray, string2);
        }
    }

    public static void netPrintln(String string) {
        Trace.netPrintln(string, 2);
    }

    public static void netPrintln(String string, int n) {
        if (bNetTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void netPrintException(Throwable throwable) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.net_error"), throwable};
        }
    }

    public static void netPrintException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        Object[] objectArray = new Object[]{string, throwable};
    }

    public static void securityPrintln(String string) {
        Trace.securityPrintln(string, 2);
    }

    public static void securityPrintln(String string, int n) {
        if (bSecurityTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void securityPrintException(Throwable throwable) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.security_error"), throwable};
            DialogFactory.showExceptionDialog(objectArray, null);
        }
    }

    public static void securityPrintException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{string, throwable};
            DialogFactory.showExceptionDialog(objectArray, string2);
        }
    }

    public static void extPrintln(String string) {
        Trace.extPrintln(string, 2);
    }

    public static void extPrintln(String string, int n) {
        if (bExtTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void extPrintException(Throwable throwable) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{ResourceHandler.getMessage("usability.ext_error"), throwable};
            DialogFactory.showExceptionDialog(objectArray, null);
        }
    }

    public static void extPrintException(Throwable throwable, String string, String string2) {
        throwable.printStackTrace();
        if (!Trace.isAutomationEnabled()) {
            Object[] objectArray = new Object[]{string, throwable};
            DialogFactory.showExceptionDialog(objectArray, string2);
        }
    }

    public static void liveConnectPrintln(String string) {
        Trace.liveConnectPrintln(string, 2);
    }

    public static void liveConnectPrintln(String string, int n) {
        if (bLiveConnectTraceOn && (n & 2) == 2) {
            System.err.println(string);
            System.err.flush();
        }
        Trace.firePrintlnEvent(string, null, n);
    }

    public static void liveConnectPrintException(Throwable throwable) {
        throwable.printStackTrace();
    }

    public static void addTraceListener(ThreadGroup threadGroup, TraceListener traceListener) {
        Trace.println(ResourceHandler.getMessage("trace.listener.added") + traceListener, 2);
        HashMap hashMap = threadGroups;
        synchronized (hashMap) {
            ArrayList<SoftReference<TraceListener>> arrayList = (ArrayList<SoftReference<TraceListener>>)threadGroups.get(threadGroup.toString());
            if (arrayList == null) {
                arrayList = new ArrayList<SoftReference<TraceListener>>();
                threadGroups.put(threadGroup.toString(), arrayList);
            }
            arrayList.add(new SoftReference<TraceListener>(traceListener));
        }
    }

    public static void removeTraceListener(ThreadGroup threadGroup, TraceListener traceListener) {
        Trace.println(ResourceHandler.getMessage("trace.listener.removed") + traceListener, 2);
        HashMap hashMap = threadGroups;
        synchronized (hashMap) {
            ArrayList arrayList = (ArrayList)threadGroups.get(threadGroup.toString());
            if (arrayList != null) {
                SoftReference softReference = null;
                Iterator iterator = ((AbstractList)arrayList).iterator();
                while (iterator.hasNext()) {
                    softReference = (SoftReference)iterator.next();
                    TraceListener traceListener2 = null;
                    if (softReference != null) {
                        traceListener2 = (TraceListener)softReference.get();
                    }
                    if (traceListener2 != null && traceListener2.equals(traceListener)) break;
                    softReference = null;
                }
                if (softReference != null) {
                    arrayList.remove(arrayList.indexOf(softReference));
                    if (arrayList.size() == 0) {
                        threadGroups.remove(threadGroup.toString());
                    }
                }
            }
        }
    }

    private static void firePrintlnEvent(String string, TraceListener traceListener, int n) {
        if (traceListener != null) {
            traceListener.println(string, n);
        } else {
            Object object;
            Thread thread = Thread.currentThread();
            ThreadGroup threadGroup = thread.getThreadGroup();
            ArrayList arrayList = null;
            HashMap hashMap = threadGroups;
            synchronized (hashMap) {
                object = (ArrayList)threadGroups.get(threadGroup.toString());
                if (object != null) {
                    arrayList = (ArrayList)((ArrayList)object).clone();
                }
            }
            if (arrayList != null) {
                object = ((AbstractList)arrayList).iterator();
                while (object.hasNext()) {
                    TraceListener traceListener2;
                    SoftReference softReference = (SoftReference)object.next();
                    if (softReference == null || (traceListener2 = (TraceListener)softReference.get()) == null) continue;
                    traceListener2.println(string, n);
                }
                arrayList.clear();
            }
        }
    }

    static {
        Trace.reset();
        bAutomationOn = Boolean.getBoolean("javaplugin.automation");
        threadGroups = new HashMap();
    }
}

