/*
 * Decompiled with CFR 0.152.
 */
package sun.plugin.cachescheme;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Random;
import java.util.StringTokenizer;
import java.util.Vector;
import sun.plugin.cachescheme.CacheTableEntryException;
import sun.plugin.cachescheme.InvalidCacheParameterException;
import sun.plugin.cachescheme.JarCacheException;
import sun.plugin.cachescheme.JarCacheInterface;
import sun.plugin.cachescheme.JarFileInvalidException;
import sun.plugin.cachescheme.PluginJarCacheTable;
import sun.plugin.cachescheme.PluginJarCacheTableEntry;
import sun.plugin.cachescheme.PluginMutex;
import sun.plugin.cachescheme.PluginMutexException;
import sun.plugin.cachescheme.PluginURLConnection;
import sun.plugin.usability.Trace;

public class PluginJarCacheHandler
implements JarCacheInterface {
    URL m_relativeCodeBase = null;
    String m_protocol = null;
    String m_urlString;
    PluginJarCacheTable m_cacheTable = null;

    public boolean isValidHandler(String string) {
        return string != null && string.equalsIgnoreCase("plugin");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Vector getJarFilesPath(String string, String string2, URL uRL) throws PluginMutexException, InvalidCacheParameterException, IOException, JarCacheException {
        if (string == null) {
            throw new InvalidCacheParameterException("Requires attribute 'cache_archive'");
        }
        Vector<Object> vector = new Vector<Object>();
        this.m_relativeCodeBase = uRL;
        PluginMutex pluginMutex = null;
        try {
            Object object;
            int n;
            pluginMutex = PluginMutex.getMutex(uRL.toString());
            pluginMutex.waitForLock();
            this.m_cacheTable = new PluginJarCacheTable();
            this.m_cacheTable.load();
            ArrayList arrayList = this.parseParameters(string);
            ArrayList arrayList2 = null;
            if (string2 != null) {
                arrayList2 = this.parseParameters(string2);
                if (arrayList.size() != arrayList2.size()) {
                    throw new InvalidCacheParameterException("Requires number of attributes specified in 'cache_archive' matches those in 'cache_version'");
                }
                n = 0;
                while (n < arrayList2.size()) {
                    object = (String)arrayList2.get(n);
                    if (object != null) {
                        PluginJarCacheTableEntry.extractVersion((String)object);
                    }
                    ++n;
                }
            }
            n = 0;
            while (n < arrayList.size()) {
                object = null;
                String string3 = null;
                String string4 = arrayList.get(n).toString();
                if (this.CheckForFullURL(string4)) {
                    throw new InvalidCacheParameterException("Only relative URL should be used in the attribute 'cache_archive'");
                }
                String string5 = null;
                try {
                    URL uRL2 = new URL(this.m_relativeCodeBase, string4);
                    string5 = uRL2.toString();
                }
                catch (MalformedURLException malformedURLException) {
                    throw new InvalidCacheParameterException("Invalid relative URL is specified in the attribute 'cache_archive'");
                }
                if (arrayList2 != null) {
                    string3 = arrayList2.get(n).toString();
                }
                if ((object = this.cacheHandler(string4, string3, string5)) != null) {
                    vector.addElement(object);
                }
                ++n;
            }
            Object var15_15 = null;
            if (pluginMutex == null) return vector;
        }
        catch (Throwable throwable) {
            Object var15_16 = null;
            if (pluginMutex == null) throw throwable;
            pluginMutex.release();
            throw throwable;
        }
        pluginMutex.release();
        return vector;
    }

    private File cacheHandler(String string, String string2, String string3) throws PluginMutexException, InvalidCacheParameterException, IOException, JarCacheException {
        File file = null;
        PluginURLConnection pluginURLConnection = new PluginURLConnection(this.m_relativeCodeBase, string);
        file = this.getJarFileFromCache(string, string2, string3, pluginURLConnection);
        if (file == null) {
            file = this.downloadJarFileToCache(string, string2, string3, pluginURLConnection);
        }
        return file;
    }

    private ArrayList parseParameters(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",", false);
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken().trim();
            arrayList.add(string2);
        }
        return arrayList;
    }

    private boolean CheckForFullURL(String string) {
        boolean bl = false;
        URL uRL = null;
        try {
            uRL = new URL(string);
            bl = true;
        }
        catch (MalformedURLException malformedURLException) {
            bl = false;
        }
        return bl;
    }

    private File downloadJarFileToCache(String string, String string2, String string3, PluginURLConnection pluginURLConnection) throws PluginMutexException, InvalidCacheParameterException, IOException, JarCacheException {
        File file;
        block4: {
            block5: {
                file = this.generateCacheFile(string, string2);
                boolean bl = false;
                try {
                    Trace.println("Downloading " + string3 + " to " + file, 2);
                    pluginURLConnection.downLoadFile(file);
                    Trace.println("Updating applet cache table", 2);
                    PluginJarCacheTableEntry pluginJarCacheTableEntry = PluginJarCacheTableEntry.createEntry(string2, file.getName(), pluginURLConnection.getLastModified(), pluginURLConnection.getContentLength());
                    this.m_cacheTable.add(string3, pluginJarCacheTableEntry);
                    this.m_cacheTable.save();
                    bl = true;
                    Object var9_8 = null;
                    if (bl) break block4;
                    if (file == null || !file.exists()) break block5;
                    file.delete();
                }
                catch (Throwable throwable) {
                    Object var9_9 = null;
                    if (!bl) {
                        if (file != null && file.exists()) {
                            file.delete();
                        }
                        this.m_cacheTable.remove(string3);
                    }
                    throw throwable;
                }
            }
            this.m_cacheTable.remove(string3);
            {
            }
        }
        return file;
    }

    private File getJarFileFromCache(String string, String string2, String string3, PluginURLConnection pluginURLConnection) throws PluginMutexException, IOException, InvalidCacheParameterException {
        File file = null;
        try {
            Trace.println("Check if " + string + " exists as entry in cache table", 2);
            PluginJarCacheTableEntry pluginJarCacheTableEntry = this.m_cacheTable.getEntry(string3);
            if (pluginJarCacheTableEntry == null) {
                Trace.println(string + " not found in cache table - force download", 2);
                return null;
            }
            Trace.println("Check if " + string + " actually exists in cache", 2);
            file = pluginJarCacheTableEntry.getFileInCache();
            if (file == null || !file.exists()) {
                Trace.println(string + " not found in applet cache - force download", 2);
                return null;
            }
            Trace.println("Check if " + string + " is upto-date", 2);
            if (string2 != null) {
                pluginJarCacheTableEntry.verifyCacheVersion(string2);
            } else {
                Date date = pluginJarCacheTableEntry.getCacheTimeStamp();
                Date date2 = new Date(pluginURLConnection.getLastModified());
                Trace.println("Last modified: cache=" + date + ", remote=" + date2, 2);
                pluginJarCacheTableEntry.verifyCacheTimeStamp(date2);
                int n = pluginJarCacheTableEntry.getCacheFileSize();
                int n2 = pluginURLConnection.getContentLength();
                Trace.println("File size: cache=" + n + ", remote=" + n2, 2);
                pluginJarCacheTableEntry.verifyCacheFileSize(n2);
            }
            Trace.println(string + " is upto-date in cache", 2);
            return file;
        }
        catch (CacheTableEntryException cacheTableEntryException) {
            Trace.println("Unable to parse cache entry from cache table - force download", 2);
            return null;
        }
        catch (JarFileInvalidException jarFileInvalidException) {
            Trace.println("File is not upto-date in cache - force download", 2);
            if (file != null) {
                file.delete();
            }
            return null;
        }
    }

    private File generateCacheFile(String string, String string2) throws JarCacheException {
        String string3;
        String string4;
        if (string.indexOf(47) != -1) {
            string4 = string.substring(string.lastIndexOf(47) + 1);
            string3 = this.m_relativeCodeBase + string.substring(0, string.lastIndexOf(47));
        } else {
            string4 = string;
            string3 = this.m_relativeCodeBase.toString();
        }
        boolean bl = true;
        File file = null;
        Random random = new Random();
        int n = 0;
        while (bl) {
            string4 = string4 + string3.hashCode() + string2 + String.valueOf(random.nextLong()) + ".jar";
            file = new File(PluginJarCacheTable.getCacheHomeDir() + File.separator + string4);
            bl = file.exists();
            if (n++ > 255) {
                Trace.println("Warning: Could not find a suitable name for the file in the cache after iteration " + n + ".", 2);
            }
            if (n <= 512) continue;
            throw new JarCacheException("Unable to find a suitable name for the jar file in the cache.");
        }
        return file;
    }
}

