/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.ole.event;

import java.beans.IntrospectionException;
import java.util.EventObject;
import java.util.Hashtable;
import sun.beans.ole.event.EncapsulatedEvent;
import sun.beans.ole.event.EncapsulatedEventAdaptor;
import sun.beans.ole.event.EncapsulatedEventInformation;
import sun.beans.ole.event.EncapsulatedEventListener;
import sun.beans.ole.event.EncapsulatedEventManager;

public class EventManager
implements EncapsulatedEventManager,
EncapsulatedEventListener {
    private EncapsulatedEventInformation[] interfacesInfo;
    private transient Hashtable sources = new Hashtable();
    private Object source;

    public EventManager(EncapsulatedEventInformation[] encapsulatedEventInformationArray, Object object) {
        this.interfacesInfo = encapsulatedEventInformationArray;
        this.source = object;
    }

    public Class[] getSourceEventListenerInterfaces(Object object) {
        Class[] classArray = new Class[this.interfacesInfo.length];
        int n = 0;
        while (n < this.interfacesInfo.length) {
            classArray[n] = this.interfacesInfo[n].getListenerType();
            ++n;
        }
        return classArray;
    }

    public void addEncapsulatedEventListener(Object object, EncapsulatedEventListener encapsulatedEventListener) {
        this.addEncapsulatedEventListener(object, encapsulatedEventListener, this.getSourceEventListenerInterfaces(object));
    }

    public void removeEncapsulatedEventListener(Object object, EncapsulatedEventListener encapsulatedEventListener) {
        this.removeEncapsulatedEventListener(object, encapsulatedEventListener, this.getSourceEventListenerInterfaces(object));
    }

    public synchronized void addEncapsulatedEventListener(Object object, EncapsulatedEventListener encapsulatedEventListener, Class[] classArray) {
        if (object == null) {
            throw new NullPointerException("Source");
        }
        if (encapsulatedEventListener == null) {
            throw new NullPointerException("Listener");
        }
        if (classArray == null) {
            throw new NullPointerException("Interfaces");
        }
        Hashtable<Class, EncapsulatedEventAdaptor> hashtable = (Hashtable<Class, EncapsulatedEventAdaptor>)this.sources.get(object);
        if (hashtable == null) {
            hashtable = new Hashtable<Class, EncapsulatedEventAdaptor>();
            this.sources.put(object, hashtable);
        }
        int n = 0;
        while (n < classArray.length) {
            EncapsulatedEventAdaptor encapsulatedEventAdaptor = (EncapsulatedEventAdaptor)hashtable.get(classArray[n]);
            if (encapsulatedEventAdaptor == null) {
                try {
                    encapsulatedEventAdaptor = EncapsulatedEventAdaptor.getEncapsulatedEventAdaptor(this.interfacesInfo[n], object);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    System.err.println("Cant create adaptor class");
                }
                catch (InstantiationException instantiationException) {
                    System.err.println("Cant instantiate adaptor");
                }
                catch (IllegalAccessException illegalAccessException) {
                    System.err.println("illegal access");
                }
                catch (IntrospectionException introspectionException) {
                    System.err.println("introspection error");
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
                if (encapsulatedEventAdaptor != null) {
                    EncapsulatedEventAdaptor encapsulatedEventAdaptor2 = encapsulatedEventAdaptor;
                    synchronized (encapsulatedEventAdaptor2) {
                        encapsulatedEventAdaptor.addEncapsulatedEventListener(encapsulatedEventListener);
                        try {
                            encapsulatedEventAdaptor.addAdaptorToSource();
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                            throw new RuntimeException("Failed to register with source");
                        }
                    }
                    hashtable.put(classArray[n], encapsulatedEventAdaptor);
                } else {
                    hashtable.put(classArray[n], null);
                }
            }
            ++n;
        }
    }

    public synchronized void removeEncapsulatedEventListener(Object object, EncapsulatedEventListener encapsulatedEventListener, Class[] classArray) {
        if (object == null) {
            if (this.source == null) {
                throw new NullPointerException("Source");
            }
            object = this.source;
        }
        if (encapsulatedEventListener == null) {
            throw new NullPointerException("Listener");
        }
        if (classArray == null) {
            throw new NullPointerException("Interfaces");
        }
        Hashtable hashtable = (Hashtable)this.sources.get(object);
        if (hashtable == null) {
            throw new IllegalArgumentException("Source");
        }
        int n = 0;
        while (n < classArray.length) {
            EncapsulatedEventAdaptor encapsulatedEventAdaptor = (EncapsulatedEventAdaptor)hashtable.get(classArray[n]);
            if (encapsulatedEventAdaptor != null) {
                encapsulatedEventAdaptor.removeEncapsulatedEventListener(encapsulatedEventListener);
                try {
                    encapsulatedEventAdaptor.removeAdaptorFromSource();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                    throw new RuntimeException("Failed to register with source");
                }
                EncapsulatedEventAdaptor encapsulatedEventAdaptor2 = encapsulatedEventAdaptor;
                synchronized (encapsulatedEventAdaptor2) {
                    if (encapsulatedEventAdaptor.getEncapsulatedListenerCount() == 0) {
                        try {
                            encapsulatedEventAdaptor.setEventInformation(null);
                        }
                        catch (Exception exception) {
                            System.err.println("failed to unregister source");
                        }
                    }
                    hashtable.remove(classArray[n]);
                }
            }
            ++n;
        }
    }

    public void encapsulatedEvent(EncapsulatedEvent encapsulatedEvent) {
        Object object = encapsulatedEvent.getEventSource();
        EventObject eventObject = encapsulatedEvent.getEvent();
    }
}

