/*
 * Decompiled with CFR 0.152.
 */
package sun.beans.ole;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class OleOutputStream
extends ByteArrayOutputStream {
    private int extInterface;
    private Hashtable threadsInfo;

    private OleOutputStream(int n, int n2) {
        super(2048);
        this.extInterface = n;
        this.threadsInfo = new Hashtable();
        this.threadsInfo.put(Thread.currentThread().toString(), new Integer(n2));
    }

    public void flush() throws IOException {
        int n = this.attachThread();
        int n2 = this.write(this.extInterface, n, this.buf, 0, this.count);
        if (n2 != 0) {
            throw new IOException("IStream::write reported " + n2);
        }
    }

    public void close() throws IOException {
        Enumeration enumeration = this.threadsInfo.elements();
        while (enumeration.hasMoreElements()) {
            Integer n;
            try {
                n = (Integer)enumeration.nextElement();
            }
            catch (ClassCastException classCastException) {
                throw new Error(classCastException.toString());
            }
            this.detachThread(n);
        }
        super.close();
    }

    private int attachThread() {
        Integer n;
        String string = Thread.currentThread().toString();
        try {
            n = (Integer)this.threadsInfo.get(string);
        }
        catch (ClassCastException classCastException) {
            throw new Error(classCastException.toString());
        }
        if (n == null) {
            n = new Integer(this.attachThread(this.extInterface));
            this.threadsInfo.put(string, n);
        }
        return n;
    }

    private native int write(int var1, int var2, byte[] var3, int var4, int var5);

    private native int attachThread(int var1);

    private native void detachThread(int var1);
}

