/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.text;

import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.text.BlockFlow;
import org.eclipse.draw2d.text.FlowFigure;
import org.eclipse.draw2d.text.FlowFigureLayout;
import org.eclipse.draw2d.text.PageFlowLayout;

public class FlowPage
extends BlockFlow {
    private Dimension pageSize = new Dimension();
    private int recommendedWidth;
    private int[] pageSizeCacheKeys = new int[3];
    private Dimension[] pageSizeCacheValues = new Dimension[3];

    protected FlowFigureLayout createDefaultFlowLayout() {
        return new PageFlowLayout(this);
    }

    public Dimension getMinimumSize(int w, int h) {
        return this.getPreferredSize(w, h);
    }

    public void invalidate() {
        this.pageSizeCacheValues = new Dimension[3];
        super.invalidate();
    }

    public Dimension getPreferredSize(int width, int h) {
        if (width >= 0) {
            width = Math.max(0, width - this.getInsets().getWidth());
        }
        int i = 0;
        while (i < 3) {
            if (this.pageSizeCacheKeys[i] == width && this.pageSizeCacheValues[i] != null) {
                return this.pageSizeCacheValues[i];
            }
            ++i;
        }
        this.pageSizeCacheKeys[2] = this.pageSizeCacheKeys[1];
        this.pageSizeCacheKeys[1] = this.pageSizeCacheKeys[0];
        this.pageSizeCacheKeys[0] = width;
        this.pageSizeCacheValues[2] = this.pageSizeCacheValues[1];
        this.pageSizeCacheValues[1] = this.pageSizeCacheValues[0];
        int oldWidth = this.getRecommendedWidth();
        this.setRecommendedWidth(width);
        this.validate();
        this.pageSizeCacheValues[0] = this.pageSize.getExpanded(this.getInsets().getWidth(), this.getInsets().getHeight());
        if (width != oldWidth) {
            this.setRecommendedWidth(oldWidth);
            this.getUpdateManager().addInvalidFigure(this);
        }
        return this.pageSizeCacheValues[0];
    }

    int getRecommendedWidth() {
        return this.recommendedWidth;
    }

    public void postValidate() {
        Rectangle r = this.getBlockBox().toRectangle();
        this.pageSize.width = r.width;
        this.pageSize.height = r.height;
        List v = this.getChildren();
        int i = 0;
        while (i < v.size()) {
            ((FlowFigure)v.get(i)).postValidate();
            ++i;
        }
    }

    public void setBounds(Rectangle r) {
        if (this.getBounds().equals(r)) {
            return;
        }
        boolean invalidate = this.getBounds().width != r.width || this.getBounds().height != r.height;
        super.setBounds(r);
        int newWidth = r.width - this.getInsets().getWidth();
        if (invalidate || this.getRecommendedWidth() != newWidth) {
            this.setRecommendedWidth(newWidth);
            this.getUpdateManager().addInvalidFigure(this);
        }
    }

    private void setRecommendedWidth(int width) {
        if (this.recommendedWidth == width) {
            return;
        }
        this.recommendedWidth = width;
        super.invalidate();
    }

    public void validate() {
        if (this.isValid()) {
            return;
        }
        super.validate();
        this.postValidate();
    }
}

