/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d.internal;

public class Timer
implements Runnable {
    private Thread t;
    private Runnable run;
    private int initial;
    private int period;
    private boolean started;
    private boolean stopped;

    public void cancel() {
        this.stopped = true;
    }

    public Thread getThread() {
        if (this.t == null) {
            this.t = new Thread(this);
            this.t.setPriority(1);
            this.t.setDaemon(true);
        }
        return this.t;
    }

    protected Runnable getRunnable() {
        return this.run;
    }

    protected void preformRun() {
        if (this.getRunnable() != null) {
            this.getRunnable().run();
        }
    }

    public synchronized void run() {
        while (!this.stopped) {
            if (!this.started) {
                this.started = true;
                try {
                    this.wait(this.initial);
                }
                catch (InterruptedException interruptedException) {}
            } else {
                try {
                    this.wait(this.period);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.stopped) {
                return;
            }
            this.preformRun();
        }
    }

    public void scheduleRepeatedly(Runnable r, int initial, int delay) {
        this.run = r;
        this.initial = initial;
        this.period = delay;
        this.start();
    }

    protected void start() {
        this.getThread().start();
    }
}

