/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Map;
import org.eclipse.draw2d.AbstractLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class XYLayout
extends AbstractLayout {
    protected Map constraints = new HashMap();

    protected Dimension calculatePreferredSize(IFigure f, int wHint, int hHint) {
        Rectangle rect = new Rectangle();
        ListIterator children = f.getChildren().listIterator();
        while (children.hasNext()) {
            IFigure child = (IFigure)children.next();
            Rectangle r = (Rectangle)this.constraints.get(child);
            if (r == null) continue;
            if (r.width == -1 && r.height == -1) {
                r = r.getResized(child.getPreferredSize());
            }
            rect.union(r);
        }
        Dimension d = rect.getSize();
        Insets insets = f.getInsets();
        return new Dimension(d.width + insets.getWidth(), d.height + insets.getHeight()).union(this.getBorderPreferredSize(f));
    }

    public Object getConstraint(IFigure figure) {
        return (Rectangle)this.constraints.get(figure);
    }

    public Point getOrigin(IFigure parent) {
        return parent.getClientArea().getLocation();
    }

    public void layout(IFigure parent) {
        Iterator children = parent.getChildren().iterator();
        Point offset = this.getOrigin(parent);
        while (children.hasNext()) {
            IFigure f = (IFigure)children.next();
            Rectangle bounds = (Rectangle)this.getConstraint(f);
            if (bounds == null) continue;
            bounds = bounds.getTranslated(offset);
            if (bounds.width == -1 || bounds.height == -1) {
                Dimension preferredSize = f.getPreferredSize();
                bounds = bounds.getCopy();
                if (bounds.width == -1) {
                    bounds.width = preferredSize.width;
                }
                if (bounds.height == -1) {
                    bounds.height = preferredSize.height;
                }
            }
            f.setBounds(bounds);
        }
    }

    public void remove(IFigure figure) {
        super.remove(figure);
        this.constraints.remove(figure);
    }

    public void setConstraint(IFigure figure, Object newConstraint) {
        super.setConstraint(figure, newConstraint);
        if (newConstraint != null) {
            this.constraints.put(figure, newConstraint);
        }
    }
}

