/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw2d;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Image;

public class ImageFigure
extends Figure {
    private Image img;
    private Dimension size;
    private int alignment;

    public ImageFigure() {
        this.setAlignment(2);
    }

    public ImageFigure(Image image) {
        this();
        this.setImage(image);
    }

    public Image getImage() {
        return this.img;
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        Dimension size = new Dimension();
        if (this.getImage() != null) {
            org.eclipse.swt.graphics.Rectangle imgSize = this.getImage().getBounds();
            size.width = imgSize.width;
            size.height = imgSize.height;
        }
        return size;
    }

    protected void paintFigure(Graphics graphics) {
        int x;
        int y;
        Rectangle area = this.getClientArea();
        switch (this.alignment & 5) {
            case 1: {
                y = area.y;
                break;
            }
            case 4: {
                y = area.y + area.height - this.size.height;
                break;
            }
            default: {
                y = (area.height - this.size.height) / 2 + area.y;
            }
        }
        switch (this.alignment & 0x18) {
            case 16: {
                x = area.x;
                break;
            }
            case 8: {
                x = area.x + area.width - this.size.width;
                break;
            }
            default: {
                x = (area.width - this.size.width) / 2 + area.x;
            }
        }
        graphics.drawImage(this.getImage(), x, y);
    }

    public void setAlignment(int flag) {
        this.alignment = flag;
    }

    public void setImage(Image image) {
        this.img = image;
        this.size = new Rectangle(image.getBounds()).getSize();
        this.revalidate();
        this.repaint();
    }
}

