/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.xerces.impl.dv.DatatypeException;
import org.apache.xerces.impl.dv.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.InvalidDatatypeValueException;
import org.apache.xerces.impl.dv.ValidatedInfo;
import org.apache.xerces.impl.dv.XSAtomicSimpleType;
import org.apache.xerces.impl.dv.XSFacets;
import org.apache.xerces.impl.dv.XSListSimpleType;
import org.apache.xerces.impl.dv.XSSimpleType;
import org.apache.xerces.impl.dv.XSUnionSimpleType;
import org.apache.xerces.impl.dv.xs.AbstractDateTimeDV;
import org.apache.xerces.impl.dv.xs.AnySimpleDV;
import org.apache.xerces.impl.dv.xs.AnyURIDV;
import org.apache.xerces.impl.dv.xs.Base64BinaryDV;
import org.apache.xerces.impl.dv.xs.BooleanDV;
import org.apache.xerces.impl.dv.xs.DateDV;
import org.apache.xerces.impl.dv.xs.DateTimeDV;
import org.apache.xerces.impl.dv.xs.DayDV;
import org.apache.xerces.impl.dv.xs.DecimalDV;
import org.apache.xerces.impl.dv.xs.DoubleDV;
import org.apache.xerces.impl.dv.xs.DurationDV;
import org.apache.xerces.impl.dv.xs.EntityDV;
import org.apache.xerces.impl.dv.xs.FloatDV;
import org.apache.xerces.impl.dv.xs.HexBinaryDV;
import org.apache.xerces.impl.dv.xs.IDDV;
import org.apache.xerces.impl.dv.xs.IDREFDV;
import org.apache.xerces.impl.dv.xs.ListDV;
import org.apache.xerces.impl.dv.xs.MonthDV;
import org.apache.xerces.impl.dv.xs.MonthDayDV;
import org.apache.xerces.impl.dv.xs.QNameDV;
import org.apache.xerces.impl.dv.xs.StringDV;
import org.apache.xerces.impl.dv.xs.TimeDV;
import org.apache.xerces.impl.dv.xs.TypeValidator;
import org.apache.xerces.impl.dv.xs.UnionDV;
import org.apache.xerces.impl.dv.xs.YearDV;
import org.apache.xerces.impl.dv.xs.YearMonthDV;
import org.apache.xerces.impl.validation.ValidationContext;
import org.apache.xerces.impl.xpath.regex.RegularExpression;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.util.XMLChar;
import org.apache.xerces.xni.NamespaceContext;

class XSSimpleTypeDecl
implements XSAtomicSimpleType,
XSListSimpleType,
XSUnionSimpleType {
    static final short DV_STRING = 1;
    static final short DV_BOOLEAN = 2;
    static final short DV_DECIMAL = 3;
    static final short DV_FLOAT = 4;
    static final short DV_DOUBLE = 5;
    static final short DV_DURATION = 6;
    static final short DV_DATETIME = 7;
    static final short DV_TIME = 8;
    static final short DV_DATE = 9;
    static final short DV_GYEARMONTH = 10;
    static final short DV_GYEAR = 11;
    static final short DV_GMONTHDAY = 12;
    static final short DV_GDAY = 13;
    static final short DV_GMONTH = 14;
    static final short DV_HEXBINARY = 15;
    static final short DV_BASE64BINARY = 16;
    static final short DV_ANYURI = 17;
    static final short DV_QNAME = 18;
    static final short DV_NOTATION = 19;
    static final short DV_ANYSIMPLETYPE = 0;
    static final short DV_ID = 20;
    static final short DV_IDREF = 21;
    static final short DV_ENTITY = 22;
    static final short DV_LIST = 23;
    static final short DV_UNION = 24;
    static final TypeValidator[] fDVs = new TypeValidator[]{new AnySimpleDV(), new StringDV(), new BooleanDV(), new DecimalDV(), new FloatDV(), new DoubleDV(), new DurationDV(), new DateTimeDV(), new TimeDV(), new DateDV(), new YearMonthDV(), new YearDV(), new MonthDayDV(), new DayDV(), new MonthDV(), new HexBinaryDV(), new Base64BinaryDV(), new AnyURIDV(), new QNameDV(), new QNameDV(), new IDDV(), new IDREFDV(), new EntityDV(), new ListDV(), new UnionDV()};
    static final short SPECIAL_TOKEN_NONE = 0;
    static final short SPECIAL_TOKEN_NMTOKEN = 1;
    static final short SPECIAL_TOKEN_NAME = 2;
    static final short SPECIAL_TOKEN_NCNAME = 3;
    static final String[] SPECIAL_TOKEN_STRING = new String[]{"NONE", "NMTOKEN", "Name", "NCName"};
    static final String[] WS_FACET_STRING = new String[]{"preserve", "collapse", "replace"};
    private XSSimpleTypeDecl fItemType;
    private XSSimpleTypeDecl[] fMemberTypes;
    private String fTypeName;
    private String fTargetNamespace;
    private short fFinalSet = 0;
    private XSSimpleTypeDecl fBase;
    private short fVariety = (short)-1;
    private short fValidationDV = (short)-1;
    private short fFacetsDefined = 0;
    private short fFixedFacet = 0;
    private short fWhiteSpace = 0;
    private int fLength = -1;
    private int fMinLength = -1;
    private int fMaxLength = -1;
    private int fTotalDigits = -1;
    private int fFractionDigits = -1;
    private Vector fPattern;
    private Vector fEnumeration;
    private Object fMaxInclusive;
    private Object fMaxExclusive;
    private Object fMinExclusive;
    private Object fMinInclusive;
    private short fTokenType = 0;
    private short fOrdered;
    private short fCardinality;
    private boolean fBounded;
    private boolean fNumeric;
    private boolean fFacetsApplied;
    static final XSSimpleTypeDecl fAnySimpleType = new XSSimpleTypeDecl(null, "anySimpleType", 0, 1, false, 1, false, true);

    protected XSSimpleTypeDecl(XSSimpleTypeDecl xSSimpleTypeDecl, String string, short s, short s2, boolean bl, short s3, boolean bl2, boolean bl3) {
        this.fBase = xSSimpleTypeDecl;
        this.fTypeName = string;
        this.fTargetNamespace = "http://www.w3.org/2001/XMLSchema";
        this.fVariety = 1;
        this.fValidationDV = s;
        this.fFacetsDefined = (short)32;
        if (s == 1) {
            this.fWhiteSpace = 0;
        } else {
            this.fWhiteSpace = (short)2;
            this.fFixedFacet = (short)32;
        }
        this.fFacetsApplied = bl3;
    }

    protected XSSimpleTypeDecl(XSSimpleTypeDecl xSSimpleTypeDecl, String string, String string2, short s, boolean bl) {
        this.fBase = xSSimpleTypeDecl;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s;
        this.fVariety = this.fBase.fVariety;
        this.fValidationDV = this.fBase.fValidationDV;
        switch (this.fVariety) {
            case 1: {
                break;
            }
            case 2: {
                this.fItemType = this.fBase.fItemType;
                break;
            }
            case 3: {
                this.fMemberTypes = this.fBase.fMemberTypes;
            }
        }
        this.fLength = this.fBase.fLength;
        this.fMinLength = this.fBase.fMinLength;
        this.fMaxLength = this.fBase.fMaxLength;
        this.fPattern = this.fBase.fPattern;
        this.fEnumeration = this.fBase.fEnumeration;
        this.fWhiteSpace = this.fBase.fWhiteSpace;
        this.fMaxExclusive = this.fBase.fMaxExclusive;
        this.fMaxInclusive = this.fBase.fMaxInclusive;
        this.fMinExclusive = this.fBase.fMinExclusive;
        this.fMinInclusive = this.fBase.fMinInclusive;
        this.fTotalDigits = this.fBase.fTotalDigits;
        this.fFractionDigits = this.fBase.fFractionDigits;
        this.fTokenType = this.fBase.fTokenType;
        this.fFixedFacet = this.fBase.fFixedFacet;
        this.fFacetsDefined = this.fBase.fFacetsDefined;
        this.caclFundamentalFacets();
        this.fFacetsApplied = bl;
    }

    protected XSSimpleTypeDecl(String string, String string2, short s, XSSimpleTypeDecl xSSimpleTypeDecl, boolean bl) {
        this.fBase = fAnySimpleType;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s;
        this.fVariety = (short)2;
        this.fItemType = xSSimpleTypeDecl;
        this.fValidationDV = (short)23;
        this.fFacetsDefined = (short)32;
        this.fFixedFacet = (short)32;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        this.fFacetsApplied = bl;
    }

    protected XSSimpleTypeDecl(String string, String string2, short s, XSSimpleTypeDecl[] xSSimpleTypeDeclArray, boolean bl) {
        this.fBase = fAnySimpleType;
        this.fTypeName = string;
        this.fTargetNamespace = string2;
        this.fFinalSet = s;
        this.fVariety = (short)3;
        this.fMemberTypes = xSSimpleTypeDeclArray;
        this.fValidationDV = (short)24;
        this.fFacetsDefined = (short)32;
        this.fWhiteSpace = (short)2;
        this.caclFundamentalFacets();
        this.fFacetsApplied = bl;
    }

    public short getXSType() {
        return 2;
    }

    public String getTypeName() {
        return this.fTypeName;
    }

    public String getTargetNamespace() {
        return this.fTargetNamespace;
    }

    public short getFinalSet() {
        return this.fFinalSet;
    }

    public XSTypeDecl getBaseType() {
        return this.fBase;
    }

    public boolean isAnonymous() {
        return this.fTypeName == null;
    }

    public short getVariety() {
        return this.fValidationDV == 0 ? (short)0 : this.fVariety;
    }

    public short getDefinedFacets() {
        return this.fFacetsDefined;
    }

    public boolean isIDType() {
        return this.fValidationDV == 20;
    }

    public short getWhitespace() throws DatatypeException {
        if (this.fVariety == 3) {
            throw new DatatypeException("dt-whitespace", new Object[]{this.fTypeName});
        }
        return this.fWhiteSpace;
    }

    public short getPrimitiveKind() {
        if (this.fVariety == 1 && this.fValidationDV != 0) {
            if (this.fVariety == 20 || this.fVariety == 21 || this.fVariety == 22) {
                return 1;
            }
            return this.fValidationDV;
        }
        return 0;
    }

    public XSSimpleType getPrimitiveType() {
        if (this.fVariety == 1 && this.fValidationDV != 0) {
            XSSimpleTypeDecl xSSimpleTypeDecl = this;
            while (xSSimpleTypeDecl.fBase != fAnySimpleType) {
                xSSimpleTypeDecl = xSSimpleTypeDecl.fBase;
            }
            return xSSimpleTypeDecl;
        }
        return null;
    }

    public XSSimpleType getItemType() {
        if (this.fVariety == 2) {
            return this.fItemType;
        }
        return null;
    }

    public XSSimpleType[] getMemberTypes() {
        if (this.fVariety == 3) {
            return this.fMemberTypes;
        }
        return null;
    }

    public void applyFacets(XSFacets xSFacets, short s, short s2, ValidationContext validationContext) throws InvalidDatatypeFacetException {
        this.applyFacets(xSFacets, s, s2, (short)0, validationContext);
    }

    void applyFacets1(XSFacets xSFacets, short s, short s2) {
        try {
            this.applyFacets(xSFacets, s, s2, (short)0, null);
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            throw new RuntimeException("internal error");
        }
    }

    void applyFacets1(XSFacets xSFacets, short s, short s2, short s3) {
        try {
            this.applyFacets(xSFacets, s, s2, s3, null);
        }
        catch (InvalidDatatypeFacetException invalidDatatypeFacetException) {
            throw new RuntimeException("internal error");
        }
    }

    void applyFacets(XSFacets xSFacets, short s, short s2, short s3, ValidationContext validationContext) throws InvalidDatatypeFacetException {
        Serializable serializable;
        if (this.fFacetsApplied) {
            throw new RuntimeException("Facets already set on this object!  Cannot reset them.");
        }
        this.fFacetsApplied = true;
        ValidatedInfo validatedInfo = new ValidatedInfo();
        this.fFacetsDefined = 0;
        this.fFixedFacet = 0;
        int n = 0;
        short s4 = fDVs[this.fValidationDV].getAllowedFacets();
        if ((s & 1) != 0) {
            if ((s4 & 1) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"length"});
            } else {
                this.fLength = xSFacets.length;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
                if ((s2 & 1) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 1);
                }
            }
        }
        if ((s & 2) != 0) {
            if ((s4 & 2) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minLength"});
            } else {
                this.fMinLength = xSFacets.minLength;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
                if ((s2 & 2) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 2);
                }
            }
        }
        if ((s & 4) != 0) {
            if ((s4 & 4) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxLength"});
            } else {
                this.fMaxLength = xSFacets.maxLength;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
                if ((s2 & 4) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 4);
                }
            }
        }
        if ((s & 8) != 0) {
            if ((s4 & 8) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"pattern"});
            } else {
                serializable = null;
                try {
                    serializable = new RegularExpression(xSFacets.pattern, "X");
                }
                catch (Exception exception) {
                    this.reportError("InvalidRegex", new Object[]{xSFacets.pattern, exception.getLocalizedMessage()});
                }
                if (serializable != null) {
                    this.fPattern = new Vector();
                    this.fPattern.addElement(serializable);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
                    if ((s2 & 8) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 8);
                    }
                }
            }
        }
        if ((s & 0x10) != 0) {
            if ((s4 & 0x10) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"enumeration"});
            } else {
                this.fEnumeration = new Vector();
                serializable = xSFacets.enumeration;
                Vector vector = xSFacets.enumNSDecls;
                ValidationContextImpl validationContextImpl = new ValidationContextImpl(validationContext);
                int n2 = 0;
                while (n2 < ((Vector)serializable).size()) {
                    if (vector != null) {
                        validationContextImpl.setNSContext((NamespaceContext)vector.elementAt(n2));
                    }
                    try {
                        this.fEnumeration.addElement(this.fBase.validate((String)((Vector)serializable).elementAt(n2), validationContextImpl, validatedInfo));
                    }
                    catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                        this.reportError("FacetValueFromBase", new Object[]{((Vector)serializable).elementAt(n2), "enumeration"});
                    }
                    ++n2;
                }
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
                if ((s2 & 0x10) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x10);
                }
            }
        }
        if ((s & 0x20) != 0) {
            if ((s4 & 0x20) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"whiteSpace"});
            } else {
                this.fWhiteSpace = xSFacets.whiteSpace;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
                if ((s2 & 0x20) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x20);
                }
            }
        }
        if ((s & 0x40) != 0) {
            if ((s4 & 0x40) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxInclusive"});
            } else {
                try {
                    this.fMaxInclusive = this.getActualValue(xSFacets.maxInclusive, validationContext, validatedInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
                    if ((s2 & 0x40) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x40);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("FacetValueFromBase", new Object[]{xSFacets.maxInclusive, "maxInclusive"});
                }
            }
        }
        if ((s & 0x80) != 0) {
            if ((s4 & 0x80) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"maxExclusive"});
            } else {
                try {
                    this.fMaxExclusive = this.getActualValue(xSFacets.maxExclusive, validationContext, validatedInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
                    if ((s2 & 0x80) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x80);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("FacetValueFromBase", new Object[]{xSFacets.maxExclusive, "maxExclusive"});
                }
            }
        }
        if ((s & 0x100) != 0) {
            if ((s4 & 0x100) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minExclusive"});
            } else {
                try {
                    this.fMinExclusive = this.getActualValue(xSFacets.minExclusive, validationContext, validatedInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
                    if ((s2 & 0x100) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x100);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("FacetValueFromBase", new Object[]{xSFacets.minExclusive, "minExclusive"});
                }
            }
        }
        if ((s & 0x200) != 0) {
            if ((s4 & 0x200) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"minInclusive"});
            } else {
                try {
                    this.fMinInclusive = this.getActualValue(xSFacets.minInclusive, validationContext, validatedInfo);
                    this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
                    if ((s2 & 0x200) != 0) {
                        this.fFixedFacet = (short)(this.fFixedFacet | 0x200);
                    }
                }
                catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                    this.reportError("FacetValueFromBase", new Object[]{xSFacets.minInclusive, "minInclusive"});
                }
            }
        }
        if ((s & 0x400) != 0) {
            if ((s4 & 0x400) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"totalDigits"});
            } else {
                this.fTotalDigits = xSFacets.totalDigits;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
                if ((s2 & 0x400) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x400);
                }
            }
        }
        if ((s & 0x800) != 0) {
            if ((s4 & 0x800) == 0) {
                this.reportError("cos-applicable-facets", new Object[]{"fractionDigits"});
            } else {
                this.fFractionDigits = xSFacets.fractionDigits;
                this.fFacetsDefined = (short)(this.fFacetsDefined | 0x800);
                if ((s2 & 0x800) != 0) {
                    this.fFixedFacet = (short)(this.fFixedFacet | 0x800);
                }
            }
        }
        if (s3 != 0) {
            this.fTokenType = s3;
        }
        if (this.fFacetsDefined != 0) {
            if ((this.fFacetsDefined & 1) != 0 && ((this.fFacetsDefined & 2) != 0 || (this.fFacetsDefined & 4) != 0)) {
                this.reportError("length-minLength-maxLength", null);
            }
            if ((this.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0 && this.fMinLength > this.fMaxLength) {
                this.reportError("minLength-less-than-equal-to-maxLength", new Object[]{Integer.toString(this.fMinLength), Integer.toString(this.fMaxLength)});
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x40) != 0) {
                this.reportError("maxInclusive-maxExclusive", null);
            }
            if ((this.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x200) != 0) {
                this.reportError("minInclusive-minExclusive", null);
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x200) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxInclusive)) != -1 && n != 0) {
                this.reportError("minInclusive-less-than-equal-to-maxInclusive", new Object[]{this.getStringValue(this.fMinInclusive), this.getStringValue(this.fMaxInclusive)});
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x100) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxExclusive)) != -1 && n != 0) {
                this.reportError("minExclusive-less-than-equal-to-maxExclusive", new Object[]{this.getStringValue(this.fMinExclusive), this.getStringValue(this.fMaxExclusive)});
            }
            if ((this.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x100) != 0 && fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fMaxInclusive) != -1) {
                this.reportError("minExclusive-less-than-maxInclusive", new Object[]{this.getStringValue(this.fMinExclusive), this.getStringValue(this.fMaxInclusive)});
            }
            if ((this.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x200) != 0 && fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fMaxExclusive) != -1) {
                this.reportError("minInclusive-less-than-maxExclusive", new Object[]{this.getStringValue(this.fMinInclusive), this.getStringValue(this.fMaxExclusive)});
            }
            if ((this.fFacetsDefined & 0x800) != 0 && (this.fFacetsDefined & 0x400) != 0 && this.fFractionDigits > this.fTotalDigits) {
                this.reportError("fractionDigits-totalDigits", new Object[]{Integer.toString(this.fFractionDigits), Integer.toString(this.fTotalDigits)});
            }
            if ((this.fFacetsDefined & 1) != 0) {
                if ((this.fBase.fFacetsDefined & 4) != 0 || (this.fBase.fFacetsDefined & 2) != 0) {
                    this.reportError("length-minLength-maxLength", null);
                } else if ((this.fBase.fFacetsDefined & 1) != 0 && this.fLength != this.fBase.fLength) {
                    this.reportError("length-valid-restriction", new Object[]{Integer.toString(this.fLength), Integer.toString(this.fBase.fLength)});
                }
            }
            if ((this.fBase.fFacetsDefined & 1) != 0 && ((this.fFacetsDefined & 4) != 0 || (this.fFacetsDefined & 2) != 0)) {
                this.reportError("length-minLength-maxLength", null);
            }
            if ((this.fFacetsDefined & 2) != 0) {
                if ((this.fBase.fFacetsDefined & 4) != 0) {
                    if (this.fMinLength > this.fBase.fMaxLength) {
                        this.reportError("minLength-less-than-equal-to-maxLength", new Object[]{Integer.toString(this.fMinLength), Integer.toString(this.fBase.fMaxLength)});
                    }
                } else if ((this.fBase.fFacetsDefined & 2) != 0) {
                    if ((this.fBase.fFixedFacet & 2) != 0 && this.fMinLength != this.fBase.fMinLength) {
                        this.reportError("FixedFacetValue", new Object[]{"minLength", Integer.toString(this.fMinLength), Integer.toString(this.fBase.fMinLength)});
                    }
                    if (this.fMinLength < this.fBase.fMinLength) {
                        this.reportError("minLength-valid-restriction", new Object[]{Integer.toString(this.fMinLength), Integer.toString(this.fBase.fMinLength)});
                    }
                }
            }
            if ((this.fFacetsDefined & 4) != 0 && (this.fBase.fFacetsDefined & 2) != 0 && this.fMaxLength < this.fBase.fMinLength) {
                this.reportError("minLength-less-than-equal-to-maxLength", new Object[]{Integer.toString(this.fBase.fMinLength), Integer.toString(this.fMaxLength)});
            }
            if ((this.fFacetsDefined & 4) != 0 && (this.fBase.fFacetsDefined & 4) != 0) {
                if ((this.fBase.fFixedFacet & 4) != 0 && this.fMaxLength != this.fBase.fMaxLength) {
                    this.reportError("FixedFacetValue", new Object[]{"maxLength", Integer.toString(this.fMaxLength), Integer.toString(this.fBase.fMaxLength)});
                }
                if (this.fMaxLength > this.fBase.fMaxLength) {
                    this.reportError("maxLength-valid-restriction", new Object[]{Integer.toString(this.fMaxLength), Integer.toString(this.fBase.fMaxLength)});
                }
            }
            if ((this.fFacetsDefined & 0x40) != 0) {
                if ((this.fBase.fFacetsDefined & 0x40) != 0) {
                    n = fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMaxInclusive);
                    if ((this.fBase.fFixedFacet & 0x40) != 0 && n != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"maxInclusive", this.getStringValue(this.fMaxInclusive), this.getStringValue(this.fBase.fMaxInclusive)});
                    }
                    if (n != -1 && n != 0) {
                        this.reportError("maxInclusive-valid-restriction.1", new Object[]{this.getStringValue(this.fMaxInclusive), this.getStringValue(this.fBase.fMaxInclusive)});
                    }
                }
                if ((this.fBase.fFacetsDefined & 0x80) != 0 && fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMaxExclusive) != -1) {
                    this.reportError("maxInclusive-valid-restriction.1", new Object[]{this.getStringValue(this.fMaxInclusive), this.getStringValue(this.fBase.fMaxExclusive)});
                }
                if ((this.fBase.fFacetsDefined & 0x200) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMinInclusive)) != 1 && n != 0) {
                    this.reportError("maxInclusive-valid-restriction.1", new Object[]{this.getStringValue(this.fMaxInclusive), this.getStringValue(this.fBase.fMinInclusive)});
                }
                if ((this.fBase.fFacetsDefined & 0x100) != 0 && fDVs[this.fValidationDV].compare(this.fMaxInclusive, this.fBase.fMinExclusive) != 1) {
                    this.reportError("maxInclusive-valid-restriction.1", new Object[]{this.getStringValue(this.fMaxInclusive), this.getStringValue(this.fBase.fMinExclusive)});
                }
            }
            if ((this.fFacetsDefined & 0x80) != 0) {
                if ((this.fBase.fFacetsDefined & 0x80) != 0) {
                    n = fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMaxExclusive);
                    if ((this.fBase.fFixedFacet & 0x80) != 0 && n != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"maxExclusive", this.getStringValue(this.fMaxExclusive), this.getStringValue(this.fBase.fMaxExclusive)});
                    }
                    if (n != -1 && n != 0) {
                        this.reportError("maxExclusive-valid-restriction.1", new Object[]{this.getStringValue(this.fMaxExclusive), this.getStringValue(this.fBase.fMaxExclusive)});
                    }
                }
                if ((this.fBase.fFacetsDefined & 0x40) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMaxInclusive)) != -1 && n != 0) {
                    this.reportError("maxExclusive-valid-restriction.2", new Object[]{this.getStringValue(this.fMaxExclusive), this.getStringValue(this.fBase.fMaxInclusive)});
                }
                if ((this.fBase.fFacetsDefined & 0x100) != 0 && fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMinExclusive) != 1) {
                    this.reportError("maxExclusive-valid-restriction.3", new Object[]{this.getStringValue(this.fMaxExclusive), this.getStringValue(this.fBase.fMinExclusive)});
                }
                if ((this.fBase.fFacetsDefined & 0x200) != 0 && fDVs[this.fValidationDV].compare(this.fMaxExclusive, this.fBase.fMinInclusive) != 1) {
                    this.reportError("maxExclusive-valid-restriction.4", new Object[]{this.getStringValue(this.fMaxExclusive), this.getStringValue(this.fBase.fMinInclusive)});
                }
            }
            if ((this.fFacetsDefined & 0x100) != 0) {
                if ((this.fBase.fFacetsDefined & 0x100) != 0) {
                    n = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMinExclusive);
                    if ((this.fBase.fFixedFacet & 0x100) != 0 && n != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"minExclusive", this.getStringValue(this.fMinExclusive), this.getStringValue(this.fBase.fMinExclusive)});
                    }
                    if (n != 1 && n != 0) {
                        this.reportError("minExclusive-valid-restriction.1", new Object[]{this.getStringValue(this.fMinExclusive), this.getStringValue(this.fBase.fMinExclusive)});
                    }
                }
                if ((this.fBase.fFacetsDefined & 0x40) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMaxInclusive)) != -1 && n != 0) {
                    this.reportError("minExclusive-valid-restriction.2", new Object[]{this.getStringValue(this.fMinExclusive), this.getStringValue(this.fBase.fMaxInclusive)});
                }
                if ((this.fBase.fFacetsDefined & 0x200) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMinInclusive)) != 1 && n != 0) {
                    this.reportError("minExclusive-valid-restriction.3", new Object[]{this.getStringValue(this.fMinExclusive), this.getStringValue(this.fBase.fMinInclusive)});
                }
                if ((this.fBase.fFacetsDefined & 0x80) != 0 && fDVs[this.fValidationDV].compare(this.fMinExclusive, this.fBase.fMaxExclusive) != -1) {
                    this.reportError("minExclusive-valid-restriction.4", new Object[]{this.getStringValue(this.fMinExclusive), this.getStringValue(this.fBase.fMaxExclusive)});
                }
            }
            if ((this.fFacetsDefined & 0x200) != 0) {
                if ((this.fBase.fFacetsDefined & 0x200) != 0) {
                    n = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMinInclusive);
                    if ((this.fBase.fFixedFacet & 0x200) != 0 && n != 0) {
                        this.reportError("FixedFacetValue", new Object[]{"minInclusive", this.getStringValue(this.fMinInclusive), this.getStringValue(this.fBase.fMinInclusive)});
                    }
                    if (n != 1 && n != 0) {
                        this.reportError("minInclusive-valid-restriction.1", new Object[]{this.getStringValue(this.fMinInclusive), this.getStringValue(this.fBase.fMinInclusive)});
                    }
                }
                if ((this.fBase.fFacetsDefined & 0x40) != 0 && (n = fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMaxInclusive)) != -1 && n != 0) {
                    this.reportError("minInclusive-valid-restriction.2", new Object[]{this.getStringValue(this.fMinInclusive), this.getStringValue(this.fBase.fMaxInclusive)});
                }
                if ((this.fBase.fFacetsDefined & 0x100) != 0 && fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMinExclusive) != 1) {
                    this.reportError("minInclusive-valid-restriction.3", new Object[]{this.getStringValue(this.fMinInclusive), this.getStringValue(this.fBase.fMinExclusive)});
                }
                if ((this.fBase.fFacetsDefined & 0x80) != 0 && fDVs[this.fValidationDV].compare(this.fMinInclusive, this.fBase.fMaxExclusive) != -1) {
                    this.reportError("minInclusive-valid-restriction.4", new Object[]{this.getStringValue(this.fMinInclusive), this.getStringValue(this.fBase.fMaxExclusive)});
                }
            }
            if ((this.fFacetsDefined & 0x400) != 0 && (this.fBase.fFacetsDefined & 0x400) != 0) {
                if ((this.fBase.fFixedFacet & 0x400) != 0 && this.fTotalDigits != this.fBase.fTotalDigits) {
                    this.reportError("FixedFacetValue", new Object[]{"totalDigits", Integer.toString(this.fTotalDigits), Integer.toString(this.fBase.fTotalDigits)});
                }
                if (this.fTotalDigits > this.fBase.fTotalDigits) {
                    this.reportError("totalDigits-valid-restriction", new Object[]{Integer.toString(this.fTotalDigits), Integer.toString(this.fBase.fTotalDigits)});
                }
            }
            if ((this.fFacetsDefined & 0x800) != 0 && (this.fBase.fFacetsDefined & 0x800) != 0 && (this.fBase.fFixedFacet & 0x800) != 0 && this.fFractionDigits != this.fBase.fFractionDigits) {
                this.reportError("FixedFacetValue", new Object[]{"fractionDigits", Integer.toString(this.fFractionDigits), Integer.toString(this.fBase.fFractionDigits)});
            }
            if ((this.fFacetsDefined & 0x20) != 0 && (this.fBase.fFacetsDefined & 0x20) != 0) {
                if ((this.fBase.fFixedFacet & 0x20) != 0 && this.fWhiteSpace != this.fBase.fWhiteSpace) {
                    this.reportError("FixedFacetValue", new Object[]{"whiteSpace", this.whiteSpaceValue(this.fWhiteSpace), this.whiteSpaceValue(this.fBase.fWhiteSpace)});
                }
                if ((this.fWhiteSpace == 0 || this.fWhiteSpace == 1) && this.fBase.fWhiteSpace == 2) {
                    this.reportError("whiteSpace-valid-restriction.1", null);
                }
                if (this.fWhiteSpace == 0 && this.fBase.fWhiteSpace == 1) {
                    this.reportError("whiteSpace-valid-restriction.2", null);
                }
            }
        }
        if ((this.fFacetsDefined & 1) == 0 && (this.fBase.fFacetsDefined & 1) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 1);
            this.fLength = this.fBase.fLength;
        }
        if ((this.fFacetsDefined & 2) == 0 && (this.fBase.fFacetsDefined & 2) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 2);
            this.fMinLength = this.fBase.fMinLength;
        }
        if ((this.fFacetsDefined & 4) == 0 && (this.fBase.fFacetsDefined & 4) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 4);
            this.fMaxLength = this.fBase.fMaxLength;
        }
        if ((this.fBase.fFacetsDefined & 8) != 0) {
            if ((this.fFacetsDefined & 8) == 0) {
                this.fPattern = new Vector();
                this.fFacetsDefined = (short)(this.fFacetsDefined | 8);
            }
            int n3 = this.fBase.fPattern.size() - 1;
            while (n3 >= 0) {
                this.fPattern.addElement(this.fBase.fPattern.elementAt(n3));
                --n3;
            }
        }
        if ((this.fFacetsDefined & 0x20) == 0 && (this.fBase.fFacetsDefined & 0x20) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x20);
            this.fWhiteSpace = this.fBase.fWhiteSpace;
        }
        if ((this.fFacetsDefined & 0x10) == 0 && (this.fBase.fFacetsDefined & 0x10) != 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x10);
            this.fEnumeration = this.fBase.fEnumeration;
        }
        if ((this.fBase.fFacetsDefined & 0x80) != 0 && (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x40) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x80);
            this.fMaxExclusive = this.fBase.fMaxExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x40) != 0 && (this.fFacetsDefined & 0x80) == 0 && (this.fFacetsDefined & 0x40) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x40);
            this.fMaxInclusive = this.fBase.fMaxInclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x100) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x200) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x100);
            this.fMinExclusive = this.fBase.fMinExclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x200) != 0 && (this.fFacetsDefined & 0x100) == 0 && (this.fFacetsDefined & 0x200) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x200);
            this.fMinInclusive = this.fBase.fMinInclusive;
        }
        if ((this.fBase.fFacetsDefined & 0x400) != 0 && (this.fFacetsDefined & 0x400) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x400);
            this.fTotalDigits = this.fBase.fTotalDigits;
        }
        if ((this.fBase.fFacetsDefined & 0x800) != 0 && (this.fFacetsDefined & 0x800) == 0) {
            this.fFacetsDefined = (short)(this.fFacetsDefined | 0x800);
            this.fFractionDigits = this.fBase.fFractionDigits;
        }
        if (this.fTokenType == 0 && this.fBase.fTokenType != 0) {
            this.fTokenType = this.fBase.fTokenType;
        }
        this.fFixedFacet = (short)(this.fFixedFacet | this.fBase.fFixedFacet);
        this.caclFundamentalFacets();
    }

    public Object validate(String string, ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (validatedInfo == null) {
            validatedInfo = new ValidatedInfo();
        }
        Object object = this.getActualValue(string, validationContext, validatedInfo);
        this.validate(validationContext, validatedInfo);
        return object;
    }

    public void validate(ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (validationContext.needFacetChecking() && this.fFacetsDefined != 0 && this.fFacetsDefined != 32) {
            this.checkFacets(validatedInfo);
        }
        if (validationContext.needExtraChecking()) {
            this.checkExtraRules(validationContext, validatedInfo);
        }
    }

    private void checkFacets(ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        int n;
        Object object = validatedInfo.actualValue;
        String string = validatedInfo.normalizedValue;
        int n2 = fDVs[this.fValidationDV].getDataLength(object);
        if ((this.fFacetsDefined & 4) != 0 && n2 > this.fMaxLength) {
            throw new InvalidDatatypeValueException("cvc-maxLength-valid", new Object[]{string, Integer.toString(n2), Integer.toString(this.fMaxLength)});
        }
        if ((this.fFacetsDefined & 2) != 0 && n2 < this.fMinLength) {
            throw new InvalidDatatypeValueException("cvc-minLength-valid", new Object[]{string, Integer.toString(n2), Integer.toString(this.fMinLength)});
        }
        if ((this.fFacetsDefined & 1) != 0 && n2 != this.fLength) {
            throw new InvalidDatatypeValueException("cvc-length-valid", new Object[]{string, Integer.toString(n2), Integer.toString(this.fLength)});
        }
        if ((this.fFacetsDefined & 0x10) != 0) {
            n = 0;
            int n3 = 0;
            while (n3 < this.fEnumeration.size()) {
                if (this.isEqual(object, this.fEnumeration.elementAt(n3))) {
                    n = 1;
                    break;
                }
                ++n3;
            }
            if (n == 0) {
                throw new InvalidDatatypeValueException("cvc-enumeration-valid", new Object[]{string, this.fEnumeration.toString()});
            }
        }
        if ((this.fFacetsDefined & 0x800) != 0 && (n = fDVs[this.fValidationDV].getFractionDigits(object)) > this.fFractionDigits) {
            throw new InvalidDatatypeValueException("cvc-fractionDigits-valid", new Object[]{string, Integer.toString(n), Integer.toString(this.fFractionDigits)});
        }
        if ((this.fFacetsDefined & 0x400) != 0 && (n = fDVs[this.fValidationDV].getTotalDigits(object)) > this.fTotalDigits) {
            throw new InvalidDatatypeValueException("cvc-totalDigits-valid", new Object[]{string, Integer.toString(n), Integer.toString(this.fTotalDigits)});
        }
        if ((this.fFacetsDefined & 0x40) != 0 && (n = fDVs[this.fValidationDV].compare(object, this.fMaxInclusive)) != -1 && n != 0) {
            throw new InvalidDatatypeValueException("cvc-maxInclusive-valid", new Object[]{string, this.fMaxInclusive});
        }
        if ((this.fFacetsDefined & 0x80) != 0 && (n = fDVs[this.fValidationDV].compare(object, this.fMaxExclusive)) != -1) {
            throw new InvalidDatatypeValueException("cvc-maxExclusive-valid", new Object[]{string, this.fMaxExclusive});
        }
        if ((this.fFacetsDefined & 0x200) != 0 && (n = fDVs[this.fValidationDV].compare(object, this.fMinInclusive)) != 1 && n != 0) {
            throw new InvalidDatatypeValueException("cvc-minInclusive-valid", new Object[]{string, this.fMinInclusive});
        }
        if ((this.fFacetsDefined & 0x100) != 0 && (n = fDVs[this.fValidationDV].compare(object, this.fMinExclusive)) != 1) {
            throw new InvalidDatatypeValueException("cvc-minExclusive-valid", new Object[]{string, this.fMinExclusive});
        }
    }

    private void checkExtraRules(ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        Object object = validatedInfo.actualValue;
        if (this.fVariety == 1) {
            fDVs[this.fValidationDV].checkExtraRules(object, validationContext);
        } else if (this.fVariety == 2) {
            Object[] objectArray = (Object[])object;
            if (this.fItemType.fVariety == 3) {
                XSSimpleTypeDecl[] xSSimpleTypeDeclArray = (XSSimpleTypeDecl[])validatedInfo.memberTypes;
                XSSimpleType xSSimpleType = validatedInfo.memberType;
                int n = objectArray.length - 1;
                while (n >= 0) {
                    validatedInfo.actualValue = objectArray[n];
                    validatedInfo.memberType = xSSimpleTypeDeclArray[n];
                    this.fItemType.checkExtraRules(validationContext, validatedInfo);
                    --n;
                }
                validatedInfo.memberType = xSSimpleType;
            } else {
                int n = objectArray.length - 1;
                while (n >= 0) {
                    validatedInfo.actualValue = objectArray[n];
                    this.fItemType.checkExtraRules(validationContext, validatedInfo);
                    --n;
                }
            }
            validatedInfo.actualValue = objectArray;
        } else {
            ((XSSimpleTypeDecl)validatedInfo.memberType).checkExtraRules(validationContext, validatedInfo);
        }
    }

    private Object getActualValue(String string, ValidationContext validationContext, ValidatedInfo validatedInfo) throws InvalidDatatypeValueException {
        if (this.fVariety == 1) {
            Object object;
            String string2 = validationContext == null || validationContext.needToNormalize() ? XSSimpleTypeDecl.normalize(string, this.fWhiteSpace) : string;
            if (this.fTokenType != 0) {
                boolean bl = false;
                if (this.fTokenType == 1) {
                    bl = !XMLChar.isValidNmtoken(string2);
                } else if (this.fTokenType == 2) {
                    bl = !XMLChar.isValidName(string2);
                } else if (this.fTokenType == 3) {
                    boolean bl2 = bl = !XMLChar.isValidNCName(string2);
                }
                if (bl) {
                    throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.1", new Object[]{string2, SPECIAL_TOKEN_STRING[this.fTokenType]});
                }
            }
            if ((this.fFacetsDefined & 8) != 0) {
                int n = this.fPattern.size() - 1;
                while (n >= 0) {
                    RegularExpression regularExpression = (RegularExpression)this.fPattern.elementAt(n);
                    if (!regularExpression.matches(string2)) {
                        throw new InvalidDatatypeValueException("cvc-pattern-valid", new Object[]{string, regularExpression});
                    }
                    --n;
                }
            }
            validatedInfo.actualValue = object = fDVs[this.fValidationDV].getActualValue(string2, validationContext);
            validatedInfo.normalizedValue = string2;
            return object;
        }
        if (this.fVariety == 2) {
            String string3 = validationContext == null || validationContext.needToNormalize() ? XSSimpleTypeDecl.normalize(string, this.fWhiteSpace) : string;
            StringTokenizer stringTokenizer = new StringTokenizer(string3);
            int n = stringTokenizer.countTokens();
            Object[] objectArray = new Object[n];
            XSSimpleTypeDecl[] xSSimpleTypeDeclArray = new XSSimpleTypeDecl[n];
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = this.fItemType.getActualValue(stringTokenizer.nextToken(), validationContext, validatedInfo);
                if (validationContext.needFacetChecking() && this.fItemType.fFacetsDefined != 0 && this.fItemType.fFacetsDefined != 32) {
                    this.fItemType.checkFacets(validatedInfo);
                }
                xSSimpleTypeDeclArray[n2] = (XSSimpleTypeDecl)validatedInfo.memberType;
                ++n2;
            }
            validatedInfo.actualValue = objectArray;
            validatedInfo.normalizedValue = string3;
            validatedInfo.memberTypes = xSSimpleTypeDeclArray;
            return objectArray;
        }
        int n = 0;
        while (n < this.fMemberTypes.length) {
            try {
                Object object = this.fMemberTypes[n].getActualValue(string, validationContext, validatedInfo);
                if (validationContext.needFacetChecking() && this.fMemberTypes[n].fFacetsDefined != 0 && this.fMemberTypes[n].fFacetsDefined != 32) {
                    this.fMemberTypes[n].checkFacets(validatedInfo);
                }
                validatedInfo.memberType = this.fMemberTypes[n];
                return object;
            }
            catch (InvalidDatatypeValueException invalidDatatypeValueException) {
                ++n;
            }
        }
        throw new InvalidDatatypeValueException("cvc-datatype-valid.1.2.2", new Object[]{string, this.fTypeName});
    }

    public boolean isEqual(Object object, Object object2) {
        if (this.fVariety == 1) {
            return fDVs[this.fValidationDV].isEqual(object, object2);
        }
        if (this.fVariety == 2) {
            if (!(object instanceof Object[]) || !(object2 instanceof Object[])) {
                return false;
            }
            Object[] objectArray = (Object[])object;
            int n = objectArray.length;
            Object[] objectArray2 = (Object[])object2;
            if (n != objectArray2.length) {
                return false;
            }
            int n2 = 0;
            while (n2 < n) {
                if (!this.fItemType.isEqual(objectArray[n2], objectArray2[n2])) {
                    return false;
                }
                ++n2;
            }
            return true;
        }
        if (this.fVariety == 3) {
            int n = this.fMemberTypes.length - 1;
            while (n >= 0) {
                if (this.fMemberTypes[n].isEqual(object, object2)) {
                    return true;
                }
                --n;
            }
            return false;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public static String normalize(String var0, short var1_1) {
        block8: {
            block7: {
                v0 = var2_2 = var0 == null ? 0 : var0.length();
                if (var2_2 == 0 || var1_1 == 0) {
                    return var0;
                }
                var3_3 = new StringBuffer();
                if (var1_1 != 1) break block7;
                var5_4 = 0;
                while (var5_4 < var2_2) {
                    var4_6 = var0.charAt(var5_4);
                    if (var4_6 != '\t' && var4_6 != '\n' && var4_6 != '\r') {
                        var3_3.append(var4_6);
                    } else {
                        var3_3.append(' ');
                    }
                    ++var5_4;
                }
                break block8;
            }
            var6_8 = true;
            var5_5 = 0;
            while (var5_5 < var2_2) {
                block9: {
                    var4_7 = var0.charAt(var5_5);
                    if (var4_7 == '\t' || var4_7 == '\n' || var4_7 == '\r' || var4_7 == ' ') ** GOTO lbl30
                    var3_3.append(var4_7);
                    var6_8 = false;
                    break block9;
                    while ((var4_7 = var0.charAt(var5_5 + 1)) == '\t' || var4_7 == '\n' || var4_7 == '\r' || var4_7 == ' ') {
                        ++var5_5;
lbl30:
                        // 2 sources

                        if (var5_5 < var2_2 - 1) continue;
                    }
                    if (var5_5 < var2_2 - 1 && !var6_8) {
                        var3_3.append(' ');
                    }
                }
                ++var5_5;
            }
        }
        return var3_3.toString();
    }

    void reportError(String string, Object[] objectArray) throws InvalidDatatypeFacetException {
        throw new InvalidDatatypeFacetException(string, objectArray);
    }

    private String whiteSpaceValue(short s) {
        return WS_FACET_STRING[s];
    }

    public String getStringValue(Object object) {
        if (object != null) {
            if (fDVs[this.fValidationDV] instanceof AbstractDateTimeDV) {
                return ((AbstractDateTimeDV)fDVs[this.fValidationDV]).dateToString((int[])object);
            }
            return object.toString();
        }
        return null;
    }

    public short getOrderedFacet() {
        return this.fOrdered;
    }

    public boolean isBounded() {
        return this.fBounded;
    }

    public short getCardinalityFacet() {
        return this.fCardinality;
    }

    public boolean isNumeric() {
        return this.fNumeric;
    }

    private void caclFundamentalFacets() {
        this.setOrdered();
        this.setNumeric();
        this.setBounded();
        this.setCardinality();
    }

    private void setOrdered() {
        if (this.fVariety == 1) {
            this.fOrdered = this.fBase.fOrdered;
        } else if (this.fVariety == 2) {
            this.fOrdered = 1;
        } else if (this.fVariety == 3) {
            int n = this.fMemberTypes.length;
            if (n == 0) {
                this.fOrdered = (short)2;
                return;
            }
            short s = this.getPrimitiveDV(this.fMemberTypes[0].fValidationDV);
            boolean bl = s != 0;
            boolean bl2 = this.fMemberTypes[0].fOrdered == 1;
            int n2 = 1;
            while (n2 < this.fMemberTypes.length && (bl || bl2)) {
                if (bl) {
                    boolean bl3 = bl = s == this.getPrimitiveDV(this.fMemberTypes[n2].fValidationDV);
                }
                if (bl2) {
                    bl2 = this.fMemberTypes[n2].fOrdered == 1;
                }
                ++n2;
            }
            this.fOrdered = bl ? this.fMemberTypes[0].fOrdered : (bl2 ? (short)1 : (short)2);
        }
    }

    private void setNumeric() {
        if (this.fVariety == 1) {
            this.fNumeric = this.fBase.fNumeric;
        } else if (this.fVariety == 2) {
            this.fNumeric = false;
        } else if (this.fVariety == 3) {
            XSSimpleType[] xSSimpleTypeArray = this.getMemberTypes();
            int n = 0;
            while (n < xSSimpleTypeArray.length) {
                if (!xSSimpleTypeArray[n].isNumeric()) {
                    this.fNumeric = false;
                    return;
                }
                ++n;
            }
            this.fNumeric = true;
        }
    }

    private void setBounded() {
        if (this.fVariety == 1) {
            this.fBounded = !((this.fFacetsDefined & 0x200) == 0 && (this.fFacetsDefined & 0x100) == 0 || (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x80) == 0);
        } else if (this.fVariety == 2) {
            this.fBounded = (this.fFacetsDefined & 1) != 0 || (this.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0;
        } else if (this.fVariety == 3) {
            XSSimpleTypeDecl[] xSSimpleTypeDeclArray = this.fMemberTypes;
            short s = 0;
            if (xSSimpleTypeDeclArray.length > 0) {
                s = this.getPrimitiveDV(xSSimpleTypeDeclArray[0].fValidationDV);
            }
            int n = 0;
            while (n < xSSimpleTypeDeclArray.length) {
                if (!xSSimpleTypeDeclArray[n].isBounded() || s != this.getPrimitiveDV(xSSimpleTypeDeclArray[n].fValidationDV)) {
                    this.fBounded = false;
                    return;
                }
                ++n;
            }
            this.fBounded = true;
        }
    }

    private boolean specialCardinalityCheck() {
        return this.fBase.fValidationDV == 9 || this.fBase.fValidationDV == 10 || this.fBase.fValidationDV == 11 || this.fBase.fValidationDV == 12 || this.fBase.fValidationDV == 13 || this.fBase.fValidationDV == 14;
    }

    private void setCardinality() {
        if (this.fVariety == 1) {
            this.fCardinality = this.fBase.fCardinality == 1 ? (short)1 : ((this.fFacetsDefined & 1) != 0 || (this.fFacetsDefined & 4) != 0 || (this.fFacetsDefined & 0x400) != 0 ? (short)1 : (!((this.fFacetsDefined & 0x200) == 0 && (this.fFacetsDefined & 0x100) == 0 || (this.fFacetsDefined & 0x40) == 0 && (this.fFacetsDefined & 0x80) == 0) ? ((this.fFacetsDefined & 0x800) != 0 || this.specialCardinalityCheck() ? (short)1 : (short)2) : (short)2));
        } else if (this.fVariety == 2) {
            this.fCardinality = (this.fFacetsDefined & 1) != 0 || (this.fFacetsDefined & 2) != 0 && (this.fFacetsDefined & 4) != 0 ? (short)1 : (short)2;
        } else if (this.fVariety == 3) {
            XSSimpleType[] xSSimpleTypeArray = this.getMemberTypes();
            int n = 0;
            while (n < xSSimpleTypeArray.length) {
                if (xSSimpleTypeArray[n].getCardinalityFacet() != 1) {
                    this.fCardinality = (short)2;
                    return;
                }
                ++n;
            }
            this.fCardinality = 1;
        }
    }

    private short getPrimitiveDV(short s) {
        if (s == 20 || s == 21 || s == 22) {
            return 1;
        }
        return s;
    }

    class ValidationContextImpl
    implements ValidationContext {
        ValidationContext fExternal;
        NamespaceContext fNSContext;

        ValidationContextImpl(ValidationContext validationContext) {
            this.fExternal = validationContext;
        }

        void setNSContext(NamespaceContext namespaceContext) {
            this.fNSContext = namespaceContext;
        }

        public boolean needFacetChecking() {
            return this.fExternal.needFacetChecking();
        }

        public boolean needExtraChecking() {
            return this.fExternal.needExtraChecking();
        }

        public boolean needToNormalize() {
            return this.fExternal.needToNormalize();
        }

        public boolean isEntityDeclared(String string) {
            return this.fExternal.isEntityDeclared(string);
        }

        public boolean isEntityUnparsed(String string) {
            return this.fExternal.isEntityUnparsed(string);
        }

        public boolean isIdDeclared(String string) {
            return this.fExternal.isIdDeclared(string);
        }

        public void addId(String string) {
            this.fExternal.addId(string);
        }

        public void addIdRef(String string) {
            this.fExternal.addIdRef(string);
        }

        public String getSymbol(String string) {
            return this.fExternal.getSymbol(string);
        }

        public String getURI(String string) {
            if (this.fNSContext == null) {
                return this.fExternal.getURI(string);
            }
            return this.fNSContext.getURI(string);
        }
    }
}

