/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import java.io.InputStream;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import latte.InternalLogicException;
import latte.Latte;
import latte.LatteData;
import latte.action.AbstractLatteAction;
import latte.action.AllAction;
import latte.di.DIPackage;
import latte.di.Diagram;
import latte.util.DebugUtil;
import latte.util.GuiUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TraverseEvent;
import org.eclipse.swt.events.TraverseListener;
import org.eclipse.swt.events.TreeEvent;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Classifier;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.UML2Package;

/**
 * Cc[
 * 
 * @version $Id: LVTree.java,v 1.6 2004/10/02 04:27:58 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class LVTree extends Composite implements Adapter{
    /** IꂽTreeItem */
    private TreeItem selectedItem_ = null;

    /** c[ */
    private Tree tree_ = null;
    /** f[g */
    private TreeItem rootModelTreeItem_ = null;
    /** _CAO[g */
    private TreeItem rootDiagTreeItem_ = null;
    
    /** \[g[h */
    private boolean sort_ = false;
    /** fύXʒm@LE */
    private boolean modelNotification_ = true;
    
    /** GfB^쐬 */
    private TreeEditor treeEditor_ = null;
    /** ACeGfB^ */
    private ItemEditor itemEditor_ = null;
    /** ef[^ */
    public static final String LATTE_DATA = "LATTE_DATA";
    
    /** 摜 */
    private Image ATTRIBASSOC_IMAGE = null;
    
    /** IXi */
    private LVTreeSelectionListener selectionListener = new LVTreeSelectionListener();
    /** c[Xi */
    private LVTreeListener treeListener = new LVTreeListener();
    /** L[Xi */
    private LVKeyListener keyListener = new LVKeyListener();

    /**
     * RXgN^
     */
    LVTree(Composite parent) {
        super(parent, SWT.NONE);
        // 摜
        ATTRIBASSOC_IMAGE = createImage("images/attribassociation.gif");
                
        // CAEgݒ
        GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        setLayout(layout);
        setLayoutData(new GridData(GridData.FILL_BOTH));
        
        // c[o[
        ToolBar toolbar = new ToolBar(this, SWT.FLAT);
        GuiUtil.createToolbarItem(toolbar, SWT.CHECK, new SortAction("\[g[h", "images/sort.gif"), sort_);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, new UpAction("", "images/up.gif"));
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, new DownAction("", "images/down.gif"));

        // RXgN^ďo
        tree_ = new Tree(this, SWT.NULL);
        GridLayout layout2 = new GridLayout();
        layout2.horizontalSpacing = 0;
        layout2.verticalSpacing = 1;
        layout2.marginHeight = 0;
        layout2.marginWidth = 0;
        tree_.setLayout(layout2);
        tree_.setLayoutData(new GridData(GridData.FILL_BOTH));
                
        // GfB^쐬
        treeEditor_ = new TreeEditor(tree_);
        
        // hbO\[XƂėL
        new DragSourceEnabler(this);
        // |bvAbvj[쐬
        createTreePopupMenu();
        
        // XiL
        enableUIListener(true);
    }
    
    
    /**
     * c[̏
     *
     */
    public void init() {
        // c[S폜
        tree_.removeAll();
                
        // LatteData擾       
        LatteData latteData = Latte.getLatteData();

        // f[g쐬
        Model model = latteData.getModel();
        rootModelTreeItem_ = new TreeItem(tree_, SWT.NULL);
        rootModelTreeItem_.setText(model.getName());
        rootModelTreeItem_.setData(LVTree.LATTE_DATA, model);
        rootModelTreeItem_.setImage(AllAction.ADD_PACKAGE.getImage());
        
        // _CAO[g쐬
        Diagram diagram = latteData.getDiagrams();
        rootDiagTreeItem_ = new TreeItem(tree_, SWT.NULL);
        rootDiagTreeItem_.setText(diagram.getName());
        rootDiagTreeItem_.setData(LVTree.LATTE_DATA, diagram);
        rootDiagTreeItem_.setImage(AllAction.ADD_PACKAGE.getImage());
        
        // Ԑݒ
        initState();
    }
    
    /**
     * fύXʒmLɂ
     *
     */
    public void enableModelNotification(boolean enable) {
        modelNotification_ = enable;
    }
    
    /**
     * ύXʒm
     * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
     */
    public void notifyChanged(Notification notification) {
        if (Latte.TRACE_EVENT) {
            System.out.print(DebugUtil.getEventId(this, notification) + " ");
            System.out.print("LVTree notifyChanged:");
        }

        if (!modelNotification_) {
            if (Latte.TRACE_EVENT) {
                System.out.println("ʒm");
            }
            return;
        }
        if (Latte.TRACE_EVENT) {
            System.out.println(notification);
        }
        
        // 
        EObject notifier = (EObject)notification.getNotifier();
        Object newValue = notification.getNewValue();
        Object oldValue = notification.getOldValue();
        Object feature = notification.getFeature();
        String name = (feature instanceof EAttribute) ? ((EAttribute)feature).getName() : null;
        boolean wasSet = notification.wasSet();
//        Object[] objs = null;

        // Cxg^Cvŕ
        
        switch (notification.getEventType()) {
        // ǉ
        case Notification.ADD:
            doEventAdd(notifier, newValue);
            break;

        // ݒ    
        case Notification.SET:
            doEventSet(notifier, feature, newValue, name, wasSet);
            break;

        // 폜
        case Notification.REMOVE:
            TreeItem removeTreeItem = null;
            switch (ModelUtil.getClassifierID(notifier)) {
            case UML2Package.MODEL:            // 02
            case UML2Package.PACKAGE:          // 06
            case UML2Package.CLASS:            // 10
            case UML2Package.INTERFACE:        // 17
                switch (ModelUtil.getClassifierID(oldValue)) {
                case UML2Package.PACKAGE:
                case UML2Package.CLASS:
                case UML2Package.INTERFACE:
                case UML2Package.PROPERTY:
                case UML2Package.OPERATION:
                    removeTreeItem = lookupTreeItem((EObject)oldValue);
                    removeTreeItem.dispose();
                    break;
                
                default:
                    break;
                }
                break;
           
            case DIPackage.DIAGRAM:            // 53
                if (ModelUtil.getClassifierID(oldValue) == DIPackage.DIAGRAM) {
                    removeTreeItem = lookupTreeItem((EObject)oldValue);
                    removeTreeItem.dispose();
                }
                break;

            default:
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVTreeŏȂCxgȂ̂Ŗ߂");
                }
                break;
            }
            break;

        // Ȃ
        case Notification.REMOVING_ADAPTER:// A_v^폜
        case Notification.CREATE:          // ֘A쐬
            if (Latte.TRACE_EVENT) {
                System.out.println("LVTreeŏȂCxgȂ̂Ŗ߂");
            }
            break;
            
        default:
            throw new InternalLogicException("T|[g̕ύXʒm");
        }
    }
    
    /**
     * 
     */
    public TreeItem lookupTreeItem(EObject element) {
        TreeItem treeItem = null;
        
        // rootModelTreeItemmF
        if (rootModelTreeItem_.getData(LVTree.LATTE_DATA) == element) {
            return rootModelTreeItem_;
        }
        // rootDiagTreeItemmF
        if (rootDiagTreeItem_.getData(LVTree.LATTE_DATA) == element) {
            return rootDiagTreeItem_;
        }

        // rootModelTreeItemċAIɌ
        treeItem = lookupTreeItemRecursive(rootModelTreeItem_.getItems(), element);
        if (treeItem != null) {
            return treeItem;
        }
        // rootDiagTreeItemċAIɌ
        treeItem = lookupTreeItemRecursive(rootDiagTreeItem_.getItems(), element);
        if (treeItem != null) {
            return treeItem;
        }
                
        return null;
    }
    
    private void doEventAdd(EObject notifier, Object newValue) {
        int index = 0;
        TreeItem parentTreeitem = null;            
        Object[] objs = null;
        // VIuWFNgŕ
        switch (ModelUtil.getClassifierID(newValue)) {
        case UML2Package.PACKAGE:
            parentTreeitem = lookupTreeItem((Element)notifier);

            // eIuWFNgŕ
            switch (ModelUtil.getClassifierID(notifier)) {
            case UML2Package.MODEL:
            case UML2Package.PACKAGE:
                Package p = (Package)notifier;
                objs = p.getOwnedMembers().toArray();
                break;
                    
            default:
                break;
            }
            break;
                
        case UML2Package.CLASS:
            parentTreeitem = lookupTreeItem((Element)notifier);

            // eIuWFNgŕ
            switch (ModelUtil.getClassifierID(notifier)) {
            case UML2Package.MODEL:
            case UML2Package.PACKAGE:
                Package p = (Package)notifier;
                objs = p.getOwnedMembers().toArray();
                break;

            case UML2Package.INTERFACE:
                Interface i = (Interface)notifier;
                objs = i.getNestedClassifiers().toArray();
                break;
                    
            case UML2Package.CLASS:
                Class c = (Class)notifier;
                objs = c.getNestedClassifiers().toArray();
                break;
                    
            default:
                break;
            }                                
            break;
            
        case UML2Package.INTERFACE:
            parentTreeitem = lookupTreeItem((Element)notifier);

            // eIuWFNgŕ
            switch (ModelUtil.getClassifierID(notifier)) {
            case UML2Package.MODEL:
            case UML2Package.PACKAGE:
                Package p = (Package)notifier;
                objs = p.getOwnedMembers().toArray();
                break;

            case UML2Package.INTERFACE:
                Interface i = (Interface)notifier;
                objs = i.getNestedClassifiers().toArray();
                break;
                    
            case UML2Package.CLASS:
                Class c = (Class)notifier;
                objs = c.getNestedClassifiers().toArray();                    
                break;
                    
            default:
                break;
            }                                
                
            break;
                
        case UML2Package.PROPERTY:
            parentTreeitem = lookupTreeItem((Element)notifier);

            // eIuWFNgŕ
            switch (ModelUtil.getClassifierID(notifier)) {
            case UML2Package.INTERFACE:
                Interface i = (Interface)notifier;
                // NX or pbP[W
                index += i.getNestedClassifiers().size();
                //
                objs = i.getOwnedAttributes().toArray();
                break;
                    
            case UML2Package.CLASS:
                Class c = (Class)notifier;
                // NX or pbP[W
                index += c.getNestedClassifiers().size();
                //
                objs = c.getOwnedAttributes().toArray();                    
                break;
                
            case UML2Package.ASSOCIATION:
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVTreeŏȂCxgȂ̂Ŗ߂");
                }
                return;
                    
            default:
                break;
            }                                
            break;
                    
        case UML2Package.OPERATION:
            parentTreeitem = lookupTreeItem((Element)notifier);

            // eIuWFNgŕ
            switch (ModelUtil.getClassifierID(notifier)) {
            case UML2Package.INTERFACE:
                Interface i = (Interface)notifier;
                // NX or pbP[W
                index += i.getNestedClassifiers().size();
                // 
                index += i.getOwnedAttributes().size();                    
                //
                objs = i.getOwnedOperations().toArray();
                break;
                    
            case UML2Package.CLASS:
                Class c = (Class)notifier;
                // NX or pbP[W
                index += c.getNestedClassifiers().size();
                // 
                index += c.getOwnedAttributes().size();                    
                //
                objs = c.getOwnedOperations().toArray();                    
                break;
                    
            default:
                break;
            }                                
            break;
/*
        case UML2Package.ASSOCIATION:
            parentTreeitem = lookupTreeItem((Element)notifier);
            Package p = (Package)notifier;
            objs = p.getOwnedMembers().toArray();
            break;
*/                
        case DIPackage.DIAGRAM: // 51
            // }
            parentTreeitem = rootDiagTreeItem_;
            objs = Latte.getLatteData().getDiagrams().getContained().toArray();
            break;
            
        default:
            if (Latte.TRACE_EVENT) {
                System.out.println("LVTreeŏȂCxgȂ̂Ŗ߂");
            }
            return;
        }
        // }ꏊ擾
        // łɃfɂ͓Ă̂-1
        index += ModelUtil.getInsertIndex(objs, newValue, false) - 1;
        // VTreeItem쐬
        TreeItem newTreeItem = addItem(parentTreeitem, newValue, index);
        // VTreeItem\
        tree_.showItem(newTreeItem);
        // Iɐݒ
        setSelectionItem(newTreeItem);
        Latte.getMainForm().setSelectedModels((EObject)newValue);
        // GfBbgJn
        editItem(newTreeItem);
        
    }
    
    private void doEventSet(EObject notifier, Object feature, Object newValue, String name, boolean wasSet) {
        // O̐ݒ肪
        if (notifier instanceof Package || notifier instanceof Class ||       // 05,09
            notifier instanceof Interface || notifier instanceof Property ||  // 16,22
            notifier instanceof Operation || notifier instanceof Diagram) {   // 23,52
                if (feature instanceof EAttribute && name.equals("name") && wasSet) {
                    
                    // Xi
                    enableUIListener(false);
            
                    // OύX
                    TreeItem renamedTreeItem = lookupTreeItem(notifier);
                    renamedTreeItem.setText((String)newValue);
                     // \[g
//                    sortTreeItems(renamedTreeItem.getParentItem());

                    // XiL
                    enableUIListener(true);
                } else {
                    if (Latte.TRACE_EVENT) {
                        System.out.println("LVTreeŏȂCxgȂ̂Ŗ߂");
                    }
                    return;
                }
        } else {
            if (Latte.TRACE_EVENT) {
                System.out.println("LVTreeŏȂCxgȂ̂Ŗ߂");
            }
            return;
        }
    }
    
    /**
     * ElementɑΉTreeItemċAIɌ
     */
    private TreeItem lookupTreeItemRecursive(TreeItem[] treeItems, EObject element) {
        for (int i=0; i<treeItems.length; i++) {
            // iԖڂelementɑΉ邩H
            if (treeItems[i].getData(LVTree.LATTE_DATA) == element) {
                return treeItems[i];
            }
            // iԖڎgΉȂ΁A̔zɑΉ̂邩
            TreeItem treeItem = lookupTreeItemRecursive(treeItems[i].getItems(), element);
            if (treeItem != null) {
                // zɑ݂Aʂɖ߂
                return treeItem;
            }
        }
        // 
        return null;      
    }


    
    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#getTarget()
     */
    public Notifier getTarget() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
     */
    public void setTarget(Notifier newTarget) {
        // TODO ꂽ\bhEX^u
    
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
     */
    public boolean isAdapterForType(Object type) {
        // TODO ꂽ\bhEX^u
        return false;
    }

    /**
     * fƓ
     *
     */
    public void syncTree() {
        // 
        init();

        // c[̍쐬
        createTree();
    }

    /**
     * I𒆂̃f
     *
     */
    EObject getSelectedModels() {
        return (EObject)selectedItem_.getData(LATTE_DATA);
    }
    
    
    /**
     * SI
     */
    public void deselectAll() {
        tree_.deselectAll();
        selectedItem_ = null;
    }
    
    /**
     * item̕\
     * @param item
     */
    public void showItem(TreeItem item) {
        tree_.showItem(item);
    }

    /**
     * Returns the tree.
     * @return tree
     */
    Tree getTree() {
        return tree_;
    }
    

    /**
     * Returns the itemEditor.
     * @return ItemEditor
     */
    public ItemEditor getItemEditor() {
        return itemEditor_;
    }

    /**
     * Returns the selectedItem.
     * @return TreeItem
     */
/*
    public TreeItem getSelectedItem() {
        return selectedItem_;
    }
*/    
    /**
     * @return
     */
    public TreeItem getRootModelTreeItem() {
        return rootModelTreeItem_;
    }
        
    /**
     * |bvAbvj[ic[j쐬
     */
    private void createTreePopupMenu() {
         // j[쐬
        Menu menu = new Menu(tree_);
        tree_.setMenu(menu);

        // ǉ
        GuiUtil.createMenuItem(menu, AllAction.ADD_ATTRIBUTE);
        GuiUtil.createMenuItem(menu, AllAction.ADD_METHOD);
        GuiUtil.createMenuItem(menu, AllAction.ADD_CLASS);
        GuiUtil.createMenuItem(menu, AllAction.ADD_INTERFACE);
        GuiUtil.createMenuItem(menu, AllAction.ADD_PACKAGE);
        // Zp[^
        new MenuItem(menu,SWT.SEPARATOR);
        GuiUtil.createMenuItem(menu, AllAction.ADD_CLASS_DIAGRAM);
        GuiUtil.createMenuItem(menu, AllAction.ADD_SEQUENCE_DIAGRAM);
        // Zp[^
        new MenuItem(menu,SWT.SEPARATOR);
        // ҏW
/*
        GuiUtil.createMenuItem(menu, AllAction.EDIT_CUT);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_COPY);
        GuiUtil.createMenuItem(menu, AllAction.EDIT_PASTE);
*/
        GuiUtil.createMenuItem(menu, AllAction.EDIT_REMOVE);
    }

    /**
     * Ԑݒ
     * TODO 폜\(2005/01)
     */
    private void initState() {
//        setSelectionItem(rootModelTreeItem_);
    }
    
    /**
     * IԂɂ
     * @param treeItem
     */
    public void setSelectionItem(TreeItem treeItem) {
        selectedItem_ = treeItem;
        tree_.setSelection(new TreeItem[]{treeItem});    
    }
    
    /**
     * \[g
     */
    private void sortTreeItems(TreeItem parent) {
        /** \[gbZ[W */
        final int TVM_SORTCHILDREN = 0x1113;
        /** \[g[ݒ */
//        final int TVM_SORTCHILDRENCB = 0x1115;

        // OɃ\[gt
        TreeItem[] items = parent.getItems();
        for (int i=0; i<items.length; i++) {
            Object o = items[i].getData(LVTree.LATTE_DATA);
            String pre = null;
            if (o instanceof Package) {
                pre = "0";
            } else if (o instanceof Interface) {
                pre = "1";
            } else if (o instanceof Class) {
                pre = "2";
            } else if (o instanceof Property) {
                pre = "3";
            } else if (o instanceof Operation) {
                pre = "4";
            } else if (o instanceof Diagram) {
                String diagType = ModelUtil.getDiagType((Diagram)o);
                if (diagType.equals(LVDiag.TYPE_CLASS_DIAG)) {
                    pre = "5";
                } else if (diagType.equals(LVDiag.TYPE_SEQ_DIAG)) {
                    pre = "6";
                } else{
                    throw new InternalLogicException("\[gpvtBbNXĂȂ");
                }
                pre = "5";
            } else {
                throw new InternalLogicException("\[gpvtBbNXĂȂ");
            }
            items[i].setText(pre + items[i].getText());
        }
        
        // \[g
        OS.SendMessage(tree_.handle, TVM_SORTCHILDREN, 0, parent.handle);

        // O߂
        items = parent.getItems();
        for (int i=0; i<items.length; i++) {
            items[i].setText(items[i].getText().substring(1));
        }
    }

    /**
     * \[g
     */
    private void unsortTreeItems(TreeItem parent) {
        /** \[gbZ[W */
        final int TVM_SORTCHILDREN = 0x1113;
        /** \[g[ݒ */
//        final int TVM_SORTCHILDRENCB = 0x1115;

        // eEObject擾
        EObject parentEObject = (EObject)parent.getData(LVTree.LATTE_DATA);
        
        EList elist = new BasicEList();
        switch (ModelUtil.getClassifierID(parentEObject)) {
        case UML2Package.MODEL:            
        case UML2Package.PACKAGE:
            Package p = (Package)parentEObject;
            elist.addAll(p.getOwnedMembers());
            break;

        case UML2Package.INTERFACE:
            Interface i = (Interface)parentEObject;
            elist.addAll(i.getNestedClassifiers());
            elist.addAll(i.getOwnedAttributes());
            elist.addAll(i.getOwnedOperations());
            break;
                    
        case UML2Package.CLASS:
            Class c = (Class)parentEObject;
            elist.addAll(c.getNestedClassifiers());
            elist.addAll(c.getOwnedAttributes());
            elist.addAll(c.getOwnedOperations());
            break;

        case UML2Package.PROPERTY:
        case UML2Package.OPERATION:
            break;
                    
        case DIPackage.DIAGRAM:
            Diagram d = (Diagram)parentEObject;
            elist = d.getContained();
            break;
        
        default:
            throw new InternalLogicException("\[gpvtBbNXĂȂ");
        }

        // fŃ\[gt
        TreeItem[] items = parent.getItems();
        DecimalFormat decimalFormat = new DecimalFormat("0000");
        for (int i=0; i<items.length; i++) {
            Object o = items[i].getData(LVTree.LATTE_DATA);
            int index = elist.indexOf(o);
            
            String pre = decimalFormat.format(index);
            
            items[i].setText(pre + items[i].getText());
        }
        
        // \[g
        OS.SendMessage(tree_.handle, TVM_SORTCHILDREN, 0, parent.handle);

        // O߂
        items = parent.getItems();
        for (int i=0; i<items.length; i++) {
            items[i].setText(items[i].getText().substring(4));
        }
    }

    /**
     * XiL
     *
     */
    private void enableUIListener(boolean enable) {
        if (enable) {
            // IXi
            tree_.addSelectionListener(selectionListener);
            // c[Xi
            tree_.addTreeListener(treeListener);
            // L[Xi
            tree_.addKeyListener(keyListener);
        } else {
            // IXi
            tree_.removeSelectionListener(selectionListener);
            // c[Xi
            tree_.removeTreeListener(treeListener);
            // L[Xi
            tree_.removeKeyListener(keyListener);        
        }
    }
    
    /**
     * Tree쐬
     */       
    private void createTree() {
        // ModelTree쐬
        TreeItem treeItem = Latte.getMainForm().getTree().rootModelTreeItem_;
        
        for (Iterator i = Latte.getLatteData().getModel().getOwnedMembers().iterator(); i.hasNext(); ) {
            createModelTree(treeItem , (EObject)i.next());
        }
        
        // }Tree쐬
        createDiagTree();

        // Ԑݒ
        initState();
    }

    /**
     * ċAIModelTree쐬(TreeItemޕʃWbN)
     * 
     * TreȅԂ𐧌䂷
     * 
     * @param node
     */
    private void createModelTree(TreeItem parentTreeItem, EObject eobject){
        
        List list = new ArrayList();
        List interfaceList = new ArrayList(); // C^[tFCX
        List classList = new ArrayList(); // NX
        Iterator i = null;
        
        // c[ڍ쐬
        TreeItem newTreeItem = addItem(parentTreeItem, eobject, -1);
        if (newTreeItem == null) {
            return;
        }
        
        switch (ModelUtil.getClassifierID(eobject)) {
        case UML2Package.PACKAGE:
            Package p = (Package)eobject;
            list = p.getOwnedMembers();
            break;
        
        case UML2Package.CLASS:
            // NX
            Class c = (Class)eobject;

            // NVt@Ct@[擾
            i = c.getNestedClassifiers().iterator();
            while (i.hasNext()) {
                Classifier nestedClassifier = (Classifier)i.next();
                if (nestedClassifier instanceof Interface) {
                    interfaceList.add(nestedClassifier);
                } else {
                    classList.add(nestedClassifier);
                }
            }
            // C^[tFCX
            list.addAll(interfaceList);
            // NX
            list.addAll(classList);
            // 
            list.addAll(c.getOwnedAttributes());
            // \bh
            list.addAll(c.getOwnedOperations());
            break;
        
        case UML2Package.INTERFACE:
            // C^[tFCX
            Interface intf = (Interface)eobject;

            // NVt@Ct@[擾
            i = intf.getNestedClassifiers().iterator();
            while (i.hasNext()) {
                Classifier nestedClassifier = (Classifier)i.next();
                if (nestedClassifier instanceof Interface) {
                    interfaceList.add(nestedClassifier);
                } else {
                    classList.add(nestedClassifier);
                }
            }
            // C^[tFCX
            list.addAll(interfaceList);
            // NX
            list.addAll(classList);
            // 
            list.addAll(intf.getOwnedAttributes());
            // \bh
            list.addAll(intf.getOwnedOperations());
            break;
            
        case UML2Package.PROPERTY:
        case UML2Package.OPERATION:
        case UML2Package.ASSOCIATION:
        case UML2Package.DEPENDENCY:
        case UML2Package.GENERALIZATION:
        case UML2Package.IMPLEMENTATION:        
            break;
        
        default:
            throw new InternalLogicException("TreeItem쐬s : "+eobject);
            
        }
        
        // ċAITree쐬
        Iterator ite = list.iterator();
        while (ite.hasNext()) {
            createModelTree(newTreeItem, (EObject)ite.next());
        }
    }
    

    /**
     * }tree쐬
     */
    private void createDiagTree() {
        Diagram d = Latte.getLatteData().getDiagrams();
        EList el = d.getContained();
        Iterator i = el.iterator();
        while (i.hasNext()) {
            // }
            Diagram diag = (Diagram)i.next();
            // TreeItem쐬
            TreeItem treeItem = addItem(rootDiagTreeItem_, diag, -1);
            // eLXgݒ
            treeItem.setText(diag.getName());
            // LATTE_DATAݒ
            treeItem.setData(LVTree.LATTE_DATA, diag);
            // C[Wݒ
            String diagType = ModelUtil.getDiagType(diag);
            if (diagType.equals(LVDiag.TYPE_CLASS_DIAG)) {
                // CLASS}
                treeItem.setImage(AllAction.ADD_CLASS_DIAGRAM.getImage());
            } else if(diagType.equals(LVDiag.TYPE_SEQ_DIAG)) {
                // SEQUENCE}
                treeItem.setImage(AllAction.ADD_SEQUENCE_DIAGRAM.getImage());
            }
        }
    }

    


    /**
     * w肳ꂽ`TreeItemeTreeitem̉ɍ쐬
     * 
     * @param index -1:ŌA0ȏ:}ꏊ
     */
    private TreeItem addItem(TreeItem parentTreeItem, Object newDef, int index) {
        // C[W&Oݒ
        String name = null;
        Image image = null;

        switch (ModelUtil.getClassifierID(newDef)) {
        case UML2Package.OPERATION:
            name = ((Operation)newDef).getName();
            image = AllAction.SHOW_METHOD.getImage();
            break;
            
        case UML2Package.PROPERTY:
            Property p = (Property)newDef;
            // O
            name = p.getName();
            // C[W
            if (p.getAssociation() == null) {
                image = AllAction.SHOW_ATTRIBUTE.getImage();
            } else {
                image = ATTRIBASSOC_IMAGE;
            }
            break;
        
        case UML2Package.CLASS:
            name = ((Class)newDef).getName();
            image = AllAction.ADD_CLASS.getImage();
            break;
        
        case UML2Package.INTERFACE:
            name = ((Interface)newDef).getName();
            image = AllAction.ADD_INTERFACE.getImage();
            break;
        
        case UML2Package.PACKAGE:
            name = ((Package)newDef).getName();
            image = AllAction.ADD_PACKAGE.getImage();
            break;

        case UML2Package.ASSOCIATION:
/*            
            name = "֘A";
            image = null;
            break;
*/
        case UML2Package.DEPENDENCY:
/*
            name = "ˑ";
            image = null;
            break;
*/
            return null;
        
        case DIPackage.DIAGRAM:
            Diagram d = (Diagram)newDef;
            name = d.getName();
            String diagType = ModelUtil.getDiagType(d);
            if (diagType.equals(LVDiag.TYPE_CLASS_DIAG)) {
                // NX}
                image = AllAction.ADD_CLASS_DIAGRAM.getImage();
            } else if (diagType.equals(LVDiag.TYPE_SEQ_DIAG)) {
                // V[PX}
                image = AllAction.ADD_SEQUENCE_DIAGRAM.getImage();
            }
            break;
            
        default:
            throw new InternalLogicException("l");
        }
        
        // TreeItem쐬
        TreeItem item = null;
        if (index >= 0) {
            // }ꏊ߂
            // TreeItem쐬
            item = new TreeItem(parentTreeItem, SWT.NULL, index);
        } else {
            // TreeItem쐬
            item = new TreeItem(parentTreeItem, SWT.NULL); // Ōɒǉ
        }
        item.setData(LVTree.LATTE_DATA, newDef);// LATTE_DATAݒ
        item.setText(name);   // eLXgݒ
        item.setImage(image); // C[Wݒ
        
        
        return item;
    }


    /**
     * ڃGfB^Jn
     */
    private void editItem(TreeItem item) {
        // ÕGfB^JĂdispose
        Control c = treeEditor_.getEditor();
        if (c != null) {
            c.dispose();
        }
        
        // GfB^̈ʒuݒ
        treeEditor_.horizontalAlignment = SWT.LEFT;
        treeEditor_.grabHorizontal = true;
        treeEditor_.minimumWidth = 50;
        // GfB^̍쐬
        itemEditor_ = new ItemEditor(this, treeEditor_, item);
        // GfB^J
        treeEditor_.setEditor(itemEditor_, item);
        // GfB^ɃtH[JX
        itemEditor_.setFocus();                    
    }
    
    private Image createImage(String fileName) {
        InputStream is = getClass().getResourceAsStream(fileName);
        return GuiUtil.createImage(is);
    }
    
        
    /**
     * ڃGfB^`
     */
    class ItemEditor extends Composite {
        /** LVTree */
        LVTree latteTree_ = null;
        /** TreeItem */
        TreeItem treeItem_ = null;
        /** eLXg */
        Text text_ = new Text(this, SWT.NONE);
        
        /**
         * RXgN^
         */
        ItemEditor(LVTree latteTree, TreeEditor treeEditor, TreeItem treeItem) {
            // ẽRXgN^Ă
            super(tree_, SWT.NONE);
            
            // ɐݒ
            latteTree_ = latteTree;
            treeEditor_ = treeEditor;
            treeItem_ = treeItem;
            
            // eLXg쐬Ac[ڂlRs[ASI
            text_.setText(treeItem_.getText());
            text_.selectAll();
            
            // eLXgtH[JXXi[o^
            text_.addFocusListener(new FocusListener(){
                /** tH[JX */
                public void focusLost(FocusEvent e) {
                    commit();
                }
                /** tH[JX擾 */
                public void focusGained(FocusEvent e) {}
            });
            
            // go[XXi[o^
            text_.addTraverseListener(new TraverseListener() {
                public void keyTraversed(TraverseEvent te) {
                    switch (te.detail) {
                    case SWT.TRAVERSE_ESCAPE: // ESCL[
                        roolback();
                        te.doit = false;
                        break;
                    case SWT.TRAVERSE_RETURN: // RETURNL[
                        commit();
                        te.doit = true;
                        break;
                    }
                }
            });
            
            // TCYXi[o^
            addListener (SWT.Resize, new Listener () {
                public void handleEvent (Event e) {
                    Rectangle rect = getClientArea ();
                    text_.setBounds (rect.x + 1, rect.y + 1, rect.width - 2, rect.height - 2);
                }
            });
            
            // TreeItemXi[o^
            treeItem_.addDisposeListener(new DisposeListener() {
                public void widgetDisposed(DisposeEvent e) {
                    roolback();
                }
            });
        }
        
        /**
         * lm肵GfBbgIBIԂɂB
         */
        private void commit() {
            // VO
            String newName = text_.getText();
            Object o = treeItem_.getData(LVTree.LATTE_DATA);

            // 
            closeItemEditor();
            
            // OύXANV
            AllAction.EDIT_RENAME.execute(new Object[]{o, newName});
        }
        
        /**
         * lm肹ɃGfBbgI
         */
        public void roolback() {
            // 
            closeItemEditor();
        }
        
        /**
         * ڃGfB^
         */
        private void closeItemEditor() {
            // dispose
            dispose();
            
            // treeEditoreditornullɂ
            treeEditor_.setEditor(null);
        }
    }   

    /**
     * c[IXi
     */
    class LVTreeSelectionListener implements SelectionListener {
        /** ŏII */
        private long lastSelectTime_ = 0;
        
        /**
         * ICxg
         */
        public void widgetSelected(SelectionEvent e) {
            // ݎ
            long curTime = System.currentTimeMillis();

            // OƓTreeItemłP.5bȓȂGfB^N
            if ((TreeItem)e.item == selectedItem_ && curTime-lastSelectTime_ <1000) {
                editItem(selectedItem_);
            }

            // IꂽTreeItem擾
            selectedItem_ = (TreeItem)e.item;
            // Ifݒ
            EObject o = (EObject)selectedItem_.getData(LVTree.LATTE_DATA);
            Latte.getMainForm().setSelectedModels(o);

            // L
            lastSelectTime_ = curTime;
        }
        
        /**
         * ftHgIi_uNbNjCxg
         */
        public void widgetDefaultSelected(SelectionEvent e) {
        	try {
                // I𒆂̃f擾
                Object o = getSelectedModels();

				// }ł[g}ȊOȂ
				if (ModelUtil.getClassifierID(o) == DIPackage.DIAGRAM && o != Latte.getLatteData().getDiagrams()) {      
					// }\
					Latte.getMainForm().getDiagFolder().showDiag((Diagram)o);
				}
        	}
        	catch (Exception ex) {
        		ex.printStackTrace();
        		MsgUtil.showMsg("G[F"+ex.getMessage());
        	}
        }
    }
    
    
    /**
     * L[Xi
     */
    class LVKeyListener implements KeyListener {

        /* ( Javadoc)
         * @see org.eclipse.swt.events.KeyListener#keyPressed(org.eclipse.swt.events.KeyEvent)
         */
        public void keyPressed(KeyEvent e) {
            if (e.keyCode == SWT.F2) {
                if (selectedItem_ != null) {
                    editItem(selectedItem_);
                }
            }
        }

        /* ( Javadoc)
         * @see org.eclipse.swt.events.KeyListener#keyReleased(org.eclipse.swt.events.KeyEvent)
         */
        public void keyReleased(KeyEvent e) {
        }
    }
    
    /**
     * c[Xi
     */
    class LVTreeListener implements TreeListener {

		/**
         * c[Ƃ
		 */
		public void treeCollapsed(TreeEvent e) {
		}

		/**
         * c[JƂ
		 */
		public void treeExpanded(TreeEvent e) {
		}
    }
    
    /**
     * \[gANV
     */
    class SortAction extends AbstractLatteAction {

        /**
         * @param title
         * @param imageFile
         */
        public SortAction(String title, String imageFile) {
            super(title, imageFile);
        }

        /**
         * @see latte.action.AbstractLatteAction#execMain(java.lang.Object)
         */
        public void execMain(Object param) {
            // \[g
            if (sort_) {
                sort_ = false;
            } else {
                sort_ = true;
            }
            
            // v
            GuiUtil.setWaitMouseCursor();
            if (sort_) {
                // \[g f
                sortTreeItemRecursive(rootModelTreeItem_);
                // \[g }
                sortTreeItemRecursive(rootDiagTreeItem_);
            } else {
                // \[g f
                unsortTreeItemRecursive(rootModelTreeItem_);
                // \[g }
                unsortTreeItemRecursive(rootDiagTreeItem_);
            }
            // 
            GuiUtil.setNormalMouseCursor();            
        }
        
        /**
         * ċAIɃ\[g
         * @param treeItem
         */
        private void sortTreeItemRecursive(TreeItem treeItem) {
            // sort
            sortTreeItems(treeItem);
            
            // qsort
            TreeItem[] treeItems = treeItem.getItems();
            for (int i=0; i<treeItems.length; i++) {
                sortTreeItemRecursive(treeItems[i]);
            }
        }

        /**
         * ċAIɃ\[g
         * @param treeItem
         */
        private void unsortTreeItemRecursive(TreeItem treeItem) {
            // sort
            unsortTreeItems(treeItem);
            
            // qsort
            TreeItem[] treeItems = treeItem.getItems();
            for (int i=0; i<treeItems.length; i++) {
                unsortTreeItemRecursive(treeItems[i]);
            }
        }
    }
    
    /**
     * փANV
     */
    class UpAction extends AbstractLatteAction {

        /**
         * @param title
         * @param imageFile
         */
        public UpAction(String title, String imageFile) {
            super(title, imageFile);
        }

        /**
         * @see latte.action.AbstractLatteAction#execMain(java.lang.Object)
         */
        public void execMain(Object param) {
            MsgUtil.showMsg("");
        }
    }

    /**
     * փANV
     */
    class DownAction extends AbstractLatteAction {

        /**
         * @param title
         * @param imageFile
         */
        public DownAction(String title, String imageFile) {
            super(title, imageFile);
        }

        /**
         * @see latte.action.AbstractLatteAction#execMain(java.lang.Object)
         */
        public void execMain(Object param) {
            MsgUtil.showMsg("");
        }
    }
    
}
