/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.DIPackage;
import latte.di.Diagram;
import latte.di.GraphEdge;
import latte.di.GraphNode;
import latte.util.DebugUtil;
import latte.util.GuiUtil;
import latte.util.ModelUtil;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabFolderListener;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;

/**
 * e̐}\̈
 * 
 * TabFolder璼ڔhłȂ̂ŃR|WVB
 * 
 * @version $Id: LVDiagFolder.java,v 1.3 2004/10/02 04:27:59 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class LVDiagFolder implements CTabFolderListener, Adapter {
    /** ^utH_ */
    private CTabFolder tabFolder_ = null;
    /** ef[^ */
    public static final String LATTE_DATA = "LATTE_DATA";
    
    /**
     * RXgN^
     */
    public LVDiagFolder(Composite parent) {
        tabFolder_ = new CTabFolder(parent, SWT.BORDER| SWT.FLAT);
        // X{^ǉ
        tabFolder_.addCTabFolderListener(this);
        // F
        tabFolder_.setSelectionBackground(new Color[]{
            GuiUtil.getColor(SWT.COLOR_TITLE_BACKGROUND), 
            GuiUtil.getColor(SWT.COLOR_TITLE_BACKGROUND_GRADIENT), 
            GuiUtil.getColor(SWT.COLOR_WIDGET_BACKGROUND)},
            new int[] {50, 100});
        tabFolder_.setSelectionForeground(GuiUtil.getColor(SWT.COLOR_WHITE));
        // hbOhbv
        new DropTargetEnabler(this, tabFolder_);
    }
    
    /**
     * }tH_̏
     *
     */
    public void init() {
        removeAllDiag();
    }

    /**
     * }\
     */
    public void showDiag(Diagram diag) {
        // 
        CTabItem item = lookupTabItem(diag);
        
        if (item != null) {
            // Oɕ\
            tabFolder_.setSelection(item);
        } else  {
            // ̂ō쐬
            createDiag(diag);
        }
    }

    /**
     * tabtH_߂
     * }쐬ɐeƂĕKv
     * 
     * @return TabFolder
     */
    public CTabFolder getTabFolder() {
        return tabFolder_;
    }

    /**
     * \LVDiag擾
     * 
     * @return LVDiag
     */
    public LVDiag getSelectedDiag() {
        // \TabItem擾
        CTabItem item = tabFolder_.getSelection();
        
        if (item == null) {
            // \ĂȂΖ߂
            return null;
        }
        
        return (LVDiag)item.getData(LATTE_DATA);
    }

    
    /**
     * ^u폜Ƃ
     * 
     * @see CTabFolderListener
     */
    public void itemClosed(CTabFolderEvent event) {
/*
        CTabItem item = (CTabItem)event.item;
        // }폜
//        item.getControl().dispose();
*/
    }


    /**
     * ύXʒm
     * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
     */
    public void notifyChanged(Notification notification) {
        if (Latte.TRACE_EVENT) {
            System.out.print(DebugUtil.getEventId(this, notification) + " ");        
            System.out.println("LVDiagFolder notifyChanged:"+notification);
        }
        
        // 
        LVDiag lvDiag = lookupLVDiag(notification); // source画f]肷
        if (lvDiag == null) {
            if (Latte.TRACE_EVENT) {
                System.out.println("\Ȃ̂Ŗ߂");
            }
            return;
        }
        Object feature = notification.getFeature();
        Object notifier = notification.getNotifier();
        String name = (feature instanceof EAttribute) ? ((EAttribute)feature).getName() : null;
        Object newValue = notification.getNewValue();        
        Object oldValue = notification.getOldValue();
        boolean wasSet = notification.wasSet();
        
        switch (notification.getEventType()) {
        // ǉ
        case Notification.ADD:
            if (!(newValue instanceof Diagram) &&
                 (newValue instanceof GraphNode || newValue instanceof GraphEdge)) {//56
                // NXC^[tFCXDnD
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFolder]");
                }
                lvDiag.notifyChanged(notification);                
            } else {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFolderŏȂCxgȂ̂Ŗ߂");
                }
                return;                
            }
            break;
        
        // ݒ    
        case Notification.SET:
            // ^u̖OύX
            if (notifier instanceof Diagram && feature instanceof EAttribute &&
                name.equals("name") && wasSet) {//54
                    Diagram diagram = (Diagram)notifier;
                    CTabItem tabItem = lookupTabItem(diagram);
                    if (tabItem != null) {
                        // ^u\Ă
                        tabItem.setText(diagram.getName());
                    }
            } else {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFolderŏȂCxgȂ̂Ŗ߂");
                }
                return;                
            }
            break;

        // 폜
        case Notification.REMOVE:
            if (notifier instanceof Diagram && oldValue instanceof Diagram) { // 55
                // \Ȃ폜
               CTabItem cTabItem = lookupTabItem((Diagram)oldValue);
               if (cTabItem != null) {
                   cTabItem.getControl().dispose();
                   cTabItem.dispose();
               }
            } else if (notifier instanceof Diagram && 
                       (oldValue instanceof GraphNode || oldValue instanceof GraphEdge)){//57
                // NXC^[tFCX폜
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFolder]");
                }
                lvDiag.notifyChanged(notification);
            } else {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFolderŏȂCxgȂ̂Ŗ߂");
                }
                return;
            }
            break;

        // A_v^폜
        case Notification.REMOVING_ADAPTER:
            if (Latte.TRACE_EVENT) {
                System.out.println("LVDiagFolderŏȂCxgȂ̂Ŗ߂");
            }
            break;
            
        default:
            throw new InternalLogicException("T|[g̕ύXʒm");
        }
    }
    
    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#getTarget()
     */
    public Notifier getTarget() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
     */
    public void setTarget(Notifier newTarget) {
        // TODO ꂽ\bhEX^u
    
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
     */
    public boolean isAdapterForType(Object type) {
        // TODO ꂽ\bhEX^u
        return false;
    }


    /**
     * }쐬
     */    
    private void createDiag(Diagram diag) {
        LVDiag lvDiag = null;
        String diagType = ModelUtil.getDiagType(diag);
        if (diagType.equals(LVDiag.TYPE_CLASS_DIAG)) {
            // NX}쐬
            lvDiag = new LVClassDiag(diag);
        } else if(diagType.equals(LVDiag.TYPE_SEQ_DIAG)) {
            // V[PX}쐬
            lvDiag = new LVSeqDiag(diag);
        } else {
            throw new IllegalStateException("T|[gO̐}łB쐬ł܂B");
        }
        // IԂɂ
        tabFolder_.setSelection(lvDiag.getTabItem());
    }
    
    /**
     * CTabItem̌
     * @param diag
     * @return
     */
    private CTabItem lookupTabItem(Diagram diag) {
        CTabItem[] items = tabFolder_.getItems();
        
        // 
        for (int i=0; i<items.length; i++) {
            LVDiag lvDiag = (LVDiag)items[i].getData(LATTE_DATA);
            if (diag == lvDiag.getDiagram()) {
                return items[i];
            }
        }
        
        return null;
    }
    
    /**
     * CxgɑΉLVDiag
     * @param notification
     * @return
     */
    private LVDiag lookupLVDiag(Notification notification) {
        LVDiag lvDiag = null;
        Object o = notification.getNotifier();
        
        // ʒmɂ蕪
/*
        if (o instanceof Comment) {
            // RgȂ
            lvDiag = GuiUtil.getSelectedLVDiag();
        } else if (o instanceof Diagram){
*/
        switch (ModelUtil.getClassifierID(o)) {
        case DIPackage.DIAGRAM:
            // _CAOȂ
            Diagram diagram = (Diagram)o;
    
            CTabItem[] items = tabFolder_.getItems();
            // 
            for (int i=0; i<items.length; i++) {
                LVDiag d = (LVDiag)items[i].getData(LATTE_DATA);
                if (d.getDiagram() == diagram) {
                    lvDiag = d;
                    break;
                }
            }
            break;

        default:
            break;
        }
        return lvDiag;
    }
    
    /**
     * }S폜
     */
    private void removeAllDiag() {
        CTabItem[] items = tabFolder_.getItems();
        for (int i=0; i<items.length; i++) {
            // }폜
            items[i].getControl().dispose();
            // ^u폜
            items[i].dispose();
        }
    }

}
