/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import java.util.List;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.GraphNode;
import latte.util.DebugUtil;
import latte.util.GuiUtil;
import latte.util.ModelUtil;


import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.SchemeBorder;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;

/**
 * 
 * }̒ۃtBMBA
 * @FʒuA{[_AFAwiFAOpaque=true
 * 
 * @version $Id: LVDiagFigure.java,v 1.3 2004/02/19 18:23:39 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public abstract class LVDiagFigure extends Figure implements Adapter {
	/** e */
	protected LVDiag lvDiag_ = null;
    /** DiagramLink(ۂ̃fƕRt`) */
    protected GraphNode graphNode_ = null;
    /** tHgF{[h */
	protected static Font BOLD = GuiUtil.getBoldFont();
    /** tHgFC^bN{[h */
    protected static Font ITALICBOLD = GuiUtil.getItalicBoldFont();
    /** tHgFC^bN */
    protected static Font ITALIC = GuiUtil.getItalicFont();

    /**
     * RXgN^
     * ݒ荀ځFʒuA{[_AFAOpaque=true
     */
    public LVDiagFigure(LVDiag lvDiag, GraphNode graphNode) {
        super();
		// e
		lvDiag_ = lvDiag;
		// diagramLink
        graphNode_ = graphNode;

		// {[_[ݒ	
		SchemeBorder sb = new SchemeBorder(SchemeBorder.SCHEMES.ETCHED);
		setBorder(sb);

		// Cxg͂悤ɂi񓧖ɂA݂j
		setOpaque(true);

		// F
		setForegroundColor(LVConst.ForeColor);
        // wiFݒ
        setBackgroundColor(getBackgroundColor());
        
		// ʒuݒ
		setLocation(ModelUtil.getLocation(graphNode_, new Point(0, 0)));
    }
    
    /**
     * ύXʒm
     * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
     */
    public void notifyChanged(Notification notification) {
        if (Latte.TRACE_EVENT) {
            System.out.print(DebugUtil.getEventId(this, notification) + " ");
            System.out.println("LVDiagFigure notifyChanged:"+notification);
        }

        Object notifier = notification.getNotifier();
        Object newValue = notification.getNewValue();
        
        switch (notification.getEventType()) {
        // ǉ
        case Notification.ADD:
            if (Latte.TRACE_EVENT) {
                System.out.println("LVDiagFigureŏȂCxgȂ̂Ŗ߂");
            }
            return;

        // ݒ
        case Notification.SET:
            if (notifier instanceof GraphNode && newValue instanceof latte.di.Point) { // 58
                // ʒu
                Point p = ((Viewport)getParent().getParent()).getViewLocation();
                setLocation(ModelUtil.getLocation(graphNode_, new Point(-p.x, -p.y)));
            } else {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVDiagFigureŏȂCxgȂ̂Ŗ߂");
                }
                return;
            }
            break;
        
        // 폜
        case Notification.REMOVE:
            if (Latte.TRACE_EVENT) {
                System.out.println("LVDiagFigureŏȂCxgȂ̂Ŗ߂");
            }
            return;
        
        // Ȃ        
        case Notification.REMOVING_ADAPTER:// A_v^폜
        case Notification.CREATE:// ֘A쐬        
            if (Latte.TRACE_EVENT) {
                System.out.println("LVDiagFigureŏȂCxgȂ̂Ŗ߂");
            }
            break;
            
        default:
            throw new InternalLogicException("T|[g̕ύXʒm");
        }
    }
    
    /**
     * wiIFɂ
     */
    public void setSelectedBackgroundColor() {
        setBackgroundColor(LVConst.SelectedBackColor);
    }
    
    /**
     * wiWFɂ
     */
    public void setNormalBackgroundColor() {
        setBackgroundColor(getBackgroundColor());
    }
    

    /**
     * (\̈)̎ݒ
     */
    public void setConstraint() {
        org.eclipse.draw2d.geometry.Point p = getBounds().getLocation();
        Rectangle rect = new Rectangle(p.x, p.y, -1, -1);       
        getParent().getLayoutManager().setConstraint(this, rect);
    }


    /**
     * ΉDiagNode擾
     * @return LMFigure
     */
    public GraphNode getGraphNode() {
        return graphNode_;
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#getTarget()
     */
    public Notifier getTarget() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
     */
    public void setTarget(Notifier newTarget) {
        // TODO ꂽ\bhEX^u
        
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
     */
    public boolean isAdapterForType(Object type) {
        // TODO ꂽ\bhEX^u
        return false;
    }

    /**
     * wiF̎擾
     */
    public Color getBackgroundColor() {
        return LVConst.ClassBackColor;
    }

    /**
     * XeI^Cv̐ݒ
     * @param stereoType
     */
    protected void setStereoType(String stereoType) {
    	// ݂폜
    	List l = getChildren();
    	if (l.size() > 0) {
			Object o = l.get(0);
			if (o instanceof StereoType) {
				remove((StereoType)o);
			}
    	}
		// XeI^Cvǉ
		StereoType streoType = new StereoType("<< " + stereoType + " >>");
		streoType.setFont(BOLD);
		add(streoType, 0);
    }
    
    
    /**
     * lvDiag擾
     * @return
     */
    public LVDiag getLvDiag() {
        return lvDiag_;
    }

    /**
     * XeI^Cv^
     */
    class StereoType extends Label {
		StereoType(String s) {
			super(s);
		}
    }

}