/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import java.util.Iterator;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.Diagram;
import latte.di.GraphElement;
import latte.di.GraphNode;

import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.SimpleLoweredBorder;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.XYLayout;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;


/**
 * eň}̊NX
 * 
 * TabItem璼ڔhłȂ̂ŃR|WVB
 * 
 * @version $Id: LVDiag.java,v 1.5 2004/10/02 04:27:59 ohnuki Exp $
 * @author $Author: ohnuki $
 */   
public abstract class LVDiag extends AdapterImpl {
    /** }` */
    private Diagram diagram_ = null;
    /** TabItem */
    private CTabItem tabItem_ = null;
    /** `GA */
    private Canvas swtView_ = null;    // SWT
    private Figure draw2dView_ = null; // draw2d
    
    /** I[h */
    public static final int MODE_SELECTION=1;
    /** ֘A֌W@ǉ[h */
    public static final int MODE_ASSOCIATION=2;
    /** ĉ֘A@ǉ[h */
    public static final int MODE_GENELIZATION=3;
    /** ֘A@ǉ[h */
    public static final int MODE_IMPLEMENTATION=4;
    /** ˑ֘A@ǉ[h */
    public static final int MODE_DEPENDENCY=5;
    /** m[gN@ǉ[h */
    public static final int MODE_NOTELINK=6;
    /** TCYX */
    private static final int SIZE_X = 2048;
    /** TCYY */
    private static final int SIZE_Y = 2048;
    /** [h */
    private int mode_ = MODE_SELECTION;
    /** y[Wf^ */
    private static final int PAGE_DELTA = 50;
    /** _CAO^Cv */
    public static final String TYPE_CLASS_DIAG = "ClassDiagram";
	public static final String TYPE_SEQ_DIAG = "SequenceDiagram";
    public static final String TOOL_NAME = "Latte ver1";
    
    /**
     * RXgN^
     */
    protected LVDiag(Diagram diag) {
        // LMDiagݒ
        diagram_ = diag;
        // TabItem쐬
        CTabFolder tabFolder = Latte.getMainForm().getDiagFolder().getTabFolder();
        tabItem_ = new CTabItem(tabFolder, SWT.NULL);
        tabItem_.setText(diag.getName());
        tabItem_.setImage(getTabImage());
		tabItem_.setControl(createTabItemControl(tabFolder));
        tabItem_.setData(LVDiagFolder.LATTE_DATA, this); // TabItemLVDiagݒ
    }
    
    /**
     * graphElementɑΉLVClassDiagFigureԂ
     * 
     * 
     * @param graphElement
     * @return
     */
    public LVDiagFigure lookupFigure(GraphNode graphNode) {
        Iterator i = getDraw2dView().getChildren().iterator();
        while (i.hasNext()) {
            Object o = i.next(); // LVClassDiagFigure  connection\
            if (o instanceof LVDiagFigure) {
                LVDiagFigure f = (LVClassDiagFigure)o;
                GraphElement ge = f.getGraphNode();
                if (ge == graphNode) {
                    return f;
                }
            }
        }
        throw new InternalLogicException("ł͂Ȃ̂ɔłȂ");
    }

    /**
     * [h擾
     * @return int
     */
    public int getMode() {
        return mode_;
    }
    /**
     * [hݒ
     * @param mode The mode to set
     */
    public void setMode(int mode) {
        mode_ = mode;
    }
    
    /**
     * Diagram̎擾
     * 
     * @return Diagram
     */
    public Diagram getDiagram() {
        return diagram_;
    }

    /**
     * TabItem̎擾
     * @return TabItem
     */
    public CTabItem getTabItem() {
        return tabItem_;
    }
    
    /**
     * draw2dView̎擾
     * 
     * @return Figure
     */
    public Figure getDraw2dView() {
        return draw2dView_;
    }

    /**
     * swtView̎擾
     * 
     * j[̐؂ւɎgp
     * @return
     */
    public Canvas getSwtView() {
        return swtView_;
    }

    abstract public void notifyChanged(Notification notification);
    abstract protected Image getTabImage();
    abstract protected void createDiagModeBar(Composite parent);


    
    /**
     * e^uControl쐬
     * 
     *        -------------------------   -------------
     *        |Class}/Sequence}     |   Content
     *        -------------------------   -------------
     *        |ContentBase(draw2dView)|        ^
     *        -------------------------        |
     *        |   ScrollPane          |        |
     *        -------------------------   ContentBase
     *        |LightweightSystem      |        |
     *  -------------------------------   ---  |
     *  | bar |   Canvas(swtView)     |   Bar| v
     *  -------------------------------   -------------
     *  | Control(Composite)          |   TabItemControl
     *  -------------------------------   -------------
     *  |       TabFolder             |   TabFolder
     *  -------------------------------   -------------
     * 
     * @param parent
     * @return
     */
    private Control createTabItemControl(Composite tabFolder) {
    	// SWT Control쐬
    	Composite tabItemControl = new Composite(tabFolder, SWT.NULL);
  
		// CAEgݒ
		GridLayout layout = new GridLayout();
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 1;
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		tabItemControl.setLayout(layout);
		// Diag[hII
		createDiagModeBar(tabItemControl);
    	// DiagRecx[X쐬
    	createDiagContentBase(tabItemControl);
    	
		return tabItemControl;
    }
    
    /**
     * }쐬
     * 
     * @see createTabItemControl
     * @param parent
     */
    private void createDiagContentBase(Composite parent) {
		// DRAW2D ScalableLayeredPanecontentBaseƂč쐬
//		ScalableFreeformLayeredPane contentBase = new ScalableFreeformLayeredPane();
//		ScalableLayeredPane contentBase = new ScalableLayeredPane();
		draw2dView_ = new Figure();
        draw2dView_.setBackgroundColor(LVConst.diagColor_);
        draw2dView_.setOpaque(true);       // Cxg͂悤ɂi񓧖ɂA݂j
        draw2dView_.setPreferredSize(new Dimension(SIZE_X,SIZE_Y));
        draw2dView_.setLayoutManager(new FreeformLayout());
        // XYLayoutݒ肳ĂFigurẽTCYωAʒuω
        // XYLayoutݒ肳ĂȂƃXN[̓ɕs
        draw2dView_.setLayoutManager(new LatteXYLayout());

		// ScrollPane쐬
		final ScrollPane scrollPane = new ScrollPane();
		scrollPane.setContents(draw2dView_);
		scrollPane.setBorder(new SimpleLoweredBorder());

		// LWSɐݒ
		LightweightSystem lws = new LightweightSystem();
		lws.setContents(scrollPane);   // draw2d̓e

		// SWT Canvas쐬(Scroll Mousegp\ɂ)
		swtView_ = new Canvas(parent, SWT.H_SCROLL|SWT.V_SCROLL); 
        swtView_.getVerticalBar().setVisible(false);
        swtView_.getHorizontalBar().setVisible(false);
		swtView_.setLayoutData(new GridData(GridData.FILL_BOTH));// ɍL
        swtView_.addKeyListener(new KeyListener(){
            public void keyPressed(KeyEvent e) {
                scrollVerticalDraw2dView(scrollPane, e.keyCode);
            }
            public void keyReleased(KeyEvent e) {}
        });
        // Scroll MouseΉ
        swtView_.getVerticalBar().addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
//                LogUtil.writeln("VerticalBar widgetSelected() detail="+e.detail);
                scrollVerticalDraw2dView(scrollPane, e.detail);
            }
            public void widgetDefaultSelected(SelectionEvent e) {}
        });
        swtView_.getHorizontalBar().addSelectionListener(new SelectionListener() {
            public void widgetSelected(SelectionEvent e) {
//                LogUtil.writeln("HorizontalBar widgetSelected() detail="+e.detail);
                scrollHorizontalDraw2dView(scrollPane, e.detail);
            }
            public void widgetDefaultSelected(SelectionEvent e) {}
        });
        
		lws.setControl(swtView_);       // draw2dSWT̕Rt
    }
    
    private void scrollVerticalDraw2dView(ScrollPane scrollPane, int event) {
        int y;
        switch (event) {
        case SWT.PAGE_UP:
        case SWT.ARROW_UP:
            y = scrollPane.getViewport().getViewLocation().y-PAGE_DELTA;
            scrollPane.scrollVerticalTo(y);
            break;
        case SWT.PAGE_DOWN:
        case SWT.ARROW_DOWN:
            y = scrollPane.getViewport().getViewLocation().y+PAGE_DELTA;
            scrollPane.scrollVerticalTo(y);
            break;
        }
    }

    private void scrollHorizontalDraw2dView(ScrollPane scrollPane, int event) {
        int x;
        switch (event) {
        case SWT.PAGE_UP:
        case SWT.ARROW_UP:
            x = scrollPane.getViewport().getViewLocation().x-PAGE_DELTA;
            scrollPane.scrollHorizontalTo(x);
            break;
            
        case SWT.PAGE_DOWN:
        case SWT.ARROW_DOWN:
            x = scrollPane.getViewport().getViewLocation().x+PAGE_DELTA;
            scrollPane.scrollHorizontalTo(x);
            break;
        }
    }
    class LatteXYLayout extends XYLayout {
        public Point getOrigin(IFigure parent) {
            return parent.getClientArea().getLocation().translate(-2, -2);
        }
    }
    
}
