/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import latte.InternalLogicException;
import latte.Latte;
import latte.di.CoreSemanticModelBridge;
import latte.di.GraphConnector;
import latte.di.GraphEdge;
import latte.di.GraphNode;
import latte.util.DebugUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;

import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.PolylineDecoration;
//import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.UML2Package;


/**
 * 
 * NX}̃RlNVtBMBA
 * 
 * }EXCxgeɂʒm
 * 
 * @version $Id: LVClassDiagConnection.java,v 1.7 2004/10/02 04:27:59 ohnuki Exp $
 * @author $Author: ohnuki $
 *
 */
public abstract class LVClassDiagConnection extends PolylineConnection implements Adapter {
    /** e */
    protected LVClassDiag parent_ = null;
    /** GraphEdge */
    private GraphEdge graphEdge_ = null;
    
    /** ̑(W) */
    public static final int WIDTH_NORMAL = 1;
    /** ̑(I) */
    public static final int WIDTH_SELECTED = 2;
    
    /**
     * RXgN^
     * 
     * @param parent
     * @param rel
     */
    public LVClassDiagConnection(LVClassDiag parent, GraphEdge graphEdge) {
        // e
        parent_ = parent;
        // f
        graphEdge_ = graphEdge;
        
		// F
		setForegroundColor(LVConst.ForeColor);// ̐F
        
        // RlNVX^Cݒ
        setupConnectionStyle();

		// Xi[ǉ
		addMouseListener(new ClassDiagConnectionMouseListener(this));
		addMouseMotionListener(new ClassDiagConnectionMouseMotionListener(this));
    }
    
    
    /**
     * SourceRlNVAJ[쐬
     * @see latte.view.LVClassDiagConnection#createSourceConnectionAnchor()
     */
    ConnectionAnchor createSourceConnectionAnchor() {
        LVDiagFigure fig = getLVDiagFigure(ModelUtil.getFromGraphConnector(getGraphEdge()));
        if (fig == null) {
            throw new IllegalStateException("RlNV̒[͐}̗vfɊ܂܂܂");
        }
        return new ChopboxAnchor(fig);
    }

    /**
     * TargetRlNVAJ[쐬
     * @see latte.view.LVClassDiagConnection#createTargetConnectionAnchor()
     */
    ConnectionAnchor createTargetConnectionAnchor() {
        LVDiagFigure fig = getLVDiagFigure(ModelUtil.getToGraphConnector(getGraphEdge()));
        if (fig == null) {
            throw new IllegalStateException("RlNV̒[͐}̗vfɊ܂܂܂");
        }
        return new ChopboxAnchor(fig);
    }         
    
	
   	/**
	 * RlNVX^C쐬
	 * @return
	 */
	protected void setupConnectionStyle() {
		setSourceAnchor(createSourceConnectionAnchor());// AJ[(source)ݒ
		setTargetAnchor(createTargetConnectionAnchor());  // AJ[(target)ݒ
		setConnectionRouter(new BendpointConnectionRouter());// [^ݒ
	}
	
	/**
	 * 쐬
	 */
	public void createConstraint() {
		/*
				Point p = getLmRel().getRoutingCons();
		System.out.println("getRoutingCons()=" + p);
				if (p != null) {
					// ݒ
					ArrayList cons = new ArrayList(1);
					cons.add(new LatteBendpoint(p));
					setRoutingConstraint(cons);
				} else {
					// 폜
					setRoutingConstraint(null);
				}
		*/
	}
    
    /**
     * XV
     *
     */
    public void updateConnection() {
        LogUtil.writeln("LVClassDiagConnection.updateConnection()");
                
        // RlNVX^C
        setupConnectionStyle();

        // ĕ`
        repaint();
    }

	/**
     * GraphEdge̎擾
	 */
	public GraphEdge getGraphEdge() {
        return graphEdge_;
	}
    
    /**
     * CoreSemanticModelBridgewelement̎擾
     * 
     * @return
     */
    public Element getElement() {
        CoreSemanticModelBridge b = (CoreSemanticModelBridge)graphEdge_.getSemanticModel();
        
        return b.getElement();
    }
    
    public LVDiagFigure getLVDiagFigure(GraphConnector graphConnector) {
        GraphNode graphNode = (GraphNode)graphConnector.getGraphElement();
        LVDiagFigure fig = parent_.lookupFigure(graphNode);
        return fig;
    }
    
    /**
     * @see org.eclipse.emf.common.notify.Adapter#notifyChanged(org.eclipse.emf.common.notify.Notification)
     */
    public void notifyChanged(Notification notification) {
        if (Latte.TRACE_EVENT) {
            System.out.print(DebugUtil.getEventId(this, notification) + " ");
            System.out.println("LVClassDiagConnection notifyChanged:"+notification);
        }
        
        int eventType = notification.getEventType();
        EObject notifier = (EObject)notification.getNotifier();
        
        switch (eventType) {
        case Notification.SET:
            if (ModelUtil.getClassifierID(notifier) == UML2Package.PROPERTY) {
                setupConnectionStyle();
            } else {
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagConnectionŏȂCxgȂ̂Ŗ߂");                    
                }
            }
            break;
            
        
        case Notification.REMOVING_ADAPTER:// A_v^폜
        case Notification.REMOVE_MANY:
            if (Latte.TRACE_EVENT) {
                System.out.println("LVClassDiagŏȂCxgȂ̂Ŗ߂");
            }
            break;
            
        default:
            throw new InternalLogicException("T|[g̕ύXʒm");
        }
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#getTarget()
     */
    public Notifier getTarget() {
        // TODO ꂽ\bhEX^u
        return null;
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#setTarget(org.eclipse.emf.common.notify.Notifier)
     */
    public void setTarget(Notifier newTarget) {
        // TODO ꂽ\bhEX^u
        
    }

    /* ( Javadoc)
     * @see org.eclipse.emf.common.notify.Adapter#isAdapterForType(java.lang.Object)
     */
    public boolean isAdapterForType(Object type) {
        // TODO ꂽ\bhEX^u
        return false;
    }         

    static class ClassDiagConnectionMouseListener implements MouseListener {
        /** Xi[Ώ */
        private LVClassDiagConnection conn_ = null;
        
        /**
         * RXgN^
         * @param figure
         */
        ClassDiagConnectionMouseListener(LVClassDiagConnection conn) {
            conn_ = conn;
        }
        /**
         * }EXvX
         */
        public void mousePressed(MouseEvent me) {
            LogUtil.writeln("ClassDiagConnectionMouseListener.mousePressed()");
/*            
            // NbNʒuݒ
            Point sPoint = conn_.getStart();
            Point ePoint = conn_.getEnd();
            int lenStart = Math.abs(sPoint.x - me.x) + Math.abs(sPoint.y - me.y);
            int lenEnd = Math.abs(ePoint.x - me.x) + Math.abs(ePoint.y - me.y);
            if (lenStart < lenEnd) {
                Latte.getMainForm().setSelectedModelDir(DIR_FROM);
            } else {
                Latte.getMainForm().setSelectedModelDir(DIR_TO);
            }
*/        
            // POPUPj[ݒ
            Menu menu = null;
            switch (ModelUtil.getClassifierID(conn_.getElement())) {
            case UML2Package.ASSOCIATION:
                GraphEdge graphEdge = conn_.getGraphEdge();
                // U\
                boolean navigable = ModelUtil.isNavigable(graphEdge);
                conn_.parent_.POPUPMENU_ASSOCIATION.navigatableMenuItem_.setSelection(navigable);
                // AOQ[V
                conn_.parent_.POPUPMENU_ASSOCIATION.aggregationNone_.setSelection(false);
                conn_.parent_.POPUPMENU_ASSOCIATION.aggregationShare_.setSelection(false);
                conn_.parent_.POPUPMENU_ASSOCIATION.aggregationComposite_.setSelection(false);
                AggregationKind ak = ModelUtil.getAggregationKind(graphEdge);
                switch (ak.getValue()) {
                case AggregationKind.NONE:
                    conn_.parent_.POPUPMENU_ASSOCIATION.aggregationNone_.setSelection(true);
                    break;
                case AggregationKind.SHARED:
                    conn_.parent_.POPUPMENU_ASSOCIATION.aggregationShare_.setSelection(true);
                    break;
                case AggregationKind.COMPOSITE:
                    conn_.parent_.POPUPMENU_ASSOCIATION.aggregationComposite_.setSelection(true);
                    break;
                }
                menu = conn_.parent_.POPUPMENU_ASSOCIATION.menu_;
                break;
                
            case UML2Package.COMMENT:
                menu = conn_.parent_.POPUPMENU_COMMENT;
                break;
                
            default:
                menu = conn_.parent_.POPUPMENU_NORMAL;
                break;
            }
            conn_.parent_.setPopupMenu(menu);
            
            // eiNX}j̃Xiďoj[\
            conn_.getParent().handleMousePressed(me);

            // IԂɂ
            conn_.setLineWidth(WIDTH_SELECTED);
            Latte.getMainForm().setSelectedModels(conn_.getGraphEdge());
        }

    
        /**
         * }EX[X
         */
        public void mouseReleased(MouseEvent me) {
            conn_.getParent().handleMouseReleased(me);
        }

        /**
         * }EX_uNbN
         */ 
        public void mouseDoubleClicked(MouseEvent me) {
            // 폜
//            AllAction.ROUTECONS_DELETE.execute(null);
        }
    }
    
    
    static class ClassDiagConnectionMouseMotionListener implements MouseMotionListener {
        /** Xi[Ώ */
        private LVClassDiagConnection conn_ = null;
        
        /**
         * RXgN^
         * @param figure
         */
        ClassDiagConnectionMouseMotionListener(LVClassDiagConnection conn) {
            conn_ = conn;
        }
        /**
         * }EXhbO
         */ 
        public void mouseDragged(MouseEvent me) {
            conn_.getParent().handleMouseDragged(me);
        }
        /**
         * }EXړ
         */ 
        public void mouseMoved(MouseEvent me) {
            conn_.getParent().handleMouseMoved(me);
        }
        public void mouseEntered(MouseEvent me) {
            conn_.getParent().handleMouseEntered(me);
        }
        public void mouseExited(MouseEvent me) {
            conn_.getParent().handleMouseExited(me);
        }
        public void mouseHover(MouseEvent me) {
            conn_.getParent().handleMouseHover(me);
        }
    }
    
    

	/**
	 * 
	 */
	static class LineArrowDecoration extends PolylineDecoration {
		/**
		 * 
		 *
		 */
		LineArrowDecoration() {
			setScale(8, 5);		
		}
	}
	/**
	 * Op
	 */
	static class TriangleDecoration extends PolygonDecoration {
		/**
		 * Op
		 */
		TriangleDecoration() {
			setBackgroundColor(ColorConstants.white);
			setScale(8, 5);
		}
	}
	
	/**
	 * AOQ[V(_CAh)
	 */
	static class AggregationDecoration extends PolygonDecoration {
		static final PointList DIAMOND_TIP = new PointList();

		static {
			DIAMOND_TIP.addPoint(0, 0);
			DIAMOND_TIP.addPoint(-1, 1);
			DIAMOND_TIP.addPoint(-2, 0);
			DIAMOND_TIP.addPoint(-1, -1);
		}
		/**
		 * AOQ[V(_CAh)
		 */
		AggregationDecoration() {
			setTemplate(DIAMOND_TIP);
			setBackgroundColor(ColorConstants.white);            
			setScale(6, 4);
		}
	}
	/**
	 * R|WV(h_CAh)
	 */
	static class CompositionDecoration extends PolygonDecoration {
		static final PointList DIAMOND_TIP = new PointList();

		static {
			DIAMOND_TIP.addPoint(0, 0);
			DIAMOND_TIP.addPoint(-1, 1);
			DIAMOND_TIP.addPoint(-2, 0);
			DIAMOND_TIP.addPoint(-1, -1);
		}
		/**
		 * R|WV(h_CAh)
		 */
		CompositionDecoration() {
			setTemplate(DIAMOND_TIP);
			setScale(6, 4);
		}
	}
}
       