/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import org.eclipse.draw2d.ChopboxAnchor;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.ConnectionEndpointLocator;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.uml2.AggregationKind;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.UML2Package;

import latte.di.GraphEdge;
import latte.util.ModelUtil;


/**
 * ֘ARlNV
 * 
 * @version $Id: LVClassDiagAssociationConnection.java,v 1.4 2004/02/19 18:23:42 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class LVClassDiagAssociationConnection extends LVClassDiagConnection {
    /** [ */
    // eNX̃RXgN^setupConnectionStyle()Ă΂̂ŁA
    // setupConnectionStyle()㏑ꍇ́AsetupConnectionStyle()ɑSĂ
    private Label roleLabel_;
     
	/**
	 * ֘ARlNṼRXgN^
	 * @param parent
	 * @param element
	 */
	protected LVClassDiagAssociationConnection(LVClassDiag parent, GraphEdge graphEdge) {
		super(parent, graphEdge);
	}

	/** 
     * X^Cݒ
     * 
	 * @see latte.view.LVClassDiagConnection#createConnection()
	 */
	protected void setupConnectionStyle() {
		super.setupConnectionStyle();
		// CX^C
		setLineStyle(Graphics.LINE_SOLID);

		// Decoration`
		RotatableDecoration sourceDeco = null, targetDeco = null;

		// (U\)
        Property fromProperty = ModelUtil.getFromProperty(getGraphEdge());
        Property toProperty = ModelUtil.getToProperty(getGraphEdge());

		if (fromProperty!=null && fromProperty.isNavigable()) {
            targetDeco = new LVClassDiagConnection.LineArrowDecoration();
		}
        if (toProperty!=null && toProperty.isNavigable()) {
            sourceDeco = new LVClassDiagConnection.LineArrowDecoration();
		}
		
		// AOQ[V
        AggregationKind fromAgg = fromProperty.getAggregation();
        switch (fromAgg.getValue()) {
        case AggregationKind.SHARED:
			sourceDeco = new LVClassDiagConnection.AggregationDecoration();
            break;
        case AggregationKind.COMPOSITE:
			sourceDeco = new LVClassDiagConnection.CompositionDecoration();
            break;
        }
        AggregationKind toAgg = toProperty.getAggregation();
        switch (toAgg.getValue()) {
        case AggregationKind.SHARED:
			targetDeco = new LVClassDiagConnection.AggregationDecoration();
            break;
        case AggregationKind.COMPOSITE:
			targetDeco = new LVClassDiagConnection.CompositionDecoration();
            break;
        }

		// ݒ
		setSourceDecoration(sourceDeco);
		setTargetDecoration(targetDeco);
        
        // [
        if (roleLabel_ == null) {
            // [
            ConnectionEndpointLocator relationshipLocator = new ConnectionEndpointLocator(this, true);
            relationshipLocator.setUDistance(5);
            relationshipLocator.setVDistance(-5);
            
            roleLabel_ = new Label();
            add(roleLabel_, relationshipLocator);
        }
        String roleName = "";
        if (ModelUtil.getClassifierID(fromProperty.getOwner()) == UML2Package.CLASS) {
            roleName = fromProperty.getName();            
        }
        roleLabel_.setText(roleName);
	}

	/**
	 * 
	 * @see latte.view.LVClassDiagConnection#createSourceConnectionAnchor()
	 */
	ConnectionAnchor createSourceConnectionAnchor() {
		LVDiagFigure fig = getLVDiagFigure(ModelUtil.getFromGraphConnector(getGraphEdge()));
		if (fig == null) {
			throw new IllegalStateException("RlNV̒[͐}̗vfɊ܂܂܂");
		}
		return new ChopboxAnchor(fig);
	}

	/**
	 * @see latte.view.LVClassDiagConnection#createTargetConnectionAnchor()
	 */
	ConnectionAnchor createTargetConnectionAnchor() {
        LVDiagFigure fig = getLVDiagFigure(ModelUtil.getToGraphConnector(getGraphEdge()));
        if (fig == null) {
            throw new IllegalStateException("RlNV̒[͐}̗vfɊ܂܂܂");
        }
        return new ChopboxAnchor(fig);
	}    
}

       