/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Property;
import org.eclipse.uml2.UML2Package;

import latte.InternalLogicException;
import latte.Latte;
import latte.action.AbstractLatteAction;
import latte.action.AllAction;
import latte.di.DIPackage;
import latte.di.Diagram;
import latte.di.GraphEdge;
import latte.di.GraphElement;
import latte.di.GraphNode;
import latte.util.DebugUtil;
import latte.util.GuiUtil;
import latte.util.LogUtil;
import latte.util.ModelUtil;
import latte.util.MsgUtil;

/**
 * P̐}\
 * 
 * @version $Id: LVClassDiag.java,v 1.8 2004/10/02 04:27:59 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class LVClassDiag extends LVDiag {

    /**
     * POPUPj[
     */
    public final Menu POPUPMENU_NONE = null;
    /** ClassFigure POPUPj[ */
    public final ClassFigureMenu POPUPMENU_CLASS_FIG = createClassFigurePopupMenu();
    /** CommentFigure POPUPj[ */
    public final Menu POPUPMENU_NORMAL = createNormalPopupMenu();
    /** ֘A֌WPOPUPj[ */
    public final AssociationConnectionMenu POPUPMENU_ASSOCIATION = createAssociationPopupMenu();
    /** Comment, CommentLink POPUPj[ */
    public final Menu POPUPMENU_COMMENT = createCommentPopupMenu();
    
    /**
     * [h
     */
    AbstractLatteAction MODE_SELECTION_ACTION;
    AbstractLatteAction MODE_ASSOCIATION_ACTION;
    AbstractLatteAction MODE_GENELIZATION_ACTION;
    AbstractLatteAction MODE_DEPENDENCY_ACTION;
    AbstractLatteAction MODE_IMPLEMENTATION_ACTION;
    AbstractLatteAction MODE_NOTELINK_ACTION;
    
    /**
     *  ǉ̊֌W
     */
    private AddingLine addingLine_ = new AddingLine();

    
    /**
     * RXgN^
     */
    public LVClassDiag(Diagram diag) {
        super(diag);
		// DiagRec쐬
		createDiagContent();
        
        // Xiǉ
        new LVClassDiagListener();
    }
    
    /**
     * }̍XV
     * @param notification
     */
    public void notifyChanged(Notification notification)  {
        if (Latte.TRACE_EVENT) {
            System.out.print(DebugUtil.getEventId(this, notification) + " ");
            System.out.println("LVClassDiag notifyChanged:"+notification);
        }

        Object newValue = (GraphElement)notification.getNewValue();
        Object oldValue = (GraphElement)notification.getOldValue();
        
        switch (notification.getEventType()) {
        // ǉ
        case Notification.ADD:
            // newValueŕ
            switch (ModelUtil.getClassifierID(newValue)) {
            case DIPackage.GRAPH_NODE: // 56
                // Figureǉ
                addFigure((GraphNode)newValue);
                break;
            
            case DIPackage.GRAPH_EDGE: // 56
                // Connectionǉ
                addConnection((GraphEdge)newValue);
                break;
            
            default:
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagŏȂCxgȂ̂Ŗ߂");
                }
                break;
            }
            break;
        
        // 폜
        case Notification.REMOVE:
            // oldValueŕ
            switch (ModelUtil.getClassifierID(oldValue)) {
            case DIPackage.GRAPH_NODE: // 03,07,11,18,57
                // 
                LVDiagFigure f = lookupFigure((GraphNode)oldValue);
                // Figure폜
                removeFigure((LVClassDiagFigure)f);
                break;
            
            case DIPackage.GRAPH_EDGE: // 57
                // 
                LVClassDiagConnection c = lookupConnection((GraphEdge)oldValue);              
                // Connection폜
                removeConnection(c);
                break;
            
            default:
                if (Latte.TRACE_EVENT) {
                    System.out.println("LVClassDiagŏȂCxgȂ̂Ŗ߂");
                }
                break;
            }
            break;
            
        // A_v^폜
        case Notification.REMOVING_ADAPTER:
            if (Latte.TRACE_EVENT) {
                System.out.println("LVClassDiagŏȂCxgȂ̂Ŗ߂");
            }
            break;

        default:
            throw new InternalLogicException("T|[g̕ύXʒm");
        }
    }
    
    /**
     * DiagConnectionListԂ
     * 
     * @return DiagConnectionList
     */
    public List getDiagConnectionList() {
        List l =getDraw2dView().getChildren();
        List l2 = new ArrayList();
        
        Iterator ite = l.iterator();
        while (ite.hasNext()) {
            Object o = ite.next();
            if (o instanceof LVClassDiagConnection) {
                l2.add(o);
            }
        }
        
        return l2;
    }

    /**
     * ǉ̊֌W
     * @return
     */
    AddingLine getAddingLine() {
        return addingLine_;
    }

	/**
	 * LVClassDiagConnectionԂ
	 * @param xmiid
	 * @return
	 */
	private LVClassDiagConnection lookupConnection(GraphEdge graphEdge) {
        Iterator i = getDraw2dView().getChildren().iterator();
        while (i.hasNext()) {
            Object o = i.next(); // LVClassDiagFigure  connection\
            if (o instanceof LVClassDiagConnection) {
                LVClassDiagConnection c = (LVClassDiagConnection)o;
                GraphElement ge = c.getGraphEdge();
                if (ge == graphEdge) {
                    return c;
                }
            }
        }
        throw new InternalLogicException("ł͂Ȃ̂ɔłȂ");
	}
	
    /**
     * |bvAbvj[̐ݒ
     * @param menu
     */
    public void setPopupMenu(Menu menu) {
        getSwtView().setMenu(menu);          
    }
    

	/**
     * NX}[ho[̍쐬
     */
    protected void createDiagModeBar(Composite parent) {
        // ANV쐬
        MODE_SELECTION_ACTION = new ModeSelectionAction("I[h", "images/selection.gif");
        MODE_ASSOCIATION_ACTION = new ModeAssociationAction("֘A쐬[h", "images/association.gif");
        MODE_GENELIZATION_ACTION = new ModeGenelizationAction("ĉ쐬[h", "images/generalization.gif");
        MODE_DEPENDENCY_ACTION = new ModeDependencyAction("ˑ쐬[h", "images/dependency.gif");
        MODE_IMPLEMENTATION_ACTION = new ModeImplementationAction("쐬[h", "images/implementation.gif");
        MODE_NOTELINK_ACTION = new ModeNotelinkAction("m[gN쐬[h", "images/notelink.gif");
        
        
        // o[쐬
        ToolBar toolbar = new ToolBar(parent, SWT.FLAT);
        GuiUtil.createToolbarItem(toolbar, SWT.RADIO, MODE_SELECTION_ACTION, true);
        GuiUtil.createToolbarItem(toolbar, SWT.RADIO, MODE_ASSOCIATION_ACTION);
        GuiUtil.createToolbarItem(toolbar, SWT.RADIO, MODE_GENELIZATION_ACTION);
        GuiUtil.createToolbarItem(toolbar, SWT.RADIO, MODE_DEPENDENCY_ACTION);
        GuiUtil.createToolbarItem(toolbar, SWT.RADIO, MODE_IMPLEMENTATION_ACTION);
        new ToolItem(toolbar,SWT.SEPARATOR);// Zp[^
        GuiUtil.createToolbarItem(toolbar, SWT.RADIO, MODE_NOTELINK_ACTION);
        GuiUtil.createToolbarItem(toolbar, SWT.PUSH, AllAction.ADD_NOTE);
    }
    /**
     * NX}C[W̎擾
     */
    protected Image getTabImage() {
        return AllAction.ADD_CLASS_DIAGRAM.getImage();
    }

    /**
     * [h̏
     *
     */
    private void initMode() {
        // [hݒ
        setMode(LVDiag.MODE_SELECTION);
        
        // Oݒ
        MODE_SELECTION_ACTION.setSelected(true);
        MODE_ASSOCIATION_ACTION.setSelected(false);
        MODE_GENELIZATION_ACTION.setSelected(false);
        MODE_DEPENDENCY_ACTION.setSelected(false);
        MODE_IMPLEMENTATION_ACTION.setSelected(false);
        MODE_NOTELINK_ACTION.setSelected(false);
    }
    
    
    /**
     * NX}Rec̍쐬
     * @see createDiagContentBase
     */
    private void createDiagContent() {
        LogUtil.writeln("<!-- <<<<<<<<  NX}Rec쐬 >>>>>>> -->");
        
        Iterator i = getDiagram().getContained().iterator();
        while (i.hasNext()) {
            GraphElement graphElement = (GraphElement)i.next();
            switch (ModelUtil.getClassifierID(graphElement)) {
            case DIPackage.GRAPH_NODE:
                addFigure((GraphNode)graphElement);
                break;

            case DIPackage.GRAPH_EDGE:
                addConnection((GraphEdge)graphElement);
                break;

            default:
                throw new InternalLogicException("zÕIuWFNg");
            }
        }
    }
    /**
     * Figureǉ
     */
    private void addFigure(GraphNode graphNode) {
        // fElemen擾
        Element element = ModelUtil.getElement(graphNode);

        try {
            // Figure쐬
            LVClassDiagFigure lvClassDiagFigure = null;
            switch (ModelUtil.getClassifierID(element)) {
            case UML2Package.CLASS:
                lvClassDiagFigure = new LVClassDiagClassFigure(this, graphNode);
                break;
            case UML2Package.INTERFACE:
                lvClassDiagFigure = new LVClassDiagInterfaceFigure(this, graphNode);                
                break;
            case UML2Package.COMMENT:
                lvClassDiagFigure = new LVClassDiagCommentFigure(this, graphNode);
                break;
            default:
                throw new IllegalArgumentException("addFigure()ł܂");
            }
            
            // FigureɃXiǉ
            addFigureListener(lvClassDiagFigure, graphNode);
            
            // viewɒǉ
            getDraw2dView().add(lvClassDiagFigure);
            lvClassDiagFigure.setConstraint();
            getDraw2dView().setValid(false);

            LogUtil.writeln("I");
        }
        catch(IllegalStateException e) {
            e.printStackTrace();
            LogUtil.writeln(e.getMessage());
            MsgUtil.showMsg("G[܂B:"+e.getMessage());
        }
    }
    
    /**
     * Connectionǉ
     */
    private void addConnection(GraphEdge graphEdge) {
        // fElement쐬
        Element element = ModelUtil.getElement(graphEdge);

        try {
            // connection쐬
            LVClassDiagConnection lvClassDiagConnection = null;
            
            switch (ModelUtil.getClassifierID(element)) {
            case UML2Package.ASSOCIATION:    //֘ARlNV
                lvClassDiagConnection = new LVClassDiagAssociationConnection(this, graphEdge);
                break;
            case UML2Package.DEPENDENCY:     //ˑRlNV
                lvClassDiagConnection = new LVClassDiagDependencyConnection(this, graphEdge);
                break;
            case UML2Package.IMPLEMENTATION: //RlNV
                lvClassDiagConnection = new LVClassDiagImplementaionConnection(this, graphEdge);
                break;
            case UML2Package.GENERALIZATION: //ĉRlNV
                lvClassDiagConnection = new LVClassDiagGeneralizationConnection(this, graphEdge);
                break;
            case UML2Package.COMMENT:        //RgN
                lvClassDiagConnection = new LVClassDiagCommentConnection(this, graphEdge);
                break;
            default:
                throw new IllegalArgumentException("addConnection()ł܂");        
            }
            
            // FigureɃXiǉ
            addConnectionListener(lvClassDiagConnection, graphEdge);
            
            // viewɒǉ
            getDraw2dView().add(lvClassDiagConnection);
            getDraw2dView().setValid(false);
        }
        catch(IllegalStateException e) {
            e.printStackTrace();
            LogUtil.writeln(e.getMessage());
            MsgUtil.showMsg("G[܂B:"+e.getMessage());
        }
    }

    /**
     * Figure폜
     */
    private void removeFigure(LVClassDiagFigure lvFig) {
        // SXi폜
        removeFigureListener(lvFig);
        
        // View폜
        getDraw2dView().remove(lvFig);
        // figure폜
        lvFig.erase();
    }

    
    /**
     * diagElement̊֌W폜
     * @param diagElement
     */
    private void removeConnection(LVClassDiagConnection lvConn) {
        // SXi폜
        removeConnectionListener(lvConn);
        
        // View폜
        getDraw2dView().remove(lvConn);
        // figure폜
        lvConn.erase();
    }
    
    /**
     * FigureɃXi[̒ǉ
     *
     */
    private void addFigureListener(LVClassDiagFigure lvClassDiagFigure, GraphNode graphNode) {
        // GraphNodeɃXiǉ
        graphNode.eAdapters().add(lvClassDiagFigure);
        // ElementɃXiǉ
        Element element = ModelUtil.getElement(graphNode);
        element.eAdapters().add(lvClassDiagFigure);
        // ⃁\bhɃXiǉ
        Iterator i = element.getOwnedElements().iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            e.eAdapters().add(lvClassDiagFigure);
        }
        
        // ̈^\bḧɑΉGraphNode݂΂Xio^
        if (ModelUtil.isExistAttributeGraphNode(graphNode)) {
            GraphNode attributeGraphNode = ModelUtil.getAttributeGraphNode(graphNode);
            attributeGraphNode.eAdapters().add(lvClassDiagFigure);
        }
        if (ModelUtil.isExistMethodGraphNode(graphNode)) {
            GraphNode methodGraphNode = ModelUtil.getMethodGraphNode(graphNode);
            methodGraphNode.eAdapters().add(lvClassDiagFigure);
        }
    }

    /**
     * ConnectionɃXi[̒ǉ
     *
     */
    private void addConnectionListener(LVClassDiagConnection lvClassDiagConnection, GraphEdge graphEdge) {
        // GraphEdgeɃXiǉ
        graphEdge.eAdapters().add(lvClassDiagConnection);
        
        // elementɕ
        Element element = ModelUtil.getElement(graphEdge);
        switch (ModelUtil.getClassifierID(element)) {
        case UML2Package.ASSOCIATION:
            // AssociationFromPropertyɃXiǉ
        	Property prop = ModelUtil.getFromProperty(graphEdge);
        	prop.eAdapters().add(lvClassDiagConnection);
        	break;
        	
        default:
            break;
        }
    }

    /**
     * FigurȇSXi[̍폜
     * 
     * @param lvClassDiagFigure
     */
    private void removeFigureListener(LVClassDiagFigure lvClassDiagFigure) {
        GraphElement graphElement = lvClassDiagFigure.getGraphNode();
        
        // GraphElement烊Xi폜
        graphElement.eAdapters().remove(lvClassDiagFigure);
        
        // Element烊Xi폜
        Element element = ModelUtil.getElement(graphElement);
        element.eAdapters().remove(lvClassDiagFigure);
        // ⃁\bh烊Xi폜
        Iterator i = element.getOwnedElements().iterator();
        while (i.hasNext()) {
            Element e = (Element)i.next();
            e.eAdapters().remove(lvClassDiagFigure);
        }
    }

    /**
     * Connection̑SXi[̍폜
     * 
     * @param lvClassDiagConnection
     */
    private void removeConnectionListener(LVClassDiagConnection lvClassDiagConnection) {
        GraphElement graphElement = lvClassDiagConnection.getGraphEdge();
        
        // GraphElement烊Xi폜
        graphElement.eAdapters().remove(lvClassDiagConnection);
        
        // Element(Association)烊Xi폜
        Element element = ModelUtil.getElement(graphElement);
        element.eAdapters().remove(lvClassDiagConnection);
    }
    
    /**
     * WPOPUPj[
     * @return
     */
    private Menu createNormalPopupMenu() {
        // j[쐬
        Menu menu = new Menu(getSwtView());

        // ҏW
        GuiUtil.createMenuItem(menu, AllAction.EDIT_REMOVE);
        GuiUtil.createMenuItem(menu, AllAction.REMOVE_MODEL);
       
        return menu;
    }

    /**
     * ClassFigure POPUPj[
     * @return
     */
    private ClassFigureMenu createClassFigurePopupMenu() {
        // j[쐬
        ClassFigureMenu classFigureMenu = new ClassFigureMenu(getSwtView());

        // ǉ
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.ADD_ATTRIBUTE);
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.ADD_METHOD);
        // Zp[^
        new MenuItem(classFigureMenu.menu_, SWT.SEPARATOR);
        // ҏW
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.EDIT_REMOVE);
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.REMOVE_MODEL);
        // Zp[^
        new MenuItem(classFigureMenu.menu_, SWT.SEPARATOR);
        classFigureMenu.showAttributeMenuItem_ = 
            GuiUtil.createCheckMenuItem(classFigureMenu.menu_, AllAction.SHOW_ATTRIBUTE, false);
        classFigureMenu.showMethodMenuItem_ = 
            GuiUtil.createCheckMenuItem(classFigureMenu.menu_, AllAction.SHOW_METHOD, false);
        GuiUtil.createMenuItem(classFigureMenu.menu_, AllAction.SHOW_DEF);
       
        return classFigureMenu;
    }

    
    /**
     * ֌WPOPUPj[
     * @return
     */
    private AssociationConnectionMenu createAssociationPopupMenu() {
        // j[쐬
        AssociationConnectionMenu associationConnectionMenu = new AssociationConnectionMenu(getSwtView());

        // U\
        associationConnectionMenu.navigatableMenuItem_ =
            GuiUtil.createCheckMenuItem(associationConnectionMenu.menu_, AllAction.NAVIGATABLE, false);
        // Zp[^
        new MenuItem(associationConnectionMenu.menu_,SWT.SEPARATOR);
        // AOQ[V
        associationConnectionMenu.aggregationNone_ =
            GuiUtil.createCheckMenuItem(associationConnectionMenu.menu_, AllAction.CONTAINER_NONE, false); // 
        associationConnectionMenu.aggregationShare_ =
            GuiUtil.createCheckMenuItem(associationConnectionMenu.menu_, AllAction.CONTAINER_AGGREGATION, false); // W
        associationConnectionMenu.aggregationComposite_ =
            GuiUtil.createCheckMenuItem(associationConnectionMenu.menu_, AllAction.CONTAINER_COMPOSITION, false); // R|WV
        // Zp[^
        new MenuItem(associationConnectionMenu.menu_,SWT.SEPARATOR);
        // ҏW
        GuiUtil.createMenuItem(associationConnectionMenu.menu_, AllAction.EDIT_REMOVE);
        GuiUtil.createMenuItem(associationConnectionMenu.menu_, AllAction.REMOVE_MODEL);
       
        return associationConnectionMenu;
    }
    
    
    /**
     * Comment, CommentLink POPUPj[
     * @return
     */
    private Menu createCommentPopupMenu() {
        // j[쐬
        Menu menu = new Menu(getSwtView());

        // ҏW
        GuiUtil.createMenuItem(menu, AllAction.EDIT_REMOVE);
       
        return menu;
    }
    
    /**
     * NX}Xi
     * 
     * ̌ɃNXtBMAXi
     */
    class LVClassDiagListener implements MouseListener, MouseMotionListener {
        /** ȌꏊL */
        private Point last_ = new Point(0, 0);

        /**
         * RXgN^
         */
        public LVClassDiagListener(){
            // Xio^
            getDraw2dView().addMouseListener(this);
            getDraw2dView().addMouseMotionListener(this);
        }

        /**
         * }EXvX
         */
        public void mousePressed(MouseEvent me) {
            
            LogUtil.writeln("ClassDiagListener.mousePressed("+me.x+","+me.y+")" + " button=" + me.button);

            // c[̑I
            Latte.getMainForm().getTree().deselectAll();
            
            if (getMode()==LVDiag.MODE_SELECTION) {
                
                // S
                Latte.getMainForm().setSelectedModels(null);
                Iterator i = getDraw2dView().getChildren().iterator();
                while (i.hasNext()) {
                    Object o = i.next();
                    if (o instanceof LVClassDiagFigure) {
                        // FigurȇI
                        LVClassDiagFigure f = (LVClassDiagFigure)o;
                        f.setNormalBackgroundColor();
                    } else if (o instanceof LVClassDiagConnection) {
                        // Connection̑I
                        LVClassDiagConnection conn = (LVClassDiagConnection)o;
                        conn.setLineWidth(LVClassDiagConnection.WIDTH_NORMAL);
                    }
                }

                // ȌꏊL^
                Viewport viewport = (Viewport)getDraw2dView().getParent();
                last_ = me.getLocation().translate(viewport.getViewLocation());
            }
        }

        /**
         * }EX[X
         */
        public void mouseReleased(MouseEvent me) {
            // ֘A쐬~
            getAddingLine().end();
            
            // ENbNj[ɂ
            setPopupMenu(POPUPMENU_NONE);
            
            // [h
            initMode();
        }


        /**
         * }EXhbO
         */
        public void mouseDragged(MouseEvent me) {
            LogUtil.writeln("ClassDiagListener.mouseDragged("+me.x+","+me.y+")" + " button=" + me.button);
            // [hɂĕ
            switch (getMode()) {
            case LVDiag.MODE_SELECTION:
                // Jg}vf擾
                EObject selectedElement = Latte.getMainForm().getSelectedModels();
                if (!(selectedElement instanceof GraphElement)) {
                    return; // NX}FigureȊO͖߂
                }
                // GraphElement擾
                GraphElement graphElement = (GraphElement)selectedElement;
                                
                // ߂
                Viewport viewport = (Viewport)getDraw2dView().getParent();
                Point now = me.getLocation().translate(viewport.getViewLocation());
                Dimension delta = now.getDifference(last_);
            
                // I[hȂ
                if (graphElement instanceof GraphNode) {
                    // JgfNX or C^[tFCX or Rg Ȃ
                    // Figureړ
                    LogUtil.writeln("delta=" + delta);
                    AllAction.FIGURE_MOVE.execute(new Object[]{graphElement, delta});
//                    }
//                } else if (curModel instanceof LM13Relationship) {
                    // Relatioñ[eBOύXύX
    //                AllAction.ROUTECONS_SET.execute(me);
                }
                // Olݒ
                last_ = now;
                break;
                
            case LVDiag.MODE_ASSOCIATION:
            case LVDiag.MODE_DEPENDENCY:
            case LVDiag.MODE_GENELIZATION:
            case LVDiag.MODE_IMPLEMENTATION:
            case LVDiag.MODE_NOTELINK:
                // ǉ̊֌Wړ
                getAddingLine().move(me.getLocation());
                break;
                
            default:
                throw new InternalLogicException("mouseDragged()lR");
            }
        }
        public void mouseDoubleClicked(MouseEvent me) {
            LogUtil.writeln("ClassDiagListener.mouseDoubleClicked("+me.x+","+me.y+")" + " button=" + me.button);
        }

        public void mouseEntered(MouseEvent me) {
//            LogUtil.writeln("ClassDiagListener.mouseEntered("+me.x+","+me.y+")" + " button=" + me.button);
        }

        public void mouseExited(MouseEvent me) {
//            LogUtil.writeln("ClassDiagListener.mouseExited("+me.x+","+me.y+")" + " button=" + me.button);
        }

        public void mouseHover(MouseEvent me) {
//            LogUtil.writeln("ClassDiagListener.mouseHover("+me.x+","+me.y+")" + " button=" + me.button);
        }

        public void mouseMoved(MouseEvent me) {
//            LogUtil.writeln("ClassDiagListener.mouseMoved("+me.x+","+me.y+")" + " button=" + me.button);
        }
    }
    
    
    
    /**
     * ǉ̐
     */
    class AddingLine extends PolylineConnection {
        /** e */
        IFigure parent_ = null;
        /** ֌W from ֌W쐬̂ݗLȒlݒ肳 */
        private LVClassDiagFigure fromFig_ = null;
        /** ֌W to */
        private LVClassDiagFigure toFig_ = null;
        
        /**
         * RXgN^
         */
        AddingLine() {
            // Fw
            setForegroundColor(LVConst.ForeColor);
        }
        
        /**
         * Jn
         * @param figure
         */
        public void start(LVClassDiagFigure figure, Point p) {
            // eݒ
            parent_ = figure.getParent();
            // tBMA
            fromFig_ = figure;
            toFig_ = null;
            // n_AI_ݒ
            setStart(p);
            setEnd(p);
            // eɊ֌Wǉ
            parent_.add(this, 0);// 0ɂȂƑIĂ܂
        }
        
        /**
         * ړ
         * @param p
         */
        public void move(Point p) {
            // Jneݒ肳ĂI_ݒ
            if (fromFig_ != null) {
                setEnd(p);
            }
        }
        
        /**
         * I
         */
        public void end() {
            if (fromFig_ != null) {
                // e폜
                parent_.remove(this);
                // toFigݒ肳Ă֌W쐬
                if (toFig_ != null) {
                    String mode = Integer.toString(getMode());
                    AllAction.ADD_RELATION.execute(new Object[]{mode, fromFig_.getGraphNode(), toFig_.getGraphNode()});
                }
                // From,TotBMÃNA
                fromFig_ = null;
                toFig_ = null;
            }
        }
        
        /**
         * toFiǧɂȂ邩H
         * 
         * fromFigȉ̎false
         * Enull
         * Ew肳ꂽfigƓ
         * 
         */
        public boolean isToFigCandidate(LVClassDiagFigure toFig) {
            if (fromFig_==null || fromFig_==toFig) {
                return false;
            }
            
            return true;
        }
        
        /**
         * @param figure
         */
        public void setToFig(LVClassDiagFigure figure) {
            toFig_ = figure;
        }
    }
    
    
    
    /**
     * I[h
     */
    class ModeSelectionAction extends AbstractLatteAction {

        public ModeSelectionAction(String title, String imageFile) {
            super(title, imageFile);
        }
  
        /**
         * IꂽAIɂȂƂɌĂ΂
         */
        public void execMain(Object param) {
            // [hݒ
            setMode(LVDiag.MODE_SELECTION);
        }
    }
    
    
    
    /**
     * ֘A[h
     */
    class ModeAssociationAction extends AbstractLatteAction {

        public ModeAssociationAction(String title, String imageFile) {
            super(title, imageFile);
        }
  
        public void execMain(Object param) {
            // [hݒ
            setMode(LVDiag.MODE_ASSOCIATION);
        }
    }

    /**
     * ˑ[h
     */
    class ModeDependencyAction extends AbstractLatteAction {

        public ModeDependencyAction(String title, String imageFile) {
            super(title, imageFile);
        }
  
        public void execMain(Object param) {
            // [hݒ
            setMode(LVDiag.MODE_DEPENDENCY);
        }
    }
    
    /**
     * ĉ[h
     */
    class ModeGenelizationAction extends AbstractLatteAction {

        public ModeGenelizationAction(String title, String imageFile) {
            super(title, imageFile);
        }
  
        public void execMain(Object param) {
            // [hݒ
            setMode(LVDiag.MODE_GENELIZATION);
        }
    }
    
    /**
     * [h
     */
    class ModeImplementationAction extends AbstractLatteAction {

        public ModeImplementationAction(String title, String imageFile) {
            super(title, imageFile);
        }
  
        public void execMain(Object param) {
            // [hݒ
            setMode(LVDiag.MODE_IMPLEMENTATION);
        }
    }
    
    /**
     * m[gN[h
     */
    class ModeNotelinkAction extends AbstractLatteAction {

        public ModeNotelinkAction(String title, String imageFile) {
            super(title, imageFile);
        }
  
        public void execMain(Object param) {
            // [hݒ
            setMode(LVDiag.MODE_NOTELINK);
        }
    }

    /**
     * AssociationConnectionj[
     * 
     * MenufinalȂ̂ŔhłȂ
     * 
     */    
    class AssociationConnectionMenu {
        /** j[ */
        Menu menu_ = null;
        /** U\ */
        MenuItem navigatableMenuItem_ = null;
        /** AOQ[V:none */
        MenuItem aggregationNone_ = null;
        /** AOQ[V:share */
        MenuItem aggregationShare_ = null;
        /** AOQ[V:composite */
        MenuItem aggregationComposite_ = null;
        /**
         * @param parent
         */
        public AssociationConnectionMenu(Control parent) {
            menu_ = new Menu(parent);
        }
    }
    
    /**
     * ClassFigurej[
     * 
     * MenufinalȂ̂ŔhłȂ
     */
    class ClassFigureMenu {
        /** j[ */
        Menu menu_ = null;
        /** \ */
        MenuItem showAttributeMenuItem_ = null;
        /** \bh\ */
        MenuItem showMethodMenuItem_ = null;
        /**
         * @param parent
         */
        public ClassFigureMenu(Control parent) {
            menu_ = new Menu(parent);
        }
    }
}
