/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.view;

import java.util.Iterator;

import latte.Latte;
import latte.action.AllAction;
import latte.di.CoreSemanticModelBridge;
import latte.di.Diagram;
import latte.di.GraphElement;
import latte.util.GuiUtil;
import latte.util.LogUtil;

import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Control;

/**
 * hbv^[QbgL
 * 
 * @version $Id: DropTargetEnabler.java,v 1.2 2004/09/04 16:05:42 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class DropTargetEnabler implements DropTargetListener {
    /** LVDiag */
    private LVDiagFolder latteDiagFolder_ = null;
    /** hbvłf[^^Cv */
    private static Transfer[] TYPE = new Transfer[]{TextTransfer.getInstance()};
    /**  */
    private static int OPERATION = DND.DROP_MOVE | DND.DROP_COPY | DND.DROP_LINK;
   
    /**
     * RXgN^
     * 
     * DiagFolderDropTargetɂ闝R
     * EXi[̂
     * EDropʒuDisplay̑Έʒu
     * E{ɒm肽Dropdraw2dScrollPane̒Ȃ̂ŗvŌvZ
     */
    public DropTargetEnabler(LVDiagFolder folder, Control control) {
        // _CAOtH_ݒ
        latteDiagFolder_ = folder;
        // hbv^[Qbg쐬
        DropTarget target = new DropTarget(control, OPERATION);
        target.setTransfer(TYPE);
        target.addDropListener(this);
    }

    /**
     * hbv
     * 
     * x,yDisplayɑ΂鑊Έʒu
     */
    public void drop(DropTargetEvent event) {
        LogUtil.write("DropTarget.drop():");

        if (event.data == null) {
            event.detail = DND.DROP_NONE;
            LogUtil.writeln("none");
            return;
        }
        
        // ʒu␳
        Viewport viewport = (Viewport)GuiUtil.getSelectedLVDiag().getDraw2dView().getParent();
        Point offset = viewport.getViewLocation();

        Canvas c = GuiUtil.getSelectedLVDiag().getSwtView();
        org.eclipse.swt.graphics.Point p = c.toControl(new org.eclipse.swt.graphics.Point(event.x+offset.x, event.y+offset.y));
        Point droppedPoint = new Point(p.x, p.y);
        LogUtil.writeln("dropped on "+ droppedPoint);

        // FigureǉANVďo
        AllAction.ADD_FIGURE.execute(droppedPoint);
    }
    
    /**
     * Drop\̈ɓƂ̃Cxg
     */
    public void dragEnter(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dragEnter()");
        LVDiag lvDiag = GuiUtil.getSelectedLVDiag();
        if (lvDiag == null) {
            // }̂DNDȂ
            event.detail = DND.DROP_NONE;
            return;            
        }
        // 
        EObject selectedModel = Latte.getMainForm().getTree().getSelectedModels();
        Diagram diagram = lvDiag.getDiagram();
        Iterator i = diagram.getContained().iterator();
        while (i.hasNext()) {
            GraphElement graphElement  = (GraphElement)i.next();
            CoreSemanticModelBridge uml2ModelBridge =  (CoreSemanticModelBridge)graphElement.getSemanticModel();
            // ɃNX}ɃNĂAcmcȂ
            if (uml2ModelBridge.getElement() == selectedModel) {
                event.detail = DND.DROP_NONE;
                return;
            }
        }
    }
    
    /**
     * Drop\̈悩oƂ̃Cxg
     */
    public void dragLeave(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dragLeave()");
    }
    
   
    public void dragOperationChanged(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dragOperationChanged()");
        if (event.detail == DND.DROP_DEFAULT) {
            event.detail = DND.DROP_LINK;
        }
    }
    
    /**
     * DropANZvg
     */
    public void dropAccept(DropTargetEvent event) {
        LogUtil.writeln("DropTarget.dropAccept()");
    }
    

    /**
     * hbOI[o[ɔ
     * 
     * ʂɃCxg
     */
    public void dragOver(DropTargetEvent event) {
        event.feedback = DND.FEEDBACK_EXPAND | DND.FEEDBACK_SCROLL | DND.FEEDBACK_SELECT;
    }
    
}
