/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/


package latte.util;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Calendar;

import latte.Latte;

/**
 * @version $Id: LogUtil.java,v 1.5 2004/10/02 07:41:07 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class LogUtil extends DebugUtil {
	private static String LOG_FILE = "log.txt";
	private static Writer logWriter__ = null;
	private static boolean inited__ = false;
	/** LbW^[ƃCtB[h */
	private static final String CRLF = System.getProperty("line.separator");
	
	/**
	 * Oo
	 * @param msg
	 */
	public static void writeln(Object msg) {
		write(msg + CRLF);
	}
    
    /**
     * Oo
     * @param msg
     * @param e
     */
    public static void write(String msg, Exception e) {
        // bZ[W
        writeln(msg);
        
        // X^bNg[X
        if (Latte.LOG_STDOUT) {
            e.printStackTrace();
        }
        e.printStackTrace((PrintWriter)logWriter__);
    }

	/**
	 * Oo
	 * @param msg
	 */
	public static void write(String msg) {
        if (Latte.LOG_STDOUT) {
            System.out.print(msg);
        }
        
		try {
			if (!inited__) {
				init();
			}
			// o
			Calendar cal = Calendar.getInstance();
            logWriter__.write(cal.get(Calendar.YEAR)+"/"+(cal.get(Calendar.MONTH)+1)+"/"+cal.get(Calendar.DAY_OF_MONTH)+" ");
            logWriter__.write(cal.get(Calendar.HOUR_OF_DAY)+":"+cal.get(Calendar.MINUTE)+":"+cal.get(Calendar.SECOND)+" ");
            
			// o
			logWriter__.write(msg);
            if (Latte.LOG_FLUSH) {
                logWriter__.flush();
            }
		}
		catch (Exception e) {
			e.printStackTrace();
		}
	}

	private static void init() throws IOException {
		logWriter__ = new PrintWriter(new BufferedWriter(new FileWriter(LOG_FILE)));
		inited__ = true;
	}

}
