/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/


package latte.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;

import latte.di.Diagram;
import latte.di.GraphEdge;
import latte.di.GraphNode;
import latte.view.LVDiag;
import latte.view.LVDiagFigure;
import latte.view.LVDiagFolder;
import latte.view.LVTree;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Comment;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Model;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.Property;

/**
 * @version $Id: DebugUtil.java,v 1.2 2004/09/04 16:05:40 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class DebugUtil {
    /** \邩H */
    private static boolean isPrint__ = true;
    /** NX捞ޗO */
    private static Throwable stacktrace__ = new Throwable();
    /** X^bNg[Xi[郉C^[ */
    private static StringWriter stringWriter__ = new StringWriter();
    /** LbW^[ƃCtB[h */
    private static final String CRLF = System.getProperty("line.separator");
    
    synchronized public static String location() {
        //
        // tH[}bgς݃NX̎擾
        //
        stacktrace__.fillInStackTrace();
        stacktrace__.printStackTrace(new PrintWriter(stringWriter__));
        // g[Nɕ
        StringTokenizer stringTokenizer =
            new StringTokenizer(stringWriter__.toString(), CRLF);
        // Oǂݎ̂
        stringTokenizer.nextToken();
        // ̃\bh擾
        String line = stringTokenizer.nextToken();
        // g[N@@DebugUtilɂԁAǂݎ̂
        while ((line.indexOf("DebugUtil")>=0) && stringTokenizer.hasMoreTokens()) {
            line = stringTokenizer.nextToken();
        }
        // OpbP[W̊O
        String location = line.substring(4).trim();// tab,a,t,(space)4菜
        
        return location;
    }
    
    synchronized public static void printLocation() {
        if (isPrint__) {
            LogUtil.writeln(location());
        }
    }

    synchronized public static void printMsg(String msg) {
        if (isPrint__) {
            LogUtil.writeln(msg + " in " + location());
        }        
    }
    
    synchronized public static void printStackTrace() {
        stacktrace__.fillInStackTrace();
        stacktrace__.printStackTrace();
    }
    
    public static void print(Map map) {
        LogUtil.writeln("<<<<<<<<<<<this is map print >>>>>>>>>>>>>>");
		Iterator iter = map.entrySet().iterator();
		while (iter.hasNext()) {
			Map.Entry entry = (Map.Entry)iter.next();
            LogUtil.writeln(entry.getKey()+"="+entry.getValue());
		}
    	
    }
    
    public static String getEventId(Object target, Notification notification) {
        String eventid="--";
        
        Object notifier = notification.getNotifier();
        Object newValue = notification.getNewValue();
        Object oldValue = notification.getOldValue();
        int eventType = notification.getEventType();
        
        
        if (eventType == Notification.REMOVING_ADAPTER) {
            eventid = "99";
        } else if (notifier instanceof Model) {
            if (target instanceof LVTree) {
                switch (eventType) {
                case Notification.ADD:
                    eventid = "01";
                    break;
                case Notification.REMOVE:
                    eventid = "02";
                    break;
                }
            } else if (target instanceof LVDiag) {
                switch (eventType) {
                case Notification.REMOVE:
                    eventid = "03";
                    break;
                }
            }
        } else if (notifier instanceof Package) {
            if (target instanceof LVTree) {
                switch (eventType) {
                case Notification.ADD:
                    eventid = "04";
                    break;
                case Notification.SET:
                    eventid = "05";
                    break;
                case Notification.REMOVE:
                    eventid = "06";
                    break;
                }                
            } else if (target instanceof LVDiag) {
                switch (eventType) {
                case Notification.REMOVE:
                    eventid = "07";
                    break;
                }                
            }
        } else if (notifier instanceof Class) {
            if (target instanceof LVTree) {
                switch (eventType) {
                case Notification.ADD:
                    eventid = "08";
                    break;
                case Notification.SET:
                    eventid = "09";
                    break;
                case Notification.REMOVE:
                    eventid = "10";
                    break;
                }                
            } else if (target instanceof LVDiag) {
                switch (eventType) {
                case Notification.REMOVE:
                    eventid = "11";
                    break;
                }                
            } else if (target instanceof LVDiagFigure) {
                switch (eventType) {
                case Notification.ADD:
                    eventid = "12";
                    break;
                case Notification.SET:
                    eventid = "13";
                    break;
                case Notification.REMOVE:
                    eventid = "14";
                    break;
                }                
            }
        } else if (notifier instanceof Interface) {
            if (target instanceof LVTree) {
                switch (eventType) {
                case Notification.ADD:
                    eventid = "15";
                    break;
                case Notification.SET:
                    eventid = "16";
                    break;
                case Notification.REMOVE:
                    eventid = "17";
                    break;
                }                
            } else if (target instanceof LVDiag) {
                switch (eventType) {
                case Notification.REMOVE:
                    eventid = "18";
                    break;
                }                
            } else if (target instanceof LVDiagFigure) {
                switch (eventType) {
                case Notification.ADD:
                    eventid = "19";
                    break;
                case Notification.SET:
                    eventid = "20";
                    break;
                case Notification.REMOVE:
                    eventid = "21";
                    break;
                }                
            }
        } else if (notifier instanceof Property) {
            if (target instanceof LVTree || target instanceof LVDiagFigure) {
                switch (eventType) {
                case Notification.SET:
                    eventid = "22";
                    break;
                }                
            }
        } else if (notifier instanceof Operation) {
            if (target instanceof LVTree || target instanceof LVDiagFigure) {
                switch (eventType) {
                case Notification.SET:
                    eventid = "23";
                    break;
                }                
            }
        } else if (notifier instanceof Comment) {
            if (target instanceof LVDiagFigure) {
                switch (eventType) {
                case Notification.SET:
                    eventid = "24";
                    break;
                }                
            }
        } else if (notifier instanceof Diagram) {
            if (target instanceof LVTree) {
                switch (eventType) {
                case Notification.ADD:
                    eventid = "51";
                    break;
                case Notification.SET:
                    eventid = "52";
                    break;
                case Notification.REMOVE:
                    eventid = "53";
                    break;
                }                
            } else if (target instanceof LVDiagFolder) {
                switch (eventType) {
                case Notification.ADD:
                    if (!(newValue instanceof Diagram) &&
                         (newValue instanceof GraphNode || newValue instanceof GraphEdge)) {
                        eventid = "56";
                    }
                    break;
                case Notification.SET:
                    eventid = "54";
                    break;
                case Notification.REMOVE:
                    if (oldValue instanceof Diagram) {
                        eventid = "55";
                    } else if (!(oldValue instanceof Diagram) &&
                                 (oldValue instanceof GraphNode || oldValue instanceof GraphEdge)) {
                        eventid = "57";
                    }
                    break;
                }                
            } else if (target instanceof LVDiag) {
                switch (eventType) {
                case Notification.ADD:
                    if (!(newValue instanceof Diagram) &&
                         (newValue instanceof GraphNode || newValue instanceof GraphEdge)) {
                        eventid = "56";
                    }
                    break;
                case Notification.REMOVE:
                    if (!(oldValue instanceof Diagram) &&
                         (oldValue instanceof GraphNode || oldValue instanceof GraphEdge)) {
                        eventid = "57";
                    }
                    break;
                }                
            }
        } else if (notifier instanceof GraphNode) {
            if (target instanceof LVDiagFigure) {
                switch (eventType) {
                case Notification.SET:
                    eventid = "58";
                    break;
                }                
            }
        } else if (notifier instanceof GraphEdge) {
            if (target instanceof LVDiagFigure) {
                switch (eventType) {
                case Notification.SET:
                    eventid = "59";
                    break;
                }                
            }
        }
        
        return eventid;
    }
}
