/**
 * <copyright>
 * </copyright>
 *
 * $Id: DIAdapterFactory.java,v 1.2 2004/02/19 18:23:42 ohnuki Exp $
 */
package latte.di.util;

import latte.di.*;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notifier;

import org.eclipse.emf.common.notify.impl.AdapterFactoryImpl;

import org.eclipse.emf.ecore.EObject;

/**
 * <!-- begin-user-doc -->
 * The <b>Adapter Factory</b> for the model.
 * It provides an adapter <code>createXXX</code> method for each class of the model.
 * <!-- end-user-doc -->
 * @see latte.di.DIPackage
 * @generated
 */
public class DIAdapterFactory extends AdapterFactoryImpl {
    /**
     * The cached model package.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected static DIPackage modelPackage;

    /**
     * Creates an instance of the adapter factory.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public DIAdapterFactory() {
        if (modelPackage == null) {
            modelPackage = DIPackage.eINSTANCE;
        }
    }

    /**
     * Returns whether this factory is applicable for the type of the object.
     * <!-- begin-user-doc -->
     * This implementation returns <code>true</code> if the object is either the model's package or is an instance object of the model.
     * <!-- end-user-doc -->
     * @return whether this factory is applicable for the type of the object.
     * @generated
     */
    public boolean isFactoryForType(Object object) {
        if (object == modelPackage) {
            return true;
        }
        if (object instanceof EObject) {
            return ((EObject)object).eClass().getEPackage() == modelPackage;
        }
        return false;
    }

    /**
     * The switch the delegates to the <code>createXXX</code> methods.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DISwitch modelSwitch =
        new DISwitch() {
            public Object caseCoreSemanticModelBridge(CoreSemanticModelBridge object) {
                return createCoreSemanticModelBridgeAdapter();
            }
            public Object caseReference(Reference object) {
                return createReferenceAdapter();
            }
            public Object caseDiagram(Diagram object) {
                return createDiagramAdapter();
            }
            public Object caseDiagramElement(DiagramElement object) {
                return createDiagramElementAdapter();
            }
            public Object caseDiagramLink(DiagramLink object) {
                return createDiagramLinkAdapter();
            }
            public Object caseGraphConnector(GraphConnector object) {
                return createGraphConnectorAdapter();
            }
            public Object caseGraphEdge(GraphEdge object) {
                return createGraphEdgeAdapter();
            }
            public Object caseGraphElement(GraphElement object) {
                return createGraphElementAdapter();
            }
            public Object caseGraphNode(GraphNode object) {
                return createGraphNodeAdapter();
            }
            public Object caseGraphicPrimitive(GraphicPrimitive object) {
                return createGraphicPrimitiveAdapter();
            }
            public Object caseImage(Image object) {
                return createImageAdapter();
            }
            public Object caseLeafElement(LeafElement object) {
                return createLeafElementAdapter();
            }
            public Object caseProperty(Property object) {
                return createPropertyAdapter();
            }
            public Object caseSemanticModelBridge(SemanticModelBridge object) {
                return createSemanticModelBridgeAdapter();
            }
            public Object caseSimpleSemanticModelElement(SimpleSemanticModelElement object) {
                return createSimpleSemanticModelElementAdapter();
            }
            public Object caseTextElement(TextElement object) {
                return createTextElementAdapter();
            }
            public Object casePoint(Point object) {
                return createPointAdapter();
            }
            public Object caseDimension(Dimension object) {
                return createDimensionAdapter();
            }
            public Object defaultCase(EObject object) {
                return createEObjectAdapter();
            }
        };

    /**
     * Creates an adapter for the <code>target</code>.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @param target the object to adapt.
     * @return the adapter for the <code>target</code>.
     * @generated
     */
    public Adapter createAdapter(Notifier target) {
        return (Adapter)modelSwitch.doSwitch((EObject)target);
    }


    /**
     * Creates a new adapter for an object of class '{@link latte.di.CoreSemanticModelBridge <em>Core Semantic Model Bridge</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.CoreSemanticModelBridge
     * @generated
     */
    public Adapter createCoreSemanticModelBridgeAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.Reference <em>Reference</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.Reference
     * @generated
     */
    public Adapter createReferenceAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.Diagram <em>Diagram</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.Diagram
     * @generated
     */
    public Adapter createDiagramAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.DiagramElement <em>Diagram Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.DiagramElement
     * @generated
     */
    public Adapter createDiagramElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.DiagramLink <em>Diagram Link</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.DiagramLink
     * @generated
     */
    public Adapter createDiagramLinkAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.GraphConnector <em>Graph Connector</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.GraphConnector
     * @generated
     */
    public Adapter createGraphConnectorAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.GraphEdge <em>Graph Edge</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.GraphEdge
     * @generated
     */
    public Adapter createGraphEdgeAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.GraphElement <em>Graph Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.GraphElement
     * @generated
     */
    public Adapter createGraphElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.GraphNode <em>Graph Node</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.GraphNode
     * @generated
     */
    public Adapter createGraphNodeAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.GraphicPrimitive <em>Graphic Primitive</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.GraphicPrimitive
     * @generated
     */
    public Adapter createGraphicPrimitiveAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.Image <em>Image</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.Image
     * @generated
     */
    public Adapter createImageAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.LeafElement <em>Leaf Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.LeafElement
     * @generated
     */
    public Adapter createLeafElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.Property <em>Property</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.Property
     * @generated
     */
    public Adapter createPropertyAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.SemanticModelBridge <em>Semantic Model Bridge</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.SemanticModelBridge
     * @generated
     */
    public Adapter createSemanticModelBridgeAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.SimpleSemanticModelElement <em>Simple Semantic Model Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.SimpleSemanticModelElement
     * @generated
     */
    public Adapter createSimpleSemanticModelElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.TextElement <em>Text Element</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.TextElement
     * @generated
     */
    public Adapter createTextElementAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.Point <em>Point</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.Point
     * @generated
     */
    public Adapter createPointAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for an object of class '{@link latte.di.Dimension <em>Dimension</em>}'.
     * <!-- begin-user-doc -->
     * This default implementation returns null so that we can easily ignore cases;
     * it's useful to ignore a case when inheritance will catch all the cases anyway.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @see latte.di.Dimension
     * @generated
     */
    public Adapter createDimensionAdapter() {
        return null;
    }

    /**
     * Creates a new adapter for the default case.
     * <!-- begin-user-doc -->
     * This default implementation returns null.
     * <!-- end-user-doc -->
     * @return the new adapter.
     * @generated
     */
    public Adapter createEObjectAdapter() {
        return null;
    }

} //DIAdapterFactory
