/**
 * <copyright>
 * </copyright>
 *
 * $Id: TextElementImpl.java,v 1.2 2004/02/19 18:23:32 ohnuki Exp $
 */
package latte.di.impl;

import java.util.Collection;

import latte.di.DIPackage;
import latte.di.GraphElement;
import latte.di.TextElement;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Text Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.TextElementImpl#getText <em>Text</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class TextElementImpl extends LeafElementImpl implements TextElement {
    /**
     * The default value of the '{@link #getText() <em>Text</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getText()
     * @generated
     * @ordered
     */
    protected static final String TEXT_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getText() <em>Text</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getText()
     * @generated
     * @ordered
     */
    protected String text = TEXT_EDEFAULT;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected TextElementImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getTextElement();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getText() {
        return text;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setText(String newText) {
        String oldText = text;
        text = newText;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.TEXT_ELEMENT__TEXT, oldText, text));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.TEXT_ELEMENT__CONTAINER:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.TEXT_ELEMENT__CONTAINER, msgs);
                case DIPackage.TEXT_ELEMENT__REFERENCE:
                    return ((InternalEList)getReference()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.TEXT_ELEMENT__CONTAINER:
                    return eBasicSetContainer(null, DIPackage.TEXT_ELEMENT__CONTAINER, msgs);
                case DIPackage.TEXT_ELEMENT__REFERENCE:
                    return ((InternalEList)getReference()).basicRemove(otherEnd, msgs);
                case DIPackage.TEXT_ELEMENT__PROPERTY:
                    return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.TEXT_ELEMENT__CONTAINER:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__CONTAINED, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.TEXT_ELEMENT__VISIBLE:
                return isVisible() ? Boolean.TRUE : Boolean.FALSE;
            case DIPackage.TEXT_ELEMENT__CONTAINER:
                return getContainer();
            case DIPackage.TEXT_ELEMENT__REFERENCE:
                return getReference();
            case DIPackage.TEXT_ELEMENT__PROPERTY:
                return getProperty();
            case DIPackage.TEXT_ELEMENT__TEXT:
                return getText();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.TEXT_ELEMENT__VISIBLE:
                setVisible(((Boolean)newValue).booleanValue());
                return;
            case DIPackage.TEXT_ELEMENT__CONTAINER:
                setContainer((GraphElement)newValue);
                return;
            case DIPackage.TEXT_ELEMENT__REFERENCE:
                getReference().clear();
                getReference().addAll((Collection)newValue);
                return;
            case DIPackage.TEXT_ELEMENT__PROPERTY:
                getProperty().clear();
                getProperty().addAll((Collection)newValue);
                return;
            case DIPackage.TEXT_ELEMENT__TEXT:
                setText((String)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.TEXT_ELEMENT__VISIBLE:
                setVisible(VISIBLE_EDEFAULT);
                return;
            case DIPackage.TEXT_ELEMENT__CONTAINER:
                setContainer((GraphElement)null);
                return;
            case DIPackage.TEXT_ELEMENT__REFERENCE:
                getReference().clear();
                return;
            case DIPackage.TEXT_ELEMENT__PROPERTY:
                getProperty().clear();
                return;
            case DIPackage.TEXT_ELEMENT__TEXT:
                setText(TEXT_EDEFAULT);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.TEXT_ELEMENT__VISIBLE:
                return visible != VISIBLE_EDEFAULT;
            case DIPackage.TEXT_ELEMENT__CONTAINER:
                return getContainer() != null;
            case DIPackage.TEXT_ELEMENT__REFERENCE:
                return reference != null && !reference.isEmpty();
            case DIPackage.TEXT_ELEMENT__PROPERTY:
                return property != null && !property.isEmpty();
            case DIPackage.TEXT_ELEMENT__TEXT:
                return TEXT_EDEFAULT == null ? text != null : !TEXT_EDEFAULT.equals(text);
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (text: ");
        result.append(text);
        result.append(')');
        return result.toString();
    }

} //TextElementImpl
