/**
 * <copyright>
 * </copyright>
 *
 * $Id: GraphNodeImpl.java,v 1.2 2004/02/19 18:23:34 ohnuki Exp $
 */
package latte.di.impl;

import java.util.Collection;

import latte.di.DIPackage;
import latte.di.Dimension;
import latte.di.GraphElement;
import latte.di.GraphNode;
import latte.di.Point;
import latte.di.SemanticModelBridge;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Graph Node</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.GraphNodeImpl#getSize <em>Size</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class GraphNodeImpl extends GraphElementImpl implements GraphNode {
    /**
     * The cached value of the '{@link #getSize() <em>Size</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSize()
     * @generated
     * @ordered
     */
    protected Dimension size = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GraphNodeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getGraphNode();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Dimension getSize() {
        return size;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetSize(Dimension newSize, NotificationChain msgs) {
        Dimension oldSize = size;
        size = newSize;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DIPackage.GRAPH_NODE__SIZE, oldSize, newSize);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSize(Dimension newSize) {
        if (newSize != size) {
            NotificationChain msgs = null;
            if (size != null)
                msgs = ((InternalEObject)size).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.GRAPH_NODE__SIZE, null, msgs);
            if (newSize != null)
                msgs = ((InternalEObject)newSize).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DIPackage.GRAPH_NODE__SIZE, null, msgs);
            msgs = basicSetSize(newSize, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.GRAPH_NODE__SIZE, newSize, newSize));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.GRAPH_NODE__CONTAINER:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.GRAPH_NODE__CONTAINER, msgs);
                case DIPackage.GRAPH_NODE__REFERENCE:
                    return ((InternalEList)getReference()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_NODE__CONTAINED:
                    return ((InternalEList)getContained()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_NODE__LINK:
                    return ((InternalEList)getLink()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_NODE__ANCHORAGE:
                    return ((InternalEList)getAnchorage()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_NODE__SEMANTIC_MODEL:
                    if (semanticModel != null)
                        msgs = ((InternalEObject)semanticModel).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.GRAPH_NODE__SEMANTIC_MODEL, null, msgs);
                    return basicSetSemanticModel((SemanticModelBridge)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.GRAPH_NODE__CONTAINER:
                    return eBasicSetContainer(null, DIPackage.GRAPH_NODE__CONTAINER, msgs);
                case DIPackage.GRAPH_NODE__REFERENCE:
                    return ((InternalEList)getReference()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_NODE__PROPERTY:
                    return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_NODE__POSITION:
                    return basicSetPosition(null, msgs);
                case DIPackage.GRAPH_NODE__CONTAINED:
                    return ((InternalEList)getContained()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_NODE__LINK:
                    return ((InternalEList)getLink()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_NODE__ANCHORAGE:
                    return ((InternalEList)getAnchorage()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_NODE__SEMANTIC_MODEL:
                    return basicSetSemanticModel(null, msgs);
                case DIPackage.GRAPH_NODE__SIZE:
                    return basicSetSize(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.GRAPH_NODE__CONTAINER:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__CONTAINED, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_NODE__VISIBLE:
                return isVisible() ? Boolean.TRUE : Boolean.FALSE;
            case DIPackage.GRAPH_NODE__CONTAINER:
                return getContainer();
            case DIPackage.GRAPH_NODE__REFERENCE:
                return getReference();
            case DIPackage.GRAPH_NODE__PROPERTY:
                return getProperty();
            case DIPackage.GRAPH_NODE__POSITION:
                return getPosition();
            case DIPackage.GRAPH_NODE__CONTAINED:
                return getContained();
            case DIPackage.GRAPH_NODE__LINK:
                return getLink();
            case DIPackage.GRAPH_NODE__ANCHORAGE:
                return getAnchorage();
            case DIPackage.GRAPH_NODE__SEMANTIC_MODEL:
                return getSemanticModel();
            case DIPackage.GRAPH_NODE__SIZE:
                return getSize();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_NODE__VISIBLE:
                setVisible(((Boolean)newValue).booleanValue());
                return;
            case DIPackage.GRAPH_NODE__CONTAINER:
                setContainer((GraphElement)newValue);
                return;
            case DIPackage.GRAPH_NODE__REFERENCE:
                getReference().clear();
                getReference().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_NODE__PROPERTY:
                getProperty().clear();
                getProperty().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_NODE__POSITION:
                setPosition((Point)newValue);
                return;
            case DIPackage.GRAPH_NODE__CONTAINED:
                getContained().clear();
                getContained().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_NODE__LINK:
                getLink().clear();
                getLink().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_NODE__ANCHORAGE:
                getAnchorage().clear();
                getAnchorage().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_NODE__SEMANTIC_MODEL:
                setSemanticModel((SemanticModelBridge)newValue);
                return;
            case DIPackage.GRAPH_NODE__SIZE:
                setSize((Dimension)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_NODE__VISIBLE:
                setVisible(VISIBLE_EDEFAULT);
                return;
            case DIPackage.GRAPH_NODE__CONTAINER:
                setContainer((GraphElement)null);
                return;
            case DIPackage.GRAPH_NODE__REFERENCE:
                getReference().clear();
                return;
            case DIPackage.GRAPH_NODE__PROPERTY:
                getProperty().clear();
                return;
            case DIPackage.GRAPH_NODE__POSITION:
                setPosition((Point)null);
                return;
            case DIPackage.GRAPH_NODE__CONTAINED:
                getContained().clear();
                return;
            case DIPackage.GRAPH_NODE__LINK:
                getLink().clear();
                return;
            case DIPackage.GRAPH_NODE__ANCHORAGE:
                getAnchorage().clear();
                return;
            case DIPackage.GRAPH_NODE__SEMANTIC_MODEL:
                setSemanticModel((SemanticModelBridge)null);
                return;
            case DIPackage.GRAPH_NODE__SIZE:
                setSize((Dimension)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_NODE__VISIBLE:
                return visible != VISIBLE_EDEFAULT;
            case DIPackage.GRAPH_NODE__CONTAINER:
                return getContainer() != null;
            case DIPackage.GRAPH_NODE__REFERENCE:
                return reference != null && !reference.isEmpty();
            case DIPackage.GRAPH_NODE__PROPERTY:
                return property != null && !property.isEmpty();
            case DIPackage.GRAPH_NODE__POSITION:
                return position != null;
            case DIPackage.GRAPH_NODE__CONTAINED:
                return contained != null && !contained.isEmpty();
            case DIPackage.GRAPH_NODE__LINK:
                return link != null && !link.isEmpty();
            case DIPackage.GRAPH_NODE__ANCHORAGE:
                return anchorage != null && !anchorage.isEmpty();
            case DIPackage.GRAPH_NODE__SEMANTIC_MODEL:
                return semanticModel != null;
            case DIPackage.GRAPH_NODE__SIZE:
                return size != null;
        }
        return eDynamicIsSet(eFeature);
    }

} //GraphNodeImpl
