/**
 * <copyright>
 * </copyright>
 *
 * $Id: GraphElementImpl.java,v 1.2 2004/02/19 18:23:33 ohnuki Exp $
 */
package latte.di.impl;

import java.util.Collection;

import latte.di.DIPackage;
import latte.di.DiagramElement;
import latte.di.DiagramLink;
import latte.di.GraphConnector;
import latte.di.GraphElement;
import latte.di.Point;
import latte.di.SemanticModelBridge;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentWithInverseEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Graph Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.GraphElementImpl#getPosition <em>Position</em>}</li>
 *   <li>{@link latte.di.impl.GraphElementImpl#getContained <em>Contained</em>}</li>
 *   <li>{@link latte.di.impl.GraphElementImpl#getLink <em>Link</em>}</li>
 *   <li>{@link latte.di.impl.GraphElementImpl#getAnchorage <em>Anchorage</em>}</li>
 *   <li>{@link latte.di.impl.GraphElementImpl#getSemanticModel <em>Semantic Model</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class GraphElementImpl extends DiagramElementImpl implements GraphElement {
    /**
     * The cached value of the '{@link #getPosition() <em>Position</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPosition()
     * @generated
     * @ordered
     */
    protected Point position = null;

    /**
     * The cached value of the '{@link #getContained() <em>Contained</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getContained()
     * @generated
     * @ordered
     */
    protected EList contained = null;

    /**
     * The cached value of the '{@link #getLink() <em>Link</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getLink()
     * @generated
     * @ordered
     */
    protected EList link = null;

    /**
     * The cached value of the '{@link #getAnchorage() <em>Anchorage</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAnchorage()
     * @generated
     * @ordered
     */
    protected EList anchorage = null;

    /**
     * The cached value of the '{@link #getSemanticModel() <em>Semantic Model</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getSemanticModel()
     * @generated
     * @ordered
     */
    protected SemanticModelBridge semanticModel = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GraphElementImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getGraphElement();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Point getPosition() {
        return position;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetPosition(Point newPosition, NotificationChain msgs) {
        Point oldPosition = position;
        position = newPosition;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DIPackage.GRAPH_ELEMENT__POSITION, oldPosition, newPosition);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setPosition(Point newPosition) {
        if (newPosition != position) {
            NotificationChain msgs = null;
            if (position != null)
                msgs = ((InternalEObject)position).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.GRAPH_ELEMENT__POSITION, null, msgs);
            if (newPosition != null)
                msgs = ((InternalEObject)newPosition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DIPackage.GRAPH_ELEMENT__POSITION, null, msgs);
            msgs = basicSetPosition(newPosition, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.GRAPH_ELEMENT__POSITION, newPosition, newPosition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getContained() {
        if (contained == null) {
            contained = new EObjectContainmentWithInverseEList(DiagramElement.class, this, DIPackage.GRAPH_ELEMENT__CONTAINED, DIPackage.DIAGRAM_ELEMENT__CONTAINER);
        }
        return contained;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getLink() {
        if (link == null) {
            link = new EObjectContainmentWithInverseEList(DiagramLink.class, this, DIPackage.GRAPH_ELEMENT__LINK, DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT);
        }
        return link;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getAnchorage() {
        if (anchorage == null) {
            anchorage = new EObjectContainmentWithInverseEList(GraphConnector.class, this, DIPackage.GRAPH_ELEMENT__ANCHORAGE, DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT);
        }
        return anchorage;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public SemanticModelBridge getSemanticModel() {
        return semanticModel;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetSemanticModel(SemanticModelBridge newSemanticModel, NotificationChain msgs) {
        SemanticModelBridge oldSemanticModel = semanticModel;
        semanticModel = newSemanticModel;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL, oldSemanticModel, newSemanticModel);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setSemanticModel(SemanticModelBridge newSemanticModel) {
        if (newSemanticModel != semanticModel) {
            NotificationChain msgs = null;
            if (semanticModel != null)
                msgs = ((InternalEObject)semanticModel).eInverseRemove(this, DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT, SemanticModelBridge.class, msgs);
            if (newSemanticModel != null)
                msgs = ((InternalEObject)newSemanticModel).eInverseAdd(this, DIPackage.SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT, SemanticModelBridge.class, msgs);
            msgs = basicSetSemanticModel(newSemanticModel, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL, newSemanticModel, newSemanticModel));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.GRAPH_ELEMENT__CONTAINER:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.GRAPH_ELEMENT__CONTAINER, msgs);
                case DIPackage.GRAPH_ELEMENT__REFERENCE:
                    return ((InternalEList)getReference()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_ELEMENT__CONTAINED:
                    return ((InternalEList)getContained()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_ELEMENT__LINK:
                    return ((InternalEList)getLink()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_ELEMENT__ANCHORAGE:
                    return ((InternalEList)getAnchorage()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL:
                    if (semanticModel != null)
                        msgs = ((InternalEObject)semanticModel).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL, null, msgs);
                    return basicSetSemanticModel((SemanticModelBridge)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.GRAPH_ELEMENT__CONTAINER:
                    return eBasicSetContainer(null, DIPackage.GRAPH_ELEMENT__CONTAINER, msgs);
                case DIPackage.GRAPH_ELEMENT__REFERENCE:
                    return ((InternalEList)getReference()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_ELEMENT__PROPERTY:
                    return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_ELEMENT__POSITION:
                    return basicSetPosition(null, msgs);
                case DIPackage.GRAPH_ELEMENT__CONTAINED:
                    return ((InternalEList)getContained()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_ELEMENT__LINK:
                    return ((InternalEList)getLink()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_ELEMENT__ANCHORAGE:
                    return ((InternalEList)getAnchorage()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL:
                    return basicSetSemanticModel(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.GRAPH_ELEMENT__CONTAINER:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__CONTAINED, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_ELEMENT__VISIBLE:
                return isVisible() ? Boolean.TRUE : Boolean.FALSE;
            case DIPackage.GRAPH_ELEMENT__CONTAINER:
                return getContainer();
            case DIPackage.GRAPH_ELEMENT__REFERENCE:
                return getReference();
            case DIPackage.GRAPH_ELEMENT__PROPERTY:
                return getProperty();
            case DIPackage.GRAPH_ELEMENT__POSITION:
                return getPosition();
            case DIPackage.GRAPH_ELEMENT__CONTAINED:
                return getContained();
            case DIPackage.GRAPH_ELEMENT__LINK:
                return getLink();
            case DIPackage.GRAPH_ELEMENT__ANCHORAGE:
                return getAnchorage();
            case DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL:
                return getSemanticModel();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_ELEMENT__VISIBLE:
                setVisible(((Boolean)newValue).booleanValue());
                return;
            case DIPackage.GRAPH_ELEMENT__CONTAINER:
                setContainer((GraphElement)newValue);
                return;
            case DIPackage.GRAPH_ELEMENT__REFERENCE:
                getReference().clear();
                getReference().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_ELEMENT__PROPERTY:
                getProperty().clear();
                getProperty().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_ELEMENT__POSITION:
                setPosition((Point)newValue);
                return;
            case DIPackage.GRAPH_ELEMENT__CONTAINED:
                getContained().clear();
                getContained().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_ELEMENT__LINK:
                getLink().clear();
                getLink().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_ELEMENT__ANCHORAGE:
                getAnchorage().clear();
                getAnchorage().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL:
                setSemanticModel((SemanticModelBridge)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_ELEMENT__VISIBLE:
                setVisible(VISIBLE_EDEFAULT);
                return;
            case DIPackage.GRAPH_ELEMENT__CONTAINER:
                setContainer((GraphElement)null);
                return;
            case DIPackage.GRAPH_ELEMENT__REFERENCE:
                getReference().clear();
                return;
            case DIPackage.GRAPH_ELEMENT__PROPERTY:
                getProperty().clear();
                return;
            case DIPackage.GRAPH_ELEMENT__POSITION:
                setPosition((Point)null);
                return;
            case DIPackage.GRAPH_ELEMENT__CONTAINED:
                getContained().clear();
                return;
            case DIPackage.GRAPH_ELEMENT__LINK:
                getLink().clear();
                return;
            case DIPackage.GRAPH_ELEMENT__ANCHORAGE:
                getAnchorage().clear();
                return;
            case DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL:
                setSemanticModel((SemanticModelBridge)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_ELEMENT__VISIBLE:
                return visible != VISIBLE_EDEFAULT;
            case DIPackage.GRAPH_ELEMENT__CONTAINER:
                return getContainer() != null;
            case DIPackage.GRAPH_ELEMENT__REFERENCE:
                return reference != null && !reference.isEmpty();
            case DIPackage.GRAPH_ELEMENT__PROPERTY:
                return property != null && !property.isEmpty();
            case DIPackage.GRAPH_ELEMENT__POSITION:
                return position != null;
            case DIPackage.GRAPH_ELEMENT__CONTAINED:
                return contained != null && !contained.isEmpty();
            case DIPackage.GRAPH_ELEMENT__LINK:
                return link != null && !link.isEmpty();
            case DIPackage.GRAPH_ELEMENT__ANCHORAGE:
                return anchorage != null && !anchorage.isEmpty();
            case DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL:
                return semanticModel != null;
        }
        return eDynamicIsSet(eFeature);
    }

} //GraphElementImpl
