/**
 * <copyright>
 * </copyright>
 *
 * $Id: GraphEdgeImpl.java,v 1.2 2004/02/19 18:23:34 ohnuki Exp $
 */
package latte.di.impl;

import java.util.Collection;

import latte.di.DIPackage;
import latte.di.GraphConnector;
import latte.di.GraphEdge;
import latte.di.GraphElement;
import latte.di.Point;
import latte.di.SemanticModelBridge;

import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Graph Edge</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.GraphEdgeImpl#getWaypoints <em>Waypoints</em>}</li>
 *   <li>{@link latte.di.impl.GraphEdgeImpl#getAnchor <em>Anchor</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class GraphEdgeImpl extends GraphElementImpl implements GraphEdge {
    /**
     * The cached value of the '{@link #getWaypoints() <em>Waypoints</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getWaypoints()
     * @generated
     * @ordered
     */
    protected EList waypoints = null;

    /**
     * The cached value of the '{@link #getAnchor() <em>Anchor</em>}' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getAnchor()
     * @generated
     * @ordered
     */
    protected EList anchor = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GraphEdgeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getGraphEdge();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getWaypoints() {
        if (waypoints == null) {
            waypoints = new EObjectContainmentEList(Point.class, this, DIPackage.GRAPH_EDGE__WAYPOINTS);
        }
        return waypoints;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getAnchor() {
        if (anchor == null) {
            anchor = new EObjectWithInverseResolvingEList.ManyInverse(GraphConnector.class, this, DIPackage.GRAPH_EDGE__ANCHOR, DIPackage.GRAPH_CONNECTOR__GRAPH_EDGE);
        }
        return anchor;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.GRAPH_EDGE__CONTAINER:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.GRAPH_EDGE__CONTAINER, msgs);
                case DIPackage.GRAPH_EDGE__REFERENCE:
                    return ((InternalEList)getReference()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__CONTAINED:
                    return ((InternalEList)getContained()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__LINK:
                    return ((InternalEList)getLink()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__ANCHORAGE:
                    return ((InternalEList)getAnchorage()).basicAdd(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__SEMANTIC_MODEL:
                    if (semanticModel != null)
                        msgs = ((InternalEObject)semanticModel).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.GRAPH_EDGE__SEMANTIC_MODEL, null, msgs);
                    return basicSetSemanticModel((SemanticModelBridge)otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__ANCHOR:
                    return ((InternalEList)getAnchor()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.GRAPH_EDGE__CONTAINER:
                    return eBasicSetContainer(null, DIPackage.GRAPH_EDGE__CONTAINER, msgs);
                case DIPackage.GRAPH_EDGE__REFERENCE:
                    return ((InternalEList)getReference()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__PROPERTY:
                    return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__POSITION:
                    return basicSetPosition(null, msgs);
                case DIPackage.GRAPH_EDGE__CONTAINED:
                    return ((InternalEList)getContained()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__LINK:
                    return ((InternalEList)getLink()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__ANCHORAGE:
                    return ((InternalEList)getAnchorage()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__SEMANTIC_MODEL:
                    return basicSetSemanticModel(null, msgs);
                case DIPackage.GRAPH_EDGE__WAYPOINTS:
                    return ((InternalEList)getWaypoints()).basicRemove(otherEnd, msgs);
                case DIPackage.GRAPH_EDGE__ANCHOR:
                    return ((InternalEList)getAnchor()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.GRAPH_EDGE__CONTAINER:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__CONTAINED, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_EDGE__VISIBLE:
                return isVisible() ? Boolean.TRUE : Boolean.FALSE;
            case DIPackage.GRAPH_EDGE__CONTAINER:
                return getContainer();
            case DIPackage.GRAPH_EDGE__REFERENCE:
                return getReference();
            case DIPackage.GRAPH_EDGE__PROPERTY:
                return getProperty();
            case DIPackage.GRAPH_EDGE__POSITION:
                return getPosition();
            case DIPackage.GRAPH_EDGE__CONTAINED:
                return getContained();
            case DIPackage.GRAPH_EDGE__LINK:
                return getLink();
            case DIPackage.GRAPH_EDGE__ANCHORAGE:
                return getAnchorage();
            case DIPackage.GRAPH_EDGE__SEMANTIC_MODEL:
                return getSemanticModel();
            case DIPackage.GRAPH_EDGE__WAYPOINTS:
                return getWaypoints();
            case DIPackage.GRAPH_EDGE__ANCHOR:
                return getAnchor();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_EDGE__VISIBLE:
                setVisible(((Boolean)newValue).booleanValue());
                return;
            case DIPackage.GRAPH_EDGE__CONTAINER:
                setContainer((GraphElement)newValue);
                return;
            case DIPackage.GRAPH_EDGE__REFERENCE:
                getReference().clear();
                getReference().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_EDGE__PROPERTY:
                getProperty().clear();
                getProperty().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_EDGE__POSITION:
                setPosition((Point)newValue);
                return;
            case DIPackage.GRAPH_EDGE__CONTAINED:
                getContained().clear();
                getContained().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_EDGE__LINK:
                getLink().clear();
                getLink().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_EDGE__ANCHORAGE:
                getAnchorage().clear();
                getAnchorage().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_EDGE__SEMANTIC_MODEL:
                setSemanticModel((SemanticModelBridge)newValue);
                return;
            case DIPackage.GRAPH_EDGE__WAYPOINTS:
                getWaypoints().clear();
                getWaypoints().addAll((Collection)newValue);
                return;
            case DIPackage.GRAPH_EDGE__ANCHOR:
                getAnchor().clear();
                getAnchor().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_EDGE__VISIBLE:
                setVisible(VISIBLE_EDEFAULT);
                return;
            case DIPackage.GRAPH_EDGE__CONTAINER:
                setContainer((GraphElement)null);
                return;
            case DIPackage.GRAPH_EDGE__REFERENCE:
                getReference().clear();
                return;
            case DIPackage.GRAPH_EDGE__PROPERTY:
                getProperty().clear();
                return;
            case DIPackage.GRAPH_EDGE__POSITION:
                setPosition((Point)null);
                return;
            case DIPackage.GRAPH_EDGE__CONTAINED:
                getContained().clear();
                return;
            case DIPackage.GRAPH_EDGE__LINK:
                getLink().clear();
                return;
            case DIPackage.GRAPH_EDGE__ANCHORAGE:
                getAnchorage().clear();
                return;
            case DIPackage.GRAPH_EDGE__SEMANTIC_MODEL:
                setSemanticModel((SemanticModelBridge)null);
                return;
            case DIPackage.GRAPH_EDGE__WAYPOINTS:
                getWaypoints().clear();
                return;
            case DIPackage.GRAPH_EDGE__ANCHOR:
                getAnchor().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_EDGE__VISIBLE:
                return visible != VISIBLE_EDEFAULT;
            case DIPackage.GRAPH_EDGE__CONTAINER:
                return getContainer() != null;
            case DIPackage.GRAPH_EDGE__REFERENCE:
                return reference != null && !reference.isEmpty();
            case DIPackage.GRAPH_EDGE__PROPERTY:
                return property != null && !property.isEmpty();
            case DIPackage.GRAPH_EDGE__POSITION:
                return position != null;
            case DIPackage.GRAPH_EDGE__CONTAINED:
                return contained != null && !contained.isEmpty();
            case DIPackage.GRAPH_EDGE__LINK:
                return link != null && !link.isEmpty();
            case DIPackage.GRAPH_EDGE__ANCHORAGE:
                return anchorage != null && !anchorage.isEmpty();
            case DIPackage.GRAPH_EDGE__SEMANTIC_MODEL:
                return semanticModel != null;
            case DIPackage.GRAPH_EDGE__WAYPOINTS:
                return waypoints != null && !waypoints.isEmpty();
            case DIPackage.GRAPH_EDGE__ANCHOR:
                return anchor != null && !anchor.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

} //GraphEdgeImpl
