/**
 * <copyright>
 * </copyright>
 *
 * $Id: GraphConnectorImpl.java,v 1.2 2004/02/19 18:23:34 ohnuki Exp $
 */
package latte.di.impl;

import java.util.Collection;

import latte.di.DIPackage;
import latte.di.GraphConnector;
import latte.di.GraphEdge;
import latte.di.GraphElement;
import latte.di.Point;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Graph Connector</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.GraphConnectorImpl#getPosition <em>Position</em>}</li>
 *   <li>{@link latte.di.impl.GraphConnectorImpl#getGraphElement <em>Graph Element</em>}</li>
 *   <li>{@link latte.di.impl.GraphConnectorImpl#getGraphEdge <em>Graph Edge</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class GraphConnectorImpl extends EObjectImpl implements GraphConnector {
    /**
     * The cached value of the '{@link #getPosition() <em>Position</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getPosition()
     * @generated
     * @ordered
     */
    protected Point position = null;

    /**
     * The cached value of the '{@link #getGraphEdge() <em>Graph Edge</em>}' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getGraphEdge()
     * @generated
     * @ordered
     */
    protected EList graphEdge = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected GraphConnectorImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getGraphConnector();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Point getPosition() {
        return position;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetPosition(Point newPosition, NotificationChain msgs) {
        Point oldPosition = position;
        position = newPosition;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DIPackage.GRAPH_CONNECTOR__POSITION, oldPosition, newPosition);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setPosition(Point newPosition) {
        if (newPosition != position) {
            NotificationChain msgs = null;
            if (position != null)
                msgs = ((InternalEObject)position).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.GRAPH_CONNECTOR__POSITION, null, msgs);
            if (newPosition != null)
                msgs = ((InternalEObject)newPosition).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DIPackage.GRAPH_CONNECTOR__POSITION, null, msgs);
            msgs = basicSetPosition(newPosition, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.GRAPH_CONNECTOR__POSITION, newPosition, newPosition));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public GraphElement getGraphElement() {
        if (eContainerFeatureID != DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT) return null;
        return (GraphElement)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setGraphElement(GraphElement newGraphElement) {
        if (newGraphElement != eContainer || (eContainerFeatureID != DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT && newGraphElement != null)) {
            if (EcoreUtil.isAncestor(this, newGraphElement))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newGraphElement != null)
                msgs = ((InternalEObject)newGraphElement).eInverseAdd(this, DIPackage.GRAPH_ELEMENT__ANCHORAGE, GraphElement.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newGraphElement, DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT, newGraphElement, newGraphElement));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getGraphEdge() {
        if (graphEdge == null) {
            graphEdge = new EObjectWithInverseResolvingEList.ManyInverse(GraphEdge.class, this, DIPackage.GRAPH_CONNECTOR__GRAPH_EDGE, DIPackage.GRAPH_EDGE__ANCHOR);
        }
        return graphEdge;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT, msgs);
                case DIPackage.GRAPH_CONNECTOR__GRAPH_EDGE:
                    return ((InternalEList)getGraphEdge()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.GRAPH_CONNECTOR__POSITION:
                    return basicSetPosition(null, msgs);
                case DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT:
                    return eBasicSetContainer(null, DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT, msgs);
                case DIPackage.GRAPH_CONNECTOR__GRAPH_EDGE:
                    return ((InternalEList)getGraphEdge()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__ANCHORAGE, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_CONNECTOR__POSITION:
                return getPosition();
            case DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT:
                return getGraphElement();
            case DIPackage.GRAPH_CONNECTOR__GRAPH_EDGE:
                return getGraphEdge();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_CONNECTOR__POSITION:
                setPosition((Point)newValue);
                return;
            case DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT:
                setGraphElement((GraphElement)newValue);
                return;
            case DIPackage.GRAPH_CONNECTOR__GRAPH_EDGE:
                getGraphEdge().clear();
                getGraphEdge().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_CONNECTOR__POSITION:
                setPosition((Point)null);
                return;
            case DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT:
                setGraphElement((GraphElement)null);
                return;
            case DIPackage.GRAPH_CONNECTOR__GRAPH_EDGE:
                getGraphEdge().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.GRAPH_CONNECTOR__POSITION:
                return position != null;
            case DIPackage.GRAPH_CONNECTOR__GRAPH_ELEMENT:
                return getGraphElement() != null;
            case DIPackage.GRAPH_CONNECTOR__GRAPH_EDGE:
                return graphEdge != null && !graphEdge.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

} //GraphConnectorImpl
