/**
 * <copyright>
 * </copyright>
 *
 * $Id: DiagramLinkImpl.java,v 1.2 2004/02/19 18:23:32 ohnuki Exp $
 */
package latte.di.impl;

import latte.di.DIPackage;
import latte.di.Diagram;
import latte.di.DiagramLink;
import latte.di.GraphElement;
import latte.di.Point;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EcoreUtil;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Diagram Link</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.DiagramLinkImpl#getZoom <em>Zoom</em>}</li>
 *   <li>{@link latte.di.impl.DiagramLinkImpl#getViewport <em>Viewport</em>}</li>
 *   <li>{@link latte.di.impl.DiagramLinkImpl#getGraphElement <em>Graph Element</em>}</li>
 *   <li>{@link latte.di.impl.DiagramLinkImpl#getDiagram <em>Diagram</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DiagramLinkImpl extends EObjectImpl implements DiagramLink {
    /**
     * The default value of the '{@link #getZoom() <em>Zoom</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getZoom()
     * @generated
     * @ordered
     */
    protected static final double ZOOM_EDEFAULT = 0.0;

    /**
     * The cached value of the '{@link #getZoom() <em>Zoom</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getZoom()
     * @generated
     * @ordered
     */
    protected double zoom = ZOOM_EDEFAULT;

    /**
     * The cached value of the '{@link #getViewport() <em>Viewport</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getViewport()
     * @generated
     * @ordered
     */
    protected Point viewport = null;

    /**
     * The cached value of the '{@link #getDiagram() <em>Diagram</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDiagram()
     * @generated
     * @ordered
     */
    protected Diagram diagram = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DiagramLinkImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getDiagramLink();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public double getZoom() {
        return zoom;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setZoom(double newZoom) {
        double oldZoom = zoom;
        zoom = newZoom;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM_LINK__ZOOM, oldZoom, zoom));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Point getViewport() {
        return viewport;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetViewport(Point newViewport, NotificationChain msgs) {
        Point oldViewport = viewport;
        viewport = newViewport;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM_LINK__VIEWPORT, oldViewport, newViewport);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setViewport(Point newViewport) {
        if (newViewport != viewport) {
            NotificationChain msgs = null;
            if (viewport != null)
                msgs = ((InternalEObject)viewport).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.DIAGRAM_LINK__VIEWPORT, null, msgs);
            if (newViewport != null)
                msgs = ((InternalEObject)newViewport).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DIPackage.DIAGRAM_LINK__VIEWPORT, null, msgs);
            msgs = basicSetViewport(newViewport, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM_LINK__VIEWPORT, newViewport, newViewport));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public GraphElement getGraphElement() {
        if (eContainerFeatureID != DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT) return null;
        return (GraphElement)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setGraphElement(GraphElement newGraphElement) {
        if (newGraphElement != eContainer || (eContainerFeatureID != DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT && newGraphElement != null)) {
            if (EcoreUtil.isAncestor(this, newGraphElement))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newGraphElement != null)
                msgs = ((InternalEObject)newGraphElement).eInverseAdd(this, DIPackage.GRAPH_ELEMENT__LINK, GraphElement.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newGraphElement, DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT, newGraphElement, newGraphElement));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Diagram getDiagram() {
        if (diagram != null && diagram.eIsProxy()) {
            Diagram oldDiagram = diagram;
            diagram = (Diagram)eResolveProxy((InternalEObject)diagram);
            if (diagram != oldDiagram) {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, DIPackage.DIAGRAM_LINK__DIAGRAM, oldDiagram, diagram));
            }
        }
        return diagram;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Diagram basicGetDiagram() {
        return diagram;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetDiagram(Diagram newDiagram, NotificationChain msgs) {
        Diagram oldDiagram = diagram;
        diagram = newDiagram;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM_LINK__DIAGRAM, oldDiagram, newDiagram);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setDiagram(Diagram newDiagram) {
        if (newDiagram != diagram) {
            NotificationChain msgs = null;
            if (diagram != null)
                msgs = ((InternalEObject)diagram).eInverseRemove(this, DIPackage.DIAGRAM__DIAGRAM_LINK, Diagram.class, msgs);
            if (newDiagram != null)
                msgs = ((InternalEObject)newDiagram).eInverseAdd(this, DIPackage.DIAGRAM__DIAGRAM_LINK, Diagram.class, msgs);
            msgs = basicSetDiagram(newDiagram, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM_LINK__DIAGRAM, newDiagram, newDiagram));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT, msgs);
                case DIPackage.DIAGRAM_LINK__DIAGRAM:
                    if (diagram != null)
                        msgs = ((InternalEObject)diagram).eInverseRemove(this, DIPackage.DIAGRAM__DIAGRAM_LINK, Diagram.class, msgs);
                    return basicSetDiagram((Diagram)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.DIAGRAM_LINK__VIEWPORT:
                    return basicSetViewport(null, msgs);
                case DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT:
                    return eBasicSetContainer(null, DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT, msgs);
                case DIPackage.DIAGRAM_LINK__DIAGRAM:
                    return basicSetDiagram(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__LINK, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM_LINK__ZOOM:
                return new Double(getZoom());
            case DIPackage.DIAGRAM_LINK__VIEWPORT:
                return getViewport();
            case DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT:
                return getGraphElement();
            case DIPackage.DIAGRAM_LINK__DIAGRAM:
                if (resolve) return getDiagram();
                return basicGetDiagram();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM_LINK__ZOOM:
                setZoom(((Double)newValue).doubleValue());
                return;
            case DIPackage.DIAGRAM_LINK__VIEWPORT:
                setViewport((Point)newValue);
                return;
            case DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT:
                setGraphElement((GraphElement)newValue);
                return;
            case DIPackage.DIAGRAM_LINK__DIAGRAM:
                setDiagram((Diagram)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM_LINK__ZOOM:
                setZoom(ZOOM_EDEFAULT);
                return;
            case DIPackage.DIAGRAM_LINK__VIEWPORT:
                setViewport((Point)null);
                return;
            case DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT:
                setGraphElement((GraphElement)null);
                return;
            case DIPackage.DIAGRAM_LINK__DIAGRAM:
                setDiagram((Diagram)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM_LINK__ZOOM:
                return zoom != ZOOM_EDEFAULT;
            case DIPackage.DIAGRAM_LINK__VIEWPORT:
                return viewport != null;
            case DIPackage.DIAGRAM_LINK__GRAPH_ELEMENT:
                return getGraphElement() != null;
            case DIPackage.DIAGRAM_LINK__DIAGRAM:
                return diagram != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (zoom: ");
        result.append(zoom);
        result.append(')');
        return result.toString();
    }

} //DiagramLinkImpl
