/**
 * <copyright>
 * </copyright>
 *
 * $Id: DiagramImpl.java,v 1.2 2004/02/19 18:23:33 ohnuki Exp $
 */
package latte.di.impl;

import java.util.Collection;

import latte.di.DIPackage;
import latte.di.Diagram;
import latte.di.DiagramLink;
import latte.di.Dimension;
import latte.di.GraphElement;
import latte.di.Point;
import latte.di.SemanticModelBridge;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Diagram</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.DiagramImpl#getName <em>Name</em>}</li>
 *   <li>{@link latte.di.impl.DiagramImpl#getZoom <em>Zoom</em>}</li>
 *   <li>{@link latte.di.impl.DiagramImpl#getViewport <em>Viewport</em>}</li>
 *   <li>{@link latte.di.impl.DiagramImpl#getDiagramLink <em>Diagram Link</em>}</li>
 *   <li>{@link latte.di.impl.DiagramImpl#getNamespace <em>Namespace</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class DiagramImpl extends GraphNodeImpl implements Diagram {
    /**
     * The default value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected static final String NAME_EDEFAULT = null;

    /**
     * The cached value of the '{@link #getName() <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getName()
     * @generated
     * @ordered
     */
    protected String name = NAME_EDEFAULT;

    /**
     * The default value of the '{@link #getZoom() <em>Zoom</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getZoom()
     * @generated
     * @ordered
     */
    protected static final double ZOOM_EDEFAULT = 0.0;

    /**
     * The cached value of the '{@link #getZoom() <em>Zoom</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getZoom()
     * @generated
     * @ordered
     */
    protected double zoom = ZOOM_EDEFAULT;

    /**
     * The cached value of the '{@link #getViewport() <em>Viewport</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getViewport()
     * @generated
     * @ordered
     */
    protected Point viewport = null;

    /**
     * The cached value of the '{@link #getDiagramLink() <em>Diagram Link</em>}' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getDiagramLink()
     * @generated
     * @ordered
     */
    protected EList diagramLink = null;

    /**
     * The cached value of the '{@link #getNamespace() <em>Namespace</em>}' containment reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getNamespace()
     * @generated
     * @ordered
     */
    protected SemanticModelBridge namespace = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DiagramImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getDiagram();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String getName() {
        return name;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setName(String newName) {
        String oldName = name;
        name = newName;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM__NAME, oldName, name));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public double getZoom() {
        return zoom;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setZoom(double newZoom) {
        double oldZoom = zoom;
        zoom = newZoom;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM__ZOOM, oldZoom, zoom));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Point getViewport() {
        return viewport;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetViewport(Point newViewport, NotificationChain msgs) {
        Point oldViewport = viewport;
        viewport = newViewport;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM__VIEWPORT, oldViewport, newViewport);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setViewport(Point newViewport) {
        if (newViewport != viewport) {
            NotificationChain msgs = null;
            if (viewport != null)
                msgs = ((InternalEObject)viewport).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.DIAGRAM__VIEWPORT, null, msgs);
            if (newViewport != null)
                msgs = ((InternalEObject)newViewport).eInverseAdd(this, EOPPOSITE_FEATURE_BASE - DIPackage.DIAGRAM__VIEWPORT, null, msgs);
            msgs = basicSetViewport(newViewport, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM__VIEWPORT, newViewport, newViewport));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getDiagramLink() {
        if (diagramLink == null) {
            diagramLink = new EObjectWithInverseResolvingEList(DiagramLink.class, this, DIPackage.DIAGRAM__DIAGRAM_LINK, DIPackage.DIAGRAM_LINK__DIAGRAM);
        }
        return diagramLink;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public SemanticModelBridge getNamespace() {
        return namespace;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain basicSetNamespace(SemanticModelBridge newNamespace, NotificationChain msgs) {
        SemanticModelBridge oldNamespace = namespace;
        namespace = newNamespace;
        if (eNotificationRequired()) {
            ENotificationImpl notification = new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM__NAMESPACE, oldNamespace, newNamespace);
            if (msgs == null) msgs = notification; else msgs.add(notification);
        }
        return msgs;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setNamespace(SemanticModelBridge newNamespace) {
        if (newNamespace != namespace) {
            NotificationChain msgs = null;
            if (namespace != null)
                msgs = ((InternalEObject)namespace).eInverseRemove(this, DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM, SemanticModelBridge.class, msgs);
            if (newNamespace != null)
                msgs = ((InternalEObject)newNamespace).eInverseAdd(this, DIPackage.SEMANTIC_MODEL_BRIDGE__DIAGRAM, SemanticModelBridge.class, msgs);
            msgs = basicSetNamespace(newNamespace, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM__NAMESPACE, newNamespace, newNamespace));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.DIAGRAM__CONTAINER:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.DIAGRAM__CONTAINER, msgs);
                case DIPackage.DIAGRAM__REFERENCE:
                    return ((InternalEList)getReference()).basicAdd(otherEnd, msgs);
                case DIPackage.DIAGRAM__CONTAINED:
                    return ((InternalEList)getContained()).basicAdd(otherEnd, msgs);
                case DIPackage.DIAGRAM__LINK:
                    return ((InternalEList)getLink()).basicAdd(otherEnd, msgs);
                case DIPackage.DIAGRAM__ANCHORAGE:
                    return ((InternalEList)getAnchorage()).basicAdd(otherEnd, msgs);
                case DIPackage.DIAGRAM__SEMANTIC_MODEL:
                    if (semanticModel != null)
                        msgs = ((InternalEObject)semanticModel).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.DIAGRAM__SEMANTIC_MODEL, null, msgs);
                    return basicSetSemanticModel((SemanticModelBridge)otherEnd, msgs);
                case DIPackage.DIAGRAM__DIAGRAM_LINK:
                    return ((InternalEList)getDiagramLink()).basicAdd(otherEnd, msgs);
                case DIPackage.DIAGRAM__NAMESPACE:
                    if (namespace != null)
                        msgs = ((InternalEObject)namespace).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - DIPackage.DIAGRAM__NAMESPACE, null, msgs);
                    return basicSetNamespace((SemanticModelBridge)otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.DIAGRAM__CONTAINER:
                    return eBasicSetContainer(null, DIPackage.DIAGRAM__CONTAINER, msgs);
                case DIPackage.DIAGRAM__REFERENCE:
                    return ((InternalEList)getReference()).basicRemove(otherEnd, msgs);
                case DIPackage.DIAGRAM__PROPERTY:
                    return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
                case DIPackage.DIAGRAM__POSITION:
                    return basicSetPosition(null, msgs);
                case DIPackage.DIAGRAM__CONTAINED:
                    return ((InternalEList)getContained()).basicRemove(otherEnd, msgs);
                case DIPackage.DIAGRAM__LINK:
                    return ((InternalEList)getLink()).basicRemove(otherEnd, msgs);
                case DIPackage.DIAGRAM__ANCHORAGE:
                    return ((InternalEList)getAnchorage()).basicRemove(otherEnd, msgs);
                case DIPackage.DIAGRAM__SEMANTIC_MODEL:
                    return basicSetSemanticModel(null, msgs);
                case DIPackage.DIAGRAM__SIZE:
                    return basicSetSize(null, msgs);
                case DIPackage.DIAGRAM__VIEWPORT:
                    return basicSetViewport(null, msgs);
                case DIPackage.DIAGRAM__DIAGRAM_LINK:
                    return ((InternalEList)getDiagramLink()).basicRemove(otherEnd, msgs);
                case DIPackage.DIAGRAM__NAMESPACE:
                    return basicSetNamespace(null, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.DIAGRAM__CONTAINER:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__CONTAINED, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM__VISIBLE:
                return isVisible() ? Boolean.TRUE : Boolean.FALSE;
            case DIPackage.DIAGRAM__CONTAINER:
                return getContainer();
            case DIPackage.DIAGRAM__REFERENCE:
                return getReference();
            case DIPackage.DIAGRAM__PROPERTY:
                return getProperty();
            case DIPackage.DIAGRAM__POSITION:
                return getPosition();
            case DIPackage.DIAGRAM__CONTAINED:
                return getContained();
            case DIPackage.DIAGRAM__LINK:
                return getLink();
            case DIPackage.DIAGRAM__ANCHORAGE:
                return getAnchorage();
            case DIPackage.DIAGRAM__SEMANTIC_MODEL:
                return getSemanticModel();
            case DIPackage.DIAGRAM__SIZE:
                return getSize();
            case DIPackage.DIAGRAM__NAME:
                return getName();
            case DIPackage.DIAGRAM__ZOOM:
                return new Double(getZoom());
            case DIPackage.DIAGRAM__VIEWPORT:
                return getViewport();
            case DIPackage.DIAGRAM__DIAGRAM_LINK:
                return getDiagramLink();
            case DIPackage.DIAGRAM__NAMESPACE:
                return getNamespace();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM__VISIBLE:
                setVisible(((Boolean)newValue).booleanValue());
                return;
            case DIPackage.DIAGRAM__CONTAINER:
                setContainer((GraphElement)newValue);
                return;
            case DIPackage.DIAGRAM__REFERENCE:
                getReference().clear();
                getReference().addAll((Collection)newValue);
                return;
            case DIPackage.DIAGRAM__PROPERTY:
                getProperty().clear();
                getProperty().addAll((Collection)newValue);
                return;
            case DIPackage.DIAGRAM__POSITION:
                setPosition((Point)newValue);
                return;
            case DIPackage.DIAGRAM__CONTAINED:
                getContained().clear();
                getContained().addAll((Collection)newValue);
                return;
            case DIPackage.DIAGRAM__LINK:
                getLink().clear();
                getLink().addAll((Collection)newValue);
                return;
            case DIPackage.DIAGRAM__ANCHORAGE:
                getAnchorage().clear();
                getAnchorage().addAll((Collection)newValue);
                return;
            case DIPackage.DIAGRAM__SEMANTIC_MODEL:
                setSemanticModel((SemanticModelBridge)newValue);
                return;
            case DIPackage.DIAGRAM__SIZE:
                setSize((Dimension)newValue);
                return;
            case DIPackage.DIAGRAM__NAME:
                setName((String)newValue);
                return;
            case DIPackage.DIAGRAM__ZOOM:
                setZoom(((Double)newValue).doubleValue());
                return;
            case DIPackage.DIAGRAM__VIEWPORT:
                setViewport((Point)newValue);
                return;
            case DIPackage.DIAGRAM__DIAGRAM_LINK:
                getDiagramLink().clear();
                getDiagramLink().addAll((Collection)newValue);
                return;
            case DIPackage.DIAGRAM__NAMESPACE:
                setNamespace((SemanticModelBridge)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM__VISIBLE:
                setVisible(VISIBLE_EDEFAULT);
                return;
            case DIPackage.DIAGRAM__CONTAINER:
                setContainer((GraphElement)null);
                return;
            case DIPackage.DIAGRAM__REFERENCE:
                getReference().clear();
                return;
            case DIPackage.DIAGRAM__PROPERTY:
                getProperty().clear();
                return;
            case DIPackage.DIAGRAM__POSITION:
                setPosition((Point)null);
                return;
            case DIPackage.DIAGRAM__CONTAINED:
                getContained().clear();
                return;
            case DIPackage.DIAGRAM__LINK:
                getLink().clear();
                return;
            case DIPackage.DIAGRAM__ANCHORAGE:
                getAnchorage().clear();
                return;
            case DIPackage.DIAGRAM__SEMANTIC_MODEL:
                setSemanticModel((SemanticModelBridge)null);
                return;
            case DIPackage.DIAGRAM__SIZE:
                setSize((Dimension)null);
                return;
            case DIPackage.DIAGRAM__NAME:
                setName(NAME_EDEFAULT);
                return;
            case DIPackage.DIAGRAM__ZOOM:
                setZoom(ZOOM_EDEFAULT);
                return;
            case DIPackage.DIAGRAM__VIEWPORT:
                setViewport((Point)null);
                return;
            case DIPackage.DIAGRAM__DIAGRAM_LINK:
                getDiagramLink().clear();
                return;
            case DIPackage.DIAGRAM__NAMESPACE:
                setNamespace((SemanticModelBridge)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM__VISIBLE:
                return visible != VISIBLE_EDEFAULT;
            case DIPackage.DIAGRAM__CONTAINER:
                return getContainer() != null;
            case DIPackage.DIAGRAM__REFERENCE:
                return reference != null && !reference.isEmpty();
            case DIPackage.DIAGRAM__PROPERTY:
                return property != null && !property.isEmpty();
            case DIPackage.DIAGRAM__POSITION:
                return position != null;
            case DIPackage.DIAGRAM__CONTAINED:
                return contained != null && !contained.isEmpty();
            case DIPackage.DIAGRAM__LINK:
                return link != null && !link.isEmpty();
            case DIPackage.DIAGRAM__ANCHORAGE:
                return anchorage != null && !anchorage.isEmpty();
            case DIPackage.DIAGRAM__SEMANTIC_MODEL:
                return semanticModel != null;
            case DIPackage.DIAGRAM__SIZE:
                return size != null;
            case DIPackage.DIAGRAM__NAME:
                return NAME_EDEFAULT == null ? name != null : !NAME_EDEFAULT.equals(name);
            case DIPackage.DIAGRAM__ZOOM:
                return zoom != ZOOM_EDEFAULT;
            case DIPackage.DIAGRAM__VIEWPORT:
                return viewport != null;
            case DIPackage.DIAGRAM__DIAGRAM_LINK:
                return diagramLink != null && !diagramLink.isEmpty();
            case DIPackage.DIAGRAM__NAMESPACE:
                return namespace != null;
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (name: ");
        result.append(name);
        result.append(", zoom: ");
        result.append(zoom);
        result.append(')');
        return result.toString();
    }

} //DiagramImpl
