/**
 * <copyright>
 * </copyright>
 *
 * $Id: DiagramElementImpl.java,v 1.2 2004/02/19 18:23:32 ohnuki Exp $
 */
package latte.di.impl;

import java.util.Collection;

import latte.di.DIPackage;
import latte.di.DiagramElement;
import latte.di.GraphElement;
import latte.di.Property;
import latte.di.Reference;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.common.util.EList;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.impl.EObjectImpl;

import org.eclipse.emf.ecore.util.EObjectContainmentEList;
import org.eclipse.emf.ecore.util.EObjectWithInverseResolvingEList;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.InternalEList;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Diagram Element</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.DiagramElementImpl#isVisible <em>Visible</em>}</li>
 *   <li>{@link latte.di.impl.DiagramElementImpl#getContainer <em>Container</em>}</li>
 *   <li>{@link latte.di.impl.DiagramElementImpl#getReference <em>Reference</em>}</li>
 *   <li>{@link latte.di.impl.DiagramElementImpl#getProperty <em>Property</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public abstract class DiagramElementImpl extends EObjectImpl implements DiagramElement {
    /**
     * The default value of the '{@link #isVisible() <em>Visible</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isVisible()
     * @generated
     * @ordered
     */
    protected static final boolean VISIBLE_EDEFAULT = false;

    /**
     * The cached value of the '{@link #isVisible() <em>Visible</em>}' attribute.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #isVisible()
     * @generated
     * @ordered
     */
    protected boolean visible = VISIBLE_EDEFAULT;

    /**
     * The cached value of the '{@link #getReference() <em>Reference</em>}' reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getReference()
     * @generated
     * @ordered
     */
    protected EList reference = null;

    /**
     * The cached value of the '{@link #getProperty() <em>Property</em>}' containment reference list.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getProperty()
     * @generated
     * @ordered
     */
    protected EList property = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected DiagramElementImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getDiagramElement();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean isVisible() {
        return visible;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setVisible(boolean newVisible) {
        boolean oldVisible = visible;
        visible = newVisible;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM_ELEMENT__VISIBLE, oldVisible, visible));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public GraphElement getContainer() {
        if (eContainerFeatureID != DIPackage.DIAGRAM_ELEMENT__CONTAINER) return null;
        return (GraphElement)eContainer;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setContainer(GraphElement newContainer) {
        if (newContainer != eContainer || (eContainerFeatureID != DIPackage.DIAGRAM_ELEMENT__CONTAINER && newContainer != null)) {
            if (EcoreUtil.isAncestor(this, newContainer))
                throw new IllegalArgumentException("Recursive containment not allowed for " + toString());
            NotificationChain msgs = null;
            if (eContainer != null)
                msgs = eBasicRemoveFromContainer(msgs);
            if (newContainer != null)
                msgs = ((InternalEObject)newContainer).eInverseAdd(this, DIPackage.GRAPH_ELEMENT__CONTAINED, GraphElement.class, msgs);
            msgs = eBasicSetContainer((InternalEObject)newContainer, DIPackage.DIAGRAM_ELEMENT__CONTAINER, msgs);
            if (msgs != null) msgs.dispatch();
        }
        else if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.DIAGRAM_ELEMENT__CONTAINER, newContainer, newContainer));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getReference() {
        if (reference == null) {
            reference = new EObjectWithInverseResolvingEList(Reference.class, this, DIPackage.DIAGRAM_ELEMENT__REFERENCE, DIPackage.REFERENCE__REFERENCED);
        }
        return reference;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public EList getProperty() {
        if (property == null) {
            property = new EObjectContainmentEList(Property.class, this, DIPackage.DIAGRAM_ELEMENT__PROPERTY);
        }
        return property;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.DIAGRAM_ELEMENT__CONTAINER:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.DIAGRAM_ELEMENT__CONTAINER, msgs);
                case DIPackage.DIAGRAM_ELEMENT__REFERENCE:
                    return ((InternalEList)getReference()).basicAdd(otherEnd, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.DIAGRAM_ELEMENT__CONTAINER:
                    return eBasicSetContainer(null, DIPackage.DIAGRAM_ELEMENT__CONTAINER, msgs);
                case DIPackage.DIAGRAM_ELEMENT__REFERENCE:
                    return ((InternalEList)getReference()).basicRemove(otherEnd, msgs);
                case DIPackage.DIAGRAM_ELEMENT__PROPERTY:
                    return ((InternalEList)getProperty()).basicRemove(otherEnd, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.DIAGRAM_ELEMENT__CONTAINER:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__CONTAINED, GraphElement.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM_ELEMENT__VISIBLE:
                return isVisible() ? Boolean.TRUE : Boolean.FALSE;
            case DIPackage.DIAGRAM_ELEMENT__CONTAINER:
                return getContainer();
            case DIPackage.DIAGRAM_ELEMENT__REFERENCE:
                return getReference();
            case DIPackage.DIAGRAM_ELEMENT__PROPERTY:
                return getProperty();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM_ELEMENT__VISIBLE:
                setVisible(((Boolean)newValue).booleanValue());
                return;
            case DIPackage.DIAGRAM_ELEMENT__CONTAINER:
                setContainer((GraphElement)newValue);
                return;
            case DIPackage.DIAGRAM_ELEMENT__REFERENCE:
                getReference().clear();
                getReference().addAll((Collection)newValue);
                return;
            case DIPackage.DIAGRAM_ELEMENT__PROPERTY:
                getProperty().clear();
                getProperty().addAll((Collection)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM_ELEMENT__VISIBLE:
                setVisible(VISIBLE_EDEFAULT);
                return;
            case DIPackage.DIAGRAM_ELEMENT__CONTAINER:
                setContainer((GraphElement)null);
                return;
            case DIPackage.DIAGRAM_ELEMENT__REFERENCE:
                getReference().clear();
                return;
            case DIPackage.DIAGRAM_ELEMENT__PROPERTY:
                getProperty().clear();
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.DIAGRAM_ELEMENT__VISIBLE:
                return visible != VISIBLE_EDEFAULT;
            case DIPackage.DIAGRAM_ELEMENT__CONTAINER:
                return getContainer() != null;
            case DIPackage.DIAGRAM_ELEMENT__REFERENCE:
                return reference != null && !reference.isEmpty();
            case DIPackage.DIAGRAM_ELEMENT__PROPERTY:
                return property != null && !property.isEmpty();
        }
        return eDynamicIsSet(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public String toString() {
        if (eIsProxy()) return super.toString();

        StringBuffer result = new StringBuffer(super.toString());
        result.append(" (visible: ");
        result.append(visible);
        result.append(')');
        return result.toString();
    }

} //DiagramElementImpl
