/**
 * <copyright>
 * </copyright>
 *
 * $Id: CoreSemanticModelBridgeImpl.java,v 1.2 2004/02/19 18:23:32 ohnuki Exp $
 */
package latte.di.impl;

import latte.di.CoreSemanticModelBridge;
import latte.di.DIPackage;
import latte.di.Diagram;
import latte.di.GraphElement;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.NotificationChain;

import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;

import org.eclipse.emf.ecore.impl.ENotificationImpl;

import org.eclipse.uml2.Element;

/**
 * <!-- begin-user-doc -->
 * An implementation of the model object '<em><b>Core Semantic Model Bridge</b></em>'.
 * <!-- end-user-doc -->
 * <p>
 * The following features are implemented:
 * <ul>
 *   <li>{@link latte.di.impl.CoreSemanticModelBridgeImpl#getElement <em>Element</em>}</li>
 * </ul>
 * </p>
 *
 * @generated
 */
public class CoreSemanticModelBridgeImpl extends SemanticModelBridgeImpl implements CoreSemanticModelBridge {
    /**
     * The cached value of the '{@link #getElement() <em>Element</em>}' reference.
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @see #getElement()
     * @generated
     * @ordered
     */
    protected Element element = null;

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected CoreSemanticModelBridgeImpl() {
        super();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    protected EClass eStaticClass() {
        return DIPackage.eINSTANCE.getCoreSemanticModelBridge();
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Element getElement() {
        if (element != null && element.eIsProxy()) {
            Element oldElement = element;
            element = (Element)eResolveProxy((InternalEObject)element);
            if (element != oldElement) {
                if (eNotificationRequired())
                    eNotify(new ENotificationImpl(this, Notification.RESOLVE, DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__ELEMENT, oldElement, element));
            }
        }
        return element;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Element basicGetElement() {
        return element;
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void setElement(Element newElement) {
        Element oldElement = element;
        element = newElement;
        if (eNotificationRequired())
            eNotify(new ENotificationImpl(this, Notification.SET, DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__ELEMENT, oldElement, element));
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT, msgs);
                case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                    if (eContainer != null)
                        msgs = eBasicRemoveFromContainer(msgs);
                    return eBasicSetContainer(otherEnd, DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM, msgs);
                default:
                    return eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
            }
        }
        if (eContainer != null)
            msgs = eBasicRemoveFromContainer(msgs);
        return eBasicSetContainer(otherEnd, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (eDerivedStructuralFeatureID(featureID, baseClass)) {
                case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                    return eBasicSetContainer(null, DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT, msgs);
                case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                    return eBasicSetContainer(null, DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM, msgs);
                default:
                    return eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
            }
        }
        return eBasicSetContainer(null, featureID, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public NotificationChain eBasicRemoveFromContainer(NotificationChain msgs) {
        if (eContainerFeatureID >= 0) {
            switch (eContainerFeatureID) {
                case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.GRAPH_ELEMENT__SEMANTIC_MODEL, GraphElement.class, msgs);
                case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                    return ((InternalEObject)eContainer).eInverseRemove(this, DIPackage.DIAGRAM__NAMESPACE, Diagram.class, msgs);
                default:
                    return eDynamicBasicRemoveFromContainer(msgs);
            }
        }
        return ((InternalEObject)eContainer).eInverseRemove(this, EOPPOSITE_FEATURE_BASE - eContainerFeatureID, null, msgs);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__PRESENTATION:
                return getPresentation();
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                return getGraphElement();
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                return getDiagram();
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__ELEMENT:
                if (resolve) return getElement();
                return basicGetElement();
        }
        return eDynamicGet(eFeature, resolve);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__PRESENTATION:
                setPresentation((String)newValue);
                return;
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                setGraphElement((GraphElement)newValue);
                return;
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                setDiagram((Diagram)newValue);
                return;
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__ELEMENT:
                setElement((Element)newValue);
                return;
        }
        eDynamicSet(eFeature, newValue);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public void eUnset(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__PRESENTATION:
                setPresentation(PRESENTATION_EDEFAULT);
                return;
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                setGraphElement((GraphElement)null);
                return;
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                setDiagram((Diagram)null);
                return;
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__ELEMENT:
                setElement((Element)null);
                return;
        }
        eDynamicUnset(eFeature);
    }

    /**
     * <!-- begin-user-doc -->
     * <!-- end-user-doc -->
     * @generated
     */
    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (eDerivedStructuralFeatureID(eFeature)) {
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__PRESENTATION:
                return PRESENTATION_EDEFAULT == null ? presentation != null : !PRESENTATION_EDEFAULT.equals(presentation);
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT:
                return getGraphElement() != null;
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM:
                return getDiagram() != null;
            case DIPackage.CORE_SEMANTIC_MODEL_BRIDGE__ELEMENT:
                return element != null;
        }
        return eDynamicIsSet(eFeature);
    }

} //CoreSemanticModelBridgeImpl
