/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.di;

import org.eclipse.emf.ecore.EObject;

/**
 * @model abstract="true"
 */
public interface SemanticModelBridge extends EObject{
    /**
     * @model
     */
    String getPresentation();

    /**
     * Sets the value of the '{@link latte.di.SemanticModelBridge#getPresentation <em>Presentation</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Presentation</em>' attribute.
     * @see #getPresentation()
     * @generated
     */
	void setPresentation(String value);

    /**
	 * @model opposite="semanticModel"
	 */
	GraphElement getGraphElement();
	
    /**
     * Sets the value of the '{@link latte.di.SemanticModelBridge#getGraphElement <em>Graph Element</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Graph Element</em>' container reference.
     * @see #getGraphElement()
     * @generated
     */
	void setGraphElement(GraphElement value);

	/**
	 * @model opposite="namespace"
	 */
	Diagram getDiagram();
    /**
     * Sets the value of the '{@link latte.di.SemanticModelBridge#getDiagram <em>Diagram</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Diagram</em>' container reference.
     * @see #getDiagram()
     * @generated
     */
	void setDiagram(Diagram value);

}
