/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.di;

import org.eclipse.emf.common.util.EList;

/**
 * @model abstract="true"
 */
public interface GraphElement extends DiagramElement{
    /**
     * @model containment="true"  required="true"
     */
    Point getPosition();

    /**
     * Sets the value of the '{@link latte.di.GraphElement#getPosition <em>Position</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Position</em>' containment reference.
     * @see #getPosition()
     * @generated
     */
	void setPosition(Point value);

    /**
	 * @model type="DiagramElement" containment="true" opposite="container"
	 */
	EList getContained();

	/**
	 * @model type="DiagramLink" containment="true" opposite="graphElement"
	 */
    EList getLink();

	/**
	 * @model type="GraphConnector" containment="true" opposite="graphElement"
	 */
	EList getAnchorage();

	/**
	 * @model type="SemanticModelBridge" containment="true" opposite="graphElement" required="true"
	 */
	SemanticModelBridge getSemanticModel();
    /**
     * Sets the value of the '{@link latte.di.GraphElement#getSemanticModel <em>Semantic Model</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Semantic Model</em>' containment reference.
     * @see #getSemanticModel()
     * @generated
     */
	void setSemanticModel(SemanticModelBridge value);

}
