/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.di;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;

/**
 * @model
 */
public interface GraphConnector extends EObject{
    /**
     * @model containment="true"  required="true"
     */
    Point getPosition();

    /**
     * Sets the value of the '{@link latte.di.GraphConnector#getPosition <em>Position</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Position</em>' containment reference.
     * @see #getPosition()
     * @generated
     */
	void setPosition(Point value);

    /**
	 * @model  required="true" opposite="anchorage"
	 */
	GraphElement getGraphElement();
	
    /**
     * Sets the value of the '{@link latte.di.GraphConnector#getGraphElement <em>Graph Element</em>}' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Graph Element</em>' container reference.
     * @see #getGraphElement()
     * @generated
     */
	void setGraphElement(GraphElement value);

	/**
	 * @model type="GraphEdge" opposite="anchor"
	 */
	EList getGraphEdge();
}
