/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.di;

import org.eclipse.emf.common.util.EList;

/**
 * @model
 */
public interface Diagram extends GraphNode{
    /**
     * @model
     */
    String getName();

    /**
     * Sets the value of the '{@link latte.di.Diagram#getName <em>Name</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Name</em>' attribute.
     * @see #getName()
     * @generated
     */
	void setName(String value);

    /**
     * @model
     */
    double getZoom();

    /**
     * Sets the value of the '{@link latte.di.Diagram#getZoom <em>Zoom</em>}' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Zoom</em>' attribute.
     * @see #getZoom()
     * @generated
     */
	void setZoom(double value);

    /**
     * @model containment="true"  required="true"
     */
    Point getViewport();
    
    /**
     * Sets the value of the '{@link latte.di.Diagram#getViewport <em>Viewport</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Viewport</em>' containment reference.
     * @see #getViewport()
     * @generated
     */
	void setViewport(Point value);

    /**
     * @model type="DiagramLink" opposite="diagram"
     */
    EList getDiagramLink();
    
    /**
     * @model containment="true" required="true" opposite="diagram"
     */
    SemanticModelBridge getNamespace();
    /**
     * Sets the value of the '{@link latte.di.Diagram#getNamespace <em>Namespace</em>}' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @param value the new value of the '<em>Namespace</em>' containment reference.
     * @see #getNamespace()
     * @generated
     */
	void setNamespace(SemanticModelBridge value);

}
