/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.di;

import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EPackage;


import org.eclipse.emf.ecore.EReference;

public interface DIPackage extends EPackage{
    String eNAME = "di";
    String eNS_URI = "http://latte.sourceforge.jp/di/1.0.0";
    String eNS_PREFIX = "di";
    

    /**
     * The singleton instance of the package.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     */
	DIPackage eINSTANCE = latte.di.impl.DIPackageImpl.init();

    /**
     * The meta object id for the '{@link latte.di.impl.SemanticModelBridgeImpl <em>Semantic Model Bridge</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.SemanticModelBridgeImpl
     * @see latte.di.impl.DIPackageImpl#getSemanticModelBridge()
     * @generated
     */
	int SEMANTIC_MODEL_BRIDGE = 13;

    /**
     * The feature id for the '<em><b>Presentation</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SEMANTIC_MODEL_BRIDGE__PRESENTATION = 0;

    /**
     * The feature id for the '<em><b>Graph Element</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT = 1;

    /**
     * The feature id for the '<em><b>Diagram</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SEMANTIC_MODEL_BRIDGE__DIAGRAM = 2;

    /**
     * The number of structural features of the the '<em>Semantic Model Bridge</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SEMANTIC_MODEL_BRIDGE_FEATURE_COUNT = 3;

    /**
     * The meta object id for the '{@link latte.di.impl.CoreSemanticModelBridgeImpl <em>Core Semantic Model Bridge</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.CoreSemanticModelBridgeImpl
     * @see latte.di.impl.DIPackageImpl#getCoreSemanticModelBridge()
     * @generated
     */
	int CORE_SEMANTIC_MODEL_BRIDGE = 0;

    /**
     * The feature id for the '<em><b>Presentation</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CORE_SEMANTIC_MODEL_BRIDGE__PRESENTATION = SEMANTIC_MODEL_BRIDGE__PRESENTATION;

    /**
     * The feature id for the '<em><b>Graph Element</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CORE_SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT = SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT;

    /**
     * The feature id for the '<em><b>Diagram</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CORE_SEMANTIC_MODEL_BRIDGE__DIAGRAM = SEMANTIC_MODEL_BRIDGE__DIAGRAM;

    /**
     * The feature id for the '<em><b>Element</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CORE_SEMANTIC_MODEL_BRIDGE__ELEMENT = SEMANTIC_MODEL_BRIDGE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Core Semantic Model Bridge</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int CORE_SEMANTIC_MODEL_BRIDGE_FEATURE_COUNT = SEMANTIC_MODEL_BRIDGE_FEATURE_COUNT + 1;

    /**
     * The meta object id for the '{@link latte.di.impl.DiagramElementImpl <em>Diagram Element</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.DiagramElementImpl
     * @see latte.di.impl.DIPackageImpl#getDiagramElement()
     * @generated
     */
	int DIAGRAM_ELEMENT = 3;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_ELEMENT__VISIBLE = 0;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_ELEMENT__CONTAINER = 1;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_ELEMENT__REFERENCE = 2;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_ELEMENT__PROPERTY = 3;

    /**
     * The number of structural features of the the '<em>Diagram Element</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_ELEMENT_FEATURE_COUNT = 4;

    /**
     * The meta object id for the '{@link latte.di.impl.GraphElementImpl <em>Graph Element</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.GraphElementImpl
     * @see latte.di.impl.DIPackageImpl#getGraphElement()
     * @generated
     */
	int GRAPH_ELEMENT = 7;

    /**
     * The meta object id for the '{@link latte.di.impl.GraphNodeImpl <em>Graph Node</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.GraphNodeImpl
     * @see latte.di.impl.DIPackageImpl#getGraphNode()
     * @generated
     */
	int GRAPH_NODE = 8;

    /**
     * The meta object id for the '{@link latte.di.impl.DiagramImpl <em>Diagram</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.DiagramImpl
     * @see latte.di.impl.DIPackageImpl#getDiagram()
     * @generated
     */
	int DIAGRAM = 2;

    /**
     * The meta object id for the '{@link latte.di.impl.DiagramLinkImpl <em>Diagram Link</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.DiagramLinkImpl
     * @see latte.di.impl.DIPackageImpl#getDiagramLink()
     * @generated
     */
	int DIAGRAM_LINK = 4;

    /**
     * The meta object id for the '{@link latte.di.impl.GraphConnectorImpl <em>Graph Connector</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.GraphConnectorImpl
     * @see latte.di.impl.DIPackageImpl#getGraphConnector()
     * @generated
     */
	int GRAPH_CONNECTOR = 5;

    /**
     * The meta object id for the '{@link latte.di.impl.GraphEdgeImpl <em>Graph Edge</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.GraphEdgeImpl
     * @see latte.di.impl.DIPackageImpl#getGraphEdge()
     * @generated
     */
	int GRAPH_EDGE = 6;

    /**
     * The meta object id for the '{@link latte.di.impl.LeafElementImpl <em>Leaf Element</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.LeafElementImpl
     * @see latte.di.impl.DIPackageImpl#getLeafElement()
     * @generated
     */
	int LEAF_ELEMENT = 11;

    /**
     * The meta object id for the '{@link latte.di.impl.GraphicPrimitiveImpl <em>Graphic Primitive</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.GraphicPrimitiveImpl
     * @see latte.di.impl.DIPackageImpl#getGraphicPrimitive()
     * @generated
     */
	int GRAPHIC_PRIMITIVE = 9;

    /**
     * The meta object id for the '{@link latte.di.impl.ImageImpl <em>Image</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.ImageImpl
     * @see latte.di.impl.DIPackageImpl#getImage()
     * @generated
     */
	int IMAGE = 10;

    /**
     * The meta object id for the '{@link latte.di.impl.PropertyImpl <em>Property</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.PropertyImpl
     * @see latte.di.impl.DIPackageImpl#getProperty()
     * @generated
     */
	int PROPERTY = 12;

    /**
     * The meta object id for the '{@link latte.di.impl.ReferenceImpl <em>Reference</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.ReferenceImpl
     * @see latte.di.impl.DIPackageImpl#getReference()
     * @generated
     */
	int REFERENCE = 1;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFERENCE__VISIBLE = DIAGRAM_ELEMENT__VISIBLE;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFERENCE__CONTAINER = DIAGRAM_ELEMENT__CONTAINER;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFERENCE__REFERENCE = DIAGRAM_ELEMENT__REFERENCE;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFERENCE__PROPERTY = DIAGRAM_ELEMENT__PROPERTY;

    /**
     * The feature id for the '<em><b>Individual Representaion</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFERENCE__INDIVIDUAL_REPRESENTAION = DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Referenced</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFERENCE__REFERENCED = DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the the '<em>Reference</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int REFERENCE_FEATURE_COUNT = DIAGRAM_ELEMENT_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT__VISIBLE = DIAGRAM_ELEMENT__VISIBLE;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT__CONTAINER = DIAGRAM_ELEMENT__CONTAINER;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT__REFERENCE = DIAGRAM_ELEMENT__REFERENCE;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT__PROPERTY = DIAGRAM_ELEMENT__PROPERTY;

    /**
     * The feature id for the '<em><b>Position</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT__POSITION = DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Contained</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT__CONTAINED = DIAGRAM_ELEMENT_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Link</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT__LINK = DIAGRAM_ELEMENT_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Anchorage</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT__ANCHORAGE = DIAGRAM_ELEMENT_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Semantic Model</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT__SEMANTIC_MODEL = DIAGRAM_ELEMENT_FEATURE_COUNT + 4;

    /**
     * The number of structural features of the the '<em>Graph Element</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_ELEMENT_FEATURE_COUNT = DIAGRAM_ELEMENT_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__VISIBLE = GRAPH_ELEMENT__VISIBLE;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__CONTAINER = GRAPH_ELEMENT__CONTAINER;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__REFERENCE = GRAPH_ELEMENT__REFERENCE;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__PROPERTY = GRAPH_ELEMENT__PROPERTY;

    /**
     * The feature id for the '<em><b>Position</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__POSITION = GRAPH_ELEMENT__POSITION;

    /**
     * The feature id for the '<em><b>Contained</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__CONTAINED = GRAPH_ELEMENT__CONTAINED;

    /**
     * The feature id for the '<em><b>Link</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__LINK = GRAPH_ELEMENT__LINK;

    /**
     * The feature id for the '<em><b>Anchorage</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__ANCHORAGE = GRAPH_ELEMENT__ANCHORAGE;

    /**
     * The feature id for the '<em><b>Semantic Model</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__SEMANTIC_MODEL = GRAPH_ELEMENT__SEMANTIC_MODEL;

    /**
     * The feature id for the '<em><b>Size</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE__SIZE = GRAPH_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Graph Node</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_NODE_FEATURE_COUNT = GRAPH_ELEMENT_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__VISIBLE = GRAPH_NODE__VISIBLE;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__CONTAINER = GRAPH_NODE__CONTAINER;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__REFERENCE = GRAPH_NODE__REFERENCE;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__PROPERTY = GRAPH_NODE__PROPERTY;

    /**
     * The feature id for the '<em><b>Position</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__POSITION = GRAPH_NODE__POSITION;

    /**
     * The feature id for the '<em><b>Contained</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__CONTAINED = GRAPH_NODE__CONTAINED;

    /**
     * The feature id for the '<em><b>Link</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__LINK = GRAPH_NODE__LINK;

    /**
     * The feature id for the '<em><b>Anchorage</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__ANCHORAGE = GRAPH_NODE__ANCHORAGE;

    /**
     * The feature id for the '<em><b>Semantic Model</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__SEMANTIC_MODEL = GRAPH_NODE__SEMANTIC_MODEL;

    /**
     * The feature id for the '<em><b>Size</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__SIZE = GRAPH_NODE__SIZE;

    /**
     * The feature id for the '<em><b>Name</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__NAME = GRAPH_NODE_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Zoom</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__ZOOM = GRAPH_NODE_FEATURE_COUNT + 1;

    /**
     * The feature id for the '<em><b>Viewport</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__VIEWPORT = GRAPH_NODE_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Diagram Link</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__DIAGRAM_LINK = GRAPH_NODE_FEATURE_COUNT + 3;

    /**
     * The feature id for the '<em><b>Namespace</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM__NAMESPACE = GRAPH_NODE_FEATURE_COUNT + 4;

    /**
     * The number of structural features of the the '<em>Diagram</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_FEATURE_COUNT = GRAPH_NODE_FEATURE_COUNT + 5;

    /**
     * The feature id for the '<em><b>Zoom</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_LINK__ZOOM = 0;

    /**
     * The feature id for the '<em><b>Viewport</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_LINK__VIEWPORT = 1;

    /**
     * The feature id for the '<em><b>Graph Element</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_LINK__GRAPH_ELEMENT = 2;

    /**
     * The feature id for the '<em><b>Diagram</b></em>' reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_LINK__DIAGRAM = 3;

    /**
     * The number of structural features of the the '<em>Diagram Link</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIAGRAM_LINK_FEATURE_COUNT = 4;

    /**
     * The feature id for the '<em><b>Position</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_CONNECTOR__POSITION = 0;

    /**
     * The feature id for the '<em><b>Graph Element</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_CONNECTOR__GRAPH_ELEMENT = 1;

    /**
     * The feature id for the '<em><b>Graph Edge</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_CONNECTOR__GRAPH_EDGE = 2;

    /**
     * The number of structural features of the the '<em>Graph Connector</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_CONNECTOR_FEATURE_COUNT = 3;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__VISIBLE = GRAPH_ELEMENT__VISIBLE;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__CONTAINER = GRAPH_ELEMENT__CONTAINER;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__REFERENCE = GRAPH_ELEMENT__REFERENCE;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__PROPERTY = GRAPH_ELEMENT__PROPERTY;

    /**
     * The feature id for the '<em><b>Position</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__POSITION = GRAPH_ELEMENT__POSITION;

    /**
     * The feature id for the '<em><b>Contained</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__CONTAINED = GRAPH_ELEMENT__CONTAINED;

    /**
     * The feature id for the '<em><b>Link</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__LINK = GRAPH_ELEMENT__LINK;

    /**
     * The feature id for the '<em><b>Anchorage</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__ANCHORAGE = GRAPH_ELEMENT__ANCHORAGE;

    /**
     * The feature id for the '<em><b>Semantic Model</b></em>' containment reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__SEMANTIC_MODEL = GRAPH_ELEMENT__SEMANTIC_MODEL;

    /**
     * The feature id for the '<em><b>Waypoints</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__WAYPOINTS = GRAPH_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Anchor</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE__ANCHOR = GRAPH_ELEMENT_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the the '<em>Graph Edge</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPH_EDGE_FEATURE_COUNT = GRAPH_ELEMENT_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int LEAF_ELEMENT__VISIBLE = DIAGRAM_ELEMENT__VISIBLE;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int LEAF_ELEMENT__CONTAINER = DIAGRAM_ELEMENT__CONTAINER;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int LEAF_ELEMENT__REFERENCE = DIAGRAM_ELEMENT__REFERENCE;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int LEAF_ELEMENT__PROPERTY = DIAGRAM_ELEMENT__PROPERTY;

    /**
     * The number of structural features of the the '<em>Leaf Element</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int LEAF_ELEMENT_FEATURE_COUNT = DIAGRAM_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPHIC_PRIMITIVE__VISIBLE = LEAF_ELEMENT__VISIBLE;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPHIC_PRIMITIVE__CONTAINER = LEAF_ELEMENT__CONTAINER;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPHIC_PRIMITIVE__REFERENCE = LEAF_ELEMENT__REFERENCE;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPHIC_PRIMITIVE__PROPERTY = LEAF_ELEMENT__PROPERTY;

    /**
     * The number of structural features of the the '<em>Graphic Primitive</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int GRAPHIC_PRIMITIVE_FEATURE_COUNT = LEAF_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int IMAGE__VISIBLE = LEAF_ELEMENT__VISIBLE;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int IMAGE__CONTAINER = LEAF_ELEMENT__CONTAINER;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int IMAGE__REFERENCE = LEAF_ELEMENT__REFERENCE;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int IMAGE__PROPERTY = LEAF_ELEMENT__PROPERTY;

    /**
     * The feature id for the '<em><b>Uri</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int IMAGE__URI = LEAF_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The feature id for the '<em><b>Mime Type</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int IMAGE__MIME_TYPE = LEAF_ELEMENT_FEATURE_COUNT + 1;

    /**
     * The number of structural features of the the '<em>Image</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int IMAGE_FEATURE_COUNT = LEAF_ELEMENT_FEATURE_COUNT + 2;

    /**
     * The feature id for the '<em><b>Key</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int PROPERTY__KEY = 0;

    /**
     * The feature id for the '<em><b>Value</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int PROPERTY__VALUE = 1;

    /**
     * The number of structural features of the the '<em>Property</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int PROPERTY_FEATURE_COUNT = 2;

    /**
     * The meta object id for the '{@link latte.di.impl.SimpleSemanticModelElementImpl <em>Simple Semantic Model Element</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.SimpleSemanticModelElementImpl
     * @see latte.di.impl.DIPackageImpl#getSimpleSemanticModelElement()
     * @generated
     */
	int SIMPLE_SEMANTIC_MODEL_ELEMENT = 14;

    /**
     * The feature id for the '<em><b>Presentation</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SIMPLE_SEMANTIC_MODEL_ELEMENT__PRESENTATION = SEMANTIC_MODEL_BRIDGE__PRESENTATION;

    /**
     * The feature id for the '<em><b>Graph Element</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SIMPLE_SEMANTIC_MODEL_ELEMENT__GRAPH_ELEMENT = SEMANTIC_MODEL_BRIDGE__GRAPH_ELEMENT;

    /**
     * The feature id for the '<em><b>Diagram</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SIMPLE_SEMANTIC_MODEL_ELEMENT__DIAGRAM = SEMANTIC_MODEL_BRIDGE__DIAGRAM;

    /**
     * The feature id for the '<em><b>Type Info</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SIMPLE_SEMANTIC_MODEL_ELEMENT__TYPE_INFO = SEMANTIC_MODEL_BRIDGE_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Simple Semantic Model Element</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int SIMPLE_SEMANTIC_MODEL_ELEMENT_FEATURE_COUNT = SEMANTIC_MODEL_BRIDGE_FEATURE_COUNT + 1;

    /**
     * The meta object id for the '{@link latte.di.impl.TextElementImpl <em>Text Element</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.TextElementImpl
     * @see latte.di.impl.DIPackageImpl#getTextElement()
     * @generated
     */
	int TEXT_ELEMENT = 15;

    /**
     * The feature id for the '<em><b>Visible</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEXT_ELEMENT__VISIBLE = LEAF_ELEMENT__VISIBLE;

    /**
     * The feature id for the '<em><b>Container</b></em>' container reference.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEXT_ELEMENT__CONTAINER = LEAF_ELEMENT__CONTAINER;

    /**
     * The feature id for the '<em><b>Reference</b></em>' reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEXT_ELEMENT__REFERENCE = LEAF_ELEMENT__REFERENCE;

    /**
     * The feature id for the '<em><b>Property</b></em>' containment reference list.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEXT_ELEMENT__PROPERTY = LEAF_ELEMENT__PROPERTY;

    /**
     * The feature id for the '<em><b>Text</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEXT_ELEMENT__TEXT = LEAF_ELEMENT_FEATURE_COUNT + 0;

    /**
     * The number of structural features of the the '<em>Text Element</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int TEXT_ELEMENT_FEATURE_COUNT = LEAF_ELEMENT_FEATURE_COUNT + 1;

    /**
     * The meta object id for the '{@link latte.di.impl.PointImpl <em>Point</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.PointImpl
     * @see latte.di.impl.DIPackageImpl#getPoint()
     * @generated
     */
	int POINT = 16;

    /**
     * The feature id for the '<em><b>X</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int POINT__X = 0;

    /**
     * The feature id for the '<em><b>Y</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int POINT__Y = 1;

    /**
     * The number of structural features of the the '<em>Point</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int POINT_FEATURE_COUNT = 2;

    /**
     * The meta object id for the '{@link latte.di.impl.DimensionImpl <em>Dimension</em>}' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see latte.di.impl.DimensionImpl
     * @see latte.di.impl.DIPackageImpl#getDimension()
     * @generated
     */
	int DIMENSION = 17;


    /**
     * The feature id for the '<em><b>Width</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIMENSION__WIDTH = 0;

    /**
     * The feature id for the '<em><b>Height</b></em>' attribute.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIMENSION__HEIGHT = 1;

    /**
     * The number of structural features of the the '<em>Dimension</em>' class.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @generated
     * @ordered
     */
	int DIMENSION_FEATURE_COUNT = 2;


    /**
     * The meta object id for the '<em>Element</em>' data type.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @see org.eclipse.uml2.Element
     * @see latte.di.impl.DIPackageImpl#getElement()
     * @generated
     */
	int ELEMENT = 18;


    /**
     * Returns the meta object for class '{@link latte.di.CoreSemanticModelBridge <em>Core Semantic Model Bridge</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Core Semantic Model Bridge</em>'.
     * @see latte.di.CoreSemanticModelBridge
     * @generated
     */
	EClass getCoreSemanticModelBridge();

    /**
     * Returns the meta object for the reference '{@link latte.di.CoreSemanticModelBridge#getElement <em>Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Element</em>'.
     * @see latte.di.CoreSemanticModelBridge#getElement()
     * @see #getCoreSemanticModelBridge()
     * @generated
     */
	EReference getCoreSemanticModelBridge_Element();

    /**
     * Returns the meta object for class '{@link latte.di.Diagram <em>Diagram</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Diagram</em>'.
     * @see latte.di.Diagram
     * @generated
     */
	EClass getDiagram();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Diagram#getName <em>Name</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Name</em>'.
     * @see latte.di.Diagram#getName()
     * @see #getDiagram()
     * @generated
     */
	EAttribute getDiagram_Name();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Diagram#getZoom <em>Zoom</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Zoom</em>'.
     * @see latte.di.Diagram#getZoom()
     * @see #getDiagram()
     * @generated
     */
	EAttribute getDiagram_Zoom();

    /**
     * Returns the meta object for the containment reference '{@link latte.di.Diagram#getViewport <em>Viewport</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Viewport</em>'.
     * @see latte.di.Diagram#getViewport()
     * @see #getDiagram()
     * @generated
     */
	EReference getDiagram_Viewport();

    /**
     * Returns the meta object for the reference list '{@link latte.di.Diagram#getDiagramLink <em>Diagram Link</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Diagram Link</em>'.
     * @see latte.di.Diagram#getDiagramLink()
     * @see #getDiagram()
     * @generated
     */
	EReference getDiagram_DiagramLink();

    /**
     * Returns the meta object for the containment reference '{@link latte.di.Diagram#getNamespace <em>Namespace</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Namespace</em>'.
     * @see latte.di.Diagram#getNamespace()
     * @see #getDiagram()
     * @generated
     */
	EReference getDiagram_Namespace();

    /**
     * Returns the meta object for class '{@link latte.di.DiagramElement <em>Diagram Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Diagram Element</em>'.
     * @see latte.di.DiagramElement
     * @generated
     */
	EClass getDiagramElement();

    /**
     * Returns the meta object for the attribute '{@link latte.di.DiagramElement#isVisible <em>Visible</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Visible</em>'.
     * @see latte.di.DiagramElement#isVisible()
     * @see #getDiagramElement()
     * @generated
     */
	EAttribute getDiagramElement_Visible();

    /**
     * Returns the meta object for the container reference '{@link latte.di.DiagramElement#getContainer <em>Container</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Container</em>'.
     * @see latte.di.DiagramElement#getContainer()
     * @see #getDiagramElement()
     * @generated
     */
	EReference getDiagramElement_Container();

    /**
     * Returns the meta object for the reference list '{@link latte.di.DiagramElement#getReference <em>Reference</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Reference</em>'.
     * @see latte.di.DiagramElement#getReference()
     * @see #getDiagramElement()
     * @generated
     */
	EReference getDiagramElement_Reference();

    /**
     * Returns the meta object for the containment reference list '{@link latte.di.DiagramElement#getProperty <em>Property</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Property</em>'.
     * @see latte.di.DiagramElement#getProperty()
     * @see #getDiagramElement()
     * @generated
     */
	EReference getDiagramElement_Property();

    /**
     * Returns the meta object for class '{@link latte.di.DiagramLink <em>Diagram Link</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Diagram Link</em>'.
     * @see latte.di.DiagramLink
     * @generated
     */
	EClass getDiagramLink();

    /**
     * Returns the meta object for the attribute '{@link latte.di.DiagramLink#getZoom <em>Zoom</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Zoom</em>'.
     * @see latte.di.DiagramLink#getZoom()
     * @see #getDiagramLink()
     * @generated
     */
	EAttribute getDiagramLink_Zoom();

    /**
     * Returns the meta object for the containment reference '{@link latte.di.DiagramLink#getViewport <em>Viewport</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Viewport</em>'.
     * @see latte.di.DiagramLink#getViewport()
     * @see #getDiagramLink()
     * @generated
     */
	EReference getDiagramLink_Viewport();

    /**
     * Returns the meta object for the container reference '{@link latte.di.DiagramLink#getGraphElement <em>Graph Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Graph Element</em>'.
     * @see latte.di.DiagramLink#getGraphElement()
     * @see #getDiagramLink()
     * @generated
     */
	EReference getDiagramLink_GraphElement();

    /**
     * Returns the meta object for the reference '{@link latte.di.DiagramLink#getDiagram <em>Diagram</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Diagram</em>'.
     * @see latte.di.DiagramLink#getDiagram()
     * @see #getDiagramLink()
     * @generated
     */
	EReference getDiagramLink_Diagram();

    /**
     * Returns the meta object for class '{@link latte.di.GraphConnector <em>Graph Connector</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Graph Connector</em>'.
     * @see latte.di.GraphConnector
     * @generated
     */
	EClass getGraphConnector();

    /**
     * Returns the meta object for the containment reference '{@link latte.di.GraphConnector#getPosition <em>Position</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Position</em>'.
     * @see latte.di.GraphConnector#getPosition()
     * @see #getGraphConnector()
     * @generated
     */
	EReference getGraphConnector_Position();

    /**
     * Returns the meta object for the container reference '{@link latte.di.GraphConnector#getGraphElement <em>Graph Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Graph Element</em>'.
     * @see latte.di.GraphConnector#getGraphElement()
     * @see #getGraphConnector()
     * @generated
     */
	EReference getGraphConnector_GraphElement();

    /**
     * Returns the meta object for the reference list '{@link latte.di.GraphConnector#getGraphEdge <em>Graph Edge</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Graph Edge</em>'.
     * @see latte.di.GraphConnector#getGraphEdge()
     * @see #getGraphConnector()
     * @generated
     */
	EReference getGraphConnector_GraphEdge();

    /**
     * Returns the meta object for class '{@link latte.di.GraphEdge <em>Graph Edge</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Graph Edge</em>'.
     * @see latte.di.GraphEdge
     * @generated
     */
	EClass getGraphEdge();

    /**
     * Returns the meta object for the containment reference list '{@link latte.di.GraphEdge#getWaypoints <em>Waypoints</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Waypoints</em>'.
     * @see latte.di.GraphEdge#getWaypoints()
     * @see #getGraphEdge()
     * @generated
     */
	EReference getGraphEdge_Waypoints();

    /**
     * Returns the meta object for the reference list '{@link latte.di.GraphEdge#getAnchor <em>Anchor</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference list '<em>Anchor</em>'.
     * @see latte.di.GraphEdge#getAnchor()
     * @see #getGraphEdge()
     * @generated
     */
	EReference getGraphEdge_Anchor();

    /**
     * Returns the meta object for class '{@link latte.di.GraphElement <em>Graph Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Graph Element</em>'.
     * @see latte.di.GraphElement
     * @generated
     */
	EClass getGraphElement();

    /**
     * Returns the meta object for the containment reference '{@link latte.di.GraphElement#getPosition <em>Position</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Position</em>'.
     * @see latte.di.GraphElement#getPosition()
     * @see #getGraphElement()
     * @generated
     */
	EReference getGraphElement_Position();

    /**
     * Returns the meta object for the containment reference list '{@link latte.di.GraphElement#getContained <em>Contained</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Contained</em>'.
     * @see latte.di.GraphElement#getContained()
     * @see #getGraphElement()
     * @generated
     */
	EReference getGraphElement_Contained();

    /**
     * Returns the meta object for the containment reference list '{@link latte.di.GraphElement#getLink <em>Link</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Link</em>'.
     * @see latte.di.GraphElement#getLink()
     * @see #getGraphElement()
     * @generated
     */
	EReference getGraphElement_Link();

    /**
     * Returns the meta object for the containment reference list '{@link latte.di.GraphElement#getAnchorage <em>Anchorage</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference list '<em>Anchorage</em>'.
     * @see latte.di.GraphElement#getAnchorage()
     * @see #getGraphElement()
     * @generated
     */
	EReference getGraphElement_Anchorage();

    /**
     * Returns the meta object for the containment reference '{@link latte.di.GraphElement#getSemanticModel <em>Semantic Model</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Semantic Model</em>'.
     * @see latte.di.GraphElement#getSemanticModel()
     * @see #getGraphElement()
     * @generated
     */
	EReference getGraphElement_SemanticModel();

    /**
     * Returns the meta object for class '{@link latte.di.GraphNode <em>Graph Node</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Graph Node</em>'.
     * @see latte.di.GraphNode
     * @generated
     */
	EClass getGraphNode();

    /**
     * Returns the meta object for the containment reference '{@link latte.di.GraphNode#getSize <em>Size</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the containment reference '<em>Size</em>'.
     * @see latte.di.GraphNode#getSize()
     * @see #getGraphNode()
     * @generated
     */
	EReference getGraphNode_Size();

    /**
     * Returns the meta object for class '{@link latte.di.GraphicPrimitive <em>Graphic Primitive</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Graphic Primitive</em>'.
     * @see latte.di.GraphicPrimitive
     * @generated
     */
	EClass getGraphicPrimitive();

    /**
     * Returns the meta object for class '{@link latte.di.Image <em>Image</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Image</em>'.
     * @see latte.di.Image
     * @generated
     */
	EClass getImage();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Image#getUri <em>Uri</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Uri</em>'.
     * @see latte.di.Image#getUri()
     * @see #getImage()
     * @generated
     */
	EAttribute getImage_Uri();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Image#getMimeType <em>Mime Type</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Mime Type</em>'.
     * @see latte.di.Image#getMimeType()
     * @see #getImage()
     * @generated
     */
	EAttribute getImage_MimeType();

    /**
     * Returns the meta object for class '{@link latte.di.LeafElement <em>Leaf Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Leaf Element</em>'.
     * @see latte.di.LeafElement
     * @generated
     */
	EClass getLeafElement();

    /**
     * Returns the meta object for class '{@link latte.di.Property <em>Property</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Property</em>'.
     * @see latte.di.Property
     * @generated
     */
	EClass getProperty();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Property#getKey <em>Key</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Key</em>'.
     * @see latte.di.Property#getKey()
     * @see #getProperty()
     * @generated
     */
	EAttribute getProperty_Key();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Property#getValue <em>Value</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Value</em>'.
     * @see latte.di.Property#getValue()
     * @see #getProperty()
     * @generated
     */
	EAttribute getProperty_Value();

    /**
     * Returns the meta object for class '{@link latte.di.Reference <em>Reference</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Reference</em>'.
     * @see latte.di.Reference
     * @generated
     */
	EClass getReference();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Reference#isIndividualRepresentaion <em>Individual Representaion</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Individual Representaion</em>'.
     * @see latte.di.Reference#isIndividualRepresentaion()
     * @see #getReference()
     * @generated
     */
	EAttribute getReference_IndividualRepresentaion();

    /**
     * Returns the meta object for the reference '{@link latte.di.Reference#getReferenced <em>Referenced</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the reference '<em>Referenced</em>'.
     * @see latte.di.Reference#getReferenced()
     * @see #getReference()
     * @generated
     */
	EReference getReference_Referenced();

    /**
     * Returns the meta object for class '{@link latte.di.SemanticModelBridge <em>Semantic Model Bridge</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Semantic Model Bridge</em>'.
     * @see latte.di.SemanticModelBridge
     * @generated
     */
	EClass getSemanticModelBridge();

    /**
     * Returns the meta object for the attribute '{@link latte.di.SemanticModelBridge#getPresentation <em>Presentation</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Presentation</em>'.
     * @see latte.di.SemanticModelBridge#getPresentation()
     * @see #getSemanticModelBridge()
     * @generated
     */
	EAttribute getSemanticModelBridge_Presentation();

    /**
     * Returns the meta object for the container reference '{@link latte.di.SemanticModelBridge#getGraphElement <em>Graph Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Graph Element</em>'.
     * @see latte.di.SemanticModelBridge#getGraphElement()
     * @see #getSemanticModelBridge()
     * @generated
     */
	EReference getSemanticModelBridge_GraphElement();

    /**
     * Returns the meta object for the container reference '{@link latte.di.SemanticModelBridge#getDiagram <em>Diagram</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the container reference '<em>Diagram</em>'.
     * @see latte.di.SemanticModelBridge#getDiagram()
     * @see #getSemanticModelBridge()
     * @generated
     */
	EReference getSemanticModelBridge_Diagram();

    /**
     * Returns the meta object for class '{@link latte.di.SimpleSemanticModelElement <em>Simple Semantic Model Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Simple Semantic Model Element</em>'.
     * @see latte.di.SimpleSemanticModelElement
     * @generated
     */
	EClass getSimpleSemanticModelElement();

    /**
     * Returns the meta object for the attribute '{@link latte.di.SimpleSemanticModelElement#getTypeInfo <em>Type Info</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Type Info</em>'.
     * @see latte.di.SimpleSemanticModelElement#getTypeInfo()
     * @see #getSimpleSemanticModelElement()
     * @generated
     */
	EAttribute getSimpleSemanticModelElement_TypeInfo();

    /**
     * Returns the meta object for class '{@link latte.di.TextElement <em>Text Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Text Element</em>'.
     * @see latte.di.TextElement
     * @generated
     */
	EClass getTextElement();

    /**
     * Returns the meta object for the attribute '{@link latte.di.TextElement#getText <em>Text</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Text</em>'.
     * @see latte.di.TextElement#getText()
     * @see #getTextElement()
     * @generated
     */
	EAttribute getTextElement_Text();

    /**
     * Returns the meta object for class '{@link latte.di.Point <em>Point</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Point</em>'.
     * @see latte.di.Point
     * @generated
     */
	EClass getPoint();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Point#getX <em>X</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>X</em>'.
     * @see latte.di.Point#getX()
     * @see #getPoint()
     * @generated
     */
	EAttribute getPoint_X();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Point#getY <em>Y</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Y</em>'.
     * @see latte.di.Point#getY()
     * @see #getPoint()
     * @generated
     */
	EAttribute getPoint_Y();

    /**
     * Returns the meta object for class '{@link latte.di.Dimension <em>Dimension</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for class '<em>Dimension</em>'.
     * @see latte.di.Dimension
     * @generated
     */
	EClass getDimension();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Dimension#getWidth <em>Width</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Width</em>'.
     * @see latte.di.Dimension#getWidth()
     * @see #getDimension()
     * @generated
     */
	EAttribute getDimension_Width();

    /**
     * Returns the meta object for the attribute '{@link latte.di.Dimension#getHeight <em>Height</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for the attribute '<em>Height</em>'.
     * @see latte.di.Dimension#getHeight()
     * @see #getDimension()
     * @generated
     */
	EAttribute getDimension_Height();

    /**
     * Returns the meta object for data type '{@link org.eclipse.uml2.Element <em>Element</em>}'.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the meta object for data type '<em>Element</em>'.
     * @see org.eclipse.uml2.Element
     * @model instanceClass="org.eclipse.uml2.Element"
     * @generated
     */
	EDataType getElement();

    /**
     * Returns the factory that creates the instances of the model.
     * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
     * @return the factory that creates the instances of the model.
     * @generated
     */
	DIFactory getDIFactory();

}
