/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action.mm;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Package;

import com.sun.javadoc.PackageDoc;

import latte.InternalLogicException;
import latte.util.ModelUtil;


/**
 * pbP[W̑i쐬AǉA폜j
 * 
 * @version $Id: PackageManip.java,v 1.2 2004/09/04 16:05:43 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class PackageManip implements IAddManip, IRemoveManip {

    /**
     * V`쐬
     */
    public EObject createDef(Object param){
        Package p = ModelUtil.Uml2Factory.createPackage();
        if (param instanceof PackageDoc) {
            PackageDoc doc = (PackageDoc)param;
            p.setName(doc.name());
        } else {
            p.setName("pbP[W");
        }
        return p;
    }
    /**
     * V`eɒǉ
     */
    public void addDef(EObject parent, EObject newDef){
        if (parent instanceof Package){
            // pbP[WAfɒǉ
            Package p = (Package)parent;
            int index = ModelUtil.getInsertIndex(p.getOwnedMembers().toArray(), newDef, false);
            p.getOwnedMembers().add(index, newDef);
        } else {
            throw new InternalLogicException("pbP[W͒ǉł܂");
        }
    }
    /**
     * 폜
     */
    public void removeDef(EObject removeDef) {
        Package removeP = (Package)removeDef;
        Element owner = removeP.getOwner();
        if (owner instanceof Package) {
            // pbP[WAf폜
            Package op = (Package)owner;
            op.getOwnedMembers().remove(removeDef);
        } else {
            throw new InternalLogicException("pbP[W͍폜ł܂");
        }
    }
}
