/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action.mm;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Operation;
import org.eclipse.uml2.Parameter;
import org.eclipse.uml2.UML2Package;
import org.eclipse.uml2.VisibilityKind;

import com.sun.javadoc.ExecutableMemberDoc;
import com.sun.javadoc.MethodDoc;

import latte.InternalLogicException;
import latte.Latte;
import latte.util.ModelUtil;


/**
 * 
 * \bh̑i쐬AǉA폜j
 * 
 * @version $Id: MethodManip.java,v 1.3 2004/09/23 14:48:21 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class MethodManip implements IAddManip, IRemoveManip {

    /**
     * V`쐬
     */
    public EObject createDef(Object param){
        Operation o = ModelUtil.Uml2Factory.createOperation();
        if (param instanceof ExecutableMemberDoc) {
            ExecutableMemberDoc doc =(ExecutableMemberDoc)param;
            // 
            if (doc.isPublic()) {
                o.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            } else if (doc.isPackagePrivate()) {
                o.setVisibility(VisibilityKind.PACKAGE_LITERAL);
            } else if (doc.isProtected()) {
                o.setVisibility(VisibilityKind.PROTECTED_LITERAL);
            } else if (doc.isPrivate()) {
                o.setVisibility(VisibilityKind.PRIVATE_LITERAL);
            }
            // O
            String name = null;
            int index = doc.name().lastIndexOf(".");
            if (index == -1) {
                name = doc.name();
            } else {
                name = doc.name().substring(index+1);
            }
            o.setName(name);            
            // ۉ
            if (param instanceof MethodDoc) {
                o.setIsAbstract(((MethodDoc)doc).isAbstract());
            }
        } else {
            // 
            o.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            // O
            o.setName("\bh");
            // ^
            Parameter p = o.createReturnResult(UML2Package.eINSTANCE.getParameter());
            p.setType(Latte.getLatteData().lookupPrimitiveTypes("int"));
        }
        return o;
    }
    /**
     * V`eɒǉ
     */
    public void addDef(EObject parent, EObject newDef){
        if (parent instanceof Class) {
            // NXɒǉ
            Class c = (Class)parent;
            int index = ModelUtil.getInsertIndex(c.getOwnedOperations().toArray(), newDef, false);
            c.getOwnedOperations().add(index, newDef);
        } else if (parent instanceof Interface) {
            // C^[tFCXɒǉ
            Interface i = (Interface)parent;
            int index = ModelUtil.getInsertIndex(i.getOwnedOperations().toArray(), newDef, false);
            i.getOwnedOperations().add(index, newDef);
        } else {
            throw new InternalLogicException("\bh͒ǉł܂");
        }
    }
    /**
     * 폜
     */
    public void removeDef(EObject removeDef) {
        Operation removeO = (Operation)removeDef;
        Element owner = removeO.getOwner();
        if (owner instanceof Class) {
            // NX폜
            Class c = (Class)owner;
            c.getOwnedOperations().remove(removeDef);
        } else if (owner instanceof Interface) {
            // C^[tFCX폜
            Interface i = (Interface)owner;
            i.getOwnedOperations().remove(removeDef);
        } else {
            throw new InternalLogicException("\bh͍폜ł܂");
        }
    }
}
