/*******************************************************************************
 * Copyright (c) 2003, 2004 Rick Ohnuki. All rights reserved.
 * 
 * This program and the accompanying materials 
 * are made available under the terms of the Common Public License v1.0
 * (http://opensource.org/licenses/cpl.php)
 * 
 * You must not remove this notice, or any other, from this software
 * 
 * Contributors:
 *     Rick Ohnuki - initial API and implementation
 *******************************************************************************/

package latte.action.mm;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.uml2.Class;
import org.eclipse.uml2.Element;
import org.eclipse.uml2.Interface;
import org.eclipse.uml2.Package;
import org.eclipse.uml2.VisibilityKind;

import com.sun.javadoc.ClassDoc;

import latte.InternalLogicException;
import latte.util.ModelUtil;



/**
 * 
 * C^[tFCX̑i쐬AǉA폜j
 * 
 * @version $Id: InterfaceManip.java,v 1.3 2004/09/23 14:48:21 ohnuki Exp $
 * @author $Author: ohnuki $
 */
public class InterfaceManip implements IAddManip, IRemoveManip {

    /**
     * V`쐬
     */
    public EObject createDef(Object param){
        Interface i = ModelUtil.Uml2Factory.createInterface();
        if (param instanceof ClassDoc) {
            ClassDoc doc = (ClassDoc)param;
            // 
            if (doc.isPublic()) {
                i.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            } else if (doc.isPackagePrivate()) {
                i.setVisibility(VisibilityKind.PACKAGE_LITERAL);
            } else if (doc.isProtected()) {
                i.setVisibility(VisibilityKind.PROTECTED_LITERAL);
            } else if (doc.isPrivate()) {
                i.setVisibility(VisibilityKind.PRIVATE_LITERAL);
            }            
            // O
            String name = null;
            int index = doc.name().lastIndexOf(".");
            if (index == -1) {
                name = doc.name();
            } else {
                name = doc.name().substring(index+1);
            }
            i.setName(name);
        } else {
            // 
            i.setVisibility(VisibilityKind.PUBLIC_LITERAL);
            // O
            i.setName("C^[tFCX");
        }
        return i;
    }
    /**
     * V`eɒǉ
     */
    public void addDef(EObject parent, EObject newDef){
        if (parent instanceof Package){
            // pbP[WAfɒǉ
            Package p = (Package)parent;
            int index = ModelUtil.getInsertIndex(p.getOwnedMembers().toArray(), newDef, false);
            p.getOwnedMembers().add(index, newDef);
        } else if (parent instanceof Class) {
            // NXɒǉ
            Class c = (Class)parent;
            int index = ModelUtil.getInsertIndex(c.getNestedClassifiers().toArray(), newDef, false);
            c.getNestedClassifiers().add(index, newDef);
        } else if (parent instanceof Interface) {
            // C^[tFCXɒǉ
            Interface i = (Interface)parent;
            int index = ModelUtil.getInsertIndex(i.getNestedClassifiers().toArray(), newDef, false);
            i.getNestedClassifiers().add(index, newDef);
        } else {
            throw new InternalLogicException("C^[tFCX͒ǉł܂ in " + parent);
        }
    }
    /**
     * 폜
     */
    public void removeDef(EObject removeDef) {
        Interface removeI = (Interface)removeDef;
        Element owner = removeI.getOwner();
        if (owner instanceof Package) {
            // pbP[WAf폜
            Package p = (Package)owner;
            p.getOwnedMembers().remove(removeDef);
        } else if (owner instanceof Class) {
            // NX폜
            Class c = (Class)owner;
            c.getNestedClassifiers().remove(removeDef);
        } else if (owner instanceof Interface) {
            // C^[tFCX폜
            Interface i = (Interface)owner;
            i.getNestedClassifiers().remove(removeDef);
        } else {
            throw new InternalLogicException("C^[tFCX͍폜ł܂");
        }
    }
}
